/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.recipes;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.CriterionTriggerRecipeUnlocked;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.ShapelessRecipes;
import net.minecraft.world.level.IMaterial;

public class ShapelessRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory b;
    private final Item c;
    private final int d;
    private final NonNullList<RecipeItemStack> e = NonNullList.a();
    private final Map<String, Criterion<?>> f = new LinkedHashMap();
    @Nullable
    private String g;

    public ShapelessRecipeBuilder(RecipeCategory category, IMaterial output, int count) {
        this.b = category;
        this.c = output.k();
        this.d = count;
    }

    public static ShapelessRecipeBuilder a(RecipeCategory category, IMaterial output) {
        return new ShapelessRecipeBuilder(category, output, 1);
    }

    public static ShapelessRecipeBuilder a(RecipeCategory category, IMaterial output, int count) {
        return new ShapelessRecipeBuilder(category, output, count);
    }

    public ShapelessRecipeBuilder a(TagKey<Item> tag) {
        return this.a(RecipeItemStack.a(tag));
    }

    public ShapelessRecipeBuilder b(IMaterial itemProvider) {
        return this.a(itemProvider, 1);
    }

    public ShapelessRecipeBuilder a(IMaterial itemProvider, int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            this.a(RecipeItemStack.a(itemProvider));
        }
        return this;
    }

    public ShapelessRecipeBuilder a(RecipeItemStack ingredient) {
        return this.a(ingredient, 1);
    }

    public ShapelessRecipeBuilder a(RecipeItemStack ingredient, int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            this.e.add(ingredient);
        }
        return this;
    }

    @Override
    public ShapelessRecipeBuilder b(String string, Criterion<?> criterion) {
        this.f.put(string, criterion);
        return this;
    }

    @Override
    public ShapelessRecipeBuilder b(@Nullable String string) {
        this.g = string;
        return this;
    }

    @Override
    @Override
    public Item a() {
        return this.c;
    }

    @Override
    @Override
    public void a(RecipeOutput exporter, MinecraftKey recipeId) {
        this.a(recipeId);
        Advancement.SerializedAdvancement builder = exporter.a().a("has_the_recipe", CriterionTriggerRecipeUnlocked.a(recipeId)).a(AdvancementRewards.a.c(recipeId)).a(AdvancementRequirements.a.b);
        this.f.forEach(builder::a);
        ShapelessRecipes shapelessRecipe = new ShapelessRecipes(Objects.requireNonNullElse(this.g, ""), RecipeBuilder.a(this.b), new ItemStack(this.c, this.d), this.e);
        exporter.a(recipeId, shapelessRecipe, builder.b(recipeId.d("recipes/" + this.b.a() + "/")));
    }

    private void a(MinecraftKey recipeId) {
        if (this.f.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + recipeId);
        }
    }

    @Override
    public /* synthetic */ RecipeBuilder a(@Nullable String group) {
        return this.b(group);
    }

    public /* synthetic */ RecipeBuilder a(String name, Criterion criterion) {
        return this.b(name, criterion);
    }
}

