/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.phys.AxisAlignedBB;
import org.slf4j.Logger;

public class GameTestHarnessBatchRunner {
    private static final Logger a = LogUtils.getLogger();
    private final BlockPosition b;
    final WorldServer c;
    private final GameTestHarnessTicker d;
    private final int e;
    private final List<GameTestHarnessInfo> f;
    private final List<Pair<GameTestHarnessBatch, Collection<GameTestHarnessInfo>>> g;
    private int h;
    private AxisAlignedBB i;
    private final BlockPosition.MutableBlockPosition j;

    public GameTestHarnessBatchRunner(Collection<GameTestHarnessBatch> batches, BlockPosition pos, EnumBlockRotation rotation, WorldServer world, GameTestHarnessTicker testManager, int sizeZ) {
        this.j = pos.j();
        this.i = new AxisAlignedBB(this.j);
        this.b = pos;
        this.c = world;
        this.d = testManager;
        this.e = sizeZ;
        this.g = (List)batches.stream().map(batch -> {
            Collection collection = (Collection)batch.b().stream().map(testFunction -> new GameTestHarnessInfo((GameTestHarnessTestFunction)testFunction, rotation, world)).collect(ImmutableList.toImmutableList());
            return Pair.of((Object)batch, (Object)collection);
        }).collect(ImmutableList.toImmutableList());
        this.f = (List)this.g.stream().flatMap(batch -> ((Collection)batch.getSecond()).stream()).collect(ImmutableList.toImmutableList());
    }

    public List<GameTestHarnessInfo> a() {
        return this.f;
    }

    public void b() {
        this.a(0);
    }

    void a(final int index) {
        if (index >= this.g.size()) {
            return;
        }
        Pair<GameTestHarnessBatch, Collection<GameTestHarnessInfo>> pair = this.g.get(index);
        final GameTestHarnessBatch gameTestBatch = (GameTestHarnessBatch)pair.getFirst();
        Collection collection = (Collection)pair.getSecond();
        Map<GameTestHarnessInfo, BlockPosition> map = this.a(collection);
        String string = gameTestBatch.a();
        a.info("Running test batch '{}' ({} tests)...", (Object)string, (Object)collection.size());
        gameTestBatch.a(this.c);
        final GameTestHarnessCollector multipleTestTracker = new GameTestHarnessCollector();
        collection.forEach(multipleTestTracker::a);
        multipleTestTracker.a(new GameTestHarnessListener(){

            private void a() {
                if (multipleTestTracker.i()) {
                    gameTestBatch.b(GameTestHarnessBatchRunner.this.c);
                    LongArraySet longSet = new LongArraySet(GameTestHarnessBatchRunner.this.c.w());
                    longSet.forEach(chunkPos -> GameTestHarnessBatchRunner.this.c.a(ChunkCoordIntPair.a(chunkPos), ChunkCoordIntPair.b(chunkPos), false));
                    GameTestHarnessBatchRunner.this.a(index + 1);
                }
            }

            @Override
            @Override
            public void a(GameTestHarnessInfo test) {
            }

            @Override
            @Override
            public void b(GameTestHarnessInfo test) {
                this.a();
            }

            @Override
            @Override
            public void c(GameTestHarnessInfo test) {
                this.a();
            }
        });
        collection.forEach(gameTest -> {
            BlockPosition blockPos = (BlockPosition)map.get(gameTest);
            GameTestHarnessRunner.a(gameTest, blockPos, this.d);
        });
    }

    private Map<GameTestHarnessInfo, BlockPosition> a(Collection<GameTestHarnessInfo> gameTests) {
        HashMap map = Maps.newHashMap();
        for (GameTestHarnessInfo gameTestInfo : gameTests) {
            BlockPosition blockPos = new BlockPosition(this.j);
            TileEntityStructure structureBlockEntity = GameTestHarnessStructures.a(gameTestInfo, blockPos, gameTestInfo.v(), this.c);
            AxisAlignedBB aABB = GameTestHarnessStructures.a(structureBlockEntity);
            gameTestInfo.a(structureBlockEntity.aB_());
            map.put(gameTestInfo, new BlockPosition(this.j));
            this.i = this.i.b(aABB);
            this.j.e((int)aABB.b() + 5, 0, 0);
            if (this.h++ % this.e != this.e - 1) continue;
            this.j.e(0, 0, (int)this.i.d() + 6);
            this.j.p(this.b.u());
            this.i = new AxisAlignedBB(this.j);
        }
        return map;
    }
}

