/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.ExhaustedAttemptsException;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLectern;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import org.apache.commons.lang3.exception.ExceptionUtils;

class ReportGameListener
implements GameTestHarnessListener {
    private final GameTestHarnessInfo c;
    private final GameTestHarnessTicker d;
    private final BlockPosition e;
    int a;
    int b;

    public ReportGameListener(GameTestHarnessInfo test, GameTestHarnessTicker testManager, BlockPosition pos) {
        this.c = test;
        this.d = testManager;
        this.e = pos;
        this.a = 0;
        this.b = 0;
    }

    @Override
    @Override
    public void a(GameTestHarnessInfo test) {
        ReportGameListener.a(this.c, Blocks.eq);
        ++this.a;
    }

    @Override
    @Override
    public void b(GameTestHarnessInfo test) {
        ++this.b;
        if (test.B()) {
            ReportGameListener.a(test, test.c() + " passed! (" + test.m() + "ms). Rerunning until failed.");
            this.a();
            return;
        }
        if (!test.y()) {
            ReportGameListener.a(test, test.c() + " passed! (" + test.m() + "ms)");
            return;
        }
        if (this.b >= test.A()) {
            ReportGameListener.a(test, test + " passed " + this.b + " times of " + this.a + " attempts.");
        } else {
            ReportGameListener.a(this.c.h(), EnumChatFormat.k, "Flaky test " + this.c + " succeeded, attempt: " + this.a + " successes: " + this.b);
            this.a();
        }
    }

    @Override
    @Override
    public void c(GameTestHarnessInfo test) {
        if (!test.y()) {
            ReportGameListener.a(test, test.o());
            return;
        }
        GameTestHarnessTestFunction testFunction = this.c.w();
        String string = "Flaky test " + this.c + " failed, attempt: " + this.a + "/" + testFunction.i();
        if (testFunction.j() > 1) {
            string = string + ", successes: " + this.b + " (" + testFunction.j() + " required)";
        }
        ReportGameListener.a(this.c.h(), EnumChatFormat.o, string);
        if (test.z() - this.a + this.b >= test.A()) {
            this.a();
        } else {
            ReportGameListener.a(test, new ExhaustedAttemptsException(this.a, this.b, test));
        }
    }

    public static void a(GameTestHarnessInfo test, String output) {
        ReportGameListener.a(test, Blocks.en);
        ReportGameListener.b(test, output);
    }

    private static void b(GameTestHarnessInfo test, String output) {
        ReportGameListener.a(test.h(), EnumChatFormat.k, output);
        GlobalTestReporter.b(test);
    }

    protected static void a(GameTestHarnessInfo test, Throwable output) {
        ReportGameListener.a(test, test.s() ? Blocks.ew : Blocks.ej);
        ReportGameListener.c(test, SystemUtils.c(output));
        ReportGameListener.b(test, output);
    }

    protected static void b(GameTestHarnessInfo test, Throwable output) {
        String string = output.getMessage() + (String)(output.getCause() == null ? "" : " cause: " + SystemUtils.c(output.getCause()));
        String string2 = (test.s() ? "" : "(optional) ") + test.c() + " failed! " + string;
        ReportGameListener.a(test.h(), test.s() ? EnumChatFormat.m : EnumChatFormat.o, string2);
        Throwable throwable = (Throwable)MoreObjects.firstNonNull((Object)ExceptionUtils.getRootCause((Throwable)output), (Object)output);
        if (throwable instanceof GameTestHarnessAssertionPosition) {
            GameTestHarnessAssertionPosition gameTestAssertPosException = (GameTestHarnessAssertionPosition)throwable;
            ReportGameListener.a(test.h(), gameTestAssertPosException.c(), gameTestAssertPosException.a());
        }
        GlobalTestReporter.a(test);
    }

    private void a() {
        this.c.p();
        GameTestHarnessInfo gameTestInfo = new GameTestHarnessInfo(this.c.w(), this.c.v(), this.c.h());
        gameTestInfo.a(this.c.B());
        this.d.a(gameTestInfo);
        gameTestInfo.a(this);
        gameTestInfo.b(this.e);
    }

    protected static void a(GameTestHarnessInfo test, Block block) {
        WorldServer serverLevel = test.h();
        BlockPosition blockPos = test.d();
        BlockPosition blockPos2 = new BlockPosition(-1, -1, -1);
        BlockPosition blockPos3 = DefinedStructure.a(blockPos.a(blockPos2), EnumBlockMirror.a, test.v(), blockPos);
        serverLevel.b(blockPos3, Blocks.fO.o().a(test.v()));
        BlockPosition blockPos4 = blockPos3.b(0, 1, 0);
        serverLevel.b(blockPos4, block.o());
        for (int i2 = -1; i2 <= 1; ++i2) {
            for (int j2 = -1; j2 <= 1; ++j2) {
                BlockPosition blockPos5 = blockPos3.b(i2, -1, j2);
                serverLevel.b(blockPos5, Blocks.ci.o());
            }
        }
    }

    private static void c(GameTestHarnessInfo test, String output) {
        WorldServer serverLevel = test.h();
        BlockPosition blockPos = test.d();
        BlockPosition blockPos2 = new BlockPosition(-1, 1, -1);
        BlockPosition blockPos3 = DefinedStructure.a(blockPos.a(blockPos2), EnumBlockMirror.a, test.v(), blockPos);
        serverLevel.b(blockPos3, Blocks.oa.o().a(test.v()));
        IBlockData blockState = serverLevel.a_(blockPos3);
        ItemStack itemStack = ReportGameListener.a(test.c(), test.s(), output);
        BlockLectern.a(null, (World)serverLevel, blockPos3, blockState, itemStack);
    }

    private static ItemStack a(String text, boolean required, String output) {
        ItemStack itemStack = new ItemStack(Items.tT);
        NBTTagList listTag = new NBTTagList();
        StringBuffer stringBuffer = new StringBuffer();
        Arrays.stream(text.split("\\.")).forEach(line -> stringBuffer.append((String)line).append('\n'));
        if (!required) {
            stringBuffer.append("(optional)\n");
        }
        stringBuffer.append("-------------------\n");
        listTag.add(NBTTagString.a(stringBuffer + output));
        itemStack.a("pages", listTag);
        return itemStack;
    }

    protected static void a(WorldServer world, EnumChatFormat formatting, String message) {
        world.a((? super EntityPlayer player) -> true).forEach(player -> player.a(IChatBaseComponent.b(message).a(formatting)));
    }

    private static void a(WorldServer world, BlockPosition pos, String message) {
        PacketDebug.a(world, pos, message, -2130771968, Integer.MAX_VALUE);
    }
}

