/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.brigadier.TagParseCommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.network.chat.IChatBaseComponent;

public class MojangsonParser {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.nbt.trailing"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.nbt.expected.key"));
    public static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.nbt.expected.value"));
    public static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((receivedType, expectedType) -> IChatBaseComponent.b("argument.nbt.list.mixed", receivedType, expectedType));
    public static final Dynamic2CommandExceptionType e = new Dynamic2CommandExceptionType((receivedType, expectedType) -> IChatBaseComponent.b("argument.nbt.array.mixed", receivedType, expectedType));
    public static final DynamicCommandExceptionType f = new DynamicCommandExceptionType(type -> IChatBaseComponent.b("argument.nbt.array.invalid", type));
    public static final char g = ',';
    public static final char h = ':';
    private static final char j = '[';
    private static final char k = ']';
    private static final char l = '}';
    private static final char m = '{';
    private static final Pattern n = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern o = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern p = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern q = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern r = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern s = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern t = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    public static final Codec<NBTTagCompound> i = Codec.STRING.comapFlatMap(nbt -> {
        try {
            return DataResult.success((Object)new MojangsonParser(new StringReader(nbt)).a(), (Lifecycle)Lifecycle.stable());
        }
        catch (CommandSyntaxException var2) {
            return DataResult.error(var2::getMessage);
        }
    }, NBTTagCompound::toString);
    private final StringReader u;
    private int depth;

    public static NBTTagCompound a(String string) throws CommandSyntaxException {
        return new MojangsonParser(new StringReader(string)).a();
    }

    @VisibleForTesting
    NBTTagCompound a() throws CommandSyntaxException {
        NBTTagCompound compoundTag = this.f();
        this.u.skipWhitespace();
        if (this.u.canRead()) {
            throw a.createWithContext((ImmutableStringReader)this.u);
        }
        return compoundTag;
    }

    public MojangsonParser(StringReader reader) {
        this.u = reader;
    }

    protected String b() throws CommandSyntaxException {
        this.u.skipWhitespace();
        if (!this.u.canRead()) {
            throw b.createWithContext((ImmutableStringReader)this.u);
        }
        return this.u.readString();
    }

    protected NBTBase c() throws CommandSyntaxException {
        this.u.skipWhitespace();
        int i2 = this.u.getCursor();
        if (StringReader.isQuotedStringStart((char)this.u.peek())) {
            return NBTTagString.a(this.u.readQuotedString());
        }
        String string = this.u.readUnquotedString();
        if (string.isEmpty()) {
            this.u.setCursor(i2);
            throw c.createWithContext((ImmutableStringReader)this.u);
        }
        return this.b(string);
    }

    public NBTBase b(String input) {
        try {
            if (p.matcher(input).matches()) {
                return NBTTagFloat.a(Float.parseFloat(input.substring(0, input.length() - 1)));
            }
            if (q.matcher(input).matches()) {
                return NBTTagByte.a(Byte.parseByte(input.substring(0, input.length() - 1)));
            }
            if (r.matcher(input).matches()) {
                return NBTTagLong.a(Long.parseLong(input.substring(0, input.length() - 1)));
            }
            if (s.matcher(input).matches()) {
                return NBTTagShort.a(Short.parseShort(input.substring(0, input.length() - 1)));
            }
            if (t.matcher(input).matches()) {
                return NBTTagInt.a(Integer.parseInt(input));
            }
            if (o.matcher(input).matches()) {
                return NBTTagDouble.a(Double.parseDouble(input.substring(0, input.length() - 1)));
            }
            if (n.matcher(input).matches()) {
                return NBTTagDouble.a(Double.parseDouble(input));
            }
            if ("true".equalsIgnoreCase(input)) {
                return NBTTagByte.c;
            }
            if ("false".equalsIgnoreCase(input)) {
                return NBTTagByte.b;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return NBTTagString.a(input);
    }

    public NBTBase d() throws CommandSyntaxException {
        this.u.skipWhitespace();
        if (!this.u.canRead()) {
            throw c.createWithContext((ImmutableStringReader)this.u);
        }
        char c2 = this.u.peek();
        if (c2 == '{') {
            return this.f();
        }
        return c2 == '[' ? this.e() : this.c();
    }

    protected NBTBase e() throws CommandSyntaxException {
        return this.u.canRead(3) && !StringReader.isQuotedStringStart((char)this.u.peek(1)) && this.u.peek(2) == ';' ? this.h() : this.g();
    }

    public NBTTagCompound f() throws CommandSyntaxException {
        this.a('{');
        this.increaseDepth();
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.u.skipWhitespace();
        while (this.u.canRead() && this.u.peek() != '}') {
            int i2 = this.u.getCursor();
            String string = this.b();
            if (string.isEmpty()) {
                this.u.setCursor(i2);
                throw b.createWithContext((ImmutableStringReader)this.u);
            }
            this.a(':');
            compoundTag.a(string, this.d());
            if (!this.i()) break;
            if (this.u.canRead()) continue;
            throw b.createWithContext((ImmutableStringReader)this.u);
        }
        this.a('}');
        --this.depth;
        return compoundTag;
    }

    private NBTBase g() throws CommandSyntaxException {
        this.a('[');
        this.u.skipWhitespace();
        if (!this.u.canRead()) {
            throw c.createWithContext((ImmutableStringReader)this.u);
        }
        this.increaseDepth();
        NBTTagList listTag = new NBTTagList();
        NBTTagType<?> tagType = null;
        while (this.u.peek() != ']') {
            int i2 = this.u.getCursor();
            NBTBase tag = this.d();
            NBTTagType<?> tagType2 = tag.c();
            if (tagType == null) {
                tagType = tagType2;
            } else if (tagType2 != tagType) {
                this.u.setCursor(i2);
                throw d.createWithContext((ImmutableStringReader)this.u, (Object)tagType2.b(), (Object)tagType.b());
            }
            listTag.add(tag);
            if (!this.i()) break;
            if (this.u.canRead()) continue;
            throw c.createWithContext((ImmutableStringReader)this.u);
        }
        this.a(']');
        --this.depth;
        return listTag;
    }

    public NBTBase h() throws CommandSyntaxException {
        this.a('[');
        int i2 = this.u.getCursor();
        char c2 = this.u.read();
        this.u.read();
        this.u.skipWhitespace();
        if (!this.u.canRead()) {
            throw c.createWithContext((ImmutableStringReader)this.u);
        }
        if (c2 == 'B') {
            return new NBTTagByteArray(this.a(NBTTagByteArray.a, NBTTagByte.a));
        }
        if (c2 == 'L') {
            return new NBTTagLongArray(this.a(NBTTagLongArray.a, NBTTagLong.a));
        }
        if (c2 == 'I') {
            return new NBTTagIntArray(this.a(NBTTagIntArray.a, NBTTagInt.a));
        }
        this.u.setCursor(i2);
        throw f.createWithContext((ImmutableStringReader)this.u, (Object)String.valueOf(c2));
    }

    private <T extends Number> List<T> a(NBTTagType<?> arrayTypeReader, NBTTagType<?> typeReader) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayList();
        while (this.u.peek() != ']') {
            int i2 = this.u.getCursor();
            NBTBase tag = this.d();
            NBTTagType<?> tagType = tag.c();
            if (tagType != typeReader) {
                this.u.setCursor(i2);
                throw e.createWithContext((ImmutableStringReader)this.u, (Object)tagType.b(), (Object)arrayTypeReader.b());
            }
            if (typeReader == NBTTagByte.a) {
                list.add(((NBTNumber)tag).i());
            } else if (typeReader == NBTTagLong.a) {
                list.add(((NBTNumber)tag).f());
            } else {
                list.add(((NBTNumber)tag).g());
            }
            if (!this.i()) break;
            if (this.u.canRead()) continue;
            throw c.createWithContext((ImmutableStringReader)this.u);
        }
        this.a(']');
        return list;
    }

    private boolean i() {
        this.u.skipWhitespace();
        if (this.u.canRead() && this.u.peek() == ',') {
            this.u.skip();
            this.u.skipWhitespace();
            return true;
        }
        return false;
    }

    private void a(char c2) throws CommandSyntaxException {
        this.u.skipWhitespace();
        this.u.expect(c2);
    }

    private void increaseDepth() throws CommandSyntaxException {
        ++this.depth;
        if (this.depth > 512) {
            throw new TagParseCommandSyntaxException("NBT tag is too complex, depth > 512");
        }
    }
}

