/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ChatHoverable {
    public static final Codec<ChatHoverable> a = Codec.either((Codec)d.a.codec(), (Codec)d.b.codec()).xmap(either -> new ChatHoverable(either.map(data -> data, data -> data)), event -> Either.left(event.b));
    private final d<?> b;

    public <T> ChatHoverable(EnumHoverAction<T> action, T contents) {
        this(new d<T>(action, contents));
    }

    private ChatHoverable(d<?> data) {
        this.b = data;
    }

    public EnumHoverAction<?> a() {
        return this.b.c;
    }

    @Nullable
    public <T> T a(EnumHoverAction<T> action) {
        if (this.b.c == action) {
            return action.a(this.b.d);
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return ((ChatHoverable)object).b.equals(this.b);
    }

    @Override
    public String toString() {
        return this.b.toString();
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }

    static final class d<T>
    extends Record {
        private final EnumHoverAction<T> c;
        private final T d;
        public static final MapCodec<d<?>> a = EnumHoverAction.e.dispatchMap("action", d::a, action -> action.h);
        public static final MapCodec<d<?>> b = EnumHoverAction.e.dispatchMap("action", d::a, action -> action.i);

        d(EnumHoverAction<T> action, T object) {
            this.c = action;
            this.d = object;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "action;value", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "action;value", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "action;value", "c", "d"}, this, object);
        }

        public EnumHoverAction<T> a() {
            return this.c;
        }

        public T b() {
            return this.d;
        }
    }

    public static class EnumHoverAction<T>
    implements INamable {
        public static final EnumHoverAction<IChatBaseComponent> a = new EnumHoverAction<IChatBaseComponent>("show_text", true, ComponentSerialization.a, DataResult::success);
        public static final EnumHoverAction<c> b = new EnumHoverAction<c>("show_item", true, net.minecraft.network.chat.ChatHoverable$c.b, c::a);
        public static final EnumHoverAction<b> c = new EnumHoverAction<b>("show_entity", true, net.minecraft.network.chat.ChatHoverable$b.a, b::a);
        public static final Codec<EnumHoverAction<?>> d = INamable.b(() -> new EnumHoverAction[]{a, b, c});
        public static final Codec<EnumHoverAction<?>> e = ExtraCodecs.a(d, EnumHoverAction::a);
        private final String f;
        private final boolean g;
        final Codec<d<T>> h;
        final Codec<d<T>> i;

        public EnumHoverAction(String name, boolean parsable, Codec<T> contentCodec, Function<IChatBaseComponent, DataResult<T>> legacySerializer) {
            this.f = name;
            this.g = parsable;
            this.h = contentCodec.xmap(content -> new d<Object>(this, content), action -> action.d).fieldOf("contents").codec();
            this.i = Codec.of((Encoder)Encoder.error((String)"Can't encode in legacy format"), (Decoder)ComponentSerialization.a.flatMap(legacySerializer).map(text -> new d<Object>(this, text)));
        }

        public boolean a() {
            return this.g;
        }

        @Override
        @Override
        public String c() {
            return this.f;
        }

        T a(Object o2) {
            return (T)o2;
        }

        @Override
        public String toString() {
            return "<action " + this.f + ">";
        }

        private static DataResult<EnumHoverAction<?>> a(@Nullable EnumHoverAction<?> action) {
            if (action == null) {
                return DataResult.error(() -> "Unknown action");
            }
            if (!action.a()) {
                return DataResult.error(() -> "Action not allowed: " + action);
            }
            return DataResult.success(action, (Lifecycle)Lifecycle.stable());
        }
    }

    public static class c {
        public static final Codec<c> a = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.h.q().fieldOf("id").forGetter(content -> content.c), (App)ExtraCodecs.a(Codec.INT, "count", Integer.valueOf(1)).forGetter(content -> content.d), (App)ExtraCodecs.a(MojangsonParser.i, "tag").forGetter(content -> content.e)).apply((Applicative)instance, c::new));
        public static final Codec<c> b = Codec.either(BuiltInRegistries.h.q(), a).xmap(either -> either.map(item -> new c((Item)item, 1, Optional.empty()), content -> content), Either::right);
        public final Item c;
        public final int d;
        public final Optional<NBTTagCompound> e;
        @Nullable
        private ItemStack f;

        c(Item item, int count, @Nullable NBTTagCompound nbt) {
            this(item, count, Optional.ofNullable(nbt));
        }

        c(Item item, int count, Optional<NBTTagCompound> nbt) {
            this.c = item;
            this.d = count;
            this.e = nbt;
        }

        public c(ItemStack stack) {
            this(stack.d(), stack.L(), stack.v() != null ? Optional.of(stack.v().h()) : Optional.empty());
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            c itemStackInfo = (c)object;
            return this.d == itemStackInfo.d && this.c.equals(itemStackInfo.c) && this.e.equals(itemStackInfo.e);
        }

        @Override
        public int hashCode() {
            int i2 = this.c.hashCode();
            i2 = 31 * i2 + this.d;
            i2 = 31 * i2 + this.e.hashCode();
            return i2;
        }

        public ItemStack a() {
            if (this.f == null) {
                this.f = new ItemStack(this.c, this.d);
                this.e.ifPresent(this.f::c);
            }
            return this.f;
        }

        private static DataResult<c> a(IChatBaseComponent text) {
            try {
                NBTTagCompound compoundTag = MojangsonParser.a(text.getString());
                return DataResult.success((Object)new c(ItemStack.a(compoundTag)));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                return DataResult.error(() -> "Failed to parse item tag: " + commandSyntaxException.getMessage());
            }
        }
    }

    public static class b {
        public static final Codec<b> a = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.g.q().fieldOf("type").forGetter(content -> content.b), (App)UUIDUtil.e.fieldOf("id").forGetter(content -> content.c), (App)ExtraCodecs.a(ComponentSerialization.a, "name").forGetter(content -> content.d)).apply((Applicative)instance, b::new));
        public final EntityTypes<?> b;
        public final UUID c;
        public final Optional<IChatBaseComponent> d;
        @Nullable
        private List<IChatBaseComponent> e;

        public b(EntityTypes<?> entityType, UUID uuid, @Nullable IChatBaseComponent name) {
            this(entityType, uuid, Optional.ofNullable(name));
        }

        public b(EntityTypes<?> entityType, UUID uuid, Optional<IChatBaseComponent> name) {
            this.b = entityType;
            this.c = uuid;
            this.d = name;
        }

        public static DataResult<b> a(IChatBaseComponent text) {
            try {
                NBTTagCompound compoundTag = MojangsonParser.a(text.getString());
                IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(compoundTag.l("name"));
                EntityTypes<?> entityType = BuiltInRegistries.g.a(new MinecraftKey(compoundTag.l("type")));
                UUID uUID = UUID.fromString(compoundTag.l("id"));
                return DataResult.success((Object)new b(entityType, uUID, component));
            }
            catch (Exception exception) {
                return DataResult.error(() -> "Failed to parse tooltip: " + exception.getMessage());
            }
        }

        public List<IChatBaseComponent> a() {
            if (this.e == null) {
                this.e = new ArrayList<IChatBaseComponent>();
                this.d.ifPresent(this.e::add);
                this.e.add(IChatBaseComponent.a("gui.entity_tooltip.type", this.b.h()));
                this.e.add(IChatBaseComponent.b(this.c.toString()));
            }
            return this.e;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            b entityTooltipInfo = (b)object;
            return this.b.equals(entityTooltipInfo.b) && this.c.equals(entityTooltipInfo.c) && this.d.equals(entityTooltipInfo.d);
        }

        @Override
        public int hashCode() {
            int i2 = this.b.hashCode();
            i2 = 31 * i2 + this.c.hashCode();
            i2 = 31 * i2 + this.d.hashCode();
            return i2;
        }
    }
}

