/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;

public class ScoreContents
implements ComponentContents {
    public static final MapCodec<ScoreContents> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(ScoreContents::b), (App)Codec.STRING.fieldOf("objective").forGetter(ScoreContents::d)).apply((Applicative)instance, ScoreContents::new));
    public static final MapCodec<ScoreContents> b = a.fieldOf("score");
    public static final ComponentContents.a<ScoreContents> c = new ComponentContents.a<ScoreContents>(b, "score");
    private final String d;
    @Nullable
    private final EntitySelector e;
    private final String f;

    @Nullable
    private static EntitySelector a(String name) {
        try {
            return new ArgumentParserSelector(new StringReader(name)).t();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    public ScoreContents(String name, String objective) {
        this.d = name;
        this.e = ScoreContents.a(name);
        this.f = objective;
    }

    @Override
    @Override
    public ComponentContents.a<?> a() {
        return c;
    }

    public String b() {
        return this.d;
    }

    @Nullable
    public EntitySelector c() {
        return this.e;
    }

    public String d() {
        return this.f;
    }

    private ScoreHolder a(CommandListenerWrapper source) throws CommandSyntaxException {
        List<? extends Entity> list;
        if (this.e != null && !(list = this.e.b(source)).isEmpty()) {
            if (list.size() != 1) {
                throw ArgumentEntity.a.create();
            }
            return list.get(0);
        }
        return ScoreHolder.d(this.d);
    }

    private IChatMutableComponent a(ScoreHolder scoreHolder, CommandListenerWrapper source) {
        ReadOnlyScoreInfo readOnlyScoreInfo;
        ScoreboardServer scoreboard;
        ScoreboardObjective objective;
        MinecraftServer minecraftServer = source.l();
        if (minecraftServer != null && (objective = (scoreboard = minecraftServer.aH()).a(this.f)) != null && (readOnlyScoreInfo = scoreboard.d(scoreHolder, objective)) != null) {
            return readOnlyScoreInfo.a(objective.a(StyledFormat.b));
        }
        return IChatBaseComponent.i();
    }

    @Override
    @Override
    public IChatMutableComponent a(@Nullable CommandListenerWrapper source, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (source == null) {
            return IChatBaseComponent.i();
        }
        ScoreHolder scoreHolder = this.a(source);
        ScoreHolder scoreHolder2 = sender != null && scoreHolder.equals(ScoreHolder.cv) ? sender : scoreHolder;
        return this.a(scoreHolder2, source);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ScoreContents)) return false;
        ScoreContents scoreContents = (ScoreContents)object;
        if (!this.d.equals(scoreContents.d)) return false;
        if (!this.f.equals(scoreContents.f)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int i2 = this.d.hashCode();
        i2 = 31 * i2 + this.f.hashCode();
        return i2;
    }

    @Override
    public String toString() {
        return "score{name='" + this.d + "', objective='" + this.f + "'}";
    }
}

