/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.level.storage.loot.LootDataManager;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class AdvancementDataWorld
extends ResourceDataJson {
    private static final Logger a = LogUtils.getLogger();
    public static final Gson b = new GsonBuilder().create();
    public Map<MinecraftKey, AdvancementHolder> c = Map.of();
    private AdvancementTree d = new AdvancementTree();
    private final LootDataManager e;

    public AdvancementDataWorld(LootDataManager conditionManager) {
        super(b, "advancements");
        this.e = conditionManager;
    }

    @Override
    protected void a(Map<MinecraftKey, JsonElement> prepared, IResourceManager manager, GameProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        prepared.forEach((minecraftkey, jsonelement) -> {
            if (SpigotConfig.disabledAdvancements != null && (SpigotConfig.disabledAdvancements.contains("*") || SpigotConfig.disabledAdvancements.contains(minecraftkey.toString()) || SpigotConfig.disabledAdvancements.contains(minecraftkey.b()))) {
                return;
            }
            try {
                Advancement advancement = (Advancement)SystemUtils.a(Advancement.a.parse((DynamicOps)JsonOps.INSTANCE, jsonelement), JsonParseException::new);
                this.a((MinecraftKey)minecraftkey, advancement);
                builder.put(minecraftkey, (Object)new AdvancementHolder((MinecraftKey)minecraftkey, advancement));
            }
            catch (Exception exception) {
                a.error("Parsing error loading custom advancement {}: {}", minecraftkey, (Object)exception.getMessage());
            }
        });
        this.c = builder.buildOrThrow();
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.a(this.c.values());
        a.info("Loaded {} advancements", (Object)advancementtree.c().size());
        for (AdvancementNode advancementnode : advancementtree.b()) {
            if (!advancementnode.b().b().c().isPresent()) continue;
            TreeNodePosition.a(advancementnode);
        }
        this.d = advancementtree;
    }

    private void a(MinecraftKey id, Advancement advancement) {
        ProblemReporter.a problemreporter_a = new ProblemReporter.a();
        advancement.a(problemreporter_a, this.e);
        Multimap<String, String> multimap = problemreporter_a.a();
        if (!multimap.isEmpty()) {
            String s2 = multimap.asMap().entrySet().stream().map(entry -> {
                String s1 = (String)entry.getKey();
                return "  at " + s1 + ": " + String.join((CharSequence)"; ", (Iterable)entry.getValue());
            }).collect(Collectors.joining("\n"));
            a.warn("Found validation problems in advancement {}: \n{}", (Object)id, (Object)s2);
        }
    }

    @Nullable
    public AdvancementHolder a(MinecraftKey id) {
        return this.c.get(id);
    }

    public AdvancementTree a() {
        return this.d;
    }

    public Collection<AdvancementHolder> b() {
        return this.c.values();
    }
}

