/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import io.papermc.paper.plugin.entrypoint.LaunchEntryPointHandler;
import io.papermc.paper.world.worldgen.OptionallyFlatBedrockConditionSource;
import java.io.PrintStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.arguments.selector.options.PlayerSelector;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.server.DebugOutputStream;
import net.minecraft.server.RedirectStream;
import net.minecraft.util.datafix.fixes.DataConverterFlattenData;
import net.minecraft.util.datafix.fixes.DataConverterMaterialId;
import net.minecraft.util.datafix.fixes.DataConverterSpawnEgg;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockComposter;
import net.minecraft.world.level.block.BlockFire;
import org.slf4j.Logger;

public class DispenserRegistry {
    public static final PrintStream a = System.out;
    private static volatile boolean c;
    private static final Logger d;
    public static final AtomicLong b;

    public static void a() {
        if (!c) {
            c = true;
            Instant instant = Instant.now();
            if (BuiltInRegistries.as.e().isEmpty()) {
                throw new IllegalStateException("Unable to load registries");
            }
            BlockFire.b();
            BlockComposter.b();
            if (EntityTypes.a(EntityTypes.bv) == null) {
                throw new IllegalStateException("Failed loading EntityTypes");
            }
            PotionBrewer.a();
            PlayerSelector.a();
            IDispenseBehavior.c();
            CauldronInteraction.a();
            BuiltInRegistries.bootStrap(() -> {
                OptionallyFlatBedrockConditionSource.bootstrap();
                LaunchEntryPointHandler.enterBootstrappers();
            });
            CreativeModeTabs.a();
            DispenserRegistry.d();
            b.set(Duration.between(instant, Instant.now()).toMillis());
            DataConverterFlattenData.a(1008, "{Name:'minecraft:oak_sign',Properties:{rotation:'0'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'0'}}");
            DataConverterFlattenData.a(1009, "{Name:'minecraft:oak_sign',Properties:{rotation:'1'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'1'}}");
            DataConverterFlattenData.a(1010, "{Name:'minecraft:oak_sign',Properties:{rotation:'2'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'2'}}");
            DataConverterFlattenData.a(1011, "{Name:'minecraft:oak_sign',Properties:{rotation:'3'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'3'}}");
            DataConverterFlattenData.a(1012, "{Name:'minecraft:oak_sign',Properties:{rotation:'4'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'4'}}");
            DataConverterFlattenData.a(1013, "{Name:'minecraft:oak_sign',Properties:{rotation:'5'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'5'}}");
            DataConverterFlattenData.a(1014, "{Name:'minecraft:oak_sign',Properties:{rotation:'6'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'6'}}");
            DataConverterFlattenData.a(1015, "{Name:'minecraft:oak_sign',Properties:{rotation:'7'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'7'}}");
            DataConverterFlattenData.a(1016, "{Name:'minecraft:oak_sign',Properties:{rotation:'8'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'8'}}");
            DataConverterFlattenData.a(1017, "{Name:'minecraft:oak_sign',Properties:{rotation:'9'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'9'}}");
            DataConverterFlattenData.a(1018, "{Name:'minecraft:oak_sign',Properties:{rotation:'10'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'10'}}");
            DataConverterFlattenData.a(1019, "{Name:'minecraft:oak_sign',Properties:{rotation:'11'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'11'}}");
            DataConverterFlattenData.a(1020, "{Name:'minecraft:oak_sign',Properties:{rotation:'12'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'12'}}");
            DataConverterFlattenData.a(1021, "{Name:'minecraft:oak_sign',Properties:{rotation:'13'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'13'}}");
            DataConverterFlattenData.a(1022, "{Name:'minecraft:oak_sign',Properties:{rotation:'14'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'14'}}");
            DataConverterFlattenData.a(1023, "{Name:'minecraft:oak_sign',Properties:{rotation:'15'}}", "{Name:'minecraft:standing_sign',Properties:{rotation:'15'}}");
            DataConverterMaterialId.a.put(323, (Object)"minecraft:oak_sign");
            DataConverterFlattenData.a(1440, "{Name:'minecraft:portal',Properties:{axis:'x'}}", "{Name:'minecraft:portal',Properties:{axis:'x'}}");
            DataConverterMaterialId.a.put(409, (Object)"minecraft:prismarine_shard");
            DataConverterMaterialId.a.put(410, (Object)"minecraft:prismarine_crystals");
            DataConverterMaterialId.a.put(411, (Object)"minecraft:rabbit");
            DataConverterMaterialId.a.put(412, (Object)"minecraft:cooked_rabbit");
            DataConverterMaterialId.a.put(413, (Object)"minecraft:rabbit_stew");
            DataConverterMaterialId.a.put(414, (Object)"minecraft:rabbit_foot");
            DataConverterMaterialId.a.put(415, (Object)"minecraft:rabbit_hide");
            DataConverterMaterialId.a.put(416, (Object)"minecraft:armor_stand");
            DataConverterMaterialId.a.put(423, (Object)"minecraft:mutton");
            DataConverterMaterialId.a.put(424, (Object)"minecraft:cooked_mutton");
            DataConverterMaterialId.a.put(425, (Object)"minecraft:banner");
            DataConverterMaterialId.a.put(426, (Object)"minecraft:end_crystal");
            DataConverterMaterialId.a.put(427, (Object)"minecraft:spruce_door");
            DataConverterMaterialId.a.put(428, (Object)"minecraft:birch_door");
            DataConverterMaterialId.a.put(429, (Object)"minecraft:jungle_door");
            DataConverterMaterialId.a.put(430, (Object)"minecraft:acacia_door");
            DataConverterMaterialId.a.put(431, (Object)"minecraft:dark_oak_door");
            DataConverterMaterialId.a.put(432, (Object)"minecraft:chorus_fruit");
            DataConverterMaterialId.a.put(433, (Object)"minecraft:chorus_fruit_popped");
            DataConverterMaterialId.a.put(434, (Object)"minecraft:beetroot");
            DataConverterMaterialId.a.put(435, (Object)"minecraft:beetroot_seeds");
            DataConverterMaterialId.a.put(436, (Object)"minecraft:beetroot_soup");
            DataConverterMaterialId.a.put(437, (Object)"minecraft:dragon_breath");
            DataConverterMaterialId.a.put(438, (Object)"minecraft:splash_potion");
            DataConverterMaterialId.a.put(439, (Object)"minecraft:spectral_arrow");
            DataConverterMaterialId.a.put(440, (Object)"minecraft:tipped_arrow");
            DataConverterMaterialId.a.put(441, (Object)"minecraft:lingering_potion");
            DataConverterMaterialId.a.put(442, (Object)"minecraft:shield");
            DataConverterMaterialId.a.put(443, (Object)"minecraft:elytra");
            DataConverterMaterialId.a.put(444, (Object)"minecraft:spruce_boat");
            DataConverterMaterialId.a.put(445, (Object)"minecraft:birch_boat");
            DataConverterMaterialId.a.put(446, (Object)"minecraft:jungle_boat");
            DataConverterMaterialId.a.put(447, (Object)"minecraft:acacia_boat");
            DataConverterMaterialId.a.put(448, (Object)"minecraft:dark_oak_boat");
            DataConverterMaterialId.a.put(449, (Object)"minecraft:totem_of_undying");
            DataConverterMaterialId.a.put(450, (Object)"minecraft:shulker_shell");
            DataConverterMaterialId.a.put(452, (Object)"minecraft:iron_nugget");
            DataConverterMaterialId.a.put(453, (Object)"minecraft:knowledge_book");
            DataConverterSpawnEgg.a[23] = "Arrow";
        }
    }

    private static <T> void a(Iterable<T> registry, Function<T, String> keyExtractor, Set<String> translationKeys) {
        LocaleLanguage localelanguage = LocaleLanguage.a();
        registry.forEach(object -> {
            String s2 = (String)keyExtractor.apply(object);
            if (!localelanguage.b(s2)) {
                translationKeys.add(s2);
            }
        });
    }

    private static void a(final Set<String> translations) {
        final LocaleLanguage localelanguage = LocaleLanguage.a();
        GameRules.a(new GameRules.GameRuleVisitor(){

            @Override
            public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                if (!localelanguage.b(key.b())) {
                    translations.add(key.a());
                }
            }
        });
    }

    public static Set<String> b() {
        TreeSet<String> set = new TreeSet<String>();
        DispenserRegistry.a(BuiltInRegistries.u, AttributeBase::c, set);
        DispenserRegistry.a(BuiltInRegistries.g, EntityTypes::g, set);
        DispenserRegistry.a(BuiltInRegistries.d, MobEffectList::d, set);
        DispenserRegistry.a(BuiltInRegistries.h, Item::a, set);
        DispenserRegistry.a(BuiltInRegistries.f, Enchantment::g, set);
        DispenserRegistry.a(BuiltInRegistries.e, Block::h, set);
        DispenserRegistry.a(BuiltInRegistries.m, minecraftkey -> {
            String s2 = minecraftkey.toString();
            return "stat." + s2.replace(':', '.');
        }, set);
        DispenserRegistry.a(set);
        return set;
    }

    public static void a(Supplier<String> callerGetter) {
        if (!c) {
            throw DispenserRegistry.b(callerGetter);
        }
    }

    private static RuntimeException b(Supplier<String> callerGetter) {
        try {
            String s2 = callerGetter.get();
            return new IllegalArgumentException("Not bootstrapped (called from " + s2 + ")");
        }
        catch (Exception exception) {
            IllegalArgumentException illegalargumentexception = new IllegalArgumentException("Not bootstrapped (failed to resolve location)");
            illegalargumentexception.addSuppressed(exception);
            return illegalargumentexception;
        }
    }

    public static void c() {
        DispenserRegistry.a(() -> "validate");
        if (SharedConstants.aW) {
            DispenserRegistry.b().forEach(s2 -> d.error("Missing translations: {}", s2));
            CommandDispatcher.b();
        }
        AttributeDefaults.a();
    }

    private static void d() {
        if (d.isDebugEnabled()) {
            System.setErr(new DebugOutputStream("STDERR", System.err));
            System.setOut(new DebugOutputStream("STDOUT", a));
        } else {
            System.setErr(new RedirectStream("STDERR", System.err));
            System.setOut(new RedirectStream("STDOUT", a));
        }
    }

    public static void a(String str) {
        a.println(str);
    }

    static {
        d = LogUtils.getLogger();
        b = new AtomicLong(-1L);
    }
}

