/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import co.aikar.timings.MinecraftTimings;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import com.destroystokyo.paper.event.server.ServerTickStartEvent;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import dev.omega24.upnp4j.UPnP4J;
import dev.omega24.upnp4j.util.Protocol;
import gg.pufferfish.pufferfish.PufferfishConfig;
import gg.pufferfish.pufferfish.util.AsyncExecutor;
import io.papermc.paper.adventure.ImprovedChatDecorator;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.adventure.providers.ClickCallbackProviderImpl;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.chunk.SingleThreadChunkRegionManager;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.event.entity.EntityMoveEvent;
import io.papermc.paper.event.server.ServerResourcesReloadedEvent;
import io.papermc.paper.log.CustomLogManager;
import io.papermc.paper.threadedregions.scheduler.FoliaGlobalRegionScheduler;
import io.papermc.paper.util.CachedLists;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.ServerStopRejectedExecutionException;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.Proxy;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import joptsimple.OptionSet;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.Main;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.DemoPlayerInteractManager;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerConnection;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.ModCheck;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TimeRange;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.GameProfilerDisabled;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.thread.IAsyncTaskHandlerReentrant;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.PersistentCommandStorage;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.validation.ContentValidationException;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecrell.terminalconsole.TerminalConsoleAppender;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.generator.CraftWorldInfo;
import org.bukkit.craftbukkit.v1_20_R3.scoreboard.CraftScoreboardManager;
import org.bukkit.craftbukkit.v1_20_R3.util.ServerShutdownThread;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.PluginLoadOrder;
import org.purpurmc.purpur.PurpurConfig;
import org.purpurmc.purpur.event.entity.RidableMoveEvent;
import org.purpurmc.purpur.event.packet.NetworkItemSerializeEvent;
import org.purpurmc.purpur.task.BeehiveTask;
import org.purpurmc.purpur.task.BossBarTask;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;
import org.spigotmc.WatchdogThread;

public abstract class MinecraftServer
extends IAsyncTaskHandlerReentrant<TickTask>
implements ServerInfo,
ICommandListener,
AutoCloseable {
    private static MinecraftServer SERVER;
    public static final Logger l;
    public static final ComponentLogger COMPONENT_LOGGER;
    public static final String b = "vanilla";
    private static final float m = 0.8f;
    private static final int n = 100;
    private static final long o;
    private static final int p = 20;
    private static final long q;
    private static final int r = 100;
    private static final long s;
    private static final long t;
    private static final int u = 12;
    public static final int c = 11;
    private static final int v = 441;
    private static final int w = 6000;
    private static final int x = 100;
    private static final int y = 3;
    public static final int d = 29999984;
    public static final WorldSettings e;
    public static final GameProfile f;
    public Convertable.ConversionSession g;
    public final WorldNBTStorage h;
    private final List<Runnable> z = Lists.newArrayList();
    private MetricsRecorder A;
    private GameProfilerFiller B;
    private Consumer<MethodProfilerResults> C;
    private Consumer<Path> D;
    private boolean E;
    @Nullable
    private TimeProfiler F;
    private boolean G;
    private ServerConnection H;
    public final WorldLoadListenerFactory I;
    @Nullable
    private ServerPing J;
    @Nullable
    private ServerPing.a K;
    private final RandomSource L;
    public final DataFixer M;
    private String N;
    private int O;
    private final LayeredRegistryAccess<RegistryLayer> P;
    private Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> Q;
    private PlayerList R;
    private volatile boolean S;
    private volatile boolean isRestarting = false;
    private boolean T;
    private int U;
    private int V;
    protected final Proxy i;
    private boolean W;
    private boolean X;
    private boolean Y;
    private boolean Z;
    private Component motd;
    private int ab;
    private final long[] ac;
    private long ad;
    public final TickTimes tickTimes5s = new TickTimes(100);
    public final TickTimes tickTimes10s = new TickTimes(200);
    public final TickTimes tickTimes60s = new TickTimes(1200);
    @Nullable
    private KeyPair ae;
    @Nullable
    private GameProfile af;
    private boolean ag;
    private volatile boolean ah;
    private long ai;
    protected final Services j;
    private long aj;
    public final Thread ak;
    private long al;
    private long am;
    private boolean an;
    private final ResourcePackRepository ao;
    private final ScoreboardServer ap;
    @Nullable
    private PersistentCommandStorage aq;
    private final BossBattleCustomData ar;
    private final CustomFunctionData as;
    private boolean at;
    private float au;
    public final Executor av;
    @Nullable
    private String aw;
    public ReloadableResources ax;
    private final StructureTemplateManager ay;
    private final ServerTickRateManager az;
    protected SaveData k;
    private volatile boolean aA;
    public final WorldLoader.a worldLoader;
    public CraftServer server;
    public OptionSet options;
    public ConsoleCommandSender console;
    public static int currentTick;
    public static final long startTimeMillis;
    public Queue<Runnable> processQueue = new ConcurrentLinkedQueue<Runnable>();
    public int autosavePeriod;
    public CommandDispatcher vanillaCommandDispatcher;
    public boolean forceTicks;
    public static final int TPS = 20;
    public static final int TICK_TIME = 50000000;
    private static final int SAMPLE_INTERVAL = 20;
    @Deprecated(forRemoval=true)
    public final double[] recentTps = new double[4];
    public final PaperConfigurations paperConfigurations;
    public static long currentTickLong;
    public boolean isIteratingOverLevels = false;
    public boolean lagging = false;
    protected boolean upnp = false;
    public volatile Thread shutdownThread;
    public volatile boolean abnormalExit = false;
    public static final long SERVER_INIT;
    public AsyncExecutor mobSpawnExecutor = new AsyncExecutor("MobSpawning");
    private boolean hasStopped = false;
    private boolean hasLoggedStop = false;
    public volatile boolean hasFullyShutdown = false;
    private final Object stopLock = new Object();
    private static final long SEC_IN_NANO = 1000000000L;
    private static final long MAX_CATCHUP_BUFFER = 60000000000L;
    private long lastTick = 0L;
    private long catchupTime = 0L;
    public final RollingAverage tps5s = new RollingAverage(5);
    public final RollingAverage tps1 = new RollingAverage(60);
    public final RollingAverage tps5 = new RollingAverage(300);
    public final RollingAverage tps15 = new RollingAverage(900);
    private static final BigDecimal TPS_BASE;
    public static volatile RuntimeException chunkSystemCrash;
    boolean isOversleep = false;
    static final long CHUNK_TASK_QUEUE_BACKOFF_MIN_TIME = 25000L;
    static final long MAX_CHUNK_EXEC_TIME = 1000L;
    static final long TASK_EXECUTION_FAILURE_BACKOFF = 5000L;
    private static long lastMidTickExecute;
    private static long lastMidTickExecuteFailure;
    public final ExecutorService chatExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Chat Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(l)).build());
    public final ChatDecorator improvedChatDecorator = new ImprovedChatDecorator(this);

    public static <S extends MinecraftServer> S a(Function<Thread, S> serverFactory) {
        AtomicReference<MinecraftServer> atomicreference = new AtomicReference<MinecraftServer>();
        TickThread thread = new TickThread(() -> ((MinecraftServer)atomicreference.get()).w(), "Server thread");
        thread.setUncaughtExceptionHandler((thread1, throwable) -> l.error("Uncaught exception in server thread", throwable));
        thread.setPriority(7);
        if (Runtime.getRuntime().availableProcessors() > 4) {
            thread.setPriority(8);
        }
        MinecraftServer s0 = (MinecraftServer)serverFactory.apply(thread);
        atomicreference.set(s0);
        thread.start();
        return (S)s0;
    }

    public MinecraftServer(OptionSet options, WorldLoader.a worldLoader, Thread thread, Convertable.ConversionSession convertable_conversionsession, ResourcePackRepository resourcepackrepository, WorldStem worldstem, Proxy proxy, DataFixer datafixer, Services services, WorldLoadListenerFactory worldloadlistenerfactory) {
        super("Server");
        SERVER = this;
        this.L = RandomSource.a();
        this.O = -1;
        this.Q = Maps.newLinkedHashMap();
        this.S = true;
        this.V = 6000;
        this.ac = new long[100];
        this.ad = 0L;
        this.al = SystemUtils.c();
        this.ap = new ScoreboardServer(this);
        this.ar = new BossBattleCustomData();
        this.P = worldstem.c();
        this.k = worldstem.d();
        this.i = proxy;
        this.ao = resourcepackrepository;
        this.ax = new ReloadableResources(worldstem.a(), worldstem.b());
        this.j = services;
        if (services.f() != null) {
            services.f().a(this);
        }
        this.az = new ServerTickRateManager(this);
        this.I = worldloadlistenerfactory;
        this.g = convertable_conversionsession;
        this.h = convertable_conversionsession.e();
        this.M = datafixer;
        this.as = new CustomFunctionData(this, this.ax.b.a());
        HolderLookup<Block> holdergetter = this.P.a().d(Registries.f).p().a(this.k.M());
        this.ay = new StructureTemplateManager(worldstem.a(), convertable_conversionsession, datafixer, holdergetter);
        this.ak = thread;
        this.av = SystemUtils.f();
        this.options = options;
        this.worldLoader = worldLoader;
        this.vanillaCommandDispatcher = worldstem.b().d;
        Runtime.getRuntime().addShutdownHook(new ServerShutdownThread(this));
        this.paperConfigurations = services.paperConfigurations();
    }

    @Override
    private void a(WorldPersistentData persistentStateManager) {
        persistentStateManager.a(this.aH().b(), "scoreboard");
    }

    protected abstract boolean e() throws IOException;

    protected void loadLevel(String s2) {
        if (!JvmProfiler.e.c()) {
            // empty if block
        }
        boolean flag = false;
        ProfiledDuration profiledduration = JvmProfiler.e.e();
        this.loadWorld0(s2);
        if (profiledduration != null) {
            profiledduration.finish();
        }
        if (flag) {
            try {
                JvmProfiler.e.b();
            }
            catch (Throwable throwable) {
                l.warn("Failed to stop JFR profiling", throwable);
            }
        }
    }

    protected void r() {
    }

    private void loadWorld0(String s2) {
        Convertable.ConversionSession worldSession = this.g;
        IRegistry<WorldDimension> dimensions = this.P.a().d(Registries.aN);
        for (WorldDimension worldDimension : dimensions) {
            WorldServer world;
            WorldDataServer worlddata;
            Dynamic<?> dynamic;
            String name;
            ResourceKey<WorldDimension> dimensionKey = dimensions.c(worldDimension).get();
            int dimension = 0;
            if (dimensionKey == WorldDimension.c) {
                if (!this.D()) continue;
                dimension = -1;
            } else if (dimensionKey == WorldDimension.d) {
                if (!this.server.getAllowEnd()) continue;
                dimension = 1;
            } else if (dimensionKey != WorldDimension.b) {
                dimension = -999;
            }
            String worldType = dimension == -999 ? dimensionKey.a().b() + "_" + dimensionKey.a().a() : World.Environment.getEnvironment((int)dimension).toString().toLowerCase();
            String string = name = dimensionKey == WorldDimension.b ? s2 : s2 + "_" + worldType;
            if (dimension != 0) {
                File newWorld = Convertable.getStorageFolder(new File(name).toPath(), dimensionKey).toFile();
                File oldWorld = Convertable.getStorageFolder(new File(s2).toPath(), dimensionKey).toFile();
                File oldLevelDat = new File(new File(s2), "level.dat");
                if (!newWorld.isDirectory() && oldWorld.isDirectory() && oldLevelDat.isFile()) {
                    l.info("---- Migration of old " + worldType + " folder required ----");
                    l.info("Unfortunately due to the way that Minecraft implemented multiworld support in 1.6, Bukkit requires that you move your " + worldType + " folder to a new location in order to operate correctly.");
                    l.info("We will move this folder for you, but it will mean that you need to move it back should you wish to stop using Bukkit in the future.");
                    l.info("Attempting to move " + oldWorld + " to " + newWorld + "...");
                    if (newWorld.exists()) {
                        l.warn("A file or folder already exists at " + newWorld + "!");
                        l.info("---- Migration of old " + worldType + " folder failed ----");
                    } else if (newWorld.getParentFile().mkdirs()) {
                        if (oldWorld.renameTo(newWorld)) {
                            l.info("Success! To restore " + worldType + " in the future, simply move " + newWorld + " to " + oldWorld);
                            try {
                                Files.copy((File)oldLevelDat, (File)new File(new File(name), "level.dat"));
                                FileUtils.copyDirectory((File)new File(new File(s2), "data"), (File)new File(new File(name), "data"));
                            }
                            catch (IOException exception) {
                                l.warn("Unable to migrate world data.");
                            }
                            l.info("---- Migration of old " + worldType + " folder complete ----");
                        } else {
                            l.warn("Could not move folder " + oldWorld + " to " + newWorld + "!");
                            l.info("---- Migration of old " + worldType + " folder failed ----");
                        }
                    } else {
                        l.warn("Could not create path for " + newWorld + "!");
                        l.info("---- Migration of old " + worldType + " folder failed ----");
                    }
                }
                try {
                    worldSession = Convertable.b(this.server.getWorldContainer().toPath()).validateAndCreateAccess(name, dimensionKey);
                }
                catch (IOException | ContentValidationException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (worldSession.k()) {
                WorldInfo worldinfo;
                try {
                    dynamic = worldSession.f();
                    worldinfo = worldSession.a(dynamic);
                }
                catch (IOException | NbtException | ReportedNbtException ioexception) {
                    Convertable.b convertable_b = worldSession.c();
                    l.warn("Failed to load world data from {}", (Object)convertable_b.b(), (Object)ioexception);
                    l.info("Attempting to use fallback");
                    try {
                        dynamic = worldSession.g();
                        worldinfo = worldSession.a(dynamic);
                    }
                    catch (IOException | NbtException | ReportedNbtException ioexception1) {
                        l.error("Failed to load world data from {}", (Object)convertable_b.c(), (Object)ioexception1);
                        l.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)convertable_b.b(), (Object)convertable_b.c());
                        return;
                    }
                    worldSession.l();
                }
                if (worldinfo.d()) {
                    l.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!worldinfo.r()) {
                    l.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dynamic = null;
            }
            ChunkGenerator gen = this.server.getGenerator(name);
            BiomeProvider biomeProvider = this.server.getBiomeProvider(name);
            WorldLoader.a worldloader_a = this.worldLoader;
            IRegistry<WorldDimension> iregistry = worldloader_a.d().d(Registries.aN);
            if (dynamic != null) {
                LevelDataAndDimensions leveldataanddimensions = Convertable.a(dynamic, worldloader_a.b(), iregistry, worldloader_a.c());
                worlddata = (WorldDataServer)leveldataanddimensions.a();
            } else {
                WorldDimensions worlddimensions;
                WorldOptions worldoptions;
                WorldSettings worldsettings;
                if (this.T()) {
                    worldsettings = e;
                    worldoptions = WorldOptions.b;
                    worlddimensions = WorldPresets.a(worldloader_a.c());
                } else {
                    DedicatedServerProperties dedicatedserverproperties = ((DedicatedServer)this).a();
                    worldsettings = new WorldSettings(dedicatedserverproperties.m, dedicatedserverproperties.l, dedicatedserverproperties.u, dedicatedserverproperties.k, false, new GameRules(), worldloader_a.b());
                    worldoptions = this.options.has("bonusChest") ? dedicatedserverproperties.Y.a(true) : dedicatedserverproperties.Y;
                    worlddimensions = dedicatedserverproperties.a(worldloader_a.c());
                }
                WorldDimensions.b worlddimensions_b = worlddimensions.a(iregistry);
                Lifecycle lifecycle = worlddimensions_b.a().add(worldloader_a.c().e());
                worlddata = new WorldDataServer(worldsettings, worldoptions, worlddimensions_b.d(), lifecycle);
            }
            worlddata.checkName(name);
            WorldDataServer iworlddataserver = worlddata;
            boolean flag = worlddata.C();
            WorldOptions worldoptions = worlddata.A();
            long i2 = worldoptions.b();
            long j2 = BiomeManager.a(i2);
            ImmutableList list = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(iworlddataserver));
            WorldDimension worlddimension = dimensions.a(dimensionKey);
            CraftWorldInfo worldInfo = new CraftWorldInfo(iworlddataserver, worldSession, World.Environment.getEnvironment((int)dimension), worlddimension.a().a(), worlddimension.b(), this.aZ());
            if (biomeProvider == null && gen != null) {
                biomeProvider = gen.getDefaultBiomeProvider((org.bukkit.generator.WorldInfo)worldInfo);
            }
            if (this.options.has("forceUpgrade")) {
                Main.convertWorldButItWorks(dimensionKey, worldSession, DataConverterRegistry.a(), worlddimension.b().b(), this.options.has("eraseCache"));
            }
            ResourceKey<net.minecraft.world.level.World> worldKey = ResourceKey.a(Registries.aM, dimensionKey.a());
            if (dimensionKey == WorldDimension.b) {
                this.k = worlddata;
                this.k.a(((DedicatedServer)this).a().l);
                worldloadlistener = this.I.create(11);
                world = new WorldServer(this, this.av, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j2, (List<MobSpawner>)list, true, null, World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
                WorldPersistentData worldpersistentdata = world.u();
                this.a(worldpersistentdata);
                this.server.scoreboardManager = new CraftScoreboardManager(this, world.f());
                this.aq = new PersistentCommandStorage(worldpersistentdata);
            } else {
                worldloadlistener = this.I.create(11);
                ImmutableList spawners = GlobalConfiguration.get().misc.useDimensionTypeForCustomSpawners && this.aZ().d(Registries.ay).c(worlddimension.a().a()).orElseThrow() == BuiltinDimensionTypes.a ? list : Collections.emptyList();
                world = new WorldServer(this, this.av, worldSession, iworlddataserver, worldKey, worlddimension, worldloadlistener, flag, j2, (List<MobSpawner>)spawners, true, this.F().J(), World.Environment.getEnvironment((int)dimension), gen, biomeProvider);
            }
            worlddata.a(this.getServerModName(), this.M().a());
            this.addLevel(world);
            this.initWorld(world, worlddata, this.k, worldoptions);
            this.ae().a(world);
            if (worlddata.G() == null) continue;
            this.aL().a(worlddata.G());
        }
        this.r();
        for (WorldServer worldserver : this.H()) {
            this.prepareLevels(worldserver.l().a.D, worldserver);
            this.server.getPluginManager().callEvent((Event)new WorldLoadEvent((World)worldserver.getWorld()));
        }
        ScoreboardServer scoreboard = this.aH();
        Collection toRemove = scoreboard.g().stream().filter(team -> team.b().startsWith("collideRule_")).map(ScoreboardTeam::b).collect(Collectors.toList());
        for (String teamName : toRemove) {
            scoreboard.d(scoreboard.b(teamName));
        }
        if (!GlobalConfiguration.get().collisions.enablePlayerCollisions) {
            this.ae().collideRuleTeamName = StringUtils.left((String)("collideRule_" + ThreadLocalRandom.current().nextInt()), (int)16);
            ScoreboardTeam collideTeam = scoreboard.c(this.ae().collideRuleTeamName);
            collideTeam.b(false);
        }
        this.server.enablePlugins(PluginLoadOrder.POSTWORLD);
        this.server.getPluginManager().callEvent((Event)new ServerLoadEvent(ServerLoadEvent.LoadType.STARTUP));
        this.H.acceptConnections();
    }

    public void initWorld(WorldServer worldserver, IWorldDataServer iworlddataserver, SaveData saveData, WorldOptions worldoptions) {
        boolean flag = saveData.C();
        if (worldserver.generator != null) {
            worldserver.getWorld().getPopulators().addAll(worldserver.generator.getDefaultPopulators((World)worldserver.getWorld()));
        }
        WorldBorder worldborder = worldserver.D_();
        worldborder.a(iworlddataserver.r());
        this.server.getPluginManager().callEvent((Event)new WorldInitEvent((World)worldserver.getWorld()));
        if (!iworlddataserver.p()) {
            try {
                MinecraftServer.a(worldserver, iworlddataserver, worldoptions.d(), flag);
                iworlddataserver.c(true);
                if (flag) {
                    this.a(this.k);
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a(throwable, "Exception initializing level");
                try {
                    worldserver.a(crashreport);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw new ReportedException(crashreport);
            }
            iworlddataserver.c(true);
        }
    }

    private static void a(WorldServer world, IWorldDataServer worldProperties, boolean bonusChest, boolean debugWorld) {
        if (debugWorld) {
            worldProperties.a(BlockPosition.b.b(80), 0.0f);
        } else {
            int i2;
            ChunkProviderServer chunkproviderserver = world.l();
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(chunkproviderserver.i().b().a());
            if (world.generator != null) {
                Random rand = new Random(world.C());
                Location spawn = world.generator.getFixedSpawnLocation((World)world.getWorld(), rand);
                if (spawn != null) {
                    if (spawn.getWorld() != world.getWorld()) {
                        throw new IllegalStateException("Cannot set spawn point for " + worldProperties.g() + " to be in another world (" + spawn.getWorld().getName() + ")");
                    }
                    worldProperties.a(new BlockPosition(spawn.getBlockX(), spawn.getBlockY(), spawn.getBlockZ()), spawn.getYaw());
                    return;
                }
            }
            if ((i2 = chunkproviderserver.g().a(world)) < world.J_()) {
                BlockPosition blockposition = chunkcoordintpair.l();
                i2 = world.a(HeightMap.Type.b, blockposition.u() + 8, blockposition.w() + 8);
            }
            worldProperties.a(chunkcoordintpair.l().b(8, i2, 8), 0.0f);
            int j2 = 0;
            int k2 = 0;
            int l2 = 0;
            int i1 = -1;
            boolean flag2 = true;
            for (int j1 = 0; j1 < MathHelper.h(11); ++j1) {
                BlockPosition blockposition1;
                if (j2 >= -5 && j2 <= 5 && k2 >= -5 && k2 <= 5 && (blockposition1 = WorldProviderNormal.a(world, new ChunkCoordIntPair(chunkcoordintpair.e + j2, chunkcoordintpair.f + k2))) != null) {
                    worldProperties.a(blockposition1, 0.0f);
                    break;
                }
                if (j2 == k2 || j2 < 0 && j2 == -k2 || j2 > 0 && j2 == 1 - k2) {
                    int k1 = l2;
                    l2 = -i1;
                    i1 = k1;
                }
                j2 += l2;
                k2 += i1;
            }
            if (bonusChest) {
                world.I_().c(Registries.aw).flatMap(iregistry -> iregistry.b(MiscOverworldFeatures.m)).ifPresent(holder_c -> ((WorldGenFeatureConfigured)holder_c.a()).a(world, chunkproviderserver.g(), world.z, new BlockPosition(worldProperties.a(), worldProperties.b(), worldProperties.c())));
            }
        }
    }

    @Override
    private void a(SaveData properties) {
        properties.a(EnumDifficulty.a);
        properties.d(true);
        IWorldDataServer iworlddataserver = properties.K();
        iworlddataserver.b(false);
        iworlddataserver.a(false);
        iworlddataserver.a(1000000000);
        iworlddataserver.b(6000L);
        iworlddataserver.a(EnumGamemode.d);
    }

    public void prepareLevels(WorldLoadListener worldloadlistener, WorldServer worldserver) {
        WorldServer worldserver1;
        ForcedChunk forcedchunk;
        ChunkProviderServer chunkproviderserver = worldserver.l();
        this.forceTicks = true;
        if (worldserver.getWorld().getKeepSpawnInMemory()) {
            l.info("Preparing start region for dimension {}", (Object)worldserver.ae().a());
            BlockPosition blockposition = worldserver.T();
            worldloadlistener.a(new ChunkCoordIntPair(blockposition));
            this.al = SystemUtils.c();
            int radiusBlocks = worldserver.paperConfig().spawn.keepSpawnLoadedRange * 16;
            int radiusChunks = radiusBlocks / 16 + ((radiusBlocks & 0xF) != 0 ? 1 : 0);
            int totalChunks = radiusChunks * 2 + 1;
            totalChunks *= totalChunks;
            worldloadlistener.setChunkRadius(radiusBlocks / 16);
            worldserver.addTicketsForSpawn(radiusBlocks, blockposition);
            this.executeModerately();
        }
        if ((forcedchunk = (worldserver1 = worldserver).u().b(ForcedChunk.a(), "chunks")) != null) {
            LongIterator longiterator = forcedchunk.b().iterator();
            while (longiterator.hasNext()) {
                long i2 = longiterator.nextLong();
                ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(i2);
                worldserver1.l().a(chunkcoordintpair, true);
            }
        }
        this.executeModerately();
        if (worldserver.getWorld().getKeepSpawnInMemory()) {
            worldloadlistener.b();
        }
        worldserver.b(worldserver.K.s() != EnumDifficulty.a && ((DedicatedServer)this).s.a().w, this.Y());
        this.forceTicks = false;
    }

    public EnumGamemode v_() {
        return this.k.m();
    }

    public boolean h() {
        return this.k.n();
    }

    public abstract int i();

    public abstract int j();

    public abstract boolean k();

    public boolean a(boolean suppressLogs, boolean flush, boolean force) {
        return this.saveAllChunks(suppressLogs, flush, force, false);
    }

    public boolean saveAllChunks(boolean suppressLogs, boolean flush, boolean force, boolean close) {
        boolean flag3 = false;
        for (WorldServer worldserver : this.H()) {
            if (!suppressLogs) {
                l.info("Saving chunks for level '{}'/{}", (Object)worldserver, (Object)worldserver.ae().a());
            }
            worldserver.save(null, flush, worldserver.e && !force, close);
            if (flush) {
                l.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)worldserver.l().a.n());
            }
            flag3 = true;
        }
        if (flush) {
            for (WorldServer worldServer : this.H()) {
            }
            l.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return flag3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean b(boolean suppressLogs, boolean flush, boolean force) {
        boolean flag3;
        try {
            this.aA = true;
            this.ae().h();
            flag3 = this.a(suppressLogs, flush, force);
        }
        finally {
            this.aA = false;
        }
        return flag3;
    }

    @Override
    public void close() {
        this.t();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasStopped() {
        Object object = this.stopLock;
        synchronized (object) {
            return this.hasStopped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t() {
        Object object = this.stopLock;
        synchronized (object) {
            if (this.hasStopped) {
                return;
            }
            this.hasStopped = true;
        }
        if (!this.hasLoggedStop && this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.shutdownThread = Thread.currentThread();
        WatchdogThread.doStop();
        if (!this.bq()) {
            l.info("Stopping main thread (Ignore any thread death message you see! - DO NOT REPORT THREAD DEATH TO PURPUR)");
            while (this.aw().isAlive()) {
                this.aw().stop();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        l.info("Stopping server");
        CommandDispatcher.COMMAND_SENDING_POOL.shutdownNow();
        MinecraftTimings.stopServer();
        if (this.upnp) {
            if (UPnP4J.close((int)this.O(), (Protocol)Protocol.TCP)) {
                l.info("[UPnP] Port {} closed", (Object)this.O());
            } else {
                l.error("[UPnP] Failed to close port {}", (Object)this.O());
            }
        }
        if (this.server != null) {
            this.server.disablePlugins();
            this.server.waitForAsyncTasksShutdown();
        }
        this.af().b();
        this.aA = true;
        if (this.R != null) {
            l.info("Saving players");
            this.R.h();
            this.R.removeAll(this.isRestarting);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        l.info("Saving worlds");
        for (WorldServer worldserver : this.H()) {
            if (worldserver == null) continue;
            worldserver.e = false;
        }
        this.saveAllChunks(false, true, false, true);
        this.aA = false;
        this.ax.close();
        try {
            this.g.close();
        }
        catch (IOException ioexception1) {
            l.error("Failed to unlock level {}", (Object)this.g.d(), (Object)ioexception1);
        }
        MCUtil.asyncExecutor.shutdown();
        try {
            MCUtil.asyncExecutor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (SpigotConfig.saveUserCacheOnStopOnly) {
            l.info("Saving usercache.json");
            this.ar().save(false);
        }
        l.info("Flushing Chunk IO");
        RegionFileIOThread.close(true);
        l.info("Closing Thread Pool");
        SystemUtils.i();
        l.info("Closing Server");
        try {
            TerminalConsoleAppender.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        CustomLogManager.forceReset();
        this.g();
    }

    public String u() {
        return this.N;
    }

    public void a_(String serverIp) {
        this.N = serverIp;
    }

    public boolean v() {
        return this.S;
    }

    @Override
    public void a(boolean waitForShutdown) {
        this.safeShutdown(waitForShutdown, false);
    }

    public void safeShutdown(boolean waitForShutdown, boolean isRestarting) {
        BossBarTask.stopAll();
        BeehiveTask.instance().unregister();
        this.isRestarting = isRestarting;
        this.hasLoggedStop = true;
        if (this.isDebugging()) {
            TraceUtil.dumpTraceForThread("Server stopped");
        }
        this.S = false;
        if (waitForShutdown) {
            try {
                this.ak.join();
            }
            catch (InterruptedException interruptedexception) {
                l.error("Error while shutting down", (Throwable)interruptedexception);
            }
        }
    }

    private static double calcTps(double avg, double exp, double tps) {
        return avg * exp + tps * (1.0 - exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void w() {
        try {
            long serverStartTime = SystemUtils.c();
            if (!this.e()) {
                throw new IllegalStateException("Failed to initialize server");
            }
            this.al = SystemUtils.c();
            this.K = this.bm().orElse(null);
            this.J = this.bo();
            l.info("Running delayed init tasks");
            this.server.getScheduler().mainThreadHeartbeat(this.U);
            String doneTime = String.format(Locale.ROOT, "%.3fs", (double)(SystemUtils.c() - serverStartTime) / 1.0E9);
            l.info("Done ({})! For help, type \"help\"", (Object)doneTime);
            WatchdogThread.tick();
            WatchdogThread.hasStarted = true;
            Arrays.fill(this.recentTps, 20.0);
            long tickSection = SystemUtils.c();
            if (GlobalConfiguration.isFirstStart) {
                l.info("*************************************************************************************");
                l.info("This is the first time you're starting this server.");
                l.info("It's recommended you read our 'Getting Started' documentation for guidance.");
                l.info("View this and more helpful information here: https://docs.papermc.io/paper/next-steps");
                l.info("*************************************************************************************");
            }
            while (this.S) {
                long i2;
                if (chunkSystemCrash != null) {
                    throw chunkSystemCrash;
                }
                if (!this.A() && this.az.a() && this.az.d()) {
                    i2 = 0L;
                    this.ai = this.al = SystemUtils.c();
                } else {
                    i2 = this.az.h();
                    long j2 = SystemUtils.c() - this.al;
                    if (j2 > o + 20L * i2 && this.al - this.ai >= q + 100L * i2) {
                        long k2 = j2 / i2;
                        if (this.server.getWarnOnOverload()) {
                            l.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)(j2 / TimeRange.b), (Object)k2);
                        }
                        this.al += k2 * i2;
                        this.ai = this.al;
                    }
                }
                ++currentTickLong;
                long currentTime = SystemUtils.c();
                if (++currentTick % 20 == 0) {
                    long diff = currentTime - tickSection;
                    BigDecimal currentTps = TPS_BASE.divide(new BigDecimal(diff), 30, RoundingMode.HALF_UP);
                    this.tps5s.add(currentTps, diff);
                    this.tps1.add(currentTps, diff);
                    this.tps5.add(currentTps, diff);
                    this.tps15.add(currentTps, diff);
                    this.recentTps[0] = this.tps5s.getAverage();
                    this.recentTps[1] = this.tps1.getAverage();
                    this.recentTps[2] = this.tps5.getAverage();
                    this.recentTps[3] = this.tps15.getAverage();
                    this.lagging = this.recentTps[0] < PurpurConfig.laggingThreshold;
                    tickSection = currentTime;
                }
                boolean flag = i2 == 0L;
                this.lastTick = currentTime;
                this.al += i2;
                this.a(flag ? () -> false : this::bk);
                this.an = true;
                this.am = Math.max(SystemUtils.c() + i2, this.al);
                if (!PurpurConfig.tpsCatchup || !PufferfishConfig.tpsCatchup) {
                    this.am = this.al = currentTime + i2;
                }
                this.w_();
                if (flag) {
                    this.az.e();
                }
                this.ah = true;
                JvmProfiler.e.a(this.au);
            }
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                l.error("Main thread terminated by WatchDog due to hard crash", throwable);
                return;
            }
            l.error("Encountered an unexpected exception", throwable);
            CrashReport crashreport = MinecraftServer.a(throwable);
            this.b(crashreport.g());
            File file = new File(new File(this.z(), "crash-reports"), "crash-" + SystemUtils.e() + "-server.txt");
            if (crashreport.a(file)) {
                l.error("This crash report has been saved to: {}", (Object)file.getAbsolutePath());
            } else {
                l.error("We were unable to save this crash report to disk.");
            }
            this.a(crashreport);
            return;
        }
        finally {
            try {
                this.T = true;
                this.t();
            }
            catch (Throwable throwable1) {
                l.error("Exception stopping the server", throwable1);
            }
            finally {
                if (this.j.f() != null) {
                    this.j.f().a();
                }
            }
        }
    }

    private static CrashReport a(Throwable throwable) {
        CrashReport crashreport;
        ReportedException reportedexception = null;
        for (Throwable throwable1 = throwable; throwable1 != null; throwable1 = throwable1.getCause()) {
            ReportedException reportedexception1;
            if (!(throwable1 instanceof ReportedException)) continue;
            reportedexception = reportedexception1 = (ReportedException)throwable1;
        }
        if (reportedexception != null) {
            crashreport = reportedexception.a();
            if (reportedexception != throwable) {
                crashreport.a("Wrapped in").a("Wrapping exception", throwable);
            }
        } else {
            crashreport = new CrashReport("Exception in server tick loop", throwable);
        }
        return crashreport;
    }

    private boolean bk() {
        if (this.forceTicks) {
            return true;
        }
        if (this.isOversleep) {
            return this.canOversleep();
        }
        return this.forceTicks || this.bw() || SystemUtils.c() < (this.an ? this.am : this.al);
    }

    private boolean canOversleep() {
        return this.an && SystemUtils.c() < this.am;
    }

    private boolean canSleepForTickNoOversleep() {
        return this.forceTicks || this.bw() || SystemUtils.c() < this.al;
    }

    private void executeModerately() {
        this.bu();
        LockSupport.parkNanos("executing tasks", 1000L);
    }

    protected void w_() {
        this.c(() -> !this.canSleepForTickNoOversleep());
    }

    public TickTask a(Runnable runnable) {
        if (this.hasStopped && Thread.currentThread().equals(this.shutdownThread)) {
            runnable.run();
            runnable = () -> {};
        }
        return new TickTask(this.U, runnable);
    }

    protected boolean a(TickTask ticktask) {
        return ticktask.a() + 3 < this.U || this.bk();
    }

    @Override
    public boolean x() {
        boolean flag;
        this.an = flag = this.bl();
        return flag;
    }

    private boolean tickMidTickTasks() {
        boolean executed = false;
        for (WorldServer world : this.H()) {
            long currTime = System.nanoTime();
            if (currTime - world.lastMidTickExecuteFailure <= 5000L) continue;
            if (!world.l().d()) {
                world.lastMidTickExecuteFailure = currTime;
                continue;
            }
            executed = true;
        }
        return executed;
    }

    public final void executeMidTickTasks() {
        long overuse;
        long currTime;
        long diff;
        boolean moreTasks;
        AsyncCatcher.catchOp("mid tick chunk task execution");
        long startTime = System.nanoTime();
        if (startTime - lastMidTickExecute <= 25000L || startTime - lastMidTickExecuteFailure <= 5000L) {
            return;
        }
        do {
            moreTasks = this.tickMidTickTasks();
            currTime = System.nanoTime();
            diff = currTime - startTime;
        } while (moreTasks && diff < 1000L);
        if (!moreTasks) {
            lastMidTickExecuteFailure = currTime;
        }
        if ((overuse = diff - 1000L) >= 10000000L) {
            overuse = 10000000L;
        }
        double overuseCount = (double)overuse / 1000.0;
        long extraSleep = Math.round(overuseCount * 25000.0);
        lastMidTickExecute = currTime + extraSleep;
    }

    private boolean bl() {
        if (super.x()) {
            this.executeMidTickTasks();
            return true;
        }
        boolean ret = false;
        if (this.az.a() || this.bk()) {
            for (WorldServer worldserver : this.H()) {
                if (!worldserver.l().d()) continue;
                ret = true;
            }
        }
        return ret;
    }

    public void b(TickTask ticktask) {
        super.d(ticktask);
    }

    private Optional<ServerPing.a> bm() {
        Optional<Path> optional = Optional.of(this.c("server-icon.png").toPath()).filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])).or(() -> this.g.h().filter(path -> java.nio.file.Files.isRegularFile(path, new LinkOption[0])));
        return optional.flatMap(path -> {
            try {
                BufferedImage bufferedimage = ImageIO.read(path.toFile());
                Preconditions.checkState((bufferedimage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((bufferedimage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedimage, "PNG", bytearrayoutputstream);
                return Optional.of(new ServerPing.a(bytearrayoutputstream.toByteArray()));
            }
            catch (Exception exception) {
                l.error("Couldn't load server icon", (Throwable)exception);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> y() {
        return this.g.h();
    }

    public File z() {
        return new File(".");
    }

    @Override
    public void a(CrashReport report) {
    }

    public void g() {
    }

    public boolean A() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(BooleanSupplier shouldKeepTicking) {
        long i2 = SystemUtils.c();
        this.c(() -> !this.canOversleep());
        new ServerTickStartEvent(this.U + 1).callEvent();
        ++this.U;
        this.az.m();
        this.b(shouldKeepTicking);
        if (i2 - this.aj >= s) {
            this.aj = i2;
            this.J = this.bo();
        }
        --this.V;
        int playerSaveInterval = GlobalConfiguration.get().playerAutoSave.rate;
        if (playerSaveInterval < 0) {
            playerSaveInterval = this.autosavePeriod;
        }
        boolean fullSave = this.autosavePeriod > 0 && this.U % this.autosavePeriod == 0;
        try {
            this.aA = true;
            if (playerSaveInterval > 0) {
                this.R.saveAll(playerSaveInterval);
            }
            for (WorldServer level : this.H()) {
                if (level.paperConfig().chunks.autoSaveInterval.value() <= 0) continue;
                level.saveIncrementally(fullSave);
            }
        }
        finally {
            this.aA = false;
        }
        CachedLists.reset();
        this.bu();
        long endTime = System.nanoTime();
        long remaining = 50000000L - (endTime - this.lastTick) - this.catchupTime;
        new ServerTickEndEvent(this.U, (double)(endTime - this.lastTick) / 1000000.0, remaining).callEvent();
        long j2 = SystemUtils.c() - i2;
        int k2 = this.U % 100;
        this.ad -= this.ac[k2];
        this.ad += j2;
        this.ac[k2] = j2;
        this.au = this.au * 0.8f + (float)j2 / (float)TimeRange.b * 0.19999999f;
        long l2 = SystemUtils.c();
        this.tickTimes5s.add(this.U, j2);
        this.tickTimes10s.add(this.U, j2);
        this.tickTimes60s.add(this.U, j2);
        this.a(l2 - i2);
        WatchdogThread.tick();
    }

    private int bn() {
        float f2;
        if (this.az.a()) {
            long i2 = this.aP() + 1L;
            f2 = (float)TimeRange.a / (float)i2;
        } else {
            f2 = this.az.f();
        }
        boolean flag = true;
        return Math.max(100, (int)(f2 * 300.0f));
    }

    public void B() {
        int i2 = this.bn();
        if (i2 < this.V) {
            this.V = i2;
        }
    }

    @Override
    protected void a(long nanos) {
    }

    private ServerPing bo() {
        ServerPing.ServerPingPlayerSample serverping_serverpingplayersample = this.bx();
        return new ServerPing(PaperAdventure.asVanilla(this.motd), Optional.of(serverping_serverpingplayersample), Optional.of(ServerPing.ServerData.a()), Optional.ofNullable(this.K), this.ay());
    }

    private ServerPing.ServerPingPlayerSample bx() {
        List<EntityPlayer> list = this.R.t();
        int i2 = this.K();
        if (this.al()) {
            return new ServerPing.ServerPingPlayerSample(i2, list.size(), List.of());
        }
        int j2 = Math.min(list.size(), SpigotConfig.playerSample);
        ObjectArrayList objectarraylist = new ObjectArrayList(j2);
        int k2 = MathHelper.a(this.L, 0, list.size() - j2);
        for (int l2 = 0; l2 < j2; ++l2) {
            EntityPlayer entityplayer = list.get(k2 + l2);
            objectarraylist.add((Object)(entityplayer.Z() ? entityplayer.fR() : f));
        }
        SystemUtils.c(objectarraylist, this.L);
        return new ServerPing.ServerPingPlayerSample(i2, list.size(), (List<GameProfile>)objectarraylist);
    }

    public void b(BooleanSupplier shouldKeepTicking) {
        this.ae().t().forEach(entityplayer -> entityplayer.c.g());
        this.server.getScheduler().mainThreadHeartbeat(this.U);
        ((FoliaGlobalRegionScheduler)Bukkit.getGlobalRegionScheduler()).tick();
        this.H().forEach(level -> {
            for (Entity entity : level.getEntityLookup().getAllCopy()) {
                CraftEntity bukkit;
                if (entity.dH() || (bukkit = entity.getBukkitEntityRaw()) == null) continue;
                bukkit.taskScheduler.executeTick();
            }
        });
        ClickCallbackProviderImpl.CALLBACK_MANAGER.handleQueue(this.U);
        this.aC().b();
        while (!this.processQueue.isEmpty()) {
            this.processQueue.remove().run();
        }
        for (WorldServer level2 : this.H()) {
            boolean doDaylight = level2.Z().b(GameRules.l);
            long dayTime = level2.Y();
            long worldTime = level2.X();
            PacketPlayOutUpdateTime worldPacket = new PacketPlayOutUpdateTime(worldTime, dayTime, doDaylight);
            for (EntityHuman entityHuman : level2.x()) {
                if (!(entityHuman instanceof EntityPlayer) || !level2.isForceTime() && (this.U + entityHuman.aj()) % 20 != 0) continue;
                EntityPlayer entityplayer2 = (EntityPlayer)entityHuman;
                long playerTime = entityplayer2.getPlayerTime();
                PacketPlayOutUpdateTime packet = playerTime == dayTime ? worldPacket : new PacketPlayOutUpdateTime(worldTime, playerTime, doDaylight);
                entityplayer2.c.b(packet);
            }
        }
        this.isIteratingOverLevels = true;
        PacketDataSerializer.hasItemSerializeEvent = NetworkItemSerializeEvent.getHandlerList().getRegisteredListeners().length > 0;
        for (WorldServer worldserver : this.H()) {
            worldserver.hasPhysicsEvent = BlockPhysicsEvent.getHandlerList().getRegisteredListeners().length > 0;
            worldserver.hasEntityMoveEvent = EntityMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            TileEntityHopper.skipHopperEvents = worldserver.paperConfig().hopper.disableMoveEvent || InventoryMoveItemEvent.getHandlerList().getRegisteredListeners().length == 0;
            worldserver.updateLagCompensationTick();
            worldserver.hasRidableMoveEvent = RidableMoveEvent.getHandlerList().getRegisteredListeners().length > 0;
            try {
                worldserver.a(shouldKeepTicking);
                for (SingleThreadChunkRegionManager regionManager : worldserver.l().a.regionManagers) {
                    regionManager.recalculateRegions();
                }
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.a(throwable, "Exception ticking world");
                worldserver.a(crashreport);
                throw new ReportedException(crashreport);
            }
            worldserver.explosionDensityCache.clear();
        }
        this.isIteratingOverLevels = false;
        this.af().c();
        this.R.d();
        if (SharedConstants.aW && this.az.i()) {
            GameTestHarnessTicker.a.b();
        }
        for (int i2 = 0; i2 < this.z.size(); ++i2) {
            this.z.get(i2).run();
        }
        for (EntityPlayer entityplayer3 : this.R.t()) {
            entityplayer3.c.f.a(entityplayer3);
            entityplayer3.c.h();
        }
    }

    private void b(WorldServer world) {
        this.R.a(new PacketPlayOutUpdateTime(world.X(), world.Y(), world.Z().b(GameRules.l)), world.ae());
    }

    public void C() {
        for (WorldServer worldserver : this.H()) {
            this.b(worldserver);
        }
    }

    public boolean D() {
        return true;
    }

    public void b(Runnable tickable) {
        this.z.add(tickable);
    }

    protected void b(String serverId) {
        this.aw = serverId;
    }

    public boolean E() {
        return !this.ak.isAlive();
    }

    public File c(String path) {
        return new File(this.z(), path);
    }

    public final WorldServer F() {
        return this.Q.get(net.minecraft.world.level.World.h);
    }

    @Nullable
    public WorldServer a(ResourceKey<net.minecraft.world.level.World> key) {
        return this.Q.get(key);
    }

    public void addLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.Q;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.put(level.ae(), level);
        this.Q = Collections.unmodifiableMap(newLevels);
    }

    public void removeLevel(WorldServer level) {
        Map<ResourceKey<net.minecraft.world.level.World>, WorldServer> oldLevels = this.Q;
        LinkedHashMap newLevels = Maps.newLinkedHashMap(oldLevels);
        newLevels.remove(level.ae());
        this.Q = Collections.unmodifiableMap(newLevels);
    }

    public Set<ResourceKey<net.minecraft.world.level.World>> G() {
        return this.Q.keySet();
    }

    public Iterable<WorldServer> H() {
        return this.Q.values();
    }

    @Override
    public String I() {
        return SharedConstants.b().c();
    }

    @Override
    public int J() {
        return this.R.m();
    }

    @Override
    public int K() {
        return this.R.n();
    }

    public String[] L() {
        return this.R.e();
    }

    @DontObfuscate
    public String getServerModName() {
        return PurpurConfig.serverModName;
    }

    public SystemReport b(SystemReport details) {
        details.a("Server Running", () -> Boolean.toString(this.S));
        if (this.R != null) {
            details.a("Player Count", () -> {
                int i2 = this.R.m();
                return i2 + " / " + this.R.n() + "; " + this.R.t();
            });
        }
        details.a("Data Packs", () -> this.ao.f().stream().map(resourcepackloader -> {
            String s2 = resourcepackloader.f();
            return s2 + (resourcepackloader.c().a() ? "" : " (incompatible)");
        }).collect(Collectors.joining(", ")));
        details.a("Enabled Feature Flags", () -> FeatureFlags.e.b(this.k.M()).stream().map(MinecraftKey::toString).collect(Collectors.joining(", ")));
        details.a("World Generation", () -> this.k.D().toString());
        if (this.aw != null) {
            details.a("Server Id", () -> this.aw);
        }
        return this.a(details);
    }

    public abstract SystemReport a(SystemReport var1);

    public ModCheck M() {
        return ModCheck.a(b, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void a(IChatBaseComponent message) {
        l.info((String)PaperAdventure.ANSI_SERIALIZER.serialize(PaperAdventure.asAdventure(message)));
    }

    public KeyPair N() {
        return this.ae;
    }

    public int O() {
        return this.O;
    }

    @Override
    public void a(int serverPort) {
        this.O = serverPort;
    }

    @Nullable
    public GameProfile P() {
        return this.af;
    }

    public void b(@Nullable GameProfile hostProfile) {
        this.af = hostProfile;
    }

    public boolean Q() {
        return this.af != null;
    }

    protected void R() {
        l.info("Generating keypair");
        try {
            this.ae = MinecraftEncryption.b();
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Failed to generate key pair", cryptographyexception);
        }
    }

    public void setDifficulty(WorldServer level, EnumDifficulty difficulty, boolean forceUpdate) {
        WorldDataServer worldData = level.K;
        if (forceUpdate || !worldData.t()) {
            worldData.a(worldData.n() ? EnumDifficulty.d : difficulty);
            level.b(worldData.s() != EnumDifficulty.a && ((DedicatedServer)this).s.a().w, this.Y());
        }
    }

    public int b(int initialDistance) {
        return initialDistance;
    }

    private void by() {
        for (WorldServer worldserver : this.H()) {
            worldserver.b(worldserver.K.s() != EnumDifficulty.a && ((DedicatedServer)this).s.a().w, this.Y());
        }
    }

    public void b(boolean locked) {
        this.k.d(locked);
        this.ae().t().forEach(this::c);
    }

    private void c(EntityPlayer player) {
        WorldData worlddata = player.dM().B_();
        player.c.b(new PacketPlayOutServerDifficulty(worlddata.s(), worlddata.t()));
    }

    public boolean S() {
        return this.k.s() != EnumDifficulty.a;
    }

    public boolean T() {
        return this.ag;
    }

    public void c(boolean demo) {
        this.ag = demo;
    }

    public Optional<ServerResourcePackInfo> U() {
        return Optional.empty();
    }

    public boolean V() {
        return this.U().filter(ServerResourcePackInfo::d).isPresent();
    }

    public abstract boolean l();

    public abstract int m();

    public boolean W() {
        return this.W;
    }

    @Override
    public void d(boolean onlineMode) {
        this.W = onlineMode;
    }

    public boolean X() {
        return this.X;
    }

    public void e(boolean preventProxyConnections) {
        this.X = preventProxyConnections;
    }

    public boolean Y() {
        return true;
    }

    public boolean Z() {
        return true;
    }

    public abstract boolean n();

    public boolean aa() {
        return this.Y;
    }

    public void f(boolean pvpEnabled) {
        this.Y = pvpEnabled;
    }

    public boolean ab() {
        return this.Z;
    }

    public void g(boolean flightEnabled) {
        this.Z = flightEnabled;
    }

    public abstract boolean o();

    @Override
    public String ac() {
        return LegacyComponentSerializer.legacySection().serialize(this.motd);
    }

    @Override
    public void d(String motd) {
        this.motd = LegacyComponentSerializer.legacySection().deserializeOr((Object)motd, (Component)Component.empty());
    }

    public Component motd() {
        return this.motd;
    }

    public void motd(Component motd) {
        this.motd = motd;
    }

    public boolean ad() {
        return this.T;
    }

    public PlayerList ae() {
        return this.R;
    }

    @Override
    public void a(PlayerList playerManager) {
        this.R = playerManager;
    }

    public abstract boolean p();

    @Override
    public void a(EnumGamemode gameMode) {
        this.k.a(gameMode);
    }

    public ServerConnection af() {
        return this.H == null ? (this.H = new ServerConnection(this)) : this.H;
    }

    public boolean ag() {
        return this.ah;
    }

    public boolean ah() {
        return false;
    }

    public boolean a(@Nullable EnumGamemode gameMode, boolean cheatsAllowed, int port) {
        return false;
    }

    public int ai() {
        return this.U;
    }

    public int aj() {
        return 16;
    }

    public boolean a(WorldServer world, BlockPosition pos, EntityHuman player) {
        return false;
    }

    public boolean ak() {
        return true;
    }

    public boolean al() {
        return false;
    }

    public Proxy am() {
        return this.i;
    }

    public int an() {
        return this.ab;
    }

    public void c(int playerIdleTimeout) {
        this.ab = playerIdleTimeout;
    }

    public MinecraftSessionService ao() {
        return this.j.c();
    }

    @Nullable
    public SignatureValidator ap() {
        return this.j.a();
    }

    public GameProfileRepository aq() {
        return this.j.e();
    }

    @Nullable
    public UserCache ar() {
        return this.j.f();
    }

    @Nullable
    public ServerPing as() {
        return this.J;
    }

    public void at() {
        this.aj = 0L;
    }

    public int au() {
        return 29999984;
    }

    @Override
    public boolean av() {
        return super.av() && !this.ad();
    }

    @Override
    public void c(Runnable runnable) {
        if (this.ad()) {
            throw new ServerStopRejectedExecutionException("Server already shutting down");
        }
        super.c(runnable);
    }

    @Override
    public Thread aw() {
        return this.ak;
    }

    public int ax() {
        return 256;
    }

    public boolean ay() {
        return false;
    }

    public long az() {
        return this.al;
    }

    public DataFixer aA() {
        return this.M;
    }

    public int a(@Nullable WorldServer world) {
        return world != null ? world.Z().c(GameRules.s) : 10;
    }

    public AdvancementDataWorld aB() {
        return this.ax.b.e();
    }

    public CustomFunctionData aC() {
        return this.as;
    }

    @Override
    @Deprecated
    @DoNotUse
    public CompletableFuture<Void> a(Collection<String> dataPacks) {
        return this.reloadResources(dataPacks, ServerResourcesReloadedEvent.Cause.PLUGIN);
    }

    public CompletableFuture<Void> reloadResources(Collection<String> dataPacks, ServerResourcesReloadedEvent.Cause cause) {
        IRegistryCustom.Dimension iregistrycustom_dimension = this.P.b(RegistryLayer.d);
        CompletionStage completablefuture = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            Stream stream = dataPacks.stream();
            ResourcePackRepository resourcepackrepository = this.ao;
            Objects.requireNonNull(this.ao);
            return (ImmutableList)stream.map(resourcepackrepository::c).filter(Objects::nonNull).map(ResourcePackLoader::e).collect(ImmutableList.toImmutableList());
        }, this).thenCompose(immutablelist -> {
            ResourceManager resourcemanager = new ResourceManager(EnumResourcePackType.b, (List<IResourcePack>)immutablelist);
            return ((CompletableFuture)DataPackResources.a(resourcemanager, iregistrycustom_dimension, this.k.M(), this.l() ? CommandDispatcher.ServerType.b : CommandDispatcher.ServerType.c, this.j(), this.av, this).whenComplete((datapackresources, throwable) -> {
                if (throwable != null) {
                    resourcemanager.close();
                }
            })).thenApply(datapackresources -> new ReloadableResources(resourcemanager, (DataPackResources)datapackresources));
        })).thenAcceptAsync(minecraftserver_reloadableresources -> {
            this.ax.close();
            this.ax = minecraftserver_reloadableresources;
            this.server.syncCommands();
            this.ao.a(dataPacks);
            WorldDataConfiguration worlddataconfiguration = new WorldDataConfiguration(MinecraftServer.a(this.ao), this.k.M());
            this.k.a(worlddataconfiguration);
            this.ax.b.a(this.aZ());
            PotionBrewer.reload();
            if (Thread.currentThread() != this.ak) {
                return;
            }
            for (EntityPlayer player : this.ae().t()) {
                player.Q().b();
            }
            this.ae().u();
            this.as.a(this.ax.b.a());
            this.ay.a(this.ax.a);
            CraftBlockData.reloadCache();
            new ServerResourcesReloadedEvent(cause).callEvent();
        }, (Executor)this);
        if (this.bq()) {
            Objects.requireNonNull(completablefuture);
            this.c(((CompletableFuture)completablefuture)::isDone);
        }
        return completablefuture;
    }

    public static WorldDataConfiguration a(ResourcePackRepository resourcePackManager, DataPackConfiguration dataPackSettings, boolean safeMode, FeatureFlagSet enabledFeatures) {
        resourcePackManager.a();
        if (safeMode) {
            resourcePackManager.a(Collections.singleton(b));
            return WorldDataConfiguration.c;
        }
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (String s2 : dataPackSettings.a()) {
            if (resourcePackManager.d(s2)) {
                set.add(s2);
                continue;
            }
            l.warn("Missing data pack {}", (Object)s2);
        }
        for (ResourcePackLoader resourcepackloader : resourcePackManager.c()) {
            String s1 = resourcepackloader.f();
            if (dataPackSettings.b().contains(s1)) continue;
            FeatureFlagSet featureflagset1 = resourcepackloader.d();
            boolean flag1 = set.contains(s1);
            if (!flag1 && resourcepackloader.j().a()) {
                if (featureflagset1.a(enabledFeatures)) {
                    l.info("Found new data pack {}, loading it automatically", (Object)s1);
                    set.add(s1);
                } else {
                    l.info("Found new data pack {}, but can't load it due to missing features {}", (Object)s1, (Object)FeatureFlags.a(enabledFeatures, featureflagset1));
                }
            }
            if (!flag1 || featureflagset1.a(enabledFeatures)) continue;
            l.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)s1, (Object)FeatureFlags.a(enabledFeatures, featureflagset1));
            set.remove(s1);
        }
        if (set.isEmpty()) {
            l.info("No datapacks selected, forcing vanilla");
            set.add(b);
        }
        resourcePackManager.a(set);
        DataPackConfiguration datapackconfiguration1 = MinecraftServer.a(resourcePackManager);
        FeatureFlagSet featureflagset2 = resourcePackManager.e();
        return new WorldDataConfiguration(datapackconfiguration1, featureflagset2);
    }

    private static DataPackConfiguration a(ResourcePackRepository dataPackManager) {
        Collection<String> collection = dataPackManager.d();
        ImmutableList list = ImmutableList.copyOf(collection);
        List list1 = (List)dataPackManager.b().stream().filter(s2 -> !collection.contains(s2)).collect(ImmutableList.toImmutableList());
        return new DataPackConfiguration((List<String>)list, list1);
    }

    @Override
    public void a(CommandListenerWrapper source) {
        if (this.aM()) {
            PlayerList playerlist = source.l().ae();
            WhiteList whitelist = playerlist.i();
            if (!((DedicatedServer)MinecraftServer.getServer()).a().V.get().booleanValue()) {
                return;
            }
            ArrayList list = Lists.newArrayList(playerlist.t());
            for (EntityPlayer entityplayer : list) {
                if (whitelist.a(entityplayer.fR()) || this.ae().f(entityplayer.fR())) continue;
                entityplayer.c.disconnect(SpigotConfig.whitelistMessage, PlayerKickEvent.Cause.WHITELIST);
            }
        }
    }

    public ResourcePackRepository aD() {
        return this.ao;
    }

    public CommandDispatcher aE() {
        return this.ax.b.d();
    }

    public CommandListenerWrapper aF() {
        WorldServer worldserver = this.F();
        return new CommandListenerWrapper(this, worldserver == null ? Vec3D.b : Vec3D.a(worldserver.T()), Vec2F.a, worldserver, 4, "Server", IChatBaseComponent.b("Server"), this, null);
    }

    @Override
    public boolean l_() {
        return true;
    }

    @Override
    public boolean x_() {
        return true;
    }

    @Override
    public abstract boolean W_();

    public CraftingManager aG() {
        return this.ax.b.c();
    }

    public ScoreboardServer aH() {
        return this.ap;
    }

    public PersistentCommandStorage aI() {
        if (this.aq == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.aq;
    }

    public LootDataManager aJ() {
        return this.ax.b.b();
    }

    public GameRules aK() {
        return this.F().Z();
    }

    public BossBattleCustomData aL() {
        return this.ar;
    }

    public boolean aM() {
        return this.at;
    }

    public void h(boolean enforceWhitelist) {
        this.at = enforceWhitelist;
    }

    public float aN() {
        return this.au;
    }

    public ServerTickRateManager aO() {
        return this.az;
    }

    public long aP() {
        return this.ad / (long)Math.min(100, Math.max(this.U, 1));
    }

    public long[] aQ() {
        return this.ac;
    }

    public int c(GameProfile profile) {
        if (this.ae().f(profile)) {
            OpListEntry oplistentry = (OpListEntry)this.ae().k().b(profile);
            return oplistentry != null ? oplistentry.a() : (this.a(profile) ? 4 : (this.Q() ? (this.ae().v() ? 4 : 0) : this.i()));
        }
        return 0;
    }

    public GameProfilerFiller aR() {
        return GameProfilerDisabled.a;
    }

    public abstract boolean a(GameProfile var1);

    @Override
    public void a(Path file) throws IOException {
    }

    private void b(Path path) {
        Path path1 = path.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<net.minecraft.world.level.World>, WorldServer> entry : this.Q.entrySet()) {
                MinecraftKey minecraftkey = entry.getKey().a();
                Path path2 = path1.resolve(minecraftkey.b()).resolve(minecraftkey.a());
                java.nio.file.Files.createDirectories(path2, new FileAttribute[0]);
                entry.getValue().a(path2);
            }
            this.d(path.resolve("gamerules.txt"));
            this.e(path.resolve("classpath.txt"));
            this.c(path.resolve("stats.txt"));
            this.f(path.resolve("threads.txt"));
            this.a(path.resolve("server.properties.txt"));
            this.g(path.resolve("modules.txt"));
        }
        catch (IOException ioexception) {
            l.warn("Failed to save debug report", (Throwable)ioexception);
        }
    }

    private void c(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            bufferedwriter.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.br()));
            bufferedwriter.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.aN())));
            bufferedwriter.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.ac)));
            bufferedwriter.write(String.format(Locale.ROOT, "queue: %s\n", SystemUtils.f()));
        }
    }

    @Override
    private void d(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            final ArrayList list = Lists.newArrayList();
            final GameRules gamerules = this.aK();
            GameRules.a(new GameRules.GameRuleVisitor(){

                @Override
                public <T extends GameRules.GameRuleValue<T>> void a(GameRules.GameRuleKey<T> key, GameRules.GameRuleDefinition<T> type) {
                    list.add(String.format(Locale.ROOT, "%s=%s\n", key.a(), gamerules.a(key)));
                }
            });
            for (String s2 : list) {
                bufferedwriter.write(s2);
            }
        }
    }

    private void e(Path path) throws IOException {
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            String s2 = System.getProperty("java.class.path");
            String s1 = System.getProperty("path.separator");
            for (String s22 : Splitter.on((String)s1).split((CharSequence)s2)) {
                bufferedwriter.write(s22);
                bufferedwriter.write("\n");
            }
        }
    }

    private void f(Path path) throws IOException {
        ThreadMXBean threadmxbean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] athreadinfo = threadmxbean.dumpAllThreads(true, true);
        Arrays.sort(athreadinfo, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
            ThreadInfo[] athreadinfo1 = athreadinfo;
            int i2 = athreadinfo.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                ThreadInfo threadinfo = athreadinfo1[j2];
                bufferedwriter.write(threadinfo.toString());
                bufferedwriter.write(10);
            }
        }
    }

    private void g(Path path) throws IOException {
        block11: {
            block10: {
                try (BufferedWriter bufferedwriter = java.nio.file.Files.newBufferedWriter(path, new OpenOption[0]);){
                    ArrayList arraylist;
                    try {
                        arraylist = Lists.newArrayList(NativeModuleLister.a());
                    }
                    catch (Throwable throwable) {
                        l.warn("Failed to list native modules", throwable);
                        break block10;
                    }
                    arraylist.sort(Comparator.comparing(nativemodulelister_a -> nativemodulelister_a.a));
                    Iterator iterator = arraylist.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            break block11;
                        }
                        NativeModuleLister.a nativemodulelister_a2 = (NativeModuleLister.a)iterator.next();
                        bufferedwriter.write(nativemodulelister_a2.toString());
                        bufferedwriter.write(10);
                    }
                }
            }
            return;
        }
    }

    @Override
    public boolean bq() {
        return TickThread.isTickThread();
    }

    public boolean isDebugging() {
        return false;
    }

    public static MinecraftServer getServer() {
        return SERVER;
    }

    private void bz() {
    }

    private void bA() {
    }

    public boolean aS() {
        return false;
    }

    public void a(Consumer<MethodProfilerResults> resultConsumer, Consumer<Path> dumpConsumer) {
    }

    public void aT() {
    }

    public void aU() {
    }

    public void aV() {
    }

    public Path a(SavedFile worldSavePath) {
        return this.g.a(worldSavePath);
    }

    public boolean aW() {
        return true;
    }

    public StructureTemplateManager aX() {
        return this.ay;
    }

    public SaveData aY() {
        return this.k;
    }

    public IRegistryCustom.Dimension aZ() {
        return this.P.a();
    }

    public LayeredRegistryAccess<RegistryLayer> ba() {
        return this.P;
    }

    public ITextFilter a(EntityPlayer player) {
        return ITextFilter.a;
    }

    public PlayerInteractManager b(EntityPlayer player) {
        return this.T() ? new DemoPlayerInteractManager(player) : new PlayerInteractManager(player);
    }

    @Nullable
    public EnumGamemode bb() {
        return null;
    }

    public IResourceManager bc() {
        return this.ax.a;
    }

    public boolean bd() {
        return this.aA;
    }

    public boolean be() {
        return false;
    }

    public void bf() {
    }

    public MethodProfilerResults bg() {
        return MethodProfilerResultsEmpty.a;
    }

    public int bh() {
        return 1000000;
    }

    public void a(IChatBaseComponent message, ChatMessageType.a params, @Nullable String prefix) {
        Component s1 = PaperAdventure.asAdventure(params.a(message));
        if (prefix != null) {
            COMPONENT_LOGGER.info("[{}] {}", (Object)prefix, (Object)s1);
        } else {
            COMPONENT_LOGGER.info("{}", (Object)s1);
        }
    }

    public ChatDecorator bi() {
        return this.improvedChatDecorator;
    }

    public boolean bj() {
        return true;
    }

    private /* synthetic */ void lambda$startMetricsRecordingTick$30(Path path) {
        this.h(() -> this.b(path.resolve("server")));
        this.D.accept(path);
    }

    static {
        l = LogUtils.getLogger();
        COMPONENT_LOGGER = ComponentLogger.logger((String)l.getName());
        o = 30L * TimeRange.a / 20L;
        q = 10L * TimeRange.a;
        s = 5L * TimeRange.a;
        t = 10L * TimeRange.b;
        e = new WorldSettings("Demo World", EnumGamemode.a, false, EnumDifficulty.c, false, new GameRules(), WorldDataConfiguration.c);
        f = new GameProfile(SystemUtils.d, "Anonymous Player");
        startTimeMillis = System.currentTimeMillis();
        currentTickLong = 0L;
        SERVER_INIT = System.nanoTime();
        TPS_BASE = new BigDecimal(1.0E9).multiply(new BigDecimal(20));
    }

    public static class TickTimes {
        private final long[] times;

        public TickTimes(int length) {
            this.times = new long[length];
        }

        void add(int index, long time) {
            this.times[index % this.times.length] = time;
        }

        public long[] getTimes() {
            return (long[])this.times.clone();
        }

        public double getAverage() {
            long total = 0L;
            for (long value : this.times) {
                total += value;
            }
            return (double)total / (double)this.times.length * 1.0E-6;
        }
    }

    public static class RollingAverage {
        private final int size;
        private long time;
        private BigDecimal total;
        private int index = 0;
        private final BigDecimal[] samples;
        private final long[] times;

        RollingAverage(int size) {
            this.size = size;
            this.time = (long)size * 1000000000L;
            this.total = RollingAverage.dec(20L).multiply(RollingAverage.dec(1000000000L)).multiply(RollingAverage.dec(size));
            this.samples = new BigDecimal[size];
            this.times = new long[size];
            for (int i2 = 0; i2 < size; ++i2) {
                this.samples[i2] = RollingAverage.dec(20L);
                this.times[i2] = 1000000000L;
            }
        }

        private static BigDecimal dec(long t2) {
            return new BigDecimal(t2);
        }

        public void add(BigDecimal x2, long t2) {
            this.time -= this.times[this.index];
            this.total = this.total.subtract(this.samples[this.index].multiply(RollingAverage.dec(this.times[this.index])));
            this.samples[this.index] = x2;
            this.times[this.index] = t2;
            this.time += t2;
            this.total = this.total.add(x2.multiply(RollingAverage.dec(t2)));
            if (++this.index == this.size) {
                this.index = 0;
            }
        }

        public double getAverage() {
            return this.total.divide(RollingAverage.dec(this.time), 30, RoundingMode.HALF_UP).doubleValue();
        }
    }

    public record ReloadableResources(IReloadableResourceManager a, DataPackResources b) implements AutoCloseable
    {
        @Override
        public void close() {
            this.a.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "a", "b"}, this, o2);
        }
    }

    public record ServerResourcePackInfo(UUID a, String b, String c, boolean d, @Nullable IChatBaseComponent e) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ServerResourcePackInfo.class, "id;url;hash;isRequired;prompt", "a", "b", "c", "d", "e"}, this, o2);
        }
    }

    private static class TimeProfiler {
        final long a;
        final int b;

        TimeProfiler(long time, int tick) {
            this.a = time;
            this.b = tick;
        }

        MethodProfilerResults a(final long endTime, final int endTick) {
            return new MethodProfilerResults(){

                @Override
                public List<MethodProfilerResultsField> a(String parentPath) {
                    return Collections.emptyList();
                }

                @Override
                public boolean a(Path path) {
                    return false;
                }

                @Override
                public long a() {
                    return a;
                }

                @Override
                public int b() {
                    return b;
                }

                @Override
                public long c() {
                    return endTime;
                }

                @Override
                public int d() {
                    return endTick;
                }

                @Override
                public String e() {
                    return "";
                }
            };
        }
    }
}

