/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.UUID;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class CommandAttribute {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(name -> IChatBaseComponent.b("commands.attribute.failed.entity", name));
    private static final Dynamic2CommandExceptionType b = new Dynamic2CommandExceptionType((entityName, attributeName) -> IChatBaseComponent.b("commands.attribute.failed.no_attribute", entityName, attributeName));
    private static final Dynamic3CommandExceptionType c = new Dynamic3CommandExceptionType((entityName, attributeName, uuid) -> IChatBaseComponent.b("commands.attribute.failed.no_modifier", attributeName, entityName, uuid));
    private static final Dynamic3CommandExceptionType d = new Dynamic3CommandExceptionType((entityName, attributeName, uuid) -> IChatBaseComponent.b("commands.attribute.failed.modifier_already_present", uuid, attributeName, entityName));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("attribute").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("target", ArgumentEntity.a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("attribute", ResourceArgument.a(registryAccess, Registries.c)).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("get").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("base").then(net.minecraft.commands.CommandDispatcher.a("set").then(net.minecraft.commands.CommandDispatcher.a("value", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.c((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value")))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("get").executes(context -> CommandAttribute.b((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.b((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("modifier").then(net.minecraft.commands.CommandDispatcher.a("add").then(net.minecraft.commands.CommandDispatcher.a("uuid", ArgumentUUID.a()).then(net.minecraft.commands.CommandDispatcher.a("name", StringArgumentType.string()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("value", DoubleArgumentType.doubleArg()).then(net.minecraft.commands.CommandDispatcher.a("add").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid"), StringArgumentType.getString((CommandContext)context, (String)"name"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), AttributeModifier.Operation.a)))).then(net.minecraft.commands.CommandDispatcher.a("multiply").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid"), StringArgumentType.getString((CommandContext)context, (String)"name"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), AttributeModifier.Operation.c)))).then(net.minecraft.commands.CommandDispatcher.a("multiply_base").executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid"), StringArgumentType.getString((CommandContext)context, (String)"name"), DoubleArgumentType.getDouble((CommandContext)context, (String)"value"), AttributeModifier.Operation.b)))))))).then(net.minecraft.commands.CommandDispatcher.a("remove").then(net.minecraft.commands.CommandDispatcher.a("uuid", ArgumentUUID.a()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid")))))).then(net.minecraft.commands.CommandDispatcher.a("value").then(net.minecraft.commands.CommandDispatcher.a("get").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("uuid", ArgumentUUID.a()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid"), 1.0))).then(net.minecraft.commands.CommandDispatcher.a("scale", DoubleArgumentType.doubleArg()).executes(context -> CommandAttribute.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.a((CommandContext<CommandListenerWrapper>)context, "target"), ResourceArgument.a((CommandContext<CommandListenerWrapper>)context, "attribute"), ArgumentUUID.a((CommandContext<CommandListenerWrapper>)context, "uuid"), DoubleArgumentType.getDouble((CommandContext)context, (String)"scale"))))))))))));
    }

    private static AttributeModifiable a(Entity entity, Holder<AttributeBase> attribute) throws CommandSyntaxException {
        AttributeModifiable attributeInstance = CommandAttribute.a(entity).eR().a(attribute);
        if (attributeInstance == null) {
            throw b.create((Object)entity.ad(), (Object)CommandAttribute.a(attribute));
        }
        return attributeInstance;
    }

    private static EntityLiving a(Entity entity) throws CommandSyntaxException {
        if (!(entity instanceof EntityLiving)) {
            throw a.create((Object)entity.ad());
        }
        return (EntityLiving)entity;
    }

    private static EntityLiving b(Entity entity, Holder<AttributeBase> attribute) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.a(entity);
        if (!livingEntity.eR().b(attribute)) {
            throw b.create((Object)entity.ad(), (Object)CommandAttribute.a(attribute));
        }
        return livingEntity;
    }

    private static int a(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, double multiplier) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.b(target, attribute);
        double d2 = livingEntity.a(attribute);
        source.a(() -> IChatBaseComponent.a("commands.attribute.value.get.success", CommandAttribute.a(attribute), target.ad(), d2), false);
        return (int)(d2 * multiplier);
    }

    private static int b(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, double multiplier) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.b(target, attribute);
        double d2 = livingEntity.b(attribute);
        source.a(() -> IChatBaseComponent.a("commands.attribute.base_value.get.success", CommandAttribute.a(attribute), target.ad(), d2), false);
        return (int)(d2 * multiplier);
    }

    private static int a(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, UUID uuid, double multiplier) throws CommandSyntaxException {
        EntityLiving livingEntity = CommandAttribute.b(target, attribute);
        AttributeMapBase attributeMap = livingEntity.eR();
        if (!attributeMap.a(attribute, uuid)) {
            throw c.create((Object)target.ad(), (Object)CommandAttribute.a(attribute), (Object)uuid);
        }
        double d2 = attributeMap.b(attribute, uuid);
        source.a(() -> IChatBaseComponent.a("commands.attribute.modifier.value.get.success", IChatBaseComponent.a(uuid), CommandAttribute.a(attribute), target.ad(), d2), false);
        return (int)(d2 * multiplier);
    }

    private static int c(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, double value) throws CommandSyntaxException {
        CommandAttribute.a(target, attribute).a(value);
        source.a(() -> IChatBaseComponent.a("commands.attribute.base_value.set.success", CommandAttribute.a(attribute), target.ad(), value), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, UUID uuid, String name, double value, AttributeModifier.Operation operation) throws CommandSyntaxException {
        AttributeModifier attributeModifier;
        AttributeModifiable attributeInstance = CommandAttribute.a(target, attribute);
        if (attributeInstance.a(attributeModifier = new AttributeModifier(uuid, name, value, operation))) {
            throw d.create((Object)target.ad(), (Object)CommandAttribute.a(attribute), (Object)uuid);
        }
        attributeInstance.c(attributeModifier);
        source.a(() -> IChatBaseComponent.a("commands.attribute.modifier.add.success", IChatBaseComponent.a(uuid), CommandAttribute.a(attribute), target.ad()), false);
        return 1;
    }

    private static int a(CommandListenerWrapper source, Entity target, Holder<AttributeBase> attribute, UUID uuid) throws CommandSyntaxException {
        AttributeModifiable attributeInstance = CommandAttribute.a(target, attribute);
        if (attributeInstance.c(uuid)) {
            source.a(() -> IChatBaseComponent.a("commands.attribute.modifier.remove.success", IChatBaseComponent.a(uuid), CommandAttribute.a(attribute), target.ad()), false);
            return 1;
        }
        throw c.create((Object)target.ad(), (Object)CommandAttribute.a(attribute), (Object)uuid);
    }

    private static IChatBaseComponent a(Holder<AttributeBase> attribute) {
        return IChatBaseComponent.c(attribute.a().c());
    }
}

