/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import org.purpurmc.purpur.PurpurConfig;

public class CommandEnchant {
    private static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(entityName -> IChatBaseComponent.b("commands.enchant.failed.entity", entityName));
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(entityName -> IChatBaseComponent.b("commands.enchant.failed.itemless", entityName));
    private static final DynamicCommandExceptionType c = new DynamicCommandExceptionType(itemName -> IChatBaseComponent.b("commands.enchant.failed.incompatible", itemName));
    private static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((level, maxLevel) -> IChatBaseComponent.b("commands.enchant.failed.level", level, maxLevel));
    private static final SimpleCommandExceptionType e = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.enchant.failed"));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("enchant").requires(source -> source.c(2))).then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("enchantment", ResourceArgument.a(registryAccess, Registries.t)).executes(context -> CommandEnchant.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ResourceArgument.g((CommandContext<CommandListenerWrapper>)context, "enchantment"), 1))).then(net.minecraft.commands.CommandDispatcher.a("level", IntegerArgumentType.integer((int)0)).executes(context -> CommandEnchant.a((CommandListenerWrapper)context.getSource(), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)context, "targets"), ResourceArgument.g((CommandContext<CommandListenerWrapper>)context, "enchantment"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"))))))));
    }

    private static int a(CommandListenerWrapper source, Collection<? extends Entity> targets, Holder<Enchantment> enchantment, int level) throws CommandSyntaxException {
        Enchantment enchantment2 = enchantment.a();
        if (!PurpurConfig.allowUnsafeEnchantCommand && level > enchantment2.a()) {
            throw d.create((Object)level, (Object)enchantment2.a());
        }
        int i2 = 0;
        for (Entity entity : targets) {
            if (entity instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                ItemStack itemStack = livingEntity.eT();
                if (!itemStack.b()) {
                    if (enchantment2.a(itemStack) && EnchantmentManager.a(EnchantmentManager.a(itemStack).keySet(), enchantment2) || PurpurConfig.allowUnsafeEnchantCommand && !itemStack.hasEnchantment(enchantment2)) {
                        itemStack.a(enchantment2, level);
                        ++i2;
                        continue;
                    }
                    if (targets.size() != 1) continue;
                    throw c.create((Object)itemStack.d().m(itemStack).getString());
                }
                if (targets.size() != 1) continue;
                throw b.create((Object)livingEntity.ad().getString());
            }
            if (targets.size() != 1) continue;
            throw a.create((Object)entity.ad().getString());
        }
        if (i2 == 0) {
            throw e.create();
        }
        if (targets.size() == 1) {
            source.a(() -> IChatBaseComponent.a("commands.enchant.success.single", enchantment2.d(level), ((Entity)targets.iterator().next()).Q_()), true);
        } else {
            source.a(() -> IChatBaseComponent.a("commands.enchant.success.multiple", enchantment2.d(level), targets.size()), true);
        }
        return i2;
    }
}

