/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentTime;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.world.level.timers.CustomFunctionCallback;
import net.minecraft.world.level.timers.CustomFunctionCallbackTag;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;

public class CommandSchedule {
    private static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("commands.schedule.same_tick"));
    private static final DynamicCommandExceptionType b = new DynamicCommandExceptionType(object -> IChatBaseComponent.b("commands.schedule.cleared.failure", object));
    private static final SuggestionProvider<CommandListenerWrapper> c = (commandcontext, suggestionsbuilder) -> ICompletionProvider.b(((CommandListenerWrapper)commandcontext.getSource()).e().K.u().a(), suggestionsbuilder);

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("schedule").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).then(net.minecraft.commands.CommandDispatcher.a("function").then(net.minecraft.commands.CommandDispatcher.a("function", ArgumentTag.a()).suggests(CommandFunction.b).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("time", ArgumentTime.a()).executes(commandcontext -> CommandSchedule.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentTag.b((CommandContext<CommandListenerWrapper>)commandcontext, "function"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"), true))).then(net.minecraft.commands.CommandDispatcher.a("append").executes(commandcontext -> CommandSchedule.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentTag.b((CommandContext<CommandListenerWrapper>)commandcontext, "function"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"), false)))).then(net.minecraft.commands.CommandDispatcher.a("replace").executes(commandcontext -> CommandSchedule.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentTag.b((CommandContext<CommandListenerWrapper>)commandcontext, "function"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"time"), true))))))).then(net.minecraft.commands.CommandDispatcher.a("clear").then(net.minecraft.commands.CommandDispatcher.a("function", StringArgumentType.greedyString()).suggests(c).executes(commandcontext -> CommandSchedule.a((CommandListenerWrapper)commandcontext.getSource(), StringArgumentType.getString((CommandContext)commandcontext, (String)"function")))))));
    }

    private static int a(CommandListenerWrapper source, Pair<MinecraftKey, Either<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>, Collection<net.minecraft.commands.functions.CommandFunction<CommandListenerWrapper>>>> function, int time, boolean replace) throws CommandSyntaxException {
        if (time == 0) {
            throw a.create();
        }
        long j2 = source.e().X() + (long)time;
        MinecraftKey minecraftkey = (MinecraftKey)function.getFirst();
        CustomFunctionCallbackTimerQueue<MinecraftServer> customfunctioncallbacktimerqueue = source.e().K.K().u();
        ((Either)function.getSecond()).ifLeft(net_minecraft_commands_functions_commandfunction -> {
            String s2 = minecraftkey.toString();
            if (replace) {
                customfunctioncallbacktimerqueue.a(s2);
            }
            customfunctioncallbacktimerqueue.a(s2, j2, new CustomFunctionCallback(minecraftkey));
            source.a(() -> IChatBaseComponent.a("commands.schedule.created.function", IChatBaseComponent.a(minecraftkey), time, j2), true);
        }).ifRight(collection -> {
            String s2 = "#" + minecraftkey;
            if (replace) {
                customfunctioncallbacktimerqueue.a(s2);
            }
            customfunctioncallbacktimerqueue.a(s2, j2, new CustomFunctionCallbackTag(minecraftkey));
            source.a(() -> IChatBaseComponent.a("commands.schedule.created.tag", IChatBaseComponent.a(minecraftkey), time, j2), true);
        });
        return Math.floorMod(j2, Integer.MAX_VALUE);
    }

    private static int a(CommandListenerWrapper source, String eventName) throws CommandSyntaxException {
        int i2 = source.e().K.u().a(eventName);
        if (i2 == 0) {
            throw b.create((Object)eventName);
        }
        source.a(() -> IChatBaseComponent.a("commands.schedule.cleared.success", i2, eventName), true);
        return i2;
    }
}

