/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.event.player.PlayerTeleportEvent;

public class CommandSpreadPlayers {
    private static final int a = 10000;
    private static final Dynamic4CommandExceptionType b = new Dynamic4CommandExceptionType((object, object1, object2, object3) -> IChatBaseComponent.b("commands.spreadplayers.failed.teams", object, object1, object2, object3));
    private static final Dynamic4CommandExceptionType c = new Dynamic4CommandExceptionType((object, object1, object2, object3) -> IChatBaseComponent.b("commands.spreadplayers.failed.entities", object, object1, object2, object3));
    private static final Dynamic2CommandExceptionType d = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.b("commands.spreadplayers.failed.invalid.height", object, object1));

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("spreadplayers").requires(commandlistenerwrapper -> commandlistenerwrapper.c(2))).then(net.minecraft.commands.CommandDispatcher.a("center", ArgumentVec2.a()).then(net.minecraft.commands.CommandDispatcher.a("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(net.minecraft.commands.CommandDispatcher.a("respectTeams", BoolArgumentType.bool()).then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).executes(commandcontext -> CommandSpreadPlayers.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentVec2.a((CommandContext<CommandListenerWrapper>)commandcontext, "center"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"maxRange"), ((CommandListenerWrapper)commandcontext.getSource()).e().al(), BoolArgumentType.getBool((CommandContext)commandcontext, (String)"respectTeams"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets")))))).then(net.minecraft.commands.CommandDispatcher.a("under").then(net.minecraft.commands.CommandDispatcher.a("maxHeight", IntegerArgumentType.integer()).then(net.minecraft.commands.CommandDispatcher.a("respectTeams", BoolArgumentType.bool()).then(net.minecraft.commands.CommandDispatcher.a("targets", ArgumentEntity.b()).executes(commandcontext -> CommandSpreadPlayers.a((CommandListenerWrapper)commandcontext.getSource(), ArgumentVec2.a((CommandContext<CommandListenerWrapper>)commandcontext, "center"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)commandcontext, (String)"maxRange"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"maxHeight"), BoolArgumentType.getBool((CommandContext)commandcontext, (String)"respectTeams"), ArgumentEntity.b((CommandContext<CommandListenerWrapper>)commandcontext, "targets"))))))))))));
    }

    private static int a(CommandListenerWrapper source, Vec2F center, float spreadDistance, float maxRange, int maxY, boolean respectTeams, Collection<? extends Entity> players) throws CommandSyntaxException {
        WorldServer worldserver = source.e();
        int j2 = worldserver.J_();
        if (maxY < j2) {
            throw d.create((Object)maxY, (Object)j2);
        }
        RandomSource randomsource = RandomSource.a();
        double d0 = center.i - maxRange;
        double d1 = center.j - maxRange;
        double d2 = center.i + maxRange;
        double d3 = center.j + maxRange;
        a[] acommandspreadplayers_a = CommandSpreadPlayers.a(randomsource, respectTeams ? CommandSpreadPlayers.a(players) : players.size(), d0, d1, d2, d3);
        CommandSpreadPlayers.a(center, spreadDistance, worldserver, randomsource, d0, d1, d2, d3, maxY, acommandspreadplayers_a, respectTeams);
        double d4 = CommandSpreadPlayers.a(players, worldserver, acommandspreadplayers_a, maxY, respectTeams);
        source.a(() -> IChatBaseComponent.a("commands.spreadplayers.success." + (respectTeams ? "teams" : "entities"), acommandspreadplayers_a.length, Float.valueOf(center.i), Float.valueOf(center.j), String.format(Locale.ROOT, "%.2f", d4)), true);
        return acommandspreadplayers_a.length;
    }

    private static int a(Collection<? extends Entity> entities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : entities) {
            if (entity instanceof EntityHuman) {
                set.add(entity.cg());
                continue;
            }
            set.add(null);
        }
        return set.size();
    }

    private static void a(Vec2F center, double spreadDistance, WorldServer world, RandomSource random, double minX, double minZ, double maxX, double maxZ, int maxY, a[] piles, boolean respectTeams) throws CommandSyntaxException {
        int j2;
        boolean flag1 = true;
        double d5 = 3.4028234663852886E38;
        for (j2 = 0; j2 < 10000 && flag1; ++j2) {
            a commandspreadplayers_a;
            int k2;
            flag1 = false;
            d5 = 3.4028234663852886E38;
            for (int l2 = 0; l2 < piles.length; ++l2) {
                a commandspreadplayers_a1 = piles[l2];
                k2 = 0;
                commandspreadplayers_a = new a();
                for (int i1 = 0; i1 < piles.length; ++i1) {
                    if (l2 == i1) continue;
                    a commandspreadplayers_a2 = piles[i1];
                    double d6 = commandspreadplayers_a1.a(commandspreadplayers_a2);
                    d5 = Math.min(d6, d5);
                    if (!(d6 < spreadDistance)) continue;
                    ++k2;
                    commandspreadplayers_a.a += commandspreadplayers_a2.a - commandspreadplayers_a1.a;
                    commandspreadplayers_a.b += commandspreadplayers_a2.b - commandspreadplayers_a1.b;
                }
                if (k2 > 0) {
                    commandspreadplayers_a.a /= (double)k2;
                    commandspreadplayers_a.b /= (double)k2;
                    double d7 = commandspreadplayers_a.b();
                    if (d7 > 0.0) {
                        commandspreadplayers_a.a();
                        commandspreadplayers_a1.b(commandspreadplayers_a);
                    } else {
                        commandspreadplayers_a1.a(random, minX, minZ, maxX, maxZ);
                    }
                    flag1 = true;
                }
                if (!commandspreadplayers_a1.a(minX, minZ, maxX, maxZ)) continue;
                flag1 = true;
            }
            if (flag1) continue;
            a[] acommandspreadplayers_a1 = piles;
            int j1 = piles.length;
            for (k2 = 0; k2 < j1; ++k2) {
                commandspreadplayers_a = acommandspreadplayers_a1[k2];
                if (commandspreadplayers_a.b(world, maxY)) continue;
                commandspreadplayers_a.a(random, minX, minZ, maxX, maxZ);
                flag1 = true;
            }
        }
        if (d5 == 3.4028234663852886E38) {
            d5 = 0.0;
        }
        if (j2 >= 10000) {
            if (respectTeams) {
                throw b.create((Object)piles.length, (Object)Float.valueOf(center.i), (Object)Float.valueOf(center.j), (Object)String.format(Locale.ROOT, "%.2f", d5));
            }
            throw c.create((Object)piles.length, (Object)Float.valueOf(center.i), (Object)Float.valueOf(center.j), (Object)String.format(Locale.ROOT, "%.2f", d5));
        }
    }

    private static double a(Collection<? extends Entity> entities, WorldServer world, a[] piles, int maxY, boolean respectTeams) {
        double d0 = 0.0;
        int j2 = 0;
        HashMap map = Maps.newHashMap();
        for (Entity entity : entities) {
            a commandspreadplayers_a;
            if (respectTeams) {
                ScoreboardTeam scoreboardteam;
                ScoreboardTeam scoreboardTeam = scoreboardteam = entity instanceof EntityHuman ? entity.cg() : null;
                if (!map.containsKey(scoreboardteam)) {
                    map.put(scoreboardteam, piles[j2++]);
                }
                commandspreadplayers_a = (a)map.get(scoreboardteam);
            } else {
                commandspreadplayers_a = piles[j2++];
            }
            entity.teleportTo(world, (double)MathHelper.a(commandspreadplayers_a.a) + 0.5, commandspreadplayers_a.a(world, maxY), (double)MathHelper.a(commandspreadplayers_a.b) + 0.5, Set.of(), entity.dC(), entity.dE(), PlayerTeleportEvent.TeleportCause.COMMAND);
            double d1 = Double.MAX_VALUE;
            a[] acommandspreadplayers_a1 = piles;
            int k2 = piles.length;
            for (int l2 = 0; l2 < k2; ++l2) {
                a commandspreadplayers_a1 = acommandspreadplayers_a1[l2];
                if (commandspreadplayers_a == commandspreadplayers_a1) continue;
                double d2 = commandspreadplayers_a.a(commandspreadplayers_a1);
                d1 = Math.min(d2, d1);
            }
            d0 += d1;
        }
        if (entities.size() < 2) {
            return 0.0;
        }
        return d0 /= (double)entities.size();
    }

    private static a[] a(RandomSource random, int count, double minX, double minZ, double maxX, double maxZ) {
        a[] acommandspreadplayers_a = new a[count];
        for (int j2 = 0; j2 < acommandspreadplayers_a.length; ++j2) {
            a commandspreadplayers_a = new a();
            commandspreadplayers_a.a(random, minX, minZ, maxX, maxZ);
            acommandspreadplayers_a[j2] = commandspreadplayers_a;
        }
        return acommandspreadplayers_a;
    }

    private static class a {
        double a;
        double b;

        a() {
        }

        double a(a other) {
            double d0 = this.a - other.a;
            double d1 = this.b - other.b;
            return Math.sqrt(d0 * d0 + d1 * d1);
        }

        void a() {
            double d0 = this.b();
            this.a /= d0;
            this.b /= d0;
        }

        double b() {
            return Math.sqrt(this.a * this.a + this.b * this.b);
        }

        public void b(a other) {
            this.a -= other.a;
            this.b -= other.b;
        }

        public boolean a(double minX, double minZ, double maxX, double maxZ) {
            boolean flag = false;
            if (this.a < minX) {
                this.a = minX;
                flag = true;
            } else if (this.a > maxX) {
                this.a = maxX;
                flag = true;
            }
            if (this.b < minZ) {
                this.b = minZ;
                flag = true;
            } else if (this.b > maxZ) {
                this.b = maxZ;
                flag = true;
            }
            return flag;
        }

        public int a(IBlockAccess blockView, int maxY) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition(this.a, (double)(maxY + 1), this.b);
            boolean flag = blockView.a_(blockposition_mutableblockposition).i();
            blockposition_mutableblockposition.c(EnumDirection.a);
            boolean flag2 = blockView.a_(blockposition_mutableblockposition).i();
            while (blockposition_mutableblockposition.v() > blockView.J_()) {
                blockposition_mutableblockposition.c(EnumDirection.a);
                boolean flag1 = blockView.a_(blockposition_mutableblockposition).i();
                if (!flag1 && flag2 && flag) {
                    return blockposition_mutableblockposition.v() + 1;
                }
                flag = flag2;
                flag2 = flag1;
            }
            return maxY + 1;
        }

        public boolean b(IBlockAccess world, int maxY) {
            BlockPosition blockposition = BlockPosition.a(this.a, (double)(this.a(world, maxY) - 1), this.b);
            IBlockData iblockdata = world.a_(blockposition);
            return blockposition.v() < maxY && !iblockdata.k() && !iblockdata.a(TagsBlock.aJ);
        }

        public void a(RandomSource random, double minX, double minZ, double maxX, double maxZ) {
            this.a = MathHelper.a(random, minX, maxX);
            this.b = MathHelper.a(random, minZ, maxZ);
        }
    }
}

