/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.World;

public class SpawnArmorTrimsCommand {
    private static final Map<Pair<ArmorMaterial, EnumItemSlot>, Item> a = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put(Pair.of((Object)EnumArmorMaterial.b, (Object)EnumItemSlot.f), Items.pz);
        map.put(Pair.of((Object)EnumArmorMaterial.b, (Object)EnumItemSlot.e), Items.pA);
        map.put(Pair.of((Object)EnumArmorMaterial.b, (Object)EnumItemSlot.d), Items.pB);
        map.put(Pair.of((Object)EnumArmorMaterial.b, (Object)EnumItemSlot.c), Items.pC);
        map.put(Pair.of((Object)EnumArmorMaterial.c, (Object)EnumItemSlot.f), Items.pD);
        map.put(Pair.of((Object)EnumArmorMaterial.c, (Object)EnumItemSlot.e), Items.pE);
        map.put(Pair.of((Object)EnumArmorMaterial.c, (Object)EnumItemSlot.d), Items.pF);
        map.put(Pair.of((Object)EnumArmorMaterial.c, (Object)EnumItemSlot.c), Items.pG);
        map.put(Pair.of((Object)EnumArmorMaterial.d, (Object)EnumItemSlot.f), Items.pL);
        map.put(Pair.of((Object)EnumArmorMaterial.d, (Object)EnumItemSlot.e), Items.pM);
        map.put(Pair.of((Object)EnumArmorMaterial.d, (Object)EnumItemSlot.d), Items.pN);
        map.put(Pair.of((Object)EnumArmorMaterial.d, (Object)EnumItemSlot.c), Items.pO);
        map.put(Pair.of((Object)EnumArmorMaterial.g, (Object)EnumItemSlot.f), Items.pP);
        map.put(Pair.of((Object)EnumArmorMaterial.g, (Object)EnumItemSlot.e), Items.pQ);
        map.put(Pair.of((Object)EnumArmorMaterial.g, (Object)EnumItemSlot.d), Items.pR);
        map.put(Pair.of((Object)EnumArmorMaterial.g, (Object)EnumItemSlot.c), Items.pS);
        map.put(Pair.of((Object)EnumArmorMaterial.e, (Object)EnumItemSlot.f), Items.pH);
        map.put(Pair.of((Object)EnumArmorMaterial.e, (Object)EnumItemSlot.e), Items.pI);
        map.put(Pair.of((Object)EnumArmorMaterial.e, (Object)EnumItemSlot.d), Items.pJ);
        map.put(Pair.of((Object)EnumArmorMaterial.e, (Object)EnumItemSlot.c), Items.pK);
        map.put(Pair.of((Object)EnumArmorMaterial.f, (Object)EnumItemSlot.f), Items.on);
    });
    private static final List<ResourceKey<TrimPattern>> b = List.of(TrimPatterns.a, TrimPatterns.b, TrimPatterns.c, TrimPatterns.d, TrimPatterns.e, TrimPatterns.f, TrimPatterns.g, TrimPatterns.h, TrimPatterns.i, TrimPatterns.j, TrimPatterns.k, TrimPatterns.l, TrimPatterns.m, TrimPatterns.n, TrimPatterns.o, TrimPatterns.p);
    private static final List<ResourceKey<TrimMaterial>> c = List.of(TrimMaterials.a, TrimMaterials.b, TrimMaterials.c, TrimMaterials.d, TrimMaterials.e, TrimMaterials.f, TrimMaterials.g, TrimMaterials.h, TrimMaterials.i, TrimMaterials.j);
    private static final ToIntFunction<ResourceKey<TrimPattern>> d = SystemUtils.e(b);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> e = SystemUtils.e(c);

    public static void a(CommandDispatcher<CommandListenerWrapper> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.a("spawn_armor_trims").requires(source -> source.c(2))).executes(context -> SpawnArmorTrimsCommand.a((CommandListenerWrapper)context.getSource(), ((CommandListenerWrapper)context.getSource()).h()))));
    }

    private static int a(CommandListenerWrapper source, EntityHuman player) {
        World level = player.dM();
        NonNullList<ArmorTrim> nonNullList = NonNullList.a();
        IRegistry<TrimPattern> registry = level.I_().d(Registries.aJ);
        IRegistry<TrimMaterial> registry2 = level.I_().d(Registries.aI);
        registry.s().sorted(Comparator.comparing(pattern -> d.applyAsInt(registry.c((TrimPattern)pattern).orElse(null)))).forEachOrdered(pattern -> registry2.s().sorted(Comparator.comparing(material -> e.applyAsInt(registry2.c((TrimMaterial)material).orElse(null)))).forEachOrdered(material -> nonNullList.add(new ArmorTrim(registry2.d((TrimMaterial)material), registry.d((TrimPattern)pattern)))));
        BlockPosition blockPos = player.dm().a(player.cE(), 5);
        int i2 = EnumArmorMaterial.values().length - 1;
        double d2 = 3.0;
        int j2 = 0;
        int k2 = 0;
        for (ArmorTrim armorTrim : nonNullList) {
            for (EnumArmorMaterial armorMaterial : EnumArmorMaterial.values()) {
                if (armorMaterial == EnumArmorMaterial.a) continue;
                double e2 = (double)blockPos.u() + 0.5 - (double)(j2 % registry2.b()) * 3.0;
                double f2 = (double)blockPos.v() + 0.5 + (double)(k2 % i2) * 3.0;
                double g2 = (double)blockPos.w() + 0.5 + (double)(j2 / registry2.b() * 10);
                EntityArmorStand armorStand = new EntityArmorStand(level, e2, f2, g2);
                armorStand.r(180.0f);
                armorStand.e(true);
                for (EnumItemSlot equipmentSlot : EnumItemSlot.values()) {
                    ItemArmor armorItem;
                    Item item = a.get(Pair.of((Object)armorMaterial, (Object)equipmentSlot));
                    if (item == null) continue;
                    ItemStack itemStack = new ItemStack(item);
                    ArmorTrim.a(level.I_(), itemStack, armorTrim);
                    armorStand.a(equipmentSlot, itemStack);
                    if (item instanceof ItemArmor && (armorItem = (ItemArmor)item).d() == EnumArmorMaterial.f) {
                        armorStand.b(armorTrim.a().a().a(armorTrim.b()).f().f(" ").b(armorTrim.b().a().e()));
                        armorStand.n(true);
                        continue;
                    }
                    armorStand.j(true);
                }
                level.b(armorStand);
                ++k2;
            }
            ++j2;
        }
        source.a(() -> IChatBaseComponent.b("Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

