/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import ca.spottedleaf.concurrentutil.executor.standard.PrioritisedExecutor;
import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.io.SyncLoadFinder;
import com.destroystokyo.paper.util.concurrent.WeakSeqLock;
import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import gg.pufferfish.pufferfish.PufferfishConfig;
import gg.pufferfish.pufferfish.util.IterableWrapper;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.chunk.system.scheduling.ChunkTaskScheduler;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.maplist.IteratorSafeOrderedReferenceSet;
import io.papermc.paper.util.player.NearbyPlayers;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.MathHelper;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.slf4j.Logger;

public class ChunkProviderServer
extends IChunkProvider {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final List<ChunkStatus> b = ChunkStatus.a();
    private final ChunkMapDistance c;
    final WorldServer d;
    public final Thread e;
    final LightEngineThreaded f;
    public final b g;
    public final PlayerChunkMap a;
    private final WorldPersistentData h;
    private long i;
    public boolean j = true;
    public boolean k = true;
    private static final int l = 4;
    private final long[] m = new long[4];
    private final ChunkStatus[] n = new ChunkStatus[4];
    private final IChunkAccess[] o = new IChunkAccess[4];
    @Nullable
    @VisibleForDebug
    private SpawnerCreature.d p;
    public final IteratorSafeOrderedReferenceSet<Chunk> tickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);
    public final IteratorSafeOrderedReferenceSet<Chunk> entityTickingChunks = new IteratorSafeOrderedReferenceSet(4096, 0.75f, 4096, 0.15, true);
    final WeakSeqLock loadedChunkMapSeqLock = new WeakSeqLock();
    final Long2ObjectOpenHashMap<Chunk> loadedChunkMap = new Long2ObjectOpenHashMap(8192, 0.5f);
    final AtomicLong chunkFutureAwaitCounter = new AtomicLong();
    private final Chunk[] lastLoadedChunks = new Chunk[16];
    public boolean firstRunSpawnCounts = true;
    public final AtomicBoolean _pufferfish_spawnCountsReady = new AtomicBoolean(false);

    public ChunkProviderServer(WorldServer world, Convertable.ConversionSession session, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor workerExecutor, ChunkGenerator chunkGenerator, int viewDistance, int simulationDistance, boolean dsync, WorldLoadListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<WorldPersistentData> persistentStateManagerFactory) {
        this.d = world;
        this.g = new b(world);
        this.e = Thread.currentThread();
        File file = session.a(world.ae()).resolve("data").toFile();
        file.mkdirs();
        this.h = new WorldPersistentData(file, dataFixer);
        this.a = new PlayerChunkMap(world, session, dataFixer, structureTemplateManager, workerExecutor, this.g, this, chunkGenerator, worldGenerationProgressListener, chunkStatusChangeListener, persistentStateManagerFactory, viewDistance, dsync);
        this.f = this.a.e();
        this.c = this.a.j();
        this.c.b(simulationDistance);
        this.r();
    }

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        PlayerChunk chunk = this.a.a(ChunkCoordIntPair.c(chunkX, chunkZ));
        if (chunk == null) {
            return false;
        }
        return chunk.getFullChunkNow() != null;
    }

    private static int getChunkCacheKey(int x2, int z2) {
        return x2 & 3 | (z2 & 3) << 2;
    }

    public void addLoadedChunk(Chunk chunk) {
        this.loadedChunkMapSeqLock.acquireWrite();
        try {
            this.loadedChunkMap.put(chunk.coordinateKey, (Object)chunk);
        }
        finally {
            this.loadedChunkMapSeqLock.releaseWrite();
        }
        int cacheKey = ChunkProviderServer.getChunkCacheKey(chunk.locX, chunk.locZ);
        this.lastLoadedChunks[cacheKey] = chunk;
    }

    public void removeLoadedChunk(Chunk chunk) {
        this.loadedChunkMapSeqLock.acquireWrite();
        try {
            this.loadedChunkMap.remove(chunk.coordinateKey);
        }
        finally {
            this.loadedChunkMapSeqLock.releaseWrite();
        }
        int cacheKey = ChunkProviderServer.getChunkCacheKey(chunk.locX, chunk.locZ);
        Chunk cachedChunk = this.lastLoadedChunks[cacheKey];
        if (cachedChunk != null && cachedChunk.coordinateKey == chunk.coordinateKey) {
            this.lastLoadedChunks[cacheKey] = null;
        }
    }

    public final Chunk getChunkAtIfLoadedMainThread(int x2, int z2) {
        int cacheKey = ChunkProviderServer.getChunkCacheKey(x2, z2);
        Chunk cachedChunk = this.lastLoadedChunks[cacheKey];
        if (cachedChunk != null && cachedChunk.locX == x2 & cachedChunk.locZ == z2) {
            return cachedChunk;
        }
        long chunkKey = ChunkCoordIntPair.c(x2, z2);
        this.lastLoadedChunks[cacheKey] = cachedChunk = (Chunk)this.loadedChunkMap.get(chunkKey);
        return cachedChunk;
    }

    public final Chunk getChunkAtIfLoadedMainThreadNoCache(int x2, int z2) {
        return (Chunk)this.loadedChunkMap.get(ChunkCoordIntPair.c(x2, z2));
    }

    @Nullable
    public IChunkAccess getChunkAtImmediately(int x2, int z2) {
        PlayerChunk holder = this.a.b(ChunkCoordIntPair.c(x2, z2));
        if (holder == null) {
            return null;
        }
        return holder.i();
    }

    public <T> void addTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkPos, int ticketLevel, T identifier) {
        this.c.a(ticketType, chunkPos, ticketLevel, identifier);
    }

    public <T> void removeTicketAtLevel(TicketType<T> ticketType, ChunkCoordIntPair chunkPos, int ticketLevel, T identifier) {
        this.c.b(ticketType, chunkPos, ticketLevel, identifier);
    }

    @Nullable
    public Chunk getChunkAtIfCachedImmediately(int x2, int z2) {
        long k2 = ChunkCoordIntPair.c(x2, z2);
        PlayerChunk playerChunk = this.b(k2);
        if (playerChunk == null) {
            return null;
        }
        return playerChunk.getFullChunkNowUnchecked();
    }

    @Nullable
    public Chunk getChunkAtIfLoadedImmediately(int x2, int z2) {
        long readlock;
        long k2 = ChunkCoordIntPair.c(x2, z2);
        if (TickThread.isTickThread()) {
            return this.getChunkAtIfLoadedMainThread(x2, z2);
        }
        Chunk ret = null;
        do {
            readlock = this.loadedChunkMapSeqLock.acquireRead();
            try {
                ret = (Chunk)this.loadedChunkMap.get(k2);
            }
            catch (Throwable thr) {
                if (!(thr instanceof ThreadDeath)) continue;
                throw (ThreadDeath)thr;
            }
        } while (!this.loadedChunkMapSeqLock.tryReleaseRead(readlock));
        return ret;
    }

    public LightEngineThreaded a() {
        return this.f;
    }

    @Nullable
    private PlayerChunk b(long pos) {
        return this.a.b(pos);
    }

    public int b() {
        return this.a.h();
    }

    private void a(long pos, IChunkAccess chunk, ChunkStatus status) {
        for (int j2 = 3; j2 > 0; --j2) {
            this.m[j2] = this.m[j2 - 1];
            this.n[j2] = this.n[j2 - 1];
            this.o[j2] = this.o[j2 - 1];
        }
        this.m[0] = pos;
        this.n[0] = status;
        this.o[0] = chunk;
    }

    @Override
    @Nullable
    public IChunkAccess a(int x2, int z2, ChunkStatus leastStatus, boolean create) {
        int x1 = x2;
        int z1 = z2;
        if (!TickThread.isTickThread()) {
            return CompletableFuture.supplyAsync(() -> this.a(x2, z2, leastStatus, create), this.g).join();
        }
        Chunk ifLoaded = this.getChunkAtIfLoadedMainThread(x2, z2);
        if (ifLoaded != null) {
            return ifLoaded;
        }
        long k2 = ChunkCoordIntPair.c(x2, z2);
        CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture = this.getChunkFutureMainThread(x2, z2, leastStatus, create, true);
        b chunkproviderserver_b = this.g;
        Objects.requireNonNull(completablefuture);
        if (!completablefuture.isDone()) {
            ChunkTaskScheduler.pushChunkWait(this.d, x1, z1);
            SyncLoadFinder.logSyncLoad(this.d, x2, z2);
            chunkproviderserver_b.c(completablefuture::isDone);
            ChunkTaskScheduler.popChunkWait();
        }
        IChunkAccess ichunkaccess = (IChunkAccess)completablefuture.join().map(ichunkaccess1 -> ichunkaccess1, playerchunk_failure -> {
            if (create) {
                throw SystemUtils.b(new IllegalStateException("Chunk not there when requested: " + playerchunk_failure));
            }
            return null;
        });
        this.a(k2, ichunkaccess, leastStatus);
        return ichunkaccess;
    }

    @Override
    @Nullable
    public Chunk a(int chunkX, int chunkZ) {
        if (!TickThread.isTickThread()) {
            return null;
        }
        return this.getChunkAtIfLoadedMainThread(chunkX, chunkZ);
    }

    private void r() {
        Arrays.fill(this.m, ChunkCoordIntPair.a);
        Arrays.fill(this.n, null);
        Arrays.fill(this.o, null);
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> b(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        CompletionStage<Either<IChunkAccess, PlayerChunk.Failure>> completablefuture;
        boolean flag1 = TickThread.isTickThread();
        if (flag1) {
            completablefuture = this.c(chunkX, chunkZ, leastStatus, create);
            b chunkproviderserver_b = this.g;
            Objects.requireNonNull(completablefuture);
            chunkproviderserver_b.c(() -> completablefuture.isDone());
        } else {
            completablefuture = CompletableFuture.supplyAsync(() -> this.c(chunkX, chunkZ, leastStatus, create), this.g).thenCompose(completablefuture1 -> completablefuture1);
        }
        return completablefuture;
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> c(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create) {
        return this.getChunkFutureMainThread(chunkX, chunkZ, leastStatus, create, false);
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> getChunkFutureMainThread(int chunkX, int chunkZ, ChunkStatus leastStatus, boolean create, boolean isUrgent) {
        NewChunkHolder.ChunkCompletion chunkCompletion;
        boolean needsFullScheduling;
        TickThread.ensureTickThread(this.d, chunkX, chunkZ, "Scheduling chunk load off-main");
        int minLevel = ChunkLevel.a(leastStatus);
        NewChunkHolder chunkHolder = this.d.chunkTaskScheduler.chunkHolderManager.getChunkHolder(chunkX, chunkZ);
        boolean bl = needsFullScheduling = leastStatus == ChunkStatus.n && (chunkHolder == null || !chunkHolder.getChunkStatus().a(FullChunkStatus.b));
        if ((chunkHolder == null || chunkHolder.getTicketLevel() > minLevel || needsFullScheduling) && !create) {
            return PlayerChunk.b;
        }
        NewChunkHolder.ChunkCompletion chunkCompletion2 = chunkCompletion = chunkHolder == null ? null : chunkHolder.getLastChunkCompletion();
        if (needsFullScheduling || chunkCompletion == null || !chunkCompletion.genStatus().b(leastStatus)) {
            CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> ret = new CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>>();
            Consumer<IChunkAccess> complete = chunk -> {
                if (chunk == null) {
                    ret.complete(Either.right(PlayerChunk.Failure.b));
                } else {
                    ret.complete(Either.left(chunk));
                }
            };
            this.d.chunkTaskScheduler.scheduleChunkLoad(chunkX, chunkZ, leastStatus, true, isUrgent ? PrioritisedExecutor.Priority.BLOCKING : PrioritisedExecutor.Priority.NORMAL, complete);
            return ret;
        }
        return CompletableFuture.completedFuture(Either.left(chunkCompletion.chunk()));
    }

    @Override
    public boolean b(int x2, int z2) {
        return this.getChunkAtIfLoadedImmediately(x2, z2) != null;
    }

    @Override
    @Nullable
    public LightChunk c(int chunkX, int chunkZ) {
        long k2 = ChunkCoordIntPair.c(chunkX, chunkZ);
        PlayerChunk playerchunk = this.b(k2);
        if (playerchunk == null) {
            return null;
        }
        ChunkStatus status = playerchunk.getChunkHolderStatus();
        if (status != null && !status.b(ChunkStatus.l.d())) {
            return null;
        }
        return playerchunk.getAvailableChunkNow();
    }

    public World c() {
        return this.d;
    }

    public boolean d() {
        return this.g.x();
    }

    public boolean s() {
        return this.d.chunkTaskScheduler.chunkHolderManager.processTicketUpdates();
    }

    public boolean isPositionTicking(Entity entity) {
        return this.a(ChunkCoordIntPair.c(MathHelper.a(entity.dr()) >> 4, MathHelper.a(entity.dx()) >> 4));
    }

    public boolean a(long pos) {
        PlayerChunk holder = this.a.b(pos);
        return holder != null && holder.isTickingReady();
    }

    public void a(boolean flush) {
        this.s();
        this.a.a(flush);
    }

    public void saveIncrementally() {
        this.s();
        this.a.saveIncrementally();
    }

    @Override
    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean save) {
        this.d.chunkTaskScheduler.chunkHolderManager.close(save, true);
        try {
            this.h.close();
        }
        catch (IOException exception) {
            LOGGER.error("Failed to close persistent world data", (Throwable)exception);
        }
    }

    public void purgeUnload() {
    }

    @Override
    public void a(BooleanSupplier shouldKeepTicking, boolean tickChunks) {
        this.c.a();
        this.s();
        if (tickChunks) {
            this.a.q.playerChunkLoader.tick();
            this.t();
            this.a.l();
        }
        this.a.a(shouldKeepTicking);
        this.r();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void t() {
        long i2 = this.d.X();
        long j2 = i2 - this.i;
        this.i = i2;
        if (!this.d.ah()) {
            this.d.resetIceAndSnowTick();
            if (this.d.o().aO().i()) {
                Iterator<Chunk> chunkIterator;
                int k2;
                int naturalSpawnChunkCount = k2 = this.c.b();
                if ((this.k || this.j) && this.d.paperConfig().entities.spawning.perPlayerMobSpawns) {
                    if (!PufferfishConfig.enableAsyncMobSpawning) {
                        for (EntityPlayer player : this.d.H) {
                            for (int ii = 0; ii < EntityPlayer.MOBCATEGORY_TOTAL_ENUMS; ++ii) {
                                player.mobCounts[ii] = 0;
                                int newBackoff = player.mobBackoffCounts[ii] - 1;
                                if (newBackoff < 0) {
                                    newBackoff = 0;
                                }
                                player.mobBackoffCounts[ii] = newBackoff;
                            }
                        }
                        this.p = SpawnerCreature.createState(naturalSpawnChunkCount, this.d.A(), this::a, null, true);
                    }
                } else {
                    this.p = SpawnerCreature.createState(naturalSpawnChunkCount, this.d.A(), this::a, !this.d.paperConfig().entities.spawning.perPlayerMobSpawns ? new LocalMobCapCalculator(this.a) : null, false);
                    this._pufferfish_spawnCountsReady.set(true);
                }
                boolean flag = this.d.Z().b(GameRules.e) && !this.d.x().isEmpty();
                PlayerChunkMap playerChunkMap = this.a;
                for (EntityPlayer player : this.d.H) {
                    if (!player.affectsSpawning || player.P_()) {
                        playerChunkMap.playerMobSpawnMap.remove(player);
                        player.playerNaturallySpawnedEvent = null;
                        player.lastEntitySpawnRadiusSquared = -1.0;
                        continue;
                    }
                    int chunkRange = this.d.spigotConfig.mobSpawnRange;
                    int viewDistance = ChunkSystem.getTickViewDistance(player);
                    chunkRange = chunkRange > viewDistance ? viewDistance : (int)chunkRange;
                    chunkRange = chunkRange > 8 ? 8 : chunkRange;
                    PlayerNaturallySpawnCreaturesEvent event = new PlayerNaturallySpawnCreaturesEvent((Player)player.getBukkitEntity(), (byte)chunkRange);
                    event.callEvent();
                    if (event.isCancelled() || event.getSpawnRadius() < 0) {
                        playerChunkMap.playerMobSpawnMap.remove(player);
                        player.playerNaturallySpawnedEvent = null;
                        player.lastEntitySpawnRadiusSquared = -1.0;
                        continue;
                    }
                    int range = Math.min(event.getSpawnRadius(), 8);
                    int chunkX = CoordinateUtils.getChunkCoordinate(player.dr());
                    int chunkZ = CoordinateUtils.getChunkCoordinate(player.dx());
                    playerChunkMap.playerMobSpawnMap.addOrUpdate(player, chunkX, chunkZ, range);
                    player.lastEntitySpawnRadiusSquared = (range << 4) * (range << 4);
                    player.playerNaturallySpawnedEvent = event;
                }
                int l2 = this.d.Z().c(GameRules.o);
                boolean flag1 = this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) != 0L && this.d.B_().e() % this.d.ticksPerSpawnCategory.getLong((Object)SpawnCategory.ANIMAL) == 0L;
                int chunksTicked = 0;
                NearbyPlayers nearbyPlayers = this.a.getNearbyPlayers();
                if (this.d.paperConfig().entities.spawning.perPlayerMobSpawns) {
                    chunkIterator = this.tickingChunks.iterator();
                } else {
                    chunkIterator = this.tickingChunks.unsafeIterator();
                    ArrayList shuffled = Lists.newArrayListWithCapacity((int)this.tickingChunks.size());
                    while (chunkIterator.hasNext()) {
                        shuffled.add(chunkIterator.next());
                    }
                    SystemUtils.c(shuffled, this.d.z);
                    chunkIterator = shuffled.iterator();
                }
                try {
                    while (chunkIterator.hasNext()) {
                        double distance;
                        EntityPlayer player;
                        Chunk chunk1 = chunkIterator.next();
                        ChunkCoordIntPair chunkcoordintpair = chunk1.f();
                        ReferenceList<EntityPlayer> playersNearby = nearbyPlayers.getPlayers(chunkcoordintpair, NearbyPlayers.NearbyMapType.SPAWN_RANGE);
                        if (playersNearby == null) continue;
                        Object[] rawData = playersNearby.getRawData();
                        boolean spawn = false;
                        boolean tick = false;
                        int len = playersNearby.size();
                        for (int itr = 0; itr < len && ((player = (EntityPlayer)rawData[itr]).P_() || !((spawn |= player.lastEntitySpawnRadiusSquared >= (distance = PlayerChunkMap.a(chunkcoordintpair, player))) & (tick |= 16384.0 >= distance))); ++itr) {
                        }
                        if (!tick || !chunk1.chunkStatus.a(FullChunkStatus.d)) continue;
                        chunk1.a(j2);
                        if (spawn && flag && (!PufferfishConfig.enableAsyncMobSpawning || this._pufferfish_spawnCountsReady.get()) && (this.j || this.k) && this.d.D_().a(chunkcoordintpair)) {
                            SpawnerCreature.a(this.d, chunk1, this.p, this.k, this.j, flag1);
                        }
                        this.d.a(chunk1, l2);
                        if ((chunksTicked++ & 1) != 0) continue;
                        MinecraftServer.getServer().executeMidTickTasks();
                    }
                }
                finally {
                    if (chunkIterator instanceof IteratorSafeOrderedReferenceSet.Iterator) {
                        IteratorSafeOrderedReferenceSet.Iterator safeIterator = chunkIterator;
                        safeIterator.finishedIterating();
                    }
                }
                if (flag) {
                    this.d.a(this.j, this.k);
                }
            }
            if (!this.a.needsChangeBroadcasting.isEmpty()) {
                ReferenceOpenHashSet copy = this.a.needsChangeBroadcasting.clone();
                this.a.needsChangeBroadcasting.clear();
                for (PlayerChunk holder : copy) {
                    holder.a(holder.getFullChunkNowUnchecked());
                    if (!holder.needsBroadcastChanges()) continue;
                    this.a.needsChangeBroadcasting.add((Object)holder);
                }
            }
        }
        if (PufferfishConfig.enableAsyncMobSpawning) {
            for (EntityPlayer player : this.d.H) {
                for (int ii = 0; ii < EntityPlayer.MOBCATEGORY_TOTAL_ENUMS; ++ii) {
                    player.mobCounts[ii] = 0;
                    int newBackoff = player.mobBackoffCounts[ii] - 1;
                    if (newBackoff < 0) {
                        newBackoff = 0;
                    }
                    player.mobBackoffCounts[ii] = newBackoff;
                }
            }
            if (this.firstRunSpawnCounts) {
                this.firstRunSpawnCounts = false;
                this._pufferfish_spawnCountsReady.set(true);
            }
            if (this._pufferfish_spawnCountsReady.getAndSet(false)) {
                MinecraftServer.getServer().mobSpawnExecutor.submit(() -> {
                    int mapped = this.c.b();
                    IteratorSafeOrderedReferenceSet.Iterator<Entity> objectiterator = this.d.L.entities.iterator(1);
                    IterableWrapper<Entity> wrappedIterator = new IterableWrapper<Entity>(objectiterator);
                    this.p = SpawnerCreature.createState(mapped, wrappedIterator, this::a, null, true);
                    objectiterator.finishedIterating();
                    this._pufferfish_spawnCountsReady.set(true);
                });
            }
        }
    }

    private void a(long pos, Consumer<Chunk> chunkConsumer) {
        Chunk chunk;
        PlayerChunk playerchunk = this.b(pos);
        if (playerchunk != null && (chunk = playerchunk.g()) != null) {
            chunkConsumer.accept(chunk);
        }
    }

    @Override
    public String e() {
        return Integer.toString(this.j());
    }

    @VisibleForTesting
    public int f() {
        return this.g.br();
    }

    public ChunkGenerator g() {
        return this.a.a();
    }

    public ChunkGeneratorStructureState h() {
        return this.a.b();
    }

    public RandomState i() {
        return this.a.c();
    }

    @Override
    public int j() {
        return this.a.i();
    }

    public void a(BlockPosition pos) {
        int j2;
        int i2 = SectionPosition.a(pos.u());
        PlayerChunk playerchunk = this.b(ChunkCoordIntPair.c(i2, j2 = SectionPosition.a(pos.w())));
        if (playerchunk != null) {
            playerchunk.a(pos);
        }
    }

    @Override
    public void a(EnumSkyBlock type, SectionPosition pos) {
        this.g.execute(() -> {
            PlayerChunk playerchunk = this.b(pos.r().a());
            if (playerchunk != null) {
                playerchunk.a(type, pos.b());
            }
        });
    }

    public <T> void a(TicketType<T> ticketType, ChunkCoordIntPair pos, int radius, T argument) {
        this.c.c(ticketType, pos, radius, argument);
    }

    public <T> void b(TicketType<T> ticketType, ChunkCoordIntPair pos, int radius, T argument) {
        this.c.d(ticketType, pos, radius, argument);
    }

    @Override
    public void a(ChunkCoordIntPair pos, boolean forced) {
        this.c.a(pos, forced);
    }

    public void a(EntityPlayer player) {
        if (!player.dH()) {
            this.a.a(player);
        }
    }

    public void a(Entity entity) {
        this.a.b(entity);
    }

    public void b(Entity entity) {
        this.a.a(entity);
    }

    public void a(Entity entity, Packet<?> packet) {
        this.a.b(entity, packet);
    }

    public void b(Entity entity, Packet<?> packet) {
        this.a.a(entity, packet);
    }

    public void a(int watchDistance) {
        this.a.a(watchDistance);
    }

    public void b(int simulationDistance) {
        this.c.b(simulationDistance);
    }

    @Override
    public void a(boolean spawnMonsters, boolean spawnAnimals) {
        this.j = spawnMonsters;
        this.k = spawnAnimals;
    }

    public String a(ChunkCoordIntPair pos) {
        return this.a.a(pos);
    }

    public WorldPersistentData k() {
        return this.h;
    }

    public VillagePlace l() {
        return this.a.m();
    }

    public ChunkScanAccess m() {
        return this.a.p();
    }

    @Nullable
    @VisibleForDebug
    public SpawnerCreature.d n() {
        return this.p;
    }

    public void o() {
        this.c.e();
    }

    private static /* synthetic */ boolean lambda$purgeUnload$6() {
        return true;
    }

    public final class b
    extends IAsyncTaskHandler<Runnable> {
        b(World world) {
            super("Chunk source main thread executor for " + world.ae().a());
        }

        @Override
        protected Runnable f(Runnable runnable) {
            return runnable;
        }

        @Override
        protected boolean e(Runnable task) {
            return true;
        }

        @Override
        protected boolean av() {
            return true;
        }

        @Override
        protected Thread aw() {
            return ChunkProviderServer.this.e;
        }

        @Override
        protected void d(Runnable task) {
            super.d(task);
        }

        @Override
        public boolean x() {
            if (ChunkProviderServer.this.s()) {
                return true;
            }
            return super.x() | ChunkProviderServer.this.d.chunkTaskScheduler.executeMainThreadTask();
        }
    }

    private record a(Chunk a, PlayerChunk b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "chunk;holder", "a", "b"}, this, o2);
        }
    }
}

