/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.destroystokyo.paper.event.entity.PlayerNaturallySpawnCreaturesEvent;
import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.destroystokyo.paper.util.misc.PlayerAreaMap;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Queues;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import gg.pufferfish.pufferfish.util.AsyncPlayerAreaMap;
import io.papermc.paper.chunk.SingleThreadChunkRegionManager;
import io.papermc.paper.chunk.system.ChunkSystem;
import io.papermc.paper.chunk.system.io.RegionFileIOThread;
import io.papermc.paper.chunk.system.scheduling.NewChunkHolder;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.event.player.PlayerTrackEntityEvent;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.player.NearbyPlayers;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMapDistance;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.thread.IAsyncTaskHandler;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.storage.ChunkRegionLoader;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.bukkit.craftbukkit.v1_20_R3.generator.CustomChunkGenerator;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotWorldConfig;
import org.spigotmc.TrackingRange;

public class PlayerChunkMap
extends IChunkLoader
implements PlayerChunk.d {
    private static final byte f = -1;
    private static final byte g = 0;
    private static final byte h = 1;
    private static final Logger i = LogUtils.getLogger();
    private static final int j = 200;
    private static final int k = 20;
    private static final int l = 10000;
    public static final int a = 2;
    public static final int b = 32;
    public static final int c = ChunkLevel.a(FullChunkStatus.d);
    public final WorldServer q;
    private final LightEngineThreaded r;
    public final IAsyncTaskHandler<Runnable> s;
    public ChunkGenerator t;
    private final RandomState u;
    private final ChunkGeneratorStructureState v;
    public final Supplier<WorldPersistentData> w;
    private final VillagePlace x;
    private boolean z;
    public final WorldLoadListener D;
    private final ChunkStatusUpdateListener E;
    public final ChunkDistanceManager F;
    private final AtomicInteger G;
    public final StructureTemplateManager H;
    private final String I;
    private final PlayerMap J;
    public final Int2ObjectMap<EntityTracker> K;
    private final Long2ByteMap L;
    private final Long2LongMap M;
    private final Queue<Runnable> N;
    public int O;
    private final PooledLinkedHashSets<EntityPlayer> pooledLinkedPlayerHashSets = new PooledLinkedHashSets();
    static final TrackingRange.TrackingRangeType[] TRACKING_RANGE_TYPES = TrackingRange.TrackingRangeType.values();
    public final PlayerAreaMap[] playerEntityTrackerTrackMaps;
    final int[] entityTrackerTrackRanges;
    public final List<SingleThreadChunkRegionManager> regionManagers = new ArrayList<SingleThreadChunkRegionManager>();
    public final SingleThreadChunkRegionManager dataRegionManager;
    public final NearbyPlayers nearbyPlayers;
    public final ReferenceOpenHashSet<PlayerChunk> needsChangeBroadcasting = new ReferenceOpenHashSet();
    public final PlayerAreaMap playerMobSpawnMap = new AsyncPlayerAreaMap(this.pooledLinkedPlayerHashSets);

    public static boolean isLegacyTrackingEntity(net.minecraft.world.entity.Entity entity) {
        return entity.isLegacyTrackingEntity;
    }

    public final int getEntityTrackerRange(int ordinal) {
        return this.entityTrackerTrackRanges[ordinal];
    }

    private int convertSpigotRangeToVanilla(int vanilla) {
        return MinecraftServer.getServer().b(vanilla);
    }

    void addPlayerToDistanceMaps(EntityPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.dr());
        int chunkZ = MCUtil.getChunkCoordinate(player.dx());
        this.nearbyPlayers.addPlayer(player);
        this.q.playerChunkLoader.addPlayer(player);
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            PlayerAreaMap trackMap = this.playerEntityTrackerTrackMaps[i2];
            int trackRange = this.entityTrackerTrackRanges[i2];
            trackMap.add(player, chunkX, chunkZ, Math.min(trackRange, ChunkSystem.getSendViewDistance(player)));
        }
    }

    void removePlayerFromDistanceMaps(EntityPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.dr());
        int chunkZ = MCUtil.getChunkCoordinate(player.dx());
        this.nearbyPlayers.removePlayer(player);
        this.q.playerChunkLoader.removePlayer(player);
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            this.playerEntityTrackerTrackMaps[i2].remove(player);
        }
        this.playerMobSpawnMap.remove(player);
    }

    void updateMaps(EntityPlayer player) {
        int chunkX = MCUtil.getChunkCoordinate(player.dr());
        int chunkZ = MCUtil.getChunkCoordinate(player.dx());
        this.nearbyPlayers.tickPlayer(player);
        this.q.playerChunkLoader.updatePlayer(player);
        int len = TRACKING_RANGE_TYPES.length;
        for (int i2 = 0; i2 < len; ++i2) {
            PlayerAreaMap trackMap = this.playerEntityTrackerTrackMaps[i2];
            int trackRange = this.entityTrackerTrackRanges[i2];
            trackMap.update(player, chunkX, chunkZ, Math.min(trackRange, ChunkSystem.getSendViewDistance(player)));
        }
    }

    public final PlayerChunk getUnloadingChunkHolder(int chunkX, int chunkZ) {
        return null;
    }

    public PlayerChunkMap(WorldServer world, Convertable.ConversionSession session, DataFixer dataFixer, StructureTemplateManager structureTemplateManager, Executor executor, IAsyncTaskHandler<Runnable> mainThreadExecutor, ILightAccess chunkProvider, ChunkGenerator chunkGenerator, WorldLoadListener worldGenerationProgressListener, ChunkStatusUpdateListener chunkStatusChangeListener, Supplier<WorldPersistentData> persistentStateManagerFactory, int viewDistance, boolean dsync) {
        super(session.a(world.ae()).resolve("region"), dataFixer, dsync);
        this.G = new AtomicInteger();
        this.J = new PlayerMap();
        this.K = new Int2ObjectOpenHashMap();
        this.L = new Long2ByteOpenHashMap();
        this.M = new Long2LongOpenHashMap();
        this.N = Queues.newConcurrentLinkedQueue();
        this.H = structureTemplateManager;
        Path path = session.a(world.ae());
        this.I = path.getFileName().toString();
        this.q = world;
        this.t = chunkGenerator;
        if (chunkGenerator instanceof CustomChunkGenerator) {
            chunkGenerator = ((CustomChunkGenerator)chunkGenerator).getDelegate();
        }
        IRegistryCustom iregistrycustom = world.I_();
        long j2 = world.C();
        if (chunkGenerator instanceof ChunkGeneratorAbstract) {
            ChunkGeneratorAbstract chunkgeneratorabstract = (ChunkGeneratorAbstract)chunkGenerator;
            this.u = RandomState.a(chunkgeneratorabstract.g().a(), iregistrycustom.b(Registries.aB), j2);
        } else {
            this.u = RandomState.a(GeneratorSettingBase.e(), iregistrycustom.b(Registries.aB), j2);
        }
        this.v = chunkGenerator.createState(iregistrycustom.b(Registries.aF), this.u, j2, world.spigotConfig);
        this.s = mainThreadExecutor;
        Objects.requireNonNull(mainThreadExecutor);
        this.D = worldGenerationProgressListener;
        this.E = chunkStatusChangeListener;
        this.r = new LightEngineThreaded(chunkProvider, this, this.q.E_().g(), null, null);
        this.F = new ChunkDistanceManager(executor, mainThreadExecutor);
        this.w = persistentStateManagerFactory;
        this.x = new VillagePlace(path.resolve("poi"), dataFixer, dsync, iregistrycustom, world);
        this.a(viewDistance);
        this.dataRegionManager = new SingleThreadChunkRegionManager(this.q, 2, 0.3333333333333333, 1, 6, "Data", DataRegionData::new, DataRegionSectionData::new);
        this.regionManagers.add(this.dataRegionManager);
        this.nearbyPlayers = new NearbyPlayers(this.q);
        this.playerEntityTrackerTrackMaps = new PlayerAreaMap[TRACKING_RANGE_TYPES.length];
        this.entityTrackerTrackRanges = new int[TRACKING_RANGE_TYPES.length];
        SpigotWorldConfig spigotWorldConfig = this.q.spigotConfig;
        for (TrackingRange.TrackingRangeType trackingRangeType : TRACKING_RANGE_TYPES) {
            int trackRange;
            int configuredSpigotValue = switch (trackingRangeType) {
                case TrackingRange.TrackingRangeType.PLAYER -> spigotWorldConfig.playerTrackingRange;
                case TrackingRange.TrackingRangeType.ANIMAL -> spigotWorldConfig.animalTrackingRange;
                case TrackingRange.TrackingRangeType.MONSTER -> spigotWorldConfig.monsterTrackingRange;
                case TrackingRange.TrackingRangeType.MISC -> spigotWorldConfig.miscTrackingRange;
                case TrackingRange.TrackingRangeType.OTHER -> spigotWorldConfig.otherTrackingRange;
                case TrackingRange.TrackingRangeType.ENDERDRAGON -> EntityTypes.D.o() * 16;
                case TrackingRange.TrackingRangeType.DISPLAY -> spigotWorldConfig.displayTrackingRange;
                default -> throw new IllegalStateException("Missing case for enum " + trackingRangeType);
            };
            configuredSpigotValue = this.convertSpigotRangeToVanilla(configuredSpigotValue);
            this.entityTrackerTrackRanges[ordinal] = trackRange = (configuredSpigotValue >>> 4) + ((configuredSpigotValue & 0xF) != 0 ? 1 : 0);
            this.playerEntityTrackerTrackMaps[ordinal] = new PlayerAreaMap(this.pooledLinkedPlayerHashSets);
        }
    }

    public final NearbyPlayers getNearbyPlayers() {
        return this.nearbyPlayers;
    }

    protected ChunkGenerator a() {
        return this.t;
    }

    protected ChunkGeneratorStructureState b() {
        return this.v;
    }

    protected RandomState c() {
        return this.u;
    }

    public void d() {
        DataResult dataresult = ChunkGenerator.a.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.t);
        DataResult dataresult1 = dataresult.flatMap(jsonelement -> ChunkGenerator.a.parse((DynamicOps)JsonOps.INSTANCE, jsonelement));
        dataresult1.result().ifPresent(chunkgenerator -> {
            this.t = chunkgenerator;
        });
    }

    public void updatePlayerMobTypeMap(net.minecraft.world.entity.Entity entity) {
        if (!this.q.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int index = entity.ai().f().ordinal();
        ReferenceList<EntityPlayer> inRange = this.getNearbyPlayers().getPlayers(entity.do(), NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        Object[] backingSet = inRange.getRawData();
        int len = inRange.size();
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = index;
            ((EntityPlayer)backingSet[i2]).mobCounts[n2] = ((EntityPlayer)backingSet[i2]).mobCounts[n2] + 1;
        }
    }

    public void updateFailurePlayerMobTypeMap(int chunkX, int chunkZ, EnumCreatureType mobCategory) {
        if (!this.q.paperConfig().entities.spawning.perPlayerMobSpawns) {
            return;
        }
        int idx = mobCategory.ordinal();
        ReferenceList<EntityPlayer> inRange = this.getNearbyPlayers().getPlayersByChunk(chunkX, chunkZ, NearbyPlayers.NearbyMapType.TICK_VIEW_DISTANCE);
        if (inRange == null) {
            return;
        }
        Object[] backingSet = inRange.getRawData();
        int len = inRange.size();
        for (int i2 = 0; i2 < len; ++i2) {
            int n2 = idx;
            ((EntityPlayer)backingSet[i2]).mobBackoffCounts[n2] = ((EntityPlayer)backingSet[i2]).mobBackoffCounts[n2] + 1;
        }
    }

    public int getMobCountNear(EntityPlayer player, EnumCreatureType mobCategory) {
        return player.mobCounts[mobCategory.ordinal()] + player.mobBackoffCounts[mobCategory.ordinal()];
    }

    public static double a(ChunkCoordIntPair pos, net.minecraft.world.entity.Entity entity) {
        double d0 = SectionPosition.a(pos.e, 8);
        double d1 = SectionPosition.a(pos.f, 8);
        double d2 = d0 - entity.dr();
        double d3 = d1 - entity.dx();
        return d2 * d2 + d3 * d3;
    }

    boolean a(EntityPlayer player, int chunkX, int chunkZ) {
        return this.q.playerChunkLoader.isChunkSent(player, chunkX, chunkZ);
    }

    private boolean b(EntityPlayer player, int chunkX, int chunkZ) {
        return this.q.playerChunkLoader.isChunkSent(player, chunkX, chunkZ, true);
    }

    protected LightEngineThreaded e() {
        return this.r;
    }

    @Nullable
    protected PlayerChunk a(long pos) {
        NewChunkHolder holder = this.q.chunkTaskScheduler.chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    @Nullable
    public PlayerChunk b(long pos) {
        NewChunkHolder holder = this.q.chunkTaskScheduler.chunkHolderManager.getChunkHolder(pos);
        return holder == null ? null : holder.vanillaChunkHolder;
    }

    protected IntSupplier c(long pos) {
        throw new UnsupportedOperationException();
    }

    public String a(ChunkCoordIntPair chunkPos) {
        PlayerChunk playerchunk = this.b(chunkPos.a());
        if (playerchunk == null) {
            return "null";
        }
        String s2 = playerchunk.m() + "\n";
        ChunkStatus chunkstatus = playerchunk.h();
        IChunkAccess ichunkaccess = playerchunk.i();
        if (chunkstatus != null) {
            s2 = s2 + "St: \u00a7" + chunkstatus.c() + chunkstatus + "\u00a7r\n";
        }
        if (ichunkaccess != null) {
            s2 = s2 + "Ch: \u00a7" + ichunkaccess.j().c() + ichunkaccess.j() + "\u00a7r\n";
        }
        FullChunkStatus fullchunkstatus = playerchunk.k();
        s2 = s2 + String.valueOf('\u00a7') + fullchunkstatus.ordinal() + fullchunkstatus;
        return s2 + "\u00a7r";
    }

    private CompletableFuture<Either<List<IChunkAccess>, PlayerChunk.Failure>> a(PlayerChunk centerChunk, int margin, IntFunction<ChunkStatus> distanceToStatus) {
        throw new UnsupportedOperationException();
    }

    public ReportedException a(IllegalStateException exception, String details) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<PlayerChunk> consumer = playerchunk -> playerchunk.q().forEach(pair -> {
            ChunkStatus chunkstatus = (ChunkStatus)pair.getFirst();
            CompletableFuture completablefuture = (CompletableFuture)pair.getSecond();
            if (completablefuture != null && completablefuture.isDone() && completablefuture.join() == null) {
                stringbuilder.append(playerchunk.l()).append(" - status: ").append(chunkstatus).append(" future: ").append(completablefuture).append(System.lineSeparator());
            }
        });
        stringbuilder.append("Updating:").append(System.lineSeparator());
        ChunkSystem.getUpdatingChunkHolders(this.q).forEach(consumer);
        stringbuilder.append("Visible:").append(System.lineSeparator());
        ChunkSystem.getVisibleChunkHolders(this.q).forEach(consumer);
        CrashReport crashreport = CrashReport.a(exception, "Chunk loading");
        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Chunk loading");
        crashreportsystemdetails.a("Details", details);
        crashreportsystemdetails.a("Futures", stringbuilder);
        return new ReportedException(crashreport);
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> a(PlayerChunk chunk) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    PlayerChunk a(long pos, int level, @Nullable PlayerChunk holder, int k2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        throw new UnsupportedOperationException("Use ServerChunkCache#close");
    }

    protected void saveIncrementally() {
        this.q.chunkTaskScheduler.chunkHolderManager.autoSave();
    }

    protected void a(boolean flush) {
        this.q.chunkTaskScheduler.chunkHolderManager.saveAllChunks(flush, false, false);
    }

    protected void a(BooleanSupplier shouldKeepTicking) {
        this.x.a(shouldKeepTicking);
        if (!this.q.t()) {
            this.b(shouldKeepTicking);
        }
    }

    public boolean f() {
        throw new UnsupportedOperationException();
    }

    private void b(BooleanSupplier shouldKeepTicking) {
        this.q.chunkTaskScheduler.chunkHolderManager.processUnloads();
    }

    private void a(long pos, PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    protected boolean g() {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> a(PlayerChunk holder, ChunkStatus requiredStatus) {
        throw new UnsupportedOperationException();
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> f(ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    public static boolean b(NBTTagCompound nbt) {
        return nbt.b("Status", 8);
    }

    private Either<IChunkAccess, PlayerChunk.Failure> a(Throwable throwable, ChunkCoordIntPair chunkPos) {
        if (throwable instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable;
            Throwable throwable1 = reportedexception.getCause();
            if (!(throwable1 instanceof IOException)) {
                this.h(chunkPos);
                throw reportedexception;
            }
            i.error("Couldn't load chunk {}", (Object)chunkPos, (Object)throwable1);
        } else if (throwable instanceof IOException) {
            i.error("Couldn't load chunk {}", (Object)chunkPos, (Object)throwable);
        }
        return Either.left(this.g(chunkPos));
    }

    private IChunkAccess g(ChunkCoordIntPair chunkPos) {
        this.h(chunkPos);
        return new ProtoChunk(chunkPos, ChunkConverter.a, this.q, this.q.I_().d(Registries.at), null);
    }

    private void h(ChunkCoordIntPair pos) {
        this.L.put(pos.a(), (byte)-1);
    }

    private byte a(ChunkCoordIntPair pos, ChunkStatus.Type type) {
        return this.L.put(pos.a(), (byte)(type == ChunkStatus.Type.a ? -1 : 1));
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> b(PlayerChunk holder, ChunkStatus requiredStatus) {
        throw new UnsupportedOperationException();
    }

    protected void b(ChunkCoordIntPair pos) {
        this.s.i(SystemUtils.a(() -> this.F.b(TicketType.e, pos, ChunkLevel.a(ChunkStatus.l), pos), () -> "release light ticket " + pos));
    }

    public static ChunkStatus a(ChunkStatus centerChunkTargetStatus, int distance) {
        ChunkStatus chunkstatus1 = distance == 0 ? centerChunkTargetStatus.d() : ChunkStatus.a(ChunkStatus.a(centerChunkTargetStatus) + distance);
        return chunkstatus1;
    }

    public static void postLoadProtoChunk(WorldServer world, List<NBTTagCompound> nbt, ChunkCoordIntPair position) {
        if (!nbt.isEmpty()) {
            world.addWorldGenChunkEntities(EntityTypes.a(nbt, (World)world).filter(entity -> {
                boolean needsRemoval = false;
                DedicatedServer server = world.getCraftServer().getServer();
                if (!server.Z() && entity instanceof NPC) {
                    entity.discard(null);
                    needsRemoval = true;
                }
                if (!server.Y() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal)) {
                    entity.discard(null);
                    needsRemoval = true;
                }
                PlayerChunkMap.checkDupeUUID(world, entity);
                return !needsRemoval;
            }), position);
        }
    }

    private CompletableFuture<Either<IChunkAccess, PlayerChunk.Failure>> d(PlayerChunk chunkHolder) {
        throw new UnsupportedOperationException();
    }

    public static boolean checkDupeUUID(WorldServer level, net.minecraft.world.entity.Entity entity) {
        WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode mode = level.paperConfig().entities.spawning.duplicateUuid.mode;
        if (mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.WARN && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.DELETE && mode != WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN) {
            return false;
        }
        net.minecraft.world.entity.Entity other = level.a(entity.cw());
        if (other == null || other == entity) {
            return false;
        }
        if (mode == WorldConfiguration.Entities.Spawning.DuplicateUUID.DuplicateUUIDMode.SAFE_REGEN && other != null && !other.dH() && Objects.equals(other.bw(), entity.bw()) && entity.getBukkitEntity().getLocation().distance(other.getBukkitEntity().getLocation()) < (double)level.paperConfig().entities.spawning.duplicateUuid.safeRegenDeleteRange) {
            entity.discard(null);
            return true;
        }
        if (!other.dH()) {
            switch (mode) {
                case SAFE_REGEN: {
                    entity.a_(UUID.randomUUID());
                    break;
                }
                case DELETE: {
                    entity.discard(EntityRemoveEvent.Cause.DISCARD);
                    return true;
                }
            }
        }
        return false;
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> b(PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    private void a(Chunk chunk) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Either<Chunk, PlayerChunk.Failure>> c(PlayerChunk holder) {
        throw new UnsupportedOperationException();
    }

    public int h() {
        return this.G.get();
    }

    private boolean e(PlayerChunk chunkHolder) {
        throw new UnsupportedOperationException();
    }

    public boolean a(IChunkAccess chunk) {
        throw new UnsupportedOperationException();
    }

    private boolean i(ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    public void setTickViewDistance(int distance) {
        this.q.playerChunkLoader.setTickDistance(distance);
    }

    public void setSendViewDistance(int distance) {
        this.q.playerChunkLoader.setSendDistance(distance);
    }

    public void a(int watchDistance) {
        int j2 = MathHelper.a(watchDistance, 2, 32);
        if (j2 != this.O) {
            this.O = j2;
            this.q.playerChunkLoader.setLoadDistance(this.O + 1);
        }
    }

    public int b(EntityPlayer player) {
        return ChunkSystem.getSendViewDistance(player);
    }

    private void a(EntityPlayer player, ChunkCoordIntPair pos) {
        throw new UnsupportedOperationException();
    }

    private static void a(EntityPlayer player, Chunk chunk) {
        throw new UnsupportedOperationException();
    }

    private static void b(EntityPlayer player, ChunkCoordIntPair pos) {
    }

    @Nullable
    public Chunk d(long pos) {
        PlayerChunk playerchunk = this.b(pos);
        return playerchunk == null ? null : playerchunk.f();
    }

    public int i() {
        return ChunkSystem.getVisibleChunkHolderCount(this.q);
    }

    public ChunkMapDistance j() {
        return this.F;
    }

    protected Iterable<PlayerChunk> k() {
        return Iterables.unmodifiableIterable(ChunkSystem.getVisibleChunkHolders(this.q));
    }

    void a(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static String a(CompletableFuture<Either<Chunk, PlayerChunk.Failure>> future) {
        try {
            Either either = future.getNow(null);
            return either != null ? either.map(chunk -> "done", playerchunk_failure -> "unloaded") : "not completed";
        }
        catch (CompletionException completionexception) {
            return "failed " + completionexception.getCause().getMessage();
        }
        catch (CancellationException cancellationexception) {
            return "cancelled";
        }
    }

    @Override
    @Nullable
    public NBTTagCompound readSync(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            return RegionFileIOThread.loadData(this.q, chunkcoordintpair.e, chunkcoordintpair.f, RegionFileIOThread.RegionFileType.CHUNK_DATA, RegionFileIOThread.getIOBlockingPriorityForCurrentThread());
        }
        return super.readSync(chunkcoordintpair);
    }

    @Override
    public void a(ChunkCoordIntPair chunkcoordintpair, NBTTagCompound nbttagcompound) throws IOException {
        if (!RegionFileIOThread.isRegionFileThread()) {
            RegionFileIOThread.scheduleSave(this.q, chunkcoordintpair.e, chunkcoordintpair.f, nbttagcompound, RegionFileIOThread.RegionFileType.CHUNK_DATA);
            return;
        }
        super.a(chunkcoordintpair, nbttagcompound);
    }

    private CompletableFuture<Optional<NBTTagCompound>> j(ChunkCoordIntPair chunkPos) {
        try {
            return CompletableFuture.completedFuture(Optional.ofNullable(this.readConvertChunkSync(chunkPos)));
        }
        catch (Throwable thr) {
            return CompletableFuture.failedFuture(thr);
        }
    }

    private NBTTagCompound upgradeChunkTag(NBTTagCompound nbttagcompound, ChunkCoordIntPair chunkcoordintpair) {
        return this.upgradeChunkTag(this.q.getTypeKey(), this.w, nbttagcompound, this.t.b(), chunkcoordintpair, this.q);
    }

    @Nullable
    public NBTTagCompound readConvertChunkSync(ChunkCoordIntPair pos) throws IOException {
        NBTTagCompound nbttagcompound = this.readSync(pos);
        if (nbttagcompound == null) {
            return null;
        }
        if ((nbttagcompound = this.upgradeChunkTag(nbttagcompound, pos)) == null) {
            return null;
        }
        this.updateChunkStatusOnDisk(pos, nbttagcompound);
        return nbttagcompound;
    }

    public ChunkStatus getChunkStatusOnDiskIfCached(ChunkCoordIntPair chunkPos) {
        RegionFile regionFile = this.regionFileCache.getRegionFileIfLoaded(chunkPos);
        return regionFile == null ? null : regionFile.getStatusIfCached(chunkPos.e, chunkPos.f);
    }

    public ChunkStatus getChunkStatusOnDisk(ChunkCoordIntPair chunkPos) throws IOException {
        RegionFile regionFile = this.regionFileCache.getRegionFile(chunkPos, true);
        if (regionFile == null || !this.regionFileCache.chunkExists(chunkPos)) {
            return null;
        }
        ChunkStatus status = regionFile.getStatusIfCached(chunkPos.e, chunkPos.f);
        if (status != null) {
            return status;
        }
        this.j(chunkPos);
        return regionFile.getStatusIfCached(chunkPos.e, chunkPos.f);
    }

    public void updateChunkStatusOnDisk(ChunkCoordIntPair chunkPos, @Nullable NBTTagCompound compound) throws IOException {
        RegionFile regionFile = this.regionFileCache.getRegionFile(chunkPos, false);
        regionFile.setStatus(chunkPos.e, chunkPos.f, ChunkRegionLoader.getStatus(compound));
    }

    public IChunkAccess getUnloadingChunk(int chunkX, int chunkZ) {
        PlayerChunk chunkHolder = ChunkSystem.getUnloadingChunkHolder(this.q, chunkX, chunkZ);
        return chunkHolder == null ? null : chunkHolder.getAvailableChunkNow();
    }

    public boolean c(ChunkCoordIntPair pos) {
        return this.anyPlayerCloseEnoughForSpawning(pos, false);
    }

    boolean anyPlayerCloseEnoughForSpawning(ChunkCoordIntPair chunkcoordintpair, boolean reducedRange) {
        EntityPlayer entityplayer;
        int chunkRange = this.q.spigotConfig.mobSpawnRange;
        chunkRange = chunkRange > this.q.spigotConfig.viewDistance ? (int)this.q.spigotConfig.viewDistance : chunkRange;
        int finalChunkRange = chunkRange = chunkRange > 8 ? 8 : (int)chunkRange;
        double blockRange = 16384.0;
        if (!this.F.f(chunkcoordintpair.a())) {
            return false;
        }
        Iterator<EntityPlayer> iterator = this.J.a().iterator();
        do {
            if (!iterator.hasNext()) {
                return false;
            }
            entityplayer = iterator.next();
            blockRange = 16384.0;
            if (!reducedRange) continue;
            PlayerNaturallySpawnCreaturesEvent event = entityplayer.playerNaturallySpawnedEvent;
            if (event == null || event.isCancelled()) {
                return false;
            }
            blockRange = (event.getSpawnRadius() << 4) * (event.getSpawnRadius() << 4);
        } while (!this.playerIsCloseEnoughForSpawning(entityplayer, chunkcoordintpair, blockRange));
        return true;
    }

    public List<EntityPlayer> d(ChunkCoordIntPair pos) {
        long i2 = pos.a();
        if (!this.F.f(i2)) {
            return List.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (EntityPlayer entityplayer : this.J.a()) {
            if (!this.playerIsCloseEnoughForSpawning(entityplayer, pos, 16384.0)) continue;
            builder.add((Object)entityplayer);
        }
        return builder.build();
    }

    private boolean playerIsCloseEnoughForSpawning(EntityPlayer entityplayer, ChunkCoordIntPair chunkcoordintpair, double range) {
        if (entityplayer.P_()) {
            return false;
        }
        double d0 = PlayerChunkMap.a(chunkcoordintpair, entityplayer);
        return d0 < range;
    }

    private boolean c(EntityPlayer player) {
        return player.P_() && !this.q.Z().b(GameRules.r);
    }

    void a(EntityPlayer player, boolean added) {
        boolean flag1 = this.c(player);
        boolean flag2 = this.J.d(player);
        if (added) {
            this.J.a(player, flag1);
            this.d(player);
            if (!flag1) {
                this.F.a(SectionPosition.a(player), player);
            }
            this.addPlayerToDistanceMaps(player);
        } else {
            SectionPosition sectionposition = player.V();
            this.J.a(player);
            if (!flag2) {
                this.F.b(sectionposition, player);
            }
            this.removePlayerFromDistanceMaps(player);
        }
    }

    private void d(EntityPlayer player) {
        SectionPosition sectionposition = SectionPosition.a(player);
        player.a(sectionposition);
    }

    public void a(EntityPlayer player) {
        boolean flag2;
        SectionPosition sectionposition = player.V();
        SectionPosition sectionposition1 = SectionPosition.a(player);
        boolean flag = this.J.e(player);
        boolean flag1 = this.c(player);
        boolean bl = flag2 = sectionposition.s() != sectionposition1.s();
        if (flag2 || flag != flag1) {
            this.d(player);
            if (!flag) {
                this.F.b(sectionposition, player);
            }
            if (!flag1) {
                this.F.a(sectionposition1, player);
            }
            if (!flag && flag1) {
                this.J.b(player);
            }
            if (flag && !flag1) {
                this.J.c(player);
            }
        }
        this.updateMaps(player);
    }

    private void e(EntityPlayer player) {
        throw new UnsupportedOperationException();
    }

    private void a(EntityPlayer player, ChunkTrackingView chunkFilter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<EntityPlayer> a(ChunkCoordIntPair chunkPos, boolean onlyOnWatchDistanceEdge) {
        PlayerChunk holder = this.b(chunkPos.a());
        if (holder == null) {
            return new ArrayList<EntityPlayer>();
        }
        return holder.getPlayers(onlyOnWatchDistanceEdge);
    }

    public void a(net.minecraft.world.entity.Entity entity) {
        AsyncCatcher.catchOp("entity track");
        if (!entity.valid || entity.dM() != this.q || this.K.containsKey(entity.aj())) {
            i.error("Illegal ChunkMap::addEntity for world " + this.q.getWorld().getName() + ": " + entity + (this.K.containsKey(entity.aj()) ? " ALREADY CONTAINED (This would have crashed your server)" : ""), new Throwable());
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).supressTrackerForLogin) {
            return;
        }
        if (!(entity instanceof EntityComplexPart)) {
            EntityTypes<?> entitytypes = entity.ai();
            int i2 = entitytypes.o() * 16;
            if ((i2 = TrackingRange.getEntityTrackingRange(entity, i2)) != 0) {
                EntityTracker playerchunkmap_entitytracker;
                int j2 = entitytypes.p();
                if (this.K.containsKey(entity.aj())) {
                    throw SystemUtils.b(new IllegalStateException("Entity is already tracked!"));
                }
                entity.tracker = playerchunkmap_entitytracker = new EntityTracker(entity, i2, j2, entitytypes.q());
                this.K.put(entity.aj(), (Object)playerchunkmap_entitytracker);
                playerchunkmap_entitytracker.updatePlayers(entity.getPlayersInTrackRange());
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    this.a(entityplayer, true);
                    for (EntityTracker playerchunkmap_entitytracker1 : this.K.values()) {
                        if (playerchunkmap_entitytracker1.c == entityplayer) continue;
                        playerchunkmap_entitytracker1.b(entityplayer);
                    }
                }
            }
        }
    }

    protected void b(net.minecraft.world.entity.Entity entity) {
        EntityTracker playerchunkmap_entitytracker1;
        AsyncCatcher.catchOp("entity untrack");
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            this.a(entityplayer, false);
            for (EntityTracker playerchunkmap_entitytracker : this.K.values()) {
                playerchunkmap_entitytracker.a(entityplayer);
            }
        }
        if ((playerchunkmap_entitytracker1 = (EntityTracker)this.K.remove(entity.aj())) != null) {
            playerchunkmap_entitytracker1.a();
        }
        entity.tracker = null;
    }

    private final void processTrackQueue() {
        for (EntityTracker tracker : this.K.values()) {
            tracker.updatePlayers(tracker.c.getPlayersInTrackRange());
        }
        for (EntityTracker tracker : this.K.values()) {
            tracker.b.a();
        }
    }

    protected void l() {
        this.processTrackQueue();
    }

    public void a(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.K.get(entity.aj());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.a(packet);
        }
    }

    protected void b(net.minecraft.world.entity.Entity entity, Packet<?> packet) {
        EntityTracker playerchunkmap_entitytracker = (EntityTracker)this.K.get(entity.aj());
        if (playerchunkmap_entitytracker != null) {
            playerchunkmap_entitytracker.b(packet);
        }
    }

    public void a(List<IChunkAccess> chunks) {
        HashMap<EntityPlayer, List> map = new HashMap<EntityPlayer, List>();
        for (IChunkAccess ichunkaccess : chunks) {
            Chunk chunk1;
            ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
            Chunk chunk = ichunkaccess instanceof Chunk ? (chunk1 = (Chunk)ichunkaccess) : this.q.d(chunkcoordintpair.e, chunkcoordintpair.f);
            for (EntityPlayer entityplayer : this.a(chunkcoordintpair, false)) {
                map.computeIfAbsent(entityplayer, entityplayer1 -> new ArrayList()).add(chunk);
            }
        }
        map.forEach((entityplayer1, list1) -> entityplayer1.c.b(ClientboundChunksBiomesPacket.a(list1)));
    }

    public VillagePlace m() {
        return this.x;
    }

    public String n() {
        return this.I;
    }

    void a(ChunkCoordIntPair chunkPos, FullChunkStatus levelType) {
        this.E.onChunkStatusChange(chunkPos, levelType);
    }

    public void a(ChunkCoordIntPair centerPos, int radius) {
    }

    public class ChunkDistanceManager
    extends ChunkMapDistance {
        protected ChunkDistanceManager(Executor workerExecutor, Executor mainThreadExecutor) {
            super(workerExecutor, mainThreadExecutor, PlayerChunkMap.this);
        }

        @Override
        protected boolean a(long pos) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        protected PlayerChunk b(long pos) {
            return PlayerChunkMap.this.a(pos);
        }

        @Override
        @Nullable
        protected PlayerChunk a(long pos, int level, @Nullable PlayerChunk holder, int k2) {
            return PlayerChunkMap.this.a(pos, level, holder, k2);
        }
    }

    public class EntityTracker {
        public final EntityTrackerEntry b;
        final net.minecraft.world.entity.Entity c;
        private final int d;
        SectionPosition e;
        public final Set<ServerPlayerConnection> f = new ReferenceOpenHashSet();
        PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> lastTrackerCandidates;

        public EntityTracker(net.minecraft.world.entity.Entity entity, int i2, int j2, boolean flag) {
            this.b = new EntityTrackerEntry(PlayerChunkMap.this.q, entity, j2, flag, this::a, this.f);
            this.c = entity;
            this.d = i2;
            this.e = SectionPosition.a(entity);
        }

        final void updatePlayers(PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> newTrackerCandidates) {
            PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> oldTrackerCandidates = this.lastTrackerCandidates;
            this.lastTrackerCandidates = newTrackerCandidates;
            if (newTrackerCandidates != null) {
                for (EntityPlayer raw : newTrackerCandidates.getBackingSet()) {
                    if (!(raw instanceof EntityPlayer)) continue;
                    EntityPlayer player = raw;
                    this.b(player);
                }
            }
            if (oldTrackerCandidates == newTrackerCandidates) {
                return;
            }
            for (ServerPlayerConnection conn : this.f.toArray(new ServerPlayerConnection[0])) {
                if (newTrackerCandidates != null && newTrackerCandidates.contains(conn.p())) continue;
                this.b(conn.p());
            }
        }

        public boolean equals(Object object) {
            return object instanceof EntityTracker ? ((EntityTracker)object).c.aj() == this.c.aj() : false;
        }

        public int hashCode() {
            return this.c.aj();
        }

        public void a(Packet<?> packet) {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                serverplayerconnection.b(packet);
            }
        }

        public void b(Packet<?> packet) {
            this.a(packet);
            if (this.c instanceof EntityPlayer) {
                ((EntityPlayer)this.c).c.b(packet);
            }
        }

        public void a() {
            for (ServerPlayerConnection serverplayerconnection : this.f) {
                this.b.a(serverplayerconnection.p());
            }
        }

        public void a(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker clear");
            if (this.f.remove(player.c)) {
                this.b.a(player);
            }
        }

        public void b(EntityPlayer player) {
            AsyncCatcher.catchOp("player tracker update");
            if (player != this.c) {
                double rangeY;
                boolean flag;
                double vec3d_dx = player.dr() - this.c.dr();
                double vec3d_dz = player.dx() - this.c.dx();
                int i2 = PlayerChunkMap.this.b(player);
                double d1 = vec3d_dx * vec3d_dx + vec3d_dz * vec3d_dz;
                double d0 = Math.min(this.b(), i2 * 16);
                double d2 = d0 * d0;
                boolean bl = flag = d1 <= d2 && this.c.a(player) && PlayerChunkMap.this.a(player, this.c.do().e, this.c.do().f);
                if (flag && PlayerChunkMap.this.q.paperConfig().entities.trackingRangeY.enabled && (rangeY = (double)PlayerChunkMap.this.q.paperConfig().entities.trackingRangeY.get(this.c, -1)) != -1.0) {
                    double vec3d_dy = player.dt() - this.c.dt();
                    boolean bl2 = flag = vec3d_dy * vec3d_dy <= rangeY * rangeY;
                }
                if (flag && !player.getBukkitEntity().canSee(this.c.getBukkitEntity())) {
                    flag = false;
                }
                if (flag) {
                    if (this.f.add(player.c) && (PlayerTrackEntityEvent.getHandlerList().getRegisteredListeners().length == 0 || new PlayerTrackEntityEvent((Player)player.getBukkitEntity(), (Entity)this.c.getBukkitEntity()).callEvent())) {
                        this.b.b(player);
                    }
                } else if (this.f.remove(player.c)) {
                    this.b.a(player);
                }
            }
        }

        private int a(int initialDistance) {
            return PlayerChunkMap.this.q.o().b(initialDistance);
        }

        private static int getHighestRange(net.minecraft.world.entity.Entity parent, int highest) {
            List<net.minecraft.world.entity.Entity> passengers = parent.cP();
            int size = passengers.size();
            for (int i2 = 0; i2 < size; ++i2) {
                net.minecraft.world.entity.Entity entity = passengers.get(i2);
                int range = entity.ai().o() * 16;
                if ((range = TrackingRange.getEntityTrackingRange(entity, range)) > highest) {
                    highest = range;
                }
                highest = EntityTracker.getHighestRange(entity, highest);
            }
            return highest;
        }

        private int b() {
            int i2 = this.d;
            i2 = EntityTracker.getHighestRange(this.c, i2);
            return this.a(i2);
        }

        public void a(List<EntityPlayer> players) {
            for (EntityPlayer entityplayer : players) {
                this.b(entityplayer);
            }
        }
    }

    public static final class DataRegionSectionData
    implements SingleThreadChunkRegionManager.RegionSectionData {
        @Override
        public void removeFromRegion(SingleThreadChunkRegionManager.RegionSection section, SingleThreadChunkRegionManager.Region from) {
            DataRegionSectionData sectionData = (DataRegionSectionData)section.sectionData;
            DataRegionData fromData = (DataRegionData)from.regionData;
        }

        @Override
        public void addToRegion(SingleThreadChunkRegionManager.RegionSection section, SingleThreadChunkRegionManager.Region oldRegion, SingleThreadChunkRegionManager.Region newRegion) {
            DataRegionSectionData sectionData = (DataRegionSectionData)section.sectionData;
            DataRegionData oldRegionData = oldRegion == null ? null : (DataRegionData)oldRegion.regionData;
            DataRegionData newRegionData = (DataRegionData)newRegion.regionData;
        }
    }

    public static final class DataRegionData
    implements SingleThreadChunkRegionManager.RegionData {
    }
}

