/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemBisected;
import net.minecraft.world.item.ItemDebugStick;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCake;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.GameMode;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.slf4j.Logger;

public class PlayerInteractManager {
    private static final Logger a = LogUtils.getLogger();
    public WorldServer c;
    protected final EntityPlayer d;
    private EnumGamemode b = EnumGamemode.e;
    @Nullable
    private EnumGamemode e;
    private boolean f;
    private int g;
    private BlockPosition h = BlockPosition.b;
    private int i;
    private boolean j;
    private BlockPosition k = BlockPosition.b;
    private int l;
    private int m = -1;
    public boolean captureSentBlockEntities = false;
    public boolean capturedBlockEntity = false;
    public boolean interactResult = false;
    public boolean firedInteract = false;
    public BlockPosition interactPosition;
    public EnumHand interactHand;
    public ItemStack interactItemStack;

    public PlayerInteractManager(EntityPlayer player) {
        this.d = player;
        this.c = player.z();
    }

    public boolean a(EnumGamemode gameMode) {
        PlayerGameModeChangeEvent event = this.changeGameModeForPlayer(gameMode, PlayerGameModeChangeEvent.Cause.UNKNOWN, null);
        return event != null && event.isCancelled();
    }

    @Nullable
    public PlayerGameModeChangeEvent changeGameModeForPlayer(EnumGamemode gameMode, PlayerGameModeChangeEvent.Cause cause, @Nullable Component cancelMessage) {
        if (gameMode == this.b) {
            return null;
        }
        PlayerGameModeChangeEvent event = new PlayerGameModeChangeEvent((Player)this.d.getBukkitEntity(), GameMode.getByValue((int)gameMode.a()), cause, cancelMessage);
        this.c.getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.a(gameMode, this.b);
        this.d.y();
        this.d.d.ae().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.c, this.d), this.d);
        this.c.e();
        return event;
    }

    protected void a(EnumGamemode gameMode, @Nullable EnumGamemode previousGameMode) {
        this.e = previousGameMode;
        this.b = gameMode;
        gameMode.a(this.d.fT());
    }

    public EnumGamemode b() {
        return this.b;
    }

    @Nullable
    public EnumGamemode c() {
        return this.e;
    }

    public boolean d() {
        return this.b.h();
    }

    public boolean e() {
        return this.b.g();
    }

    public void a() {
        this.i = (int)this.c.getLagCompensationTick();
        if (this.j) {
            IBlockData iblockdata = this.c.getBlockStateIfLoaded(this.k);
            if (iblockdata == null || iblockdata.i()) {
                this.j = false;
            } else {
                float f2 = this.a(iblockdata, this.k, this.l);
                if (f2 >= 1.0f) {
                    this.j = false;
                    this.a(this.k);
                }
            }
        } else if (this.f) {
            IBlockData iblockdata = this.c.getBlockStateIfLoaded(this.h);
            if (iblockdata == null) {
                this.f = false;
                return;
            }
            if (iblockdata.i()) {
                this.c.a(this.d.aj(), this.h, -1);
                this.m = -1;
                this.f = false;
            } else {
                this.a(iblockdata, this.h, this.g);
            }
        }
    }

    private float a(IBlockData state, BlockPosition pos, int failedStartMiningTime) {
        int j2 = this.i - failedStartMiningTime;
        float f2 = state.a(this.d, this.d.dM(), pos) * (float)(j2 + 1);
        int k2 = (int)(f2 * 10.0f);
        if (k2 != this.m) {
            this.c.a(this.d.aj(), pos, k2);
            this.m = k2;
        }
        return f2;
    }

    private void a(BlockPosition pos, boolean success, int sequence, String reason) {
    }

    public void a(BlockPosition pos, PacketPlayInBlockDig.EnumPlayerDigType action, EnumDirection direction, int worldHeight, int sequence) {
        if (this.d.br().g(Vec3D.b(pos)) > PlayerConnection.d) {
            return;
        }
        if (pos.v() >= worldHeight) {
            this.d.c.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
            this.a(pos, false, sequence, "too high");
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.a) {
            if (!this.c.a((EntityHuman)this.d, pos)) {
                CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, pos, direction, this.d.fS().f(), EnumHand.a);
                this.d.c.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
                this.a(pos, false, sequence, "may not interact");
                this.capturedBlockEntity = true;
                return;
            }
            PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.d, Action.LEFT_CLICK_BLOCK, pos, direction, this.d.fS().f(), EnumHand.a);
            if (event.isCancelled()) {
                this.capturedBlockEntity = true;
                return;
            }
            if (this.e()) {
                this.a(pos, sequence, "creative destroy");
                return;
            }
            if (this.d.eT().a(Items.vq) && ((ItemDebugStick)Items.vq).a(this.d, this.c.a_(pos), this.c, pos, false, this.d.eT())) {
                return;
            }
            if (this.d.a(this.c, pos, this.b)) {
                this.d.c.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
                this.a(pos, false, sequence, "block action restricted");
                return;
            }
            this.g = this.i;
            float f2 = 1.0f;
            IBlockData iblockdata = this.c.a_(pos);
            if (event.useInteractedBlock() != Event.Result.DENY && !iblockdata.i()) {
                iblockdata.a((World)this.c, pos, this.d);
                f2 = iblockdata.a(this.d, this.d.dM(), pos);
            }
            if (event.useItemInHand() == Event.Result.DENY) {
                if (f2 > 1.0f) {
                    // empty if block
                }
                return;
            }
            BlockDamageEvent blockEvent = CraftEventFactory.callBlockDamageEvent(this.d, pos, direction, this.d.fS().f(), f2 >= 1.0f);
            if (blockEvent.isCancelled()) {
                return;
            }
            if (blockEvent.getInstaBreak()) {
                f2 = 2.0f;
            }
            if (!iblockdata.i() && f2 >= 1.0f) {
                this.a(pos, sequence, "insta mine");
            } else {
                if (this.f) {
                    this.d.c.b(new PacketPlayOutBlockChange(this.h, this.c.a_(this.h)));
                    this.a(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.f = true;
                this.h = pos.i();
                int k2 = (int)(f2 * 10.0f);
                this.c.a(this.d.aj(), pos, k2);
                this.a(pos, true, sequence, "actual start of destroying");
                this.m = k2;
            }
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.c) {
            if (pos.equals(this.h)) {
                int l2 = this.i - this.g;
                IBlockData iblockdata = this.c.a_(pos);
                if (!iblockdata.i()) {
                    float f1 = iblockdata.a(this.d, this.d.dM(), pos) * (float)(l2 + 1);
                    if (f1 >= 0.7f) {
                        this.f = false;
                        this.c.a(this.d.aj(), pos, -1);
                        this.a(pos, sequence, "destroyed");
                        return;
                    }
                    if (!this.j) {
                        this.f = false;
                        this.j = true;
                        this.k = pos;
                        this.l = this.g;
                    }
                }
            }
            this.a(pos, true, sequence, "stopped destroying");
        } else if (action == PacketPlayInBlockDig.EnumPlayerDigType.b) {
            this.f = false;
            if (!Objects.equals(this.h, pos) && !BlockPosition.b.equals(this.h)) {
                a.debug("Mismatch in destroy block pos: {} {}", (Object)this.h, (Object)pos);
                IBlockData type = this.c.getBlockStateIfLoaded(this.h);
                if (type != null) {
                    this.c.a(this.d.aj(), this.h, -1);
                }
                if (type != null) {
                    this.a(pos, true, sequence, "aborted mismatched destroying");
                }
                this.h = BlockPosition.b;
            }
            this.c.a(this.d.aj(), pos, -1);
            this.a(pos, true, sequence, "aborted destroying");
            CraftEventFactory.callBlockDamageAbortEvent(this.d, pos, this.d.fS().f());
        }
        this.c.chunkPacketBlockController.onPlayerLeftClickBlock(this, pos, action, direction, worldHeight, sequence);
    }

    public void a(BlockPosition pos, int sequence, String reason) {
        if (this.a(pos)) {
            this.a(pos, true, sequence, reason);
        } else {
            this.d.c.b(new PacketPlayOutBlockChange(pos, this.c.a_(pos)));
            this.a(pos, false, sequence, reason);
        }
    }

    public boolean a(BlockPosition pos) {
        IBlockData iblockdata = this.c.a_(pos);
        CraftBlock bblock = CraftBlock.at(this.c, pos);
        BlockBreakEvent event = null;
        if (this.d instanceof EntityPlayer) {
            boolean isSwordNoBreak = !this.d.eT().d().a(iblockdata, (World)this.c, pos, (EntityHuman)this.d);
            event = new BlockBreakEvent((org.bukkit.block.Block)bblock, (Player)this.d.getBukkitEntity());
            event.setCancelled(isSwordNoBreak);
            IBlockData nmsData = this.c.a_(pos);
            Block nmsBlock = nmsData.b();
            ItemStack itemstack = this.d.c(EnumItemSlot.a);
            if (nmsBlock != null && !event.isCancelled() && !this.e() && this.d.e(nmsBlock.o())) {
                event.setExpToDrop(nmsBlock.getExpDrop(nmsData, this.c, pos, itemstack, true));
            }
            this.c.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                if (isSwordNoBreak) {
                    return false;
                }
                if (!this.captureSentBlockEntities) {
                    TileEntity tileentity = this.c.c_(pos);
                    if (tileentity != null) {
                        this.d.c.b(tileentity.j());
                    }
                } else {
                    this.capturedBlockEntity = true;
                }
                return false;
            }
            if (this.d.dM().purpurConfig.slabHalfBreak && this.d.bS() && iblockdata.b() instanceof BlockStepAbstract && ((BlockStepAbstract)iblockdata.b()).halfBreak(iblockdata, pos, this.d)) {
                return true;
            }
        }
        if ((iblockdata = this.c.a_(pos)).i()) {
            return false;
        }
        TileEntity tileentity = this.c.c_(pos);
        Block block = iblockdata.b();
        if (!(!(block instanceof GameMasterBlock) || this.d.gp() || block instanceof BlockCommand && this.d.f() && this.d.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.c.a(pos, iblockdata, iblockdata, 3);
            return false;
        }
        if (this.d.a(this.c, pos, this.b)) {
            return false;
        }
        BlockState state = bblock.getState();
        this.c.captureDrops = new ArrayList<EntityItem>();
        IBlockData iblockdata1 = block.a((World)this.c, pos, iblockdata, (EntityHuman)this.d);
        boolean flag = this.c.a(pos, false);
        if (flag) {
            block.a((GeneratorAccess)this.c, pos, iblockdata1);
        }
        ItemStack mainHandStack = null;
        boolean isCorrectTool = false;
        if (!this.e()) {
            ItemStack itemstack = this.d.eT();
            ItemStack itemstack1 = itemstack.p();
            boolean flag1 = this.d.e(iblockdata1);
            mainHandStack = itemstack1;
            isCorrectTool = flag1;
            itemstack.a((World)this.c, iblockdata1, pos, this.d);
            if (flag && flag1) {
                block.playerDestroy(this.c, this.d, pos, iblockdata1, tileentity, itemstack1, event.isDropItems(), false);
            }
        }
        List<EntityItem> itemsToDrop = this.c.captureDrops;
        this.c.captureDrops = null;
        if (event.isDropItems()) {
            CraftEventFactory.handleBlockDropItemEvent(bblock, state, this.d, itemsToDrop);
        }
        if (flag && event != null) {
            iblockdata.b().popExperience(this.c, pos, event.getExpToDrop(), this.d);
        }
        if (mainHandStack != null && flag && isCorrectTool && event.isDropItems() && block instanceof BlockBeehive && tileentity instanceof TileEntityBeehive) {
            TileEntityBeehive beehiveBlockEntity = (TileEntityBeehive)tileentity;
            CriterionTriggers.L.a(this.d, iblockdata, mainHandStack, beehiveBlockEntity.g());
        }
        return true;
    }

    public EnumInteractionResult a(EntityPlayer player, World world, ItemStack stack, EnumHand hand) {
        if (this.b == EnumGamemode.d) {
            return EnumInteractionResult.d;
        }
        if (player.gn().a(stack.d())) {
            return EnumInteractionResult.d;
        }
        int i2 = stack.L();
        int j2 = stack.k();
        InteractionResultWrapper<ItemStack> interactionresultwrapper = stack.a(world, (EntityHuman)player, hand);
        ItemStack itemstack1 = interactionresultwrapper.b();
        if (itemstack1 == stack && itemstack1.L() == i2 && itemstack1.r() <= 0 && itemstack1.k() == j2) {
            return interactionresultwrapper.a();
        }
        if (interactionresultwrapper.a() == EnumInteractionResult.e && itemstack1.r() > 0 && !player.fn()) {
            return interactionresultwrapper.a();
        }
        if (stack != itemstack1) {
            player.a(hand, itemstack1);
        }
        if (this.e() && itemstack1 != ItemStack.f) {
            itemstack1.f(i2);
            if (itemstack1.i() && itemstack1.k() != j2) {
                itemstack1.b(j2);
            }
        }
        if (itemstack1.b()) {
            player.a(hand, ItemStack.f);
        }
        if (!player.fn()) {
            player.bR.b();
        }
        return interactionresultwrapper.a();
    }

    public EnumInteractionResult a(EntityPlayer player, World world, ItemStack stack, EnumHand hand, MovingObjectPositionBlock hitResult) {
        if (this.shiftClickMended(stack)) {
            return EnumInteractionResult.a;
        }
        BlockPosition blockposition = hitResult.a();
        IBlockData iblockdata = world.a_(blockposition);
        EnumInteractionResult enuminteractionresult = EnumInteractionResult.d;
        boolean cancelledBlock = false;
        boolean cancelledItem = false;
        if (!iblockdata.b().a(world.I())) {
            return EnumInteractionResult.e;
        }
        if (this.b == EnumGamemode.d) {
            ITileInventory itileinventory = iblockdata.b(world, blockposition);
            boolean bl = cancelledBlock = !(itileinventory instanceof ITileInventory);
        }
        if (player.gn().a(stack.d())) {
            cancelledItem = true;
        }
        PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(player, Action.RIGHT_CLICK_BLOCK, blockposition, hitResult.b(), stack, cancelledBlock, cancelledItem, hand, hitResult.e());
        this.firedInteract = true;
        this.interactResult = event.useItemInHand() == Event.Result.DENY;
        this.interactPosition = blockposition.i();
        this.interactHand = hand;
        this.interactItemStack = stack.p();
        if (event.useInteractedBlock() == Event.Result.DENY) {
            if (!(iblockdata.b() instanceof BlockDoor)) {
                if (iblockdata.b() instanceof BlockCake) {
                    player.getBukkitEntity().sendHealthUpdate();
                } else if (!(this.interactItemStack.d() instanceof ItemBisected) && (iblockdata.a(Blocks.pa) || iblockdata.b() instanceof BlockCommand)) {
                    player.c.b(new PacketPlayOutCloseWindow(this.d.bS.j));
                }
            }
            player.getBukkitEntity().updateInventory();
            this.d.resyncUsingItem(this.d);
            enuminteractionresult = event.useItemInHand() != Event.Result.ALLOW ? EnumInteractionResult.a : EnumInteractionResult.d;
        } else {
            if (this.b == EnumGamemode.d) {
                ITileInventory itileinventory = iblockdata.b(world, blockposition);
                if (itileinventory != null) {
                    player.a(itileinventory);
                    return EnumInteractionResult.a;
                }
                return EnumInteractionResult.d;
            }
            boolean flag = !player.eT().b() || !player.eU().b();
            boolean flag1 = player.fI() && flag;
            ItemStack itemstack1 = stack.p();
            if ((!flag1 || player.dM().purpurConfig.composterBulkProcess && iblockdata.a(Blocks.pc)) && (enuminteractionresult = iblockdata.a(world, player, hand, hitResult)).a()) {
                CriterionTriggers.N.a(player, blockposition, itemstack1);
                return enuminteractionresult;
            }
            if (!stack.b() && enuminteractionresult != EnumInteractionResult.a && !this.interactResult) {
                EnumInteractionResult enuminteractionresult1;
                ItemActionContext itemactioncontext = new ItemActionContext(player, hand, hitResult);
                if (this.e()) {
                    int i2 = stack.L();
                    enuminteractionresult1 = stack.a(itemactioncontext);
                    stack.f(i2);
                } else {
                    enuminteractionresult1 = stack.a(itemactioncontext);
                }
                if (enuminteractionresult1.a()) {
                    CriterionTriggers.N.a(player, blockposition, itemstack1);
                }
                return enuminteractionresult1;
            }
            if (this.interactResult && this.interactResult != cancelledItem) {
                this.d.resyncUsingItem(this.d);
            }
        }
        return enuminteractionresult;
    }

    public void a(WorldServer world) {
        this.c = world;
    }

    public boolean shiftClickMended(ItemStack itemstack) {
        int points;
        if (this.d.dM().purpurConfig.shiftRightClickRepairsMendingPoints > 0 && this.d.bS() && this.d.getBukkitEntity().hasPermission("purpur.mending_shift_click") && (points = Math.min(this.d.cg, this.d.dM().purpurConfig.shiftRightClickRepairsMendingPoints)) > 0 && itemstack.j() && EnchantmentManager.a(Enchantments.L, itemstack) > 0) {
            this.d.d(-points);
            this.d.dM().b(new EntityExperienceOrb(this.d.dM(), this.d.dr(), this.d.dt(), this.d.dx(), points, ExperienceOrb.SpawnReason.UNKNOWN, this.d, this.d));
            return true;
        }
        return false;
    }
}

