/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.event.player.PlayerHandshakeEvent;
import com.destroystokyo.paper.network.PaperNetworkClient;
import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import com.mojang.util.UndashedUuid;
import io.netty.channel.unix.DomainSocketAddress;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.SharedConstants;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.LoginListener;
import net.minecraft.server.network.PacketStatusListener;
import org.apache.logging.log4j.LogManager;
import org.spigotmc.SpigotConfig;

public class HandshakeListener
implements PacketHandshakingInListener {
    private static final Gson gson = new Gson();
    static final Pattern HOST_PATTERN = Pattern.compile("[0-9a-f\\.:]{0,45}");
    static final Pattern PROP_PATTERN = Pattern.compile("\\w{0,16}");
    private static final HashMap<InetAddress, Long> throttleTracker = new HashMap();
    private static int throttleCounter = 0;
    private static final IChatBaseComponent a = IChatBaseComponent.c("disconnect.ignoring_status_request");
    private final MinecraftServer b;
    private final NetworkManager c;
    private static final boolean BYPASS_HOSTCHECK = Boolean.getBoolean("Paper.bypassHostCheck");

    public HandshakeListener(MinecraftServer server, NetworkManager connection) {
        this.b = server;
        this.c = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void a(PacketHandshakingInSetProtocol packet) {
        this.c.hostname = packet.d() + ":" + packet.e();
        switch (packet.f()) {
            case b: {
                IChatMutableComponent chatmessage;
                this.c.a(ClientIntent.b);
                try {
                    if (!(this.c.n.localAddress() instanceof DomainSocketAddress)) {
                        long currentTime = System.currentTimeMillis();
                        long connectionThrottle = this.b.server.getConnectionThrottle();
                        InetAddress address = ((InetSocketAddress)this.c.f()).getAddress();
                        HashMap<InetAddress, Long> hashMap = throttleTracker;
                        synchronized (hashMap) {
                            if (throttleTracker.containsKey(address) && !"127.0.0.1".equals(address.getHostAddress()) && currentTime - throttleTracker.get(address) < connectionThrottle) {
                                throttleTracker.put(address, currentTime);
                                IChatBaseComponent chatmessage2 = PaperAdventure.asVanilla(GlobalConfiguration.get().messages.kick.connectionThrottle);
                                this.c.a(new PacketLoginOutDisconnect(chatmessage2));
                                this.c.a(chatmessage2);
                                return;
                            }
                            throttleTracker.put(address, currentTime);
                            if (++throttleCounter > 200) {
                                throttleCounter = 0;
                                Iterator<Map.Entry<InetAddress, Long>> iter = throttleTracker.entrySet().iterator();
                                while (iter.hasNext()) {
                                    Map.Entry<InetAddress, Long> entry = iter.next();
                                    if (entry.getValue() <= connectionThrottle) continue;
                                    iter.remove();
                                }
                            }
                        }
                    }
                }
                catch (Throwable t2) {
                    LogManager.getLogger().debug("Failed to check connection throttle", t2);
                }
                if (packet.a() != SharedConstants.b().e()) {
                    TextComponent adventureComponent = packet.a() < SharedConstants.b().e() ? LegacyComponentSerializer.legacySection().deserialize(MessageFormat.format(SpigotConfig.outdatedClientMessage.replaceAll("'", "''"), SharedConstants.b().c())) : LegacyComponentSerializer.legacySection().deserialize(MessageFormat.format(SpigotConfig.outdatedServerMessage.replaceAll("'", "''"), SharedConstants.b().c()));
                    IChatBaseComponent ichatmutablecomponent = PaperAdventure.asVanilla((Component)adventureComponent);
                    this.c.a(new PacketLoginOutDisconnect(ichatmutablecomponent));
                    this.c.a(ichatmutablecomponent);
                    break;
                }
                this.c.a(new LoginListener(this.b, this.c));
                boolean proxyLogicEnabled = SpigotConfig.bungee;
                boolean handledByEvent = false;
                if (PlayerHandshakeEvent.getHandlerList().getRegisteredListeners().length != 0) {
                    SocketAddress socketAddress = this.c.o;
                    String hostnameOfRemote = socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getHostString() : InetAddress.getLoopbackAddress().getHostAddress();
                    PlayerHandshakeEvent event = new PlayerHandshakeEvent(packet.d(), hostnameOfRemote, !proxyLogicEnabled);
                    if (event.callEvent()) {
                        if (event.isFailed()) {
                            IChatBaseComponent component = PaperAdventure.asVanilla(event.failMessage());
                            this.c.a(new PacketLoginOutDisconnect(component));
                            this.c.a(component);
                            return;
                        }
                        if (event.getServerHostname() != null) {
                            packet = new PacketHandshakingInSetProtocol(packet.a(), event.getServerHostname(), packet.e(), packet.f());
                        }
                        if (event.getSocketAddressHostname() != null) {
                            this.c.o = new InetSocketAddress(event.getSocketAddressHostname(), socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getPort() : 0);
                        }
                        this.c.spoofedUUID = event.getUniqueId();
                        this.c.spoofedProfile = (Property[])gson.fromJson(event.getPropertiesJson(), Property[].class);
                        handledByEvent = true;
                    }
                }
                String[] split = packet.d().split("\u0000");
                if (!handledByEvent && proxyLogicEnabled) {
                    if ((split.length == 3 || split.length == 4) && (BYPASS_HOSTCHECK || HOST_PATTERN.matcher(split[1]).matches())) {
                        SocketAddress socketAddress = this.c.f();
                        this.c.hostname = split[0];
                        this.c.o = new InetSocketAddress(split[1], socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getPort() : 0);
                        this.c.spoofedUUID = UndashedUuid.fromStringLenient((String)split[2]);
                        if (split.length != 4) break;
                    } else {
                        chatmessage = IChatBaseComponent.b("If you wish to use IP forwarding, please enable it in your BungeeCord config as well!");
                        this.c.a(new PacketLoginOutDisconnect(chatmessage));
                        this.c.a(chatmessage);
                        return;
                    }
                    this.c.spoofedProfile = (Property[])gson.fromJson(split[3], Property[].class);
                    break;
                }
                if (split.length != 3 && split.length != 4 || !HOST_PATTERN.matcher(split[1]).matches()) break;
                chatmessage = IChatBaseComponent.b("Unknown data in login hostname, did you forget to enable BungeeCord in spigot.yml?");
                this.c.a(new PacketLoginOutDisconnect(chatmessage));
                this.c.a(chatmessage);
                return;
            }
            case a: {
                ServerPing serverping = this.b.as();
                if (this.b.ak() && serverping != null) {
                    this.c.a(ClientIntent.a);
                    this.c.a(new PacketStatusListener(serverping, this.c));
                    break;
                }
                this.c.a(a);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + packet.f());
            }
        }
        this.c.protocolVersion = packet.a();
        this.c.virtualHost = PaperNetworkClient.prepareVirtualHost(packet.d(), packet.e());
    }

    @Override
    public void a(IChatBaseComponent reason) {
    }

    @Override
    public boolean c() {
        return this.c.k();
    }
}

