/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.proxy.VelocityProxy;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutCustomPayload;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.HandshakeListener;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_20_R3.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class LoginListener
implements PacketLoginInListener,
TickablePacketListener {
    private static final AtomicInteger a = new AtomicInteger(0);
    static final Logger b = LogUtils.getLogger();
    private static final ExecutorService authenticatorPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("User Authenticator #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(b)).build());
    private static final int c = 600;
    private static final IChatBaseComponent d = IChatBaseComponent.c("multiplayer.disconnect.unexpected_query_response");
    private final byte[] e;
    final MinecraftServer f;
    public final NetworkManager g;
    public volatile EnumProtocolState h = EnumProtocolState.a;
    private int i;
    @Nullable
    String j;
    @Nullable
    public GameProfile k;
    private final String l;
    private EntityPlayer player;
    public boolean iKnowThisMayNotBeTheBestIdeaButPleaseDisableUsernameValidation = false;
    private int velocityLoginMessageId = -1;

    public LoginListener(MinecraftServer server, NetworkManager connection) {
        this.l = "";
        this.f = server;
        this.g = connection;
        this.e = Ints.toByteArray((int)RandomSource.a().f());
    }

    @Override
    public void e() {
        if (!MinecraftServer.getServer().v()) {
            this.b(CraftChatMessage.fromString(SpigotConfig.restartMessage)[0]);
            return;
        }
        if (this.h == EnumProtocolState.e && this.g.k()) {
            this.c(Objects.requireNonNull(this.k));
        }
        if (this.h == EnumProtocolState.f && !this.a(Objects.requireNonNull(this.k))) {
            this.d(this.k);
        }
        if (this.i++ == 600) {
            this.b(IChatBaseComponent.c("multiplayer.disconnect.slow_login"));
        }
    }

    @Deprecated
    public void disconnect(String s2) {
        this.b(PaperAdventure.asVanilla((Component)LegacyComponentSerializer.legacySection().deserialize(s2)));
    }

    @Override
    public boolean c() {
        return this.g.k();
    }

    public void b(IChatBaseComponent reason) {
        try {
            b.info("Disconnecting {}: {}", (Object)this.f(), (Object)reason.getString());
            this.g.a(new PacketLoginOutDisconnect(reason));
            this.g.a(reason);
        }
        catch (Exception exception) {
            b.error("Error whilst disconnecting player", (Throwable)exception);
        }
    }

    private boolean a(GameProfile profile) {
        return this.f.ae().a(profile.getId()) != null;
    }

    @Override
    public void a(IChatBaseComponent reason) {
        b.info("{} lost connection: {}", (Object)this.f(), (Object)reason.getString());
    }

    public String f() {
        String s2 = this.g.a(this.f.bj());
        return this.j != null ? this.j + " (" + s2 + ")" : s2;
    }

    @Override
    public void a(PacketLoginInStart packet) {
        Validate.validState((this.h == EnumProtocolState.a ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        if (GlobalConfiguration.get().proxies.isProxyOnlineMode() && GlobalConfiguration.get().unsupportedSettings.performUsernameValidation && !this.iKnowThisMayNotBeTheBestIdeaButPleaseDisableUsernameValidation) {
            Validate.validState((boolean)EntityHuman.c(packet.a()), (String)"Invalid characters in username", (Object[])new Object[0]);
        }
        this.j = packet.a();
        GameProfile gameprofile = this.f.P();
        if (gameprofile != null && this.j.equalsIgnoreCase(gameprofile.getName())) {
            this.b(gameprofile);
        } else if (this.f.W() && !this.g.g()) {
            this.h = EnumProtocolState.b;
            this.g.a(new PacketLoginOutEncryptionBegin("", this.f.N().getPublic().getEncoded(), this.e));
        } else {
            if (GlobalConfiguration.get().proxies.velocity.enabled) {
                this.velocityLoginMessageId = ThreadLocalRandom.current().nextInt();
                PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
                buf.k(4);
                PacketLoginOutCustomPayload packet1 = new PacketLoginOutCustomPayload(this.velocityLoginMessageId, new PacketLoginOutCustomPayload.PlayerInfoChannelPayload(VelocityProxy.PLAYER_INFO_CHANNEL, buf));
                this.g.a(packet1);
                return;
            }
            authenticatorPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        GameProfile gameprofile = LoginListener.this.createOfflineProfile(LoginListener.this.j);
                        gameprofile = LoginListener.this.callPlayerPreLoginEvents(gameprofile);
                        b.info("UUID of player {} is {}", (Object)gameprofile.getName(), (Object)gameprofile.getId());
                        LoginListener.this.b(gameprofile);
                    }
                    catch (Exception ex) {
                        LoginListener.this.disconnect("Failed to verify username!");
                        LoginListener.this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + LoginListener.this.j, ex);
                    }
                }
            });
        }
    }

    void b(GameProfile profile) {
        this.k = profile;
        this.h = EnumProtocolState.e;
    }

    private void c(GameProfile profile) {
        PlayerList playerlist = this.f.ae();
        this.player = playerlist.canPlayerLogin(this, profile);
        if (this.player != null) {
            boolean flag;
            if (this.f.ax() >= 0 && !this.g.g()) {
                this.g.a(new PacketLoginOutSetCompression(this.f.ax()), PacketSendListener.a(() -> this.g.a(this.f.ax(), true)));
            }
            if (flag = playerlist.disconnectAllPlayersWithProfile(profile, this.player)) {
                this.h = EnumProtocolState.f;
            } else {
                this.d(profile);
            }
        }
    }

    private void d(GameProfile profile) {
        this.h = EnumProtocolState.g;
        this.g.a(new PacketLoginOutSuccess(profile));
    }

    @Override
    public void a(PacketLoginInEncryptionBegin packet) {
        String s2;
        Validate.validState((this.h == EnumProtocolState.b ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey privatekey = this.f.N().getPrivate();
            if (!packet.a(this.e, privatekey)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretkey = packet.a(privatekey);
            s2 = new BigInteger(MinecraftEncryption.a("", this.f.N().getPublic(), secretkey)).toString(16);
            this.h = EnumProtocolState.c;
            this.g.setupEncryption(secretkey);
        }
        catch (CryptographyException cryptographyexception) {
            throw new IllegalStateException("Protocol error", cryptographyexception);
        }
        authenticatorPool.execute(new Runnable(){

            @Override
            public void run() {
                String s1 = Objects.requireNonNull(LoginListener.this.j, "Player name not initialized");
                try {
                    ProfileResult profileresult = LoginListener.this.f.ao().hasJoinedServer(s1, s2, this.getAddress());
                    if (profileresult != null) {
                        GameProfile gameprofile = profileresult.profile();
                        if (!LoginListener.this.g.k()) {
                            return;
                        }
                        gameprofile = LoginListener.this.callPlayerPreLoginEvents(gameprofile);
                        b.info("UUID of player {} is {}", (Object)gameprofile.getName(), (Object)gameprofile.getId());
                        LoginListener.this.b(gameprofile);
                    } else if (LoginListener.this.f.Q()) {
                        b.warn("Failed to verify username but will let them in anyway!");
                        LoginListener.this.b(LoginListener.this.createOfflineProfile(s1));
                    } else {
                        LoginListener.this.b(PurpurConfig.unverifiedUsername.equals("default") ? IChatBaseComponent.c("multiplayer.disconnect.unverified_username") : PaperAdventure.asVanilla(MiniMessage.miniMessage().deserialize((Object)PurpurConfig.unverifiedUsername)));
                        b.error("Username '{}' tried to join with an invalid session", (Object)s1);
                    }
                }
                catch (AuthenticationUnavailableException authenticationunavailableexception) {
                    if (LoginListener.this.f.Q()) {
                        b.warn("Authentication servers are down but will let them in anyway!");
                        LoginListener.this.b(LoginListener.this.createOfflineProfile(s1));
                    } else {
                        LoginListener.this.b(PaperAdventure.asVanilla(GlobalConfiguration.get().messages.kick.authenticationServersDown));
                        b.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception exception) {
                    LoginListener.this.disconnect("Failed to verify username!");
                    LoginListener.this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + s1, exception);
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress socketaddress = LoginListener.this.g.f();
                return LoginListener.this.f.X() && socketaddress instanceof InetSocketAddress ? ((InetSocketAddress)socketaddress).getAddress() : null;
            }
        });
    }

    private GameProfile callPlayerPreLoginEvents(GameProfile gameprofile) throws Exception {
        if (this.velocityLoginMessageId == -1 && GlobalConfiguration.get().proxies.velocity.enabled) {
            this.disconnect("This server requires you to connect with Velocity.");
            return gameprofile;
        }
        String playerName = gameprofile.getName();
        InetAddress address = ((InetSocketAddress)this.g.f()).getAddress();
        UUID uniqueId = gameprofile.getId();
        final CraftServer server = this.f.server;
        InetAddress rawAddress = ((InetSocketAddress)this.g.n.remoteAddress()).getAddress();
        PlayerProfile profile = CraftPlayerProfile.asBukkitMirror(gameprofile);
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, rawAddress, uniqueId, profile, this.g.hostname);
        server.getPluginManager().callEvent((Event)asyncEvent);
        profile = asyncEvent.getPlayerProfile();
        profile.complete(true);
        gameprofile = CraftPlayerProfile.asAuthlibCopy(profile);
        playerName = gameprofile.getName();
        uniqueId = gameprofile.getId();
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.kickMessage());
            }
            Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(){

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    server.getPluginManager().callEvent((Event)event);
                    return event.getResult();
                }
            };
            this.f.processQueue.add(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.b(PaperAdventure.asVanilla(event.kickMessage()));
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.b(PaperAdventure.asVanilla(asyncEvent.kickMessage()));
        }
        return gameprofile;
    }

    @Override
    public void a(ServerboundCustomQueryAnswerPacket packet) {
        if (GlobalConfiguration.get().proxies.velocity.enabled && packet.a() == this.velocityLoginMessageId) {
            ServerboundCustomQueryAnswerPacket.QueryAnswerPayload payload = (ServerboundCustomQueryAnswerPacket.QueryAnswerPayload)packet.d();
            if (payload == null) {
                this.disconnect("This server requires you to connect with Velocity.");
                return;
            }
            PacketDataSerializer buf = payload.buffer;
            if (!VelocityProxy.checkIntegrity(buf)) {
                this.disconnect("Unable to verify player details");
                return;
            }
            int version = buf.n();
            if (version > 4) {
                throw new IllegalStateException("Unsupported forwarding version " + version + ", wanted upto 4");
            }
            SocketAddress listening = this.g.f();
            int port = 0;
            if (listening instanceof InetSocketAddress) {
                port = ((InetSocketAddress)listening).getPort();
            }
            this.g.o = new InetSocketAddress(VelocityProxy.readAddress(buf), port);
            this.k = VelocityProxy.createProfile(buf);
            authenticatorPool.execute(() -> {
                try {
                    GameProfile gameprofile = this.callPlayerPreLoginEvents(this.k);
                    b.info("UUID of player {} is {}", (Object)gameprofile.getName(), (Object)gameprofile.getId());
                    this.b(gameprofile);
                }
                catch (Exception ex) {
                    this.disconnect("Failed to verify username!");
                    this.f.server.getLogger().log(Level.WARNING, "Exception verifying " + this.k.getName(), ex);
                }
            });
            return;
        }
        this.b(d);
    }

    @Override
    public void a(ServerboundLoginAcknowledgedPacket packet) {
        Validate.validState((this.h == EnumProtocolState.g ? 1 : 0) != 0, (String)"Unexpected login acknowledgement packet", (Object[])new Object[0]);
        CommonListenerCookie commonlistenercookie = CommonListenerCookie.a(Objects.requireNonNull(this.k));
        ServerConfigurationPacketListenerImpl serverconfigurationpacketlistenerimpl = new ServerConfigurationPacketListenerImpl(this.f, this.g, commonlistenercookie, this.player);
        this.g.a(serverconfigurationpacketlistenerimpl);
        serverconfigurationpacketlistenerimpl.m();
        this.h = EnumProtocolState.h;
    }

    @Override
    public void a(CrashReportSystemDetails section) {
        section.a("Login phase", () -> this.h.toString());
    }

    protected GameProfile createOfflineProfile(String s2) {
        UUID uuid = this.g.spoofedUUID != null ? this.g.spoofedUUID : UUIDUtil.a(s2);
        GameProfile gameProfile = new GameProfile(uuid, s2);
        if (this.g.spoofedProfile != null) {
            for (Property property : this.g.spoofedProfile) {
                if (!HandshakeListener.PROP_PATTERN.matcher(property.name()).matches()) continue;
                gameProfile.getProperties().put((Object)property.name(), (Object)property);
            }
        }
        return gameProfile;
    }

    public static enum EnumProtocolState {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h;

    }
}

