/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.resource.ResourcePackCallback;
import net.kyori.adventure.resource.ResourcePackStatus;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.util.VisibleForDebug;
import org.bukkit.craftbukkit.v1_20_R3.CraftServer;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R3.util.Waitable;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.purpurmc.purpur.PurpurConfig;
import org.slf4j.Logger;

public abstract class ServerCommonPacketListenerImpl
implements ServerCommonPacketListener {
    private static final Logger d = LogUtils.getLogger();
    public static final int a = 15000;
    private static final IChatBaseComponent e = IChatBaseComponent.c("disconnect.timeout");
    protected final MinecraftServer b;
    public final NetworkManager c;
    private long f = SystemUtils.b();
    private boolean g;
    private long h;
    private LongList keepAlives = new LongArrayList();
    private int i;
    private volatile boolean j = false;
    public final Map<UUID, ResourcePackCallback> packCallbacks = new ConcurrentHashMap<UUID, ResourcePackCallback>();
    private static final long KEEPALIVE_LIMIT = Long.getLong("paper.playerconnection.keepalive", 30L) * 1000L;
    protected static final MinecraftKey MINECRAFT_BRAND = new MinecraftKey("brand");
    protected static final MinecraftKey PURPUR_CLIENT = new MinecraftKey("purpur", "client");
    protected final EntityPlayer player;
    protected final CraftServer cserver;
    public boolean processedDisconnect;
    private static final MinecraftKey CUSTOM_REGISTER = new MinecraftKey("register");
    private static final MinecraftKey CUSTOM_UNREGISTER = new MinecraftKey("unregister");

    public ServerCommonPacketListenerImpl(MinecraftServer minecraftserver, NetworkManager networkmanager, CommonListenerCookie commonlistenercookie, EntityPlayer player) {
        this.b = minecraftserver;
        this.c = networkmanager;
        this.f = SystemUtils.b();
        this.i = commonlistenercookie.b();
        this.player = player;
        this.cserver = minecraftserver.server;
    }

    public CraftPlayer getCraftPlayer() {
        return this.player == null ? null : this.player.getBukkitEntity();
    }

    @Override
    public void a(IChatBaseComponent reason) {
        this.onDisconnect(reason, null);
    }

    public void onDisconnect(IChatBaseComponent reason, @Nullable Component quitMessage) {
        if (this.i()) {
            d.info("Stopping singleplayer server as player logged out");
            this.b.a(false);
        }
    }

    @Override
    public void a(ServerboundKeepAlivePacket packet) {
        if (PurpurConfig.useAlternateKeepAlive) {
            long id = packet.a();
            if (this.keepAlives.size() > 0 && this.keepAlives.contains(id)) {
                int ping = (int)(SystemUtils.b() - id);
                this.i = (this.i * 3 + ping) / 4;
                this.keepAlives.clear();
            }
        } else if (this.g && packet.a() == this.h) {
            int i2 = (int)(SystemUtils.b() - this.f);
            this.i = (this.i * 3 + i2) / 4;
            this.g = false;
        } else if (!this.i()) {
            this.b.g(() -> this.disconnect(e, PlayerKickEvent.Cause.TIMEOUT));
        }
    }

    @Override
    public void a(ServerboundPongPacket packet) {
    }

    @Override
    public void a(ServerboundCustomPayloadPacket packet) {
        CustomPacketPayload customPacketPayload = packet.a();
        if (customPacketPayload instanceof BrandPayload) {
            BrandPayload brandPayload = (BrandPayload)customPacketPayload;
            this.player.clientBrandName = brandPayload.b();
        }
        if (!(packet.a() instanceof ServerboundCustomPayloadPacket.UnknownPayload)) {
            return;
        }
        PlayerConnectionUtils.a(packet, this, this.player.z());
        MinecraftKey identifier = packet.a().a();
        ByteBuf payload = ((ServerboundCustomPayloadPacket.UnknownPayload)packet.a()).data();
        if (identifier.equals(CUSTOM_REGISTER)) {
            try {
                String channels = payload.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().addChannel(channel);
                }
            }
            catch (Exception ex) {
                PlayerConnection.g.error("Couldn't register custom payload", (Throwable)ex);
                this.disconnect("Invalid payload REGISTER!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        } else if (identifier.equals(PURPUR_CLIENT)) {
            try {
                this.player.purpurClient = true;
            }
            catch (Exception ex) {}
        } else if (identifier.equals(CUSTOM_UNREGISTER)) {
            try {
                String channels = payload.toString(Charsets.UTF_8);
                for (String channel : channels.split("\u0000")) {
                    this.getCraftPlayer().removeChannel(channel);
                }
            }
            catch (Exception ex) {
                PlayerConnection.g.error("Couldn't unregister custom payload", (Throwable)ex);
                this.disconnect("Invalid payload UNREGISTER!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        } else {
            try {
                byte[] data = new byte[payload.readableBytes()];
                payload.readBytes(data);
                if (identifier.equals(MINECRAFT_BRAND)) {
                    try {
                        this.player.clientBrandName = new PacketDataSerializer(Unpooled.copiedBuffer((byte[])data)).d(256);
                    }
                    catch (StringIndexOutOfBoundsException ex) {
                        this.player.clientBrandName = "illegal";
                    }
                }
                this.cserver.getMessenger().dispatchIncomingMessage((Player)this.player.getBukkitEntity(), identifier.toString(), data);
            }
            catch (Exception ex) {
                PlayerConnection.g.error("Couldn't dispatch custom payload", (Throwable)ex);
                this.disconnect("Invalid custom payload!", PlayerKickEvent.Cause.INVALID_PAYLOAD);
            }
        }
    }

    public final boolean isDisconnected() {
        return !this.player.joining && !this.c.k() || this.processedDisconnect;
    }

    @Override
    public void a(ServerboundResourcePackPacket packet) {
        PlayerResourcePackStatusEvent.Status packStatus;
        ResourcePackCallback callback;
        PlayerConnectionUtils.a(packet, this, this.b);
        if (packet.d() == ServerboundResourcePackPacket.a.b && this.b.V()) {
            d.info("Disconnecting {} due to resource pack {} rejection", (Object)this.j().getName(), (Object)packet.a());
            this.disconnect(IChatBaseComponent.c("multiplayer.requiredTexturePrompt.disconnect"), PlayerKickEvent.Cause.RESOURCE_PACK_REJECTION);
        }
        if ((callback = packet.d().a() ? this.packCallbacks.remove(packet.a()) : this.packCallbacks.get(packet.a())) != null) {
            callback.packEventReceived(packet.a(), ResourcePackStatus.valueOf((String)packet.d().name()), (Audience)this.getCraftPlayer());
        }
        this.player.getBukkitEntity().resourcePackStatus = packStatus = PlayerResourcePackStatusEvent.Status.values()[packet.d().ordinal()];
        this.cserver.getPluginManager().callEvent((Event)new PlayerResourcePackStatusEvent((Player)this.getCraftPlayer(), packet.a(), packStatus));
    }

    protected void f() {
        long currentTime = SystemUtils.b();
        long elapsedTime = currentTime - this.f;
        if (PurpurConfig.useAlternateKeepAlive) {
            if (elapsedTime >= 1000L) {
                if (!this.processedDisconnect && (long)this.keepAlives.size() * 1000L >= KEEPALIVE_LIMIT) {
                    d.warn("{} was kicked due to keepalive timeout!", (Object)this.player.cy());
                    this.disconnect(e, PlayerKickEvent.Cause.TIMEOUT);
                } else {
                    this.f = currentTime;
                    this.keepAlives.add(currentTime);
                    this.b(new ClientboundKeepAlivePacket(currentTime));
                }
            }
        } else if (this.g) {
            if (!this.processedDisconnect && elapsedTime >= KEEPALIVE_LIMIT) {
                PlayerConnection.g.warn("{} was kicked due to keepalive timeout!", (Object)this.player.cy());
                this.disconnect(e, PlayerKickEvent.Cause.TIMEOUT);
            }
        } else if (elapsedTime >= 15000L) {
            this.g = true;
            this.f = currentTime;
            this.h = currentTime;
            this.b(new ClientboundKeepAlivePacket(this.h));
        }
    }

    public void g() {
        this.j = true;
    }

    public void h() {
        this.j = false;
        this.c.c();
    }

    public void b(Packet<?> packet) {
        this.a(packet, null);
    }

    public void a(Packet<?> packet, @Nullable PacketSendListener callbacks) {
        if (packet == null || this.processedDisconnect) {
            return;
        }
        if (packet instanceof PacketPlayOutSpawnPosition) {
            PacketPlayOutSpawnPosition packet6 = (PacketPlayOutSpawnPosition)packet;
            this.player.compassTarget = CraftLocation.toBukkit(packet6.a, this.getCraftPlayer().getWorld());
        }
        boolean flag = !this.j || !this.b.bq();
        try {
            this.c.a(packet, callbacks, flag);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Sending packet");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Packet being sent");
            crashreportsystemdetails.a("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashreport);
        }
    }

    @Deprecated
    @DoNotUse
    public void disconnect(String s2) {
        this.disconnect((Component)LegacyComponentSerializer.legacySection().deserialize(s2), PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(String s2, PlayerKickEvent.Cause cause) {
        this.disconnect((Component)LegacyComponentSerializer.legacySection().deserialize(s2), cause);
    }

    @Deprecated
    @DoNotUse
    public void b(IChatBaseComponent reason) {
        this.disconnect(PaperAdventure.asAdventure(reason), PlayerKickEvent.Cause.UNKNOWN);
    }

    public void disconnect(IChatBaseComponent reason, PlayerKickEvent.Cause cause) {
        this.disconnect(PaperAdventure.asAdventure(reason), cause);
    }

    public void disconnect(final Component reason, final PlayerKickEvent.Cause cause) {
        if (this.processedDisconnect) {
            return;
        }
        if (!this.cserver.isPrimaryThread()) {
            Waitable waitable = new Waitable(){

                protected Object evaluate() {
                    ServerCommonPacketListenerImpl.this.disconnect(reason, cause);
                    return null;
                }
            };
            this.b.processQueue.add(waitable);
            try {
                waitable.get();
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e3) {
                throw new RuntimeException(e3);
            }
            return;
        }
        TranslatableComponent leaveMessage = Component.translatable((String)"multiplayer.player.left", (TextColor)NamedTextColor.YELLOW, (ComponentLike[])new ComponentLike[]{GlobalConfiguration.get().messages.useDisplayNameInQuitMessage ? this.player.getBukkitEntity().displayName() : Component.text((String)this.player.cy())});
        PlayerKickEvent event = new PlayerKickEvent((Player)this.player.getBukkitEntity(), reason, (Component)leaveMessage, cause);
        if (this.cserver.getServer().v()) {
            this.cserver.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return;
        }
        IChatBaseComponent ichatbasecomponent = PaperAdventure.asVanilla(event.reason());
        this.player.quitReason = PlayerQuitEvent.QuitReason.KICKED;
        this.c.a(new ClientboundDisconnectPacket(ichatbasecomponent), PacketSendListener.a(() -> this.c.a(ichatbasecomponent)));
        this.onDisconnect(ichatbasecomponent, event.leaveMessage());
        this.c.o();
        MinecraftServer minecraftserver = this.b;
        NetworkManager networkmanager = this.c;
        Objects.requireNonNull(this.c);
        minecraftserver.scheduleOnMain(networkmanager::p);
    }

    protected boolean i() {
        return this.b.a(this.j());
    }

    protected abstract GameProfile j();

    @VisibleForDebug
    public GameProfile k() {
        return this.j();
    }

    public int l() {
        return this.i;
    }

    protected CommonListenerCookie a(ClientInformation syncedOptions) {
        return new CommonListenerCookie(this.j(), this.i, syncedOptions);
    }
}

