/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SystemUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.server.packs.DownloadCacheCleaner;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.HttpUtilities;
import net.minecraft.util.eventlog.JsonEventLog;
import net.minecraft.util.thread.ThreadedMailbox;
import org.slf4j.Logger;

public class DownloadQueue
implements AutoCloseable {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 20;
    private final Path c;
    private final JsonEventLog<e> d;
    private final ThreadedMailbox<Runnable> e = ThreadedMailbox.a(SystemUtils.h(), "download-queue");

    public DownloadQueue(Path directory) throws IOException {
        this.c = directory;
        FileUtils.c(directory);
        this.d = JsonEventLog.a(net.minecraft.server.packs.DownloadQueue$e.a, directory.resolve("log.json"));
        DownloadCacheCleaner.a(directory, 20);
    }

    private b b(a config, Map<UUID, c> entries) {
        b batchResult = new b();
        entries.forEach((id, entry) -> {
            Path path = this.c.resolve(id.toString());
            Path path2 = null;
            try {
                path2 = HttpUtilities.a(path, entry.a, batchConfig.c, batchConfig.a, entry.b, batchConfig.b, batchConfig.d, batchConfig.e);
                batchResult.a.put((UUID)id, path2);
            }
            catch (Exception exception) {
                a.error("Failed to download {}", (Object)entry.a, (Object)exception);
                batchResult.b.add((UUID)id);
            }
            try {
                this.d.a(new e((UUID)id, entry.a.toString(), Instant.now(), Optional.ofNullable(entry.b).map(HashCode::toString), path2 != null ? this.a(path2) : Either.left("download_failed")));
            }
            catch (Exception exception2) {
                a.error("Failed to log download of {}", (Object)entry.a, (Object)exception2);
            }
        });
        return batchResult;
    }

    private Either<String, d> a(Path path) {
        try {
            long l2 = Files.size(path);
            Path path2 = this.c.relativize(path);
            return Either.right(new d(path2.toString(), l2));
        }
        catch (IOException iOException) {
            a.error("Failed to get file size of {}", (Object)path, (Object)iOException);
            return Either.left("no_access");
        }
    }

    public CompletableFuture<b> a(a config, Map<UUID, c> entries) {
        return CompletableFuture.supplyAsync(() -> this.b(config, entries), this.e::a);
    }

    @Override
    @Override
    public void close() throws IOException {
        this.e.close();
        this.d.close();
    }

    static final class e
    extends Record {
        private final UUID b;
        private final String c;
        private final Instant d;
        private final Optional<String> e;
        private final Either<String, d> f;
        public static final Codec<e> a = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.c.fieldOf("id").forGetter(e::a), (App)Codec.STRING.fieldOf("url").forGetter(e::b), (App)ExtraCodecs.m.fieldOf("time").forGetter(e::c), (App)Codec.STRING.optionalFieldOf("hash").forGetter(e::d), (App)Codec.mapEither((MapCodec)Codec.STRING.fieldOf("error"), (MapCodec)net.minecraft.server.packs.DownloadQueue$d.a.fieldOf("file")).forGetter(e::e)).apply((Applicative)instance, e::new));

        e(UUID uUID, String string, Instant instant, Optional<String> optional, Either<String, d> either) {
            this.b = uUID;
            this.c = string;
            this.d = instant;
            this.e = optional;
            this.f = either;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "id;url;time;hash;errorOrFileInfo", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "id;url;time;hash;errorOrFileInfo", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "id;url;time;hash;errorOrFileInfo", "b", "c", "d", "e", "f"}, this, object);
        }

        public UUID a() {
            return this.b;
        }

        public String b() {
            return this.c;
        }

        public Instant c() {
            return this.d;
        }

        public Optional<String> d() {
            return this.e;
        }

        public Either<String, d> e() {
            return this.f;
        }
    }

    public record b(Map<UUID, Path> a, Set<UUID> b) {
        public b() {
            this(new HashMap<UUID, Path>(), new HashSet<UUID>());
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "downloaded;failed", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "downloaded;failed", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "downloaded;failed", "a", "b"}, this, object);
        }
    }

    public record a(HashFunction a, int b, Map<String, String> c, Proxy d, HttpUtilities.a e) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "hashFunction;maxSize;headers;proxy;listener", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "hashFunction;maxSize;headers;proxy;listener", "a", "b", "c", "d", "e"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "hashFunction;maxSize;headers;proxy;listener", "a", "b", "c", "d", "e"}, this, object);
        }
    }

    static final class d
    extends Record {
        private final String b;
        private final long c;
        public static final Codec<d> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(d::a), (App)Codec.LONG.fieldOf("size").forGetter(d::b)).apply((Applicative)instance, d::new));

        d(String string, long l2) {
            this.b = string;
            this.c = l2;
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "name;size", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "name;size", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "name;size", "b", "c"}, this, object);
        }

        public String a() {
            return this.b;
        }

        public long b() {
            return this.c;
        }
    }

    public record c(URL a, @Nullable HashCode b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "url;hash", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "url;hash", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "url;hash", "a", "b"}, this, object);
        }
    }
}

