/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;

public class ResourceManagerFallback
implements IResourceManager {
    static final Logger b = LogUtils.getLogger();
    protected final List<d> a = Lists.newArrayList();
    private final EnumResourcePackType c;
    private final String d;

    public ResourceManagerFallback(EnumResourcePackType type, String namespace) {
        this.c = type;
        this.d = namespace;
    }

    public void a(IResourcePack pack) {
        this.a(pack.a(), pack, null);
    }

    public void a(IResourcePack pack, Predicate<MinecraftKey> filter) {
        this.a(pack.a(), pack, filter);
    }

    public void a(String name, Predicate<MinecraftKey> filter) {
        this.a(name, null, filter);
    }

    private void a(String name, @Nullable IResourcePack underlyingPack, @Nullable Predicate<MinecraftKey> filter) {
        this.a.add(new d(name, underlyingPack, filter));
    }

    @Override
    @Override
    public Set<String> a() {
        return ImmutableSet.of((Object)this.d);
    }

    @Override
    @Override
    public Optional<IResource> getResource(MinecraftKey id) {
        for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
            IoSupplier<InputStream> ioSupplier;
            d packEntry = this.a.get(i2);
            IResourcePack packResources = packEntry.b;
            if (packResources != null && (ioSupplier = packResources.a(this.c, id)) != null) {
                IoSupplier<ResourceMetadata> ioSupplier2 = this.a(id, i2);
                return Optional.of(ResourceManagerFallback.a(packResources, id, ioSupplier, ioSupplier2));
            }
            if (!packEntry.a(id)) continue;
            b.warn("Resource {} not found, but was filtered by pack {}", (Object)id, (Object)packEntry.a);
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static IResource a(IResourcePack pack, MinecraftKey id, IoSupplier<InputStream> supplier, IoSupplier<ResourceMetadata> metadataSupplier) {
        return new IResource(pack, ResourceManagerFallback.a(id, pack, supplier), metadataSupplier);
    }

    private static IoSupplier<InputStream> a(MinecraftKey id, IResourcePack pack, IoSupplier<InputStream> supplier) {
        if (b.isDebugEnabled()) {
            return () -> new c((InputStream)supplier.get(), id, pack.a());
        }
        return supplier;
    }

    @Override
    @Override
    public List<IResource> a(MinecraftKey id) {
        MinecraftKey resourceLocation = ResourceManagerFallback.d(id);
        ArrayList<IResource> list = new ArrayList<IResource>();
        boolean bl = false;
        String string = null;
        for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
            IoSupplier<InputStream> ioSupplier;
            d packEntry = this.a.get(i2);
            IResourcePack packResources = packEntry.b;
            if (packResources != null && (ioSupplier = packResources.a(this.c, id)) != null) {
                IoSupplier<ResourceMetadata> ioSupplier3;
                if (bl) {
                    IoSupplier<ResourceMetadata> ioSupplier2 = ResourceMetadata.b;
                } else {
                    ioSupplier3 = () -> {
                        IoSupplier<InputStream> ioSupplier = packResources.a(this.c, resourceLocation);
                        return ioSupplier != null ? ResourceManagerFallback.b(ioSupplier) : ResourceMetadata.a;
                    };
                }
                list.add(new IResource(packResources, ioSupplier, ioSupplier3));
            }
            if (packEntry.a(id)) {
                string = packEntry.a;
                break;
            }
            if (!packEntry.a(resourceLocation)) continue;
            bl = true;
        }
        if (list.isEmpty() && string != null) {
            b.warn("Resource {} not found, but was filtered by pack {}", (Object)id, string);
        }
        return Lists.reverse(list);
    }

    private static boolean b(MinecraftKey id) {
        return id.a().endsWith(".mcmeta");
    }

    private static MinecraftKey c(MinecraftKey id) {
        String string = id.a().substring(0, id.a().length() - ".mcmeta".length());
        return id.c(string);
    }

    static MinecraftKey d(MinecraftKey id) {
        return id.c(id.a() + ".mcmeta");
    }

    @Override
    @Override
    public Map<MinecraftKey, IResource> b(String startingPath, Predicate<MinecraftKey> allowedPathPredicate) {
        record A(IResourcePack a, IoSupplier<InputStream> b, int c) {
            @Override
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "packResources;resource;packIndex", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "packResources;resource;packIndex", "a", "b", "c"}, this);
            }

            @Override
            @Override
            public final boolean equals(Object object) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "packResources;resource;packIndex", "a", "b", "c"}, this, object);
            }
        }
        HashMap<MinecraftKey, A> map = new HashMap<MinecraftKey, A>();
        HashMap map2 = new HashMap();
        int i2 = this.a.size();
        for (int j2 = 0; j2 < i2; ++j2) {
            d packEntry = this.a.get(j2);
            packEntry.a(map.keySet());
            packEntry.a(map2.keySet());
            IResourcePack packResources = packEntry.b;
            if (packResources == null) continue;
            int k2 = j2;
            packResources.a(this.c, this.d, startingPath, (id, supplier) -> {
                if (ResourceManagerFallback.b(id)) {
                    if (allowedPathPredicate.test(ResourceManagerFallback.c(id))) {
                        map2.put(id, new A(packResources, (IoSupplier<InputStream>)supplier, k2));
                    }
                } else if (allowedPathPredicate.test((MinecraftKey)id)) {
                    map.put((MinecraftKey)id, new A(packResources, (IoSupplier<InputStream>)supplier, k2));
                }
            });
        }
        TreeMap map3 = Maps.newTreeMap();
        map.forEach((id, result) -> {
            IoSupplier<ResourceMetadata> ioSupplier2;
            MinecraftKey resourceLocation = ResourceManagerFallback.d(id);
            A lv = (A)map2.get(resourceLocation);
            if (lv != null && lv.c >= result.c) {
                IoSupplier<ResourceMetadata> ioSupplier = ResourceManagerFallback.a(lv.b);
            } else {
                ioSupplier2 = ResourceMetadata.b;
            }
            map3.put(id, ResourceManagerFallback.a(result.a, id, result.b, ioSupplier2));
        });
        return map3;
    }

    private IoSupplier<ResourceMetadata> a(MinecraftKey id, int index) {
        return () -> {
            MinecraftKey resourceLocation2 = ResourceManagerFallback.d(id);
            for (int j2 = this.a.size() - 1; j2 >= index; --j2) {
                IoSupplier<InputStream> ioSupplier;
                d packEntry = this.a.get(j2);
                IResourcePack packResources = packEntry.b;
                if (packResources != null && (ioSupplier = packResources.a(this.c, resourceLocation2)) != null) {
                    return ResourceManagerFallback.b(ioSupplier);
                }
                if (packEntry.a(resourceLocation2)) break;
            }
            return ResourceMetadata.a;
        };
    }

    private static IoSupplier<ResourceMetadata> a(IoSupplier<InputStream> supplier) {
        return () -> ResourceManagerFallback.b(supplier);
    }

    private static ResourceMetadata b(IoSupplier<InputStream> supplier) throws IOException {
        try (InputStream inputStream = supplier.get();){
            ResourceMetadata resourceMetadata = ResourceMetadata.a(inputStream);
            return resourceMetadata;
        }
    }

    private static void a(d pack, Map<MinecraftKey, b> idToEntryList) {
        for (b entryStack : idToEntryList.values()) {
            if (pack.a(entryStack.a)) {
                entryStack.c.clear();
                continue;
            }
            if (!pack.a(entryStack.b())) continue;
            entryStack.d.clear();
        }
    }

    private void a(d pack, String startingPath, Predicate<MinecraftKey> allowedPathPredicate, Map<MinecraftKey, b> idToEntryList) {
        IResourcePack packResources = pack.b;
        if (packResources == null) {
            return;
        }
        packResources.a(this.c, this.d, startingPath, (id, supplier) -> {
            if (ResourceManagerFallback.b(id)) {
                MinecraftKey resourceLocation = ResourceManagerFallback.c(id);
                if (!allowedPathPredicate.test(resourceLocation)) {
                    return;
                }
                map.computeIfAbsent(resourceLocation, (Function<MinecraftKey, b>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.MinecraftKey ), (Lnet/minecraft/resources/MinecraftKey;)Lnet/minecraft/server/packs/resources/ResourceManagerFallback$b;)()).d.put(packResources, (IoSupplier<InputStream>)supplier);
            } else {
                if (!allowedPathPredicate.test((MinecraftKey)id)) {
                    return;
                }
                map.computeIfAbsent(id, (Function<MinecraftKey, b>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.MinecraftKey ), (Lnet/minecraft/resources/MinecraftKey;)Lnet/minecraft/server/packs/resources/ResourceManagerFallback$b;)()).c.add(new e(packResources, (IoSupplier<InputStream>)supplier));
            }
        });
    }

    @Override
    @Override
    public Map<MinecraftKey, List<IResource>> c(String startingPath, Predicate<MinecraftKey> allowedPathPredicate) {
        HashMap map = Maps.newHashMap();
        for (d packEntry : this.a) {
            ResourceManagerFallback.a(packEntry, map);
            this.a(packEntry, startingPath, allowedPathPredicate, map);
        }
        TreeMap treeMap = Maps.newTreeMap();
        for (b entryStack : map.values()) {
            if (entryStack.c.isEmpty()) continue;
            ArrayList<IResource> list = new ArrayList<IResource>();
            for (e resourceWithSource : entryStack.c) {
                IResourcePack packResources = resourceWithSource.a;
                IoSupplier<InputStream> ioSupplier = entryStack.d.get(packResources);
                IoSupplier<ResourceMetadata> ioSupplier2 = ioSupplier != null ? ResourceManagerFallback.a(ioSupplier) : ResourceMetadata.b;
                list.add(ResourceManagerFallback.a(packResources, entryStack.a, resourceWithSource.b, ioSupplier2));
            }
            treeMap.put(entryStack.a, list);
        }
        return treeMap;
    }

    @Override
    @Override
    public Stream<IResourcePack> b() {
        return this.a.stream().map(pack -> pack.b).filter(Objects::nonNull);
    }

    record d(String a, @Nullable IResourcePack b, @Nullable Predicate<MinecraftKey> c) {
        public void a(Collection<MinecraftKey> ids) {
            if (this.c != null) {
                ids.removeIf(this.c);
            }
        }

        public boolean a(MinecraftKey id) {
            return this.c != null && this.c.test(id);
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "name;resources;filter", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "name;resources;filter", "a", "b", "c"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "name;resources;filter", "a", "b", "c"}, this, object);
        }
    }

    record b(MinecraftKey a, MinecraftKey b, List<e> c, Map<IResourcePack, IoSupplier<InputStream>> d) {
        b(MinecraftKey id) {
            this(id, ResourceManagerFallback.d(id), new ArrayList<e>(), (Map<IResourcePack, IoSupplier<InputStream>>)new Object2ObjectArrayMap());
        }

        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "fileLocation;metadataLocation;fileSources;metaSources", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "fileLocation;metadataLocation;fileSources;metaSources", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "fileLocation;metadataLocation;fileSources;metaSources", "a", "b", "c", "d"}, this, object);
        }
    }

    record e(IResourcePack a, IoSupplier<InputStream> b) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "source;resource", "a", "b"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "source;resource", "a", "b"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "source;resource", "a", "b"}, this, object);
        }
    }

    static class c
    extends FilterInputStream {
        private final Supplier<String> a;
        private boolean b;

        public c(InputStream parent, MinecraftKey id, String packName) {
            super(parent);
            Exception exception = new Exception("Stacktrace");
            this.a = () -> {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                return "Leaked resource: '" + id + "' loaded from pack: '" + packName + "'\n" + stringWriter;
            };
        }

        @Override
        @Override
        public void close() throws IOException {
            super.close();
            this.b = true;
        }

        @Override
        protected void finalize() throws Throwable {
            if (!this.b) {
                b.warn("{}", (Object)this.a.get());
            }
            super.finalize();
        }
    }
}

