/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.server.players.JsonListEntry;
import net.minecraft.util.ChatDeserializer;
import org.bukkit.Bukkit;
import org.slf4j.Logger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class JsonList<K, V extends JsonListEntry<K>> {
    private static final Logger a = LogUtils.getLogger();
    private static final Gson b = new GsonBuilder().setPrettyPrinting().create();
    private final File c;
    private final Map<String, V> d = Maps.newConcurrentMap();

    public JsonList(File file) {
        this.c = file;
    }

    public File b() {
        return this.c;
    }

    public void a(V entry) {
        this.d.put(this.a((K)((JsonListEntry)entry).g()), entry);
        try {
            this.e();
        }
        catch (IOException ioexception) {
            a.warn("Could not save the list after adding a user.", (Throwable)ioexception);
        }
    }

    @Nullable
    public V b(K key) {
        return (V)this.d.computeIfPresent(this.a(key), (k2, v2) -> v2.f() ? null : v2);
    }

    public void c(K key) {
        this.d.remove(this.a(key));
        try {
            this.e();
        }
        catch (IOException ioexception) {
            a.warn("Could not save the list after removing a user.", (Throwable)ioexception);
        }
    }

    public void b(JsonListEntry<K> entry) {
        this.c(entry.g());
    }

    public String[] a() {
        return this.d.keySet().toArray(new String[0]);
    }

    public boolean c() {
        return this.d.isEmpty();
    }

    protected String a(K profile) {
        return profile.toString();
    }

    protected boolean d(K k0) {
        this.g();
        return this.d.containsKey(this.a(k0));
    }

    private void g() {
        this.d.values().removeIf(JsonListEntry::f);
    }

    protected abstract JsonListEntry<K> a(JsonObject var1);

    public Collection<V> d() {
        return this.d.values();
    }

    public void e() throws IOException {
        this.g();
        JsonArray jsonarray = new JsonArray();
        Stream<JsonObject> stream = this.d.values().stream().map(jsonlistentry -> {
            JsonObject jsonobject = new JsonObject();
            Objects.requireNonNull(jsonlistentry);
            return SystemUtils.a(jsonobject, jsonlistentry::a);
        });
        Objects.requireNonNull(jsonarray);
        stream.forEach(arg_0 -> ((JsonArray)jsonarray).add(arg_0));
        try (BufferedWriter bufferedwriter = Files.newWriter((File)this.c, (Charset)StandardCharsets.UTF_8);){
            b.toJson((JsonElement)jsonarray, (Appendable)bufferedwriter);
        }
    }

    public void f() throws IOException {
        if (this.c.exists()) {
            BufferedReader bufferedreader;
            block10: {
                bufferedreader = Files.newReader((File)this.c, (Charset)StandardCharsets.UTF_8);
                try {
                    this.d.clear();
                    JsonArray jsonarray = (JsonArray)b.fromJson((Reader)bufferedreader, JsonArray.class);
                    if (jsonarray == null) break block10;
                    for (JsonElement jsonelement : jsonarray) {
                        JsonObject jsonobject = ChatDeserializer.m(jsonelement, "entry");
                        JsonListEntry<K> jsonlistentry = this.a(jsonobject);
                        if (jsonlistentry.g() == null) continue;
                        this.d.put(this.a(jsonlistentry.g()), jsonlistentry);
                    }
                }
                catch (JsonParseException | NullPointerException ex) {
                    Bukkit.getLogger().log(Level.WARNING, "Unable to read file " + this.c + ", backing it up to {0}.backup and creating new copy.", ex);
                    File backup = new File(this.c + ".backup");
                    this.c.renameTo(backup);
                    this.c.delete();
                }
                catch (Throwable throwable) {
                    if (bufferedreader != null) {
                        try {
                            bufferedreader.close();
                        }
                        catch (Throwable throwable1) {
                            throwable.addSuppressed(throwable1);
                        }
                    }
                    throw throwable;
                }
                if (bufferedreader != null) {
                    bufferedreader.close();
                }
                return;
            }
            if (bufferedreader != null) {
                bufferedreader.close();
            }
        }
    }
}

