/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.util.MathHelper;

public class ByIdMap {
    private static <T> IntFunction<T> a(ToIntFunction<T> valueToIdFunction, T[] values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Empty value list");
        }
        Int2ObjectOpenHashMap int2ObjectMap = new Int2ObjectOpenHashMap();
        for (T object : values) {
            int i2 = valueToIdFunction.applyAsInt(object);
            Object object2 = int2ObjectMap.put(i2, object);
            if (object2 == null) continue;
            throw new IllegalArgumentException("Duplicate entry on id " + i2 + ": current=" + object + ", previous=" + object2);
        }
        return int2ObjectMap;
    }

    public static <T> IntFunction<T> a(ToIntFunction<T> valueToIdFunction, T[] values, T fallback) {
        IntFunction intFunction = ByIdMap.a(valueToIdFunction, values);
        return index -> Objects.requireNonNullElse(intFunction.apply(index), fallback);
    }

    private static <T> T[] b(ToIntFunction<T> valueToIndexFunction, T[] values) {
        int i2 = values.length;
        if (i2 == 0) {
            throw new IllegalArgumentException("Empty value list");
        }
        Object[] objects = (Object[])values.clone();
        Arrays.fill(objects, null);
        for (T object : values) {
            int j2 = valueToIndexFunction.applyAsInt(object);
            if (j2 < 0 || j2 >= i2) {
                throw new IllegalArgumentException("Values are not continous, found index " + j2 + " for value " + object);
            }
            Object object2 = objects[j2];
            if (object2 != null) {
                throw new IllegalArgumentException("Duplicate entry on id " + j2 + ": current=" + object + ", previous=" + object2);
            }
            objects[j2] = object;
        }
        for (int k2 = 0; k2 < i2; ++k2) {
            if (objects[k2] != null) continue;
            throw new IllegalArgumentException("Missing value at index: " + k2);
        }
        return objects;
    }

    public static <T> IntFunction<T> a(ToIntFunction<T> valueToIdFunction, T[] values, a outOfBoundsHandling) {
        Object[] objects = ByIdMap.b(valueToIdFunction, values);
        int i2 = objects.length;
        return switch (outOfBoundsHandling) {
            default -> throw new IncompatibleClassChangeError();
            case a.a -> {
                Object object = objects[0];
                yield index -> index >= 0 && index < i2 ? objects[index] : object;
            }
            case a.b -> index -> objects[MathHelper.b(index, i2)];
            case a.c -> index -> objects[MathHelper.a(index, 0, i2 - 1)];
        };
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a();
        public static final /* enum */ a b = new a();
        public static final /* enum */ a c = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String string) {
            return Enum.valueOf(a.class, string);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{a, b, c};
        }

        static {
            d = net.minecraft.util.ByIdMap$a.a();
        }
    }
}

