/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class JavaOps
implements DynamicOps<Object> {
    public static final JavaOps a = new JavaOps();

    private JavaOps() {
    }

    public Object empty() {
        return null;
    }

    public Object emptyMap() {
        return Map.of();
    }

    public Object emptyList() {
        return List.of();
    }

    public <U> U convertTo(DynamicOps<U> dynamicOps, Object object) {
        if (object == null) {
            return (U)dynamicOps.empty();
        }
        if (object instanceof Map) {
            return (U)this.convertMap(dynamicOps, object);
        }
        if (object instanceof ByteList) {
            ByteList byteList = (ByteList)object;
            return (U)dynamicOps.createByteList(ByteBuffer.wrap(byteList.toByteArray()));
        }
        if (object instanceof IntList) {
            IntList intList = (IntList)object;
            return (U)dynamicOps.createIntList(intList.intStream());
        }
        if (object instanceof LongList) {
            LongList longList = (LongList)object;
            return (U)dynamicOps.createLongList(longList.longStream());
        }
        if (object instanceof List) {
            return (U)this.convertList(dynamicOps, object);
        }
        if (object instanceof String) {
            String string = (String)object;
            return (U)dynamicOps.createString(string);
        }
        if (object instanceof Boolean) {
            Boolean boolean_ = (Boolean)object;
            return (U)dynamicOps.createBoolean(boolean_.booleanValue());
        }
        if (object instanceof Byte) {
            Byte byte_ = (Byte)object;
            return (U)dynamicOps.createByte(byte_.byteValue());
        }
        if (object instanceof Short) {
            Short short_ = (Short)object;
            return (U)dynamicOps.createShort(short_.shortValue());
        }
        if (object instanceof Integer) {
            Integer integer = (Integer)object;
            return (U)dynamicOps.createInt(integer.intValue());
        }
        if (object instanceof Long) {
            Long long_ = (Long)object;
            return (U)dynamicOps.createLong(long_.longValue());
        }
        if (object instanceof Float) {
            Float float_ = (Float)object;
            return (U)dynamicOps.createFloat(float_.floatValue());
        }
        if (object instanceof Double) {
            Double double_ = (Double)object;
            return (U)dynamicOps.createDouble(double_.doubleValue());
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            return (U)dynamicOps.createNumeric(number);
        }
        throw new IllegalStateException("Don't know how to convert " + object);
    }

    public DataResult<Number> getNumberValue(Object object) {
        if (object instanceof Number) {
            Number number = (Number)object;
            return DataResult.success((Object)number);
        }
        return DataResult.error(() -> "Not a number: " + object);
    }

    public Object createNumeric(Number number) {
        return number;
    }

    public Object createByte(byte b2) {
        return b2;
    }

    public Object createShort(short s2) {
        return s2;
    }

    public Object createInt(int i2) {
        return i2;
    }

    public Object createLong(long l2) {
        return l2;
    }

    public Object createFloat(float f2) {
        return Float.valueOf(f2);
    }

    public Object createDouble(double d2) {
        return d2;
    }

    public DataResult<Boolean> getBooleanValue(Object object) {
        if (object instanceof Boolean) {
            Boolean boolean_ = (Boolean)object;
            return DataResult.success((Object)boolean_);
        }
        return DataResult.error(() -> "Not a boolean: " + object);
    }

    public Object createBoolean(boolean bl) {
        return bl;
    }

    public DataResult<String> getStringValue(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return DataResult.success((Object)string);
        }
        return DataResult.error(() -> "Not a string: " + object);
    }

    public Object createString(String string) {
        return string;
    }

    public DataResult<Object> mergeToList(Object object, Object object2) {
        if (object == this.empty()) {
            return DataResult.success(List.of(object2));
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.isEmpty()) {
                return DataResult.success(List.of(object2));
            }
            return DataResult.success((Object)ImmutableList.builder().addAll((Iterable)list).add(object2).build());
        }
        return DataResult.error(() -> "Not a list: " + object);
    }

    public DataResult<Object> mergeToList(Object object, List<Object> list) {
        if (object == this.empty()) {
            return DataResult.success(list);
        }
        if (object instanceof List) {
            List list2 = (List)object;
            if (list2.isEmpty()) {
                return DataResult.success(list);
            }
            return DataResult.success((Object)ImmutableList.builder().addAll((Iterable)list2).addAll(list).build());
        }
        return DataResult.error(() -> "Not a list: " + object);
    }

    public DataResult<Object> mergeToMap(Object object, Object object2, Object object3) {
        if (object == this.empty()) {
            return DataResult.success(Map.of(object2, object3));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (map.isEmpty()) {
                return DataResult.success(Map.of(object2, object3));
            }
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)(map.size() + 1));
            builder.putAll(map);
            builder.put(object2, object3);
            return DataResult.success((Object)builder.buildKeepingLast());
        }
        return DataResult.error(() -> "Not a map: " + object);
    }

    public DataResult<Object> mergeToMap(Object object, Map<Object, Object> map) {
        if (object == this.empty()) {
            return DataResult.success(map);
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            if (map2.isEmpty()) {
                return DataResult.success(map);
            }
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)(map2.size() + map.size()));
            builder.putAll(map2);
            builder.putAll(map);
            return DataResult.success((Object)builder.buildKeepingLast());
        }
        return DataResult.error(() -> "Not a map: " + object);
    }

    private static Map<Object, Object> a(MapLike<Object> mapLike) {
        return (Map)mapLike.entries().collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
    }

    public DataResult<Object> mergeToMap(Object object, MapLike<Object> mapLike) {
        if (object == this.empty()) {
            return DataResult.success(JavaOps.a(mapLike));
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (map.isEmpty()) {
                return DataResult.success(JavaOps.a(mapLike));
            }
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)map.size());
            builder.putAll(map);
            mapLike.entries().forEach(pair -> builder.put(pair.getFirst(), pair.getSecond()));
            return DataResult.success((Object)builder.buildKeepingLast());
        }
        return DataResult.error(() -> "Not a map: " + object);
    }

    static Stream<Pair<Object, Object>> a(Map<?, ?> map) {
        return map.entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue()));
    }

    public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            return DataResult.success(JavaOps.a(map));
        }
        return DataResult.error(() -> "Not a map: " + object);
    }

    public DataResult<Consumer<BiConsumer<Object, Object>>> getMapEntries(Object object) {
        if (object instanceof Map) {
            Map map = (Map)object;
            return DataResult.success(map::forEach);
        }
        return DataResult.error(() -> "Not a map: " + object);
    }

    public Object createMap(Stream<Pair<Object, Object>> stream) {
        return stream.collect(ImmutableMap.toImmutableMap(Pair::getFirst, Pair::getSecond));
    }

    public DataResult<MapLike<Object>> getMap(Object object) {
        if (object instanceof Map) {
            final Map map = (Map)object;
            return DataResult.success((Object)new MapLike<Object>(){

                @Nullable
                public Object get(Object object) {
                    return map.get(object);
                }

                @Nullable
                public Object get(String string) {
                    return map.get(string);
                }

                public Stream<Pair<Object, Object>> entries() {
                    return JavaOps.a(map);
                }

                @Override
                public String toString() {
                    return "MapLike[" + map + "]";
                }
            });
        }
        return DataResult.error(() -> "Not a map: " + object);
    }

    public Object createMap(Map<Object, Object> map) {
        return map;
    }

    public DataResult<Stream<Object>> getStream(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return DataResult.success(list.stream().map(value -> value));
        }
        return DataResult.error(() -> "Not an list: " + object);
    }

    public DataResult<Consumer<Consumer<Object>>> getList(Object object) {
        if (object instanceof List) {
            List list = (List)object;
            return DataResult.success(list::forEach);
        }
        return DataResult.error(() -> "Not an list: " + object);
    }

    public Object createList(Stream<Object> stream) {
        return stream.toList();
    }

    public DataResult<ByteBuffer> getByteBuffer(Object object) {
        if (object instanceof ByteList) {
            ByteList byteList = (ByteList)object;
            return DataResult.success((Object)ByteBuffer.wrap(byteList.toByteArray()));
        }
        return DataResult.error(() -> "Not a byte list: " + object);
    }

    public Object createByteList(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate().clear();
        ByteArrayList byteArrayList = new ByteArrayList();
        byteArrayList.size(byteBuffer2.capacity());
        byteBuffer2.get(0, byteArrayList.elements(), 0, byteArrayList.size());
        return byteArrayList;
    }

    public DataResult<IntStream> getIntStream(Object object) {
        if (object instanceof IntList) {
            IntList intList = (IntList)object;
            return DataResult.success((Object)intList.intStream());
        }
        return DataResult.error(() -> "Not an int list: " + object);
    }

    public Object createIntList(IntStream intStream) {
        return IntArrayList.toList((IntStream)intStream);
    }

    public DataResult<LongStream> getLongStream(Object object) {
        if (object instanceof LongList) {
            LongList longList = (LongList)object;
            return DataResult.success((Object)longList.longStream());
        }
        return DataResult.error(() -> "Not a long list: " + object);
    }

    public Object createLongList(LongStream longStream) {
        return LongArrayList.toList((LongStream)longStream);
    }

    public Object remove(Object object, String string) {
        if (object instanceof Map) {
            Map map = (Map)object;
            LinkedHashMap map2 = new LinkedHashMap(map);
            map2.remove(string);
            return DataResult.success(Map.copyOf(map2));
        }
        return DataResult.error(() -> "Not a map: " + object);
    }

    public RecordBuilder<Object> mapBuilder() {
        return new a<Object>(this);
    }

    @Override
    public String toString() {
        return "Java";
    }

    static final class a<T>
    extends RecordBuilder.AbstractUniversalBuilder<T, ImmutableMap.Builder<T, T>> {
        public a(DynamicOps<T> ops) {
            super(ops);
        }

        protected ImmutableMap.Builder<T, T> a() {
            return ImmutableMap.builder();
        }

        protected ImmutableMap.Builder<T, T> a(T object, T object2, ImmutableMap.Builder<T, T> builder) {
            return builder.put(object, object2);
        }

        /*
         * WARNING - void declaration
         */
        protected DataResult<T> a(ImmutableMap.Builder<T, T> builder, T object) {
            void immutableMap2;
            try {
                ImmutableMap immutableMap = builder.buildOrThrow();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return DataResult.error(() -> "Can't build map: " + illegalArgumentException.getMessage());
            }
            return this.ops().mergeToMap(object, (Map)immutableMap2);
        }

        protected /* synthetic */ Object append(Object object, Object object2, Object object3) {
            return this.a(object, object2, (ImmutableMap.Builder)object3);
        }

        protected /* synthetic */ DataResult build(Object object, Object object2) {
            return this.a((ImmutableMap.Builder)object, object2);
        }

        protected /* synthetic */ Object initBuilder() {
            return this.a();
        }
    }
}

