/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.StringUtils;

public class UtilColor {
    private static final Pattern a = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    private static final Pattern b = Pattern.compile("\\r\\n|\\v");
    private static final Pattern c = Pattern.compile("(?:\\r\\n|\\v)$");

    public static String a(int ticks, float tickRate) {
        int i2 = MathHelper.d((float)ticks / tickRate);
        int j2 = i2 / 60;
        i2 %= 60;
        int k2 = j2 / 60;
        j2 %= 60;
        if (k2 > 0) {
            return String.format(Locale.ROOT, "%02d:%02d:%02d", k2, j2, i2);
        }
        return String.format(Locale.ROOT, "%02d:%02d", j2, i2);
    }

    public static String a(String text) {
        return a.matcher(text).replaceAll("");
    }

    public static boolean b(@Nullable String text) {
        return StringUtils.isEmpty((CharSequence)text);
    }

    public static String a(String text, int maxLength, boolean addEllipsis) {
        if (text.length() <= maxLength) {
            return text;
        }
        if (addEllipsis && maxLength > 3) {
            return text.substring(0, maxLength - 3) + "...";
        }
        return text.substring(0, maxLength);
    }

    public static int c(String text) {
        if (text.isEmpty()) {
            return 0;
        }
        Matcher matcher = b.matcher(text);
        int i2 = 1;
        while (matcher.find()) {
            ++i2;
        }
        return i2;
    }

    public static boolean d(String text) {
        return c.matcher(text).find();
    }

    public static String e(String text) {
        return UtilColor.a(text, 256, false);
    }
}

