/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class BlendingDataFix
extends DataFix {
    private final String a;
    private static final Set<String> b = Set.of("minecraft:empty", "minecraft:structure_starts", "minecraft:structure_references", "minecraft:biomes");

    public BlendingDataFix(Schema outputSchema) {
        super(outputSchema, false);
        this.a = "Blending Data Fix v" + outputSchema.getVersionKey();
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(DataConverterTypes.c);
        return this.fixTypeEverywhereTyped(this.a, type, typed -> typed.update(DSL.remainderFinder(), chunk -> BlendingDataFix.a(chunk, chunk.get("__context"))));
    }

    private static Dynamic<?> a(Dynamic<?> chunk, OptionalDynamic<?> context) {
        chunk = chunk.remove("blending_data");
        boolean bl = "minecraft:overworld".equals(context.get("dimension").asString().result().orElse(""));
        Optional optional = chunk.get("Status").result();
        if (bl && optional.isPresent()) {
            Dynamic dynamic;
            String string2;
            String string = DataConverterSchemaNamed.a(((Dynamic)((Object)optional.get())).asString("empty"));
            Optional optional2 = chunk.get("below_zero_retrogen").result();
            if (!b.contains(string)) {
                chunk = BlendingDataFix.a(chunk, 384, -64);
            } else if (optional2.isPresent() && !b.contains(string2 = DataConverterSchemaNamed.a((dynamic = (Dynamic)((Object)optional2.get())).get("target_status").asString("empty")))) {
                chunk = BlendingDataFix.a(chunk, 256, 0);
            }
        }
        return chunk;
    }

    private static Dynamic<?> a(Dynamic<?> dynamic, int height, int minY) {
        return dynamic.set("blending_data", dynamic.createMap(Map.of(dynamic.createString("min_section"), dynamic.createInt(SectionPosition.a(minY)), dynamic.createString("max_section"), dynamic.createInt(SectionPosition.a(minY + height)))));
    }
}

