/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.stream.LongStream;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterBitStorageAlign
extends DataFix {
    private static final int a = 6;
    private static final int b = 16;
    private static final int c = 16;
    private static final int d = 4096;
    private static final int e = 9;
    private static final int f = 256;

    public DataConverterBitStorageAlign(Schema outputSchema) {
        super(outputSchema, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(DataConverterTypes.c);
        Type type2 = type.findFieldType("Level");
        OpticFinder opticFinder = DSL.fieldFinder((String)"Level", (Type)type2);
        OpticFinder opticFinder2 = opticFinder.type().findField("Sections");
        Type type3 = ((List.ListType)opticFinder2.type()).getElement();
        OpticFinder opticFinder3 = DSL.typeFinder((Type)type3);
        Type type4 = DSL.named((String)DataConverterTypes.u.typeName(), (Type)DSL.remainderType());
        OpticFinder opticFinder4 = DSL.fieldFinder((String)"Palette", (Type)DSL.list((Type)type4));
        return this.fixTypeEverywhereTyped("BitStorageAlignFix", type, this.getOutputSchema().getType(DataConverterTypes.c), chunk -> chunk.updateTyped(opticFinder, level -> this.a(DataConverterBitStorageAlign.a(opticFinder2, opticFinder3, opticFinder4, level))));
    }

    private Typed<?> a(Typed<?> fixedLevel) {
        return fixedLevel.update(DSL.remainderFinder(), levelDynamic -> levelDynamic.update("Heightmaps", heightmapsDynamic -> heightmapsDynamic.updateMapValues(heightmap -> heightmap.mapSecond(heightmapDynamic -> DataConverterBitStorageAlign.a(levelDynamic, heightmapDynamic, 256, 9)))));
    }

    private static Typed<?> a(OpticFinder<?> levelSectionsFinder, OpticFinder<?> sectionFinder, OpticFinder<List<Pair<String, Dynamic<?>>>> paletteFinder, Typed<?> level) {
        return level.updateTyped(levelSectionsFinder, levelSection -> levelSection.updateTyped(sectionFinder, section -> {
            int i2 = section.getOptional(paletteFinder).map(palette -> Math.max(4, DataFixUtils.ceillog2((int)palette.size()))).orElse(0);
            if (i2 == 0 || MathHelper.d(i2)) {
                return section;
            }
            return section.update(DSL.remainderFinder(), sectionDynamic -> sectionDynamic.update("BlockStates", statesDynamic -> DataConverterBitStorageAlign.a(sectionDynamic, statesDynamic, 4096, i2)));
        }));
    }

    private static Dynamic<?> a(Dynamic<?> sectionDynamic, Dynamic<?> statesDynamic, int maxValue, int elementBits) {
        long[] ls = statesDynamic.asLongStream().toArray();
        long[] ms = DataConverterBitStorageAlign.a(maxValue, elementBits, ls);
        return sectionDynamic.createLongList(LongStream.of(ms));
    }

    public static long[] a(int maxValue, int elementBits, long[] elements) {
        int i2 = elements.length;
        if (i2 == 0) {
            return elements;
        }
        long l2 = (1L << elementBits) - 1L;
        int j2 = 64 / elementBits;
        int k2 = (maxValue + j2 - 1) / j2;
        long[] ls = new long[k2];
        int m2 = 0;
        int n2 = 0;
        long o2 = 0L;
        int p2 = 0;
        long q2 = elements[0];
        long r2 = i2 > 1 ? elements[1] : 0L;
        for (int s2 = 0; s2 < maxValue; ++s2) {
            long z2;
            int t2 = s2 * elementBits;
            int u2 = t2 >> 6;
            int v2 = (s2 + 1) * elementBits - 1 >> 6;
            int w2 = t2 ^ u2 << 6;
            if (u2 != p2) {
                q2 = r2;
                r2 = u2 + 1 < i2 ? elements[u2 + 1] : 0L;
                p2 = u2;
            }
            if (u2 == v2) {
                long x2 = q2 >>> w2 & l2;
            } else {
                int y2 = 64 - w2;
                z2 = (q2 >>> w2 | r2 << y2) & l2;
            }
            int aa2 = n2 + elementBits;
            if (aa2 >= 64) {
                ls[m2++] = o2;
                o2 = z2;
                n2 = elementBits;
                continue;
            }
            o2 |= z2 << n2;
            n2 = aa2;
        }
        if (o2 != 0L) {
            ls[m2] = o2;
        }
        return ls;
    }
}

