/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public abstract class DataConverterBlockRename
extends DataFix {
    private final String a;

    public DataConverterBlockRename(Schema outputSchema, String name) {
        super(outputSchema, false);
        this.a = name;
    }

    public TypeRewriteRule makeRule() {
        Type type2;
        Type type = this.getInputSchema().getType(DataConverterTypes.y);
        if (!Objects.equals(type, type2 = DSL.named((String)DataConverterTypes.y.typeName(), DataConverterSchemaNamed.a()))) {
            throw new IllegalStateException("block type is not what was expected.");
        }
        TypeRewriteRule typeRewriteRule = this.fixTypeEverywhere(this.a + " for block", type2, dynamicOps -> pair -> pair.mapSecond(this::a));
        TypeRewriteRule typeRewriteRule2 = this.fixTypeEverywhereTyped(this.a + " for block_state", this.getInputSchema().getType(DataConverterTypes.u), typed -> typed.update(DSL.remainderFinder(), dynamic -> {
            Optional optional = dynamic.get("Name").asString().result();
            if (optional.isPresent()) {
                return dynamic.set("Name", dynamic.createString(this.a((String)optional.get())));
            }
            return dynamic;
        }));
        return TypeRewriteRule.seq((TypeRewriteRule)typeRewriteRule, (TypeRewriteRule)typeRewriteRule2);
    }

    protected abstract String a(String var1);

    public static DataFix a(Schema outputSchema, String name, final Function<String, String> rename) {
        return new DataConverterBlockRename(outputSchema, name){

            @Override
            @Override
            protected String a(String oldName) {
                return (String)rename.apply(oldName);
            }
        };
    }
}

