/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.FieldFinder;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.CompoundList;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Map;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import net.minecraft.util.datafix.fixes.DataConverterWorldGenSettingsBuilding;
import net.minecraft.util.datafix.schemas.DataConverterSchemaNamed;

public class DataConverterMissingDimension
extends DataFix {
    public DataConverterMissingDimension(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    protected static <A> Type<Pair<A, Dynamic<?>>> a(String string, Type<A> type) {
        return DSL.and((Type)DSL.field((String)string, type), (Type)DSL.remainderType());
    }

    protected static <A> Type<Pair<Either<A, Unit>, Dynamic<?>>> b(String string, Type<A> type) {
        return DSL.and((Type)DSL.optional((Type)DSL.field((String)string, type)), (Type)DSL.remainderType());
    }

    protected static <A1, A2> Type<Pair<Either<A1, Unit>, Pair<Either<A2, Unit>, Dynamic<?>>>> a(String string, Type<A1> type, String string2, Type<A2> type2) {
        return DSL.and((Type)DSL.optional((Type)DSL.field((String)string, type)), (Type)DSL.optional((Type)DSL.field((String)string2, type2)), (Type)DSL.remainderType());
    }

    protected TypeRewriteRule makeRule() {
        Schema schema = this.getInputSchema();
        Type type = DSL.taggedChoiceType((String)"type", (Type)DSL.string(), (Map)ImmutableMap.of((Object)"minecraft:debug", (Object)DSL.remainderType(), (Object)"minecraft:flat", DataConverterMissingDimension.a(schema), (Object)"minecraft:noise", DataConverterMissingDimension.a("biome_source", DSL.taggedChoiceType((String)"type", (Type)DSL.string(), (Map)ImmutableMap.of((Object)"minecraft:fixed", DataConverterMissingDimension.a("biome", schema.getType(DataConverterTypes.G)), (Object)"minecraft:multi_noise", (Object)DSL.list(DataConverterMissingDimension.a("biome", schema.getType(DataConverterTypes.G))), (Object)"minecraft:checkerboard", DataConverterMissingDimension.a("biomes", DSL.list((Type)schema.getType(DataConverterTypes.G))), (Object)"minecraft:vanilla_layered", (Object)DSL.remainderType(), (Object)"minecraft:the_end", (Object)DSL.remainderType())), "settings", DSL.or((Type)DSL.string(), DataConverterMissingDimension.a("default_block", schema.getType(DataConverterTypes.y), "default_fluid", schema.getType(DataConverterTypes.y))))));
        CompoundList.CompoundListType compoundListType = DSL.compoundList(DataConverterSchemaNamed.a(), DataConverterMissingDimension.a("generator", type));
        Type type2 = DSL.and((Type)compoundListType, (Type)DSL.remainderType());
        Type type3 = schema.getType(DataConverterTypes.I);
        FieldFinder fieldFinder = new FieldFinder("dimensions", type2);
        if (!type3.findFieldType("dimensions").equals((Object)type2)) {
            throw new IllegalStateException();
        }
        OpticFinder opticFinder = compoundListType.finder();
        return this.fixTypeEverywhereTyped("MissingDimensionFix", type3, typed -> typed.updateTyped((OpticFinder)fieldFinder, typed22 -> typed22.updateTyped(opticFinder, typed2 -> {
            if (!(typed2.getValue() instanceof List)) {
                throw new IllegalStateException("List exptected");
            }
            if (((List)typed2.getValue()).isEmpty()) {
                Dynamic dynamic = (Dynamic)((Object)((Object)((Object)((Object)typed.get(DSL.remainderFinder())))));
                Dynamic dynamic2 = this.a(dynamic);
                return (Typed)DataFixUtils.orElse(compoundListType.readTyped(dynamic2).result().map(Pair::getFirst), (Object)typed2);
            }
            return typed2;
        })));
    }

    protected static Type<? extends Pair<? extends Either<? extends Pair<? extends Either<?, Unit>, ? extends Pair<? extends Either<? extends List<? extends Pair<? extends Either<?, Unit>, Dynamic<?>>>, Unit>, Dynamic<?>>>, Unit>, Dynamic<?>>> a(Schema schema) {
        return DataConverterMissingDimension.b("settings", DataConverterMissingDimension.a("biome", schema.getType(DataConverterTypes.G), "layers", DSL.list(DataConverterMissingDimension.b("block", schema.getType(DataConverterTypes.y)))));
    }

    private <T> Dynamic<T> a(Dynamic<T> dynamic) {
        long l2 = dynamic.get("seed").asLong(0L);
        return new Dynamic<T>(dynamic.getOps(), DataConverterWorldGenSettingsBuilding.a(dynamic, l2, DataConverterWorldGenSettingsBuilding.a(dynamic, l2), false));
    }
}

