/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;

public class ContainerUtil {
    public static ItemStack a(List<ItemStack> stacks, int slot, int amount) {
        if (slot < 0 || slot >= stacks.size() || stacks.get(slot).b() || amount <= 0) {
            return ItemStack.f;
        }
        return stacks.get(slot).a(amount);
    }

    public static ItemStack a(List<ItemStack> stacks, int slot) {
        if (slot < 0 || slot >= stacks.size()) {
            return ItemStack.f;
        }
        return stacks.set(slot, ItemStack.f);
    }

    public static NBTTagCompound a(NBTTagCompound nbt, NonNullList<ItemStack> stacks) {
        return ContainerUtil.a(nbt, stacks, true);
    }

    public static NBTTagCompound a(NBTTagCompound nbt, NonNullList<ItemStack> stacks, boolean setIfEmpty) {
        NBTTagList listTag = new NBTTagList();
        for (int i2 = 0; i2 < stacks.size(); ++i2) {
            ItemStack itemStack = stacks.get(i2);
            if (itemStack.b()) continue;
            NBTTagCompound compoundTag = new NBTTagCompound();
            compoundTag.a("Slot", (byte)i2);
            itemStack.b(compoundTag);
            listTag.add(compoundTag);
        }
        if (!listTag.isEmpty() || setIfEmpty) {
            nbt.a("Items", listTag);
        }
        return nbt;
    }

    public static void b(NBTTagCompound nbt, NonNullList<ItemStack> stacks) {
        NBTTagList listTag = nbt.c("Items", 10);
        for (int i2 = 0; i2 < listTag.size(); ++i2) {
            NBTTagCompound compoundTag = listTag.a(i2);
            int j2 = compoundTag.f("Slot") & 0xFF;
            if (j2 < 0 || j2 >= stacks.size()) continue;
            stacks.set(j2, ItemStack.a(compoundTag));
        }
    }

    public static int a(IInventory inventory, Predicate<ItemStack> shouldRemove, int maxCount, boolean dryRun) {
        int i2 = 0;
        for (int j2 = 0; j2 < inventory.b(); ++j2) {
            ItemStack itemStack = inventory.a(j2);
            int k2 = ContainerUtil.a(itemStack, shouldRemove, maxCount - i2, dryRun);
            if (k2 > 0 && !dryRun && itemStack.b()) {
                inventory.a(j2, ItemStack.f);
            }
            i2 += k2;
        }
        return i2;
    }

    public static int a(ItemStack stack, Predicate<ItemStack> shouldRemove, int maxCount, boolean dryRun) {
        if (stack.b() || !shouldRemove.test(stack)) {
            return 0;
        }
        if (dryRun) {
            return stack.L();
        }
        int i2 = maxCount < 0 ? stack.L() : Math.min(maxCount, stack.L());
        stack.h(i2);
        return i2;
    }
}

