/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.Clearable;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntity;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.Nullable;

public interface IInventory
extends Clearable {
    public static final int n_ = 64;
    public static final int o_ = 8;
    public static final int MAX_STACK = 64;

    default public boolean hasEmptySlot(@Nullable EnumDirection enumdirection) {
        IInventory iInventory = this;
        if (iInventory instanceof IWorldInventory) {
            IWorldInventory worldlyContainer = (IWorldInventory)iInventory;
            for (Object i2 : (IInventory)worldlyContainer.a(enumdirection)) {
                if (!this.a((int)i2).b()) continue;
                return true;
            }
        } else {
            int size = this.b();
            for (int i3 = 0; i3 < size; ++i3) {
                if (!this.a(i3).b()) continue;
                return true;
            }
        }
        return false;
    }

    default public boolean isCompletelyFull(@Nullable EnumDirection enumdirection) {
        IInventory iInventory = this;
        if (iInventory instanceof IWorldInventory) {
            IWorldInventory worldlyContainer = (IWorldInventory)iInventory;
            for (Object i2 : (IInventory)worldlyContainer.a(enumdirection)) {
                ItemStack itemStack = this.a((int)i2);
                if (itemStack.L() >= itemStack.g()) continue;
                return false;
            }
        } else {
            int size = this.b();
            for (int i3 = 0; i3 < size; ++i3) {
                ItemStack itemStack = this.a(i3);
                if (itemStack.L() >= itemStack.g()) continue;
                return false;
            }
        }
        return true;
    }

    default public boolean isCompletelyEmpty(@Nullable EnumDirection enumdirection) {
        IInventory iInventory = this;
        if (iInventory instanceof IWorldInventory) {
            IWorldInventory worldlyContainer = (IWorldInventory)iInventory;
            for (Object i2 : (IInventory)worldlyContainer.a(enumdirection)) {
                if (this.a((int)i2).b()) continue;
                return false;
            }
        } else {
            int size = this.b();
            for (int i3 = 0; i3 < size; ++i3) {
                if (this.a(i3).b()) continue;
                return false;
            }
        }
        return true;
    }

    public int b();

    public boolean ai_();

    public ItemStack a(int var1);

    public ItemStack a(int var1, int var2);

    public ItemStack b(int var1);

    public void a(int var1, ItemStack var2);

    public int ak_();

    public void e();

    public boolean a(EntityHuman var1);

    default public void d_(EntityHuman player) {
    }

    default public void c(EntityHuman player) {
    }

    default public boolean b(int slot, ItemStack stack) {
        return true;
    }

    default public boolean a(IInventory hopperInventory, int slot, ItemStack stack) {
        return true;
    }

    default public int a_(Item item) {
        int i2 = 0;
        for (int j2 = 0; j2 < this.b(); ++j2) {
            ItemStack itemstack = this.a(j2);
            if (!itemstack.d().equals(item)) continue;
            i2 += itemstack.L();
        }
        return i2;
    }

    default public boolean a(Set<Item> items) {
        return this.a_((ItemStack itemstack) -> !itemstack.b() && items.contains(itemstack.d()));
    }

    default public boolean a_(Predicate<ItemStack> predicate) {
        for (int i2 = 0; i2 < this.b(); ++i2) {
            ItemStack itemstack = this.a(i2);
            if (!predicate.test(itemstack)) continue;
            return true;
        }
        return false;
    }

    public static boolean a(TileEntity blockEntity, EntityHuman player) {
        return IInventory.a(blockEntity, player, 8);
    }

    public static boolean a(TileEntity blockEntity, EntityHuman player, int range) {
        World world = blockEntity.i();
        BlockPosition blockposition = blockEntity.aB_();
        return world == null ? false : (world.c_(blockposition) != blockEntity ? false : player.i((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5) <= (double)(range * range));
    }

    public List<ItemStack> getContents();

    public void onOpen(CraftHumanEntity var1);

    public void onClose(CraftHumanEntity var1);

    public List<HumanEntity> getViewers();

    public @Nullable InventoryHolder getOwner();

    public void setMaxStackSize(int var1);

    public Location getLocation();

    default public RecipeHolder<?> getCurrentRecipe() {
        return null;
    }

    default public void setCurrentRecipe(RecipeHolder<?> recipe) {
    }
}

