/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.damagesource;

import io.papermc.paper.adventure.PaperAdventure;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.purpurmc.purpur.PurpurConfig;

public class DamageSource {
    private final Holder<DamageType> a;
    @Nullable
    private final Entity b;
    @Nullable
    private final Entity c;
    @Nullable
    private final Vec3D d;
    public BlockState explodedBlockState;
    @Nullable
    private Block directBlock;
    private boolean withSweep = false;
    private boolean melting = false;
    private boolean poison = false;
    private boolean scissors = false;
    private boolean stonecutter = false;
    @Nullable
    private Entity customEventDamager = null;
    private boolean critical;

    public DamageSource sweep() {
        this.withSweep = true;
        return this;
    }

    public boolean isSweep() {
        return this.withSweep;
    }

    public DamageSource melting() {
        this.melting = true;
        return this;
    }

    public boolean isMelting() {
        return this.melting;
    }

    public DamageSource poison() {
        this.poison = true;
        return this;
    }

    public boolean isPoison() {
        return this.poison;
    }

    public DamageSource scissors() {
        this.scissors = true;
        return this;
    }

    public boolean isScissors() {
        return this.scissors;
    }

    public DamageSource stonecutter() {
        this.stonecutter = true;
        return this;
    }

    public boolean isStonecutter() {
        return this.stonecutter;
    }

    @Nullable
    public Entity getCustomEventDamager() {
        return this.customEventDamager != null ? this.customEventDamager : this.c;
    }

    public DamageSource customEventDamager(Entity entity) {
        if (this.c != null) {
            throw new IllegalStateException("Cannot set a custom event damager entity when a direct entity is already set (report as a bug to Paper)");
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.customEventDamager = entity;
        return damageSource;
    }

    public Block getDirectBlock() {
        return this.directBlock;
    }

    public DamageSource directBlock(World world, BlockPosition blockPosition) {
        if (blockPosition == null || world == null) {
            return this;
        }
        return this.directBlock(CraftBlock.at(world, blockPosition));
    }

    public DamageSource directBlock(Block block) {
        if (block == null) {
            return this;
        }
        DamageSource damageSource = this.cloneInstance();
        damageSource.directBlock = block;
        return damageSource;
    }

    private DamageSource cloneInstance() {
        DamageSource damageSource = new DamageSource(this.a, this.c, this.b, this.d);
        damageSource.explodedBlockState = this.explodedBlockState;
        damageSource.directBlock = this.getDirectBlock();
        damageSource.withSweep = this.isSweep();
        damageSource.poison = this.isPoison();
        damageSource.melting = this.isMelting();
        damageSource.scissors = this.isScissors();
        damageSource.stonecutter = this.isStonecutter();
        return damageSource;
    }

    public String toString() {
        return "DamageSource (" + this.j().a() + ")";
    }

    public float a() {
        return this.j().c();
    }

    public boolean b() {
        return this.b != this.c;
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity source, @Nullable Entity attacker, @Nullable Vec3D position) {
        this.a = type;
        this.b = attacker;
        this.c = source;
        this.d = position;
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity source, @Nullable Entity attacker) {
        this(type, source, attacker, null);
    }

    public DamageSource(Holder<DamageType> type, Vec3D position) {
        this(type, null, null, position);
    }

    public DamageSource(Holder<DamageType> type, @Nullable Entity attacker) {
        this(type, attacker, attacker);
    }

    public DamageSource(Holder<DamageType> type) {
        this(type, null, null, null);
    }

    @Nullable
    public Entity c() {
        return this.c;
    }

    @Nullable
    public Entity d() {
        return this.b;
    }

    public IChatBaseComponent a(EntityLiving killed) {
        ItemStack itemstack;
        String s2 = "death.attack." + this.j().a();
        if (this.b == null && this.c == null) {
            EntityLiving entityliving1 = killed.eL();
            String s1 = s2 + ".player";
            return entityliving1 != null ? IChatBaseComponent.a(s1, killed.Q_(), entityliving1.Q_()) : IChatBaseComponent.a(s2, killed.Q_());
        }
        IChatBaseComponent ichatbasecomponent = this.b == null ? this.c.Q_() : this.b.Q_();
        Entity entity = this.b;
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving2 = (EntityLiving)entity;
            itemstack = entityliving2.eT();
        } else {
            itemstack = ItemStack.f;
        }
        ItemStack itemstack1 = itemstack;
        return !itemstack1.b() && (PurpurConfig.playerDeathsAlwaysShowItem || itemstack1.A()) ? IChatBaseComponent.a(s2 + ".item", killed.Q_(), ichatbasecomponent, itemstack1.J()) : IChatBaseComponent.a(s2, killed.Q_(), ichatbasecomponent);
    }

    public IChatBaseComponent getLocalizedDeathMessage(String str, EntityLiving entity) {
        Component name = PaperAdventure.asAdventure(entity.Q_());
        TagResolver.Single template = Placeholder.component((String)"player", (ComponentLike)name);
        Component component = MiniMessage.miniMessage().deserialize(str, (TagResolver)template);
        return PaperAdventure.asVanilla(component);
    }

    public String e() {
        return this.j().a();
    }

    public boolean f() {
        return switch (this.j().b()) {
            case DamageScaling.a -> false;
            case DamageScaling.b -> this.b instanceof EntityLiving && !(this.b instanceof EntityHuman);
            case DamageScaling.c -> true;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public boolean g() {
        Entity entity = this.d();
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            if (entityhuman.fT().d) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    @Nullable
    public Vec3D h() {
        return this.d != null ? this.d : (this.c != null ? this.c.dk() : null);
    }

    @Nullable
    public Vec3D i() {
        return this.d;
    }

    public boolean a(TagKey<DamageType> tag) {
        return this.a.a(tag);
    }

    public boolean a(ResourceKey<DamageType> typeKey) {
        return this.a.a(typeKey);
    }

    public DamageType j() {
        return this.a.a();
    }

    public Holder<DamageType> k() {
        return this.a;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public DamageSource critical() {
        return this.critical(true);
    }

    public DamageSource critical(boolean critical) {
        this.critical = critical;
        return this;
    }
}

