/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.destroystokyo.paper.loottable.PaperLootableInventoryData;
import com.destroystokyo.paper.util.misc.PooledLinkedHashSets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.logging.LogUtils;
import gg.pufferfish.pufferfish.PufferfishConfig;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.event.entity.EntityPortalReadyEvent;
import io.papermc.paper.event.entity.EntityPushedByEntityAttackEvent;
import io.papermc.paper.event.player.PlayerUntrackEntityEvent;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TickThread;
import io.papermc.paper.util.WorldUtil;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFenceGate;
import net.minecraft.world.level.block.BlockHoney;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.BitRandomSource;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemType;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R3.util.CraftVector;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityAirChangeEvent;
import org.bukkit.event.entity.EntityCombustByBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.bukkit.event.entity.EntityMountEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.event.entity.EntityPoseChangeEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleBlockCollisionEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.PluginManager;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.spigotmc.ActivationRange;
import org.spigotmc.TrackingRange;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class Entity
implements INamableTileEntity,
EntityAccess,
ICommandListener,
ScoreHolder {
    public static ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("rhino");
    private static final int CURRENT_LEVEL = 2;
    public boolean preserveMotion = true;
    public static RandomSource SHARED_RANDOM = new RandomRandomSource();
    public CreatureSpawnEvent.SpawnReason spawnReason;
    public PaperLootableInventoryData lootableData;
    public boolean collisionLoadChunks = false;
    private CraftEntity bukkitEntity;
    @Nullable
    public PlayerChunkMap.EntityTracker tracker;
    private static final Logger c = LogUtils.getLogger();
    public static final String w = "id";
    public static final String x = "Passengers";
    private static final AtomicInteger d = new AtomicInteger();
    private static final List<ItemStack> e = Collections.emptyList();
    public static final int y = 60;
    public static final int z = 300;
    public static final int A = 1024;
    public static final float B = 0.2f;
    public static final double C = 0.500001;
    public static final double D = 0.999999;
    public static final float E = 0.11111111f;
    public static final int F = 140;
    public static final int G = 40;
    private static final AxisAlignedBB k = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final double l = 0.014;
    private static final double m = 0.007;
    private static final double n = 0.0023333333333333335;
    public static final String H = "UUID";
    private static double o = 1.0;
    private final EntityTypes<?> p;
    private int q;
    public boolean I;
    public ImmutableList<Entity> r;
    protected int J;
    @javax.annotation.Nullable
    private Entity s;
    private net.minecraft.world.level.World t;
    public double K;
    public double L;
    public double M;
    private Vec3D u;
    public BlockPosition v;
    private ChunkCoordIntPair aE;
    private Vec3D aF;
    private float aG;
    private float aH;
    public float N;
    public float O;
    private AxisAlignedBB aI;
    public boolean aJ;
    public boolean P;
    public boolean Q;
    public boolean R;
    public boolean S;
    public boolean T;
    protected Vec3D U;
    @javax.annotation.Nullable
    private RemovalReason aK;
    public static final float V = 0.6f;
    public static final float W = 1.8f;
    public float X;
    public float Y;
    public float Z;
    public float aa;
    public float ab;
    private float aL = 1.0f;
    public double ac;
    public double ad;
    public double ae;
    public float aM;
    public boolean af;
    public final RandomSource ag;
    public int ah;
    private int aN;
    public boolean ai;
    protected Object2DoubleMap<TagKey<FluidType>> aj;
    protected boolean ak;
    private final Set<TagKey<FluidType>> aO;
    public int al;
    protected boolean am;
    protected final DataWatcher an;
    protected static final DataWatcherObject<Byte> ao = DataWatcher.a(Entity.class, DataWatcherRegistry.a);
    protected static final int ap = 0;
    private static final int aP = 1;
    private static final int aQ = 3;
    private static final int aR = 4;
    public static final int aS = 5;
    protected static final int aq = 6;
    protected static final int ar = 7;
    private static final DataWatcherObject<Integer> aT = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Optional<IChatBaseComponent>> aU = DataWatcher.a(Entity.class, DataWatcherRegistry.g);
    private static final DataWatcherObject<Boolean> aV = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aW = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> aX = DataWatcher.a(Entity.class, DataWatcherRegistry.k);
    protected static final DataWatcherObject<EntityPose> as = DataWatcher.a(Entity.class, DataWatcherRegistry.v);
    private static final DataWatcherObject<Integer> aY = DataWatcher.a(Entity.class, DataWatcherRegistry.b);
    private EntityInLevelCallback aZ;
    private final VecDeltaCodec ba;
    public boolean at;
    public boolean au;
    public int bb;
    public boolean av;
    protected int aw;
    protected BlockPosition ax;
    private boolean bc;
    protected UUID ay;
    protected String az;
    private boolean bd;
    private final Set<String> be;
    private final double[] bf;
    private long bg;
    protected EntitySize bh;
    private float bi;
    public boolean aA;
    public boolean aB;
    public boolean aC;
    public Optional<BlockPosition> aD;
    private boolean bj;
    private float bk;
    private int bl;
    public boolean bm;
    @javax.annotation.Nullable
    private IBlockData bn;
    public boolean persist = true;
    public boolean visibleByDefault = true;
    public boolean valid;
    public boolean inWorld = false;
    public boolean generation;
    public int maxAirTicks = this.getDefaultMaxAirSupply();
    @javax.annotation.Nullable
    public ProjectileSource projectileSource;
    public boolean lastDamageCancelled;
    public boolean persistentInvisibility = false;
    public BlockPosition lastLavaContact;
    public boolean pluginRemoved = false;
    public final ActivationRange.ActivationType activationType = ActivationRange.initializeEntityActivationType(this);
    public final boolean defaultActivationState;
    public long activatedTick = Integer.MIN_VALUE;
    protected int numCollisions = 0;
    public boolean fromNetherPortal;
    public long activatedImmunityTick = Integer.MIN_VALUE;
    public boolean isTemporarilyActive;
    public boolean spawnedViaMobSpawner;
    @javax.annotation.Nullable
    private Vector origin;
    @javax.annotation.Nullable
    private UUID originWorld;
    public boolean freezeLocked = false;
    public boolean fixedPose = false;
    public boolean activatedPriorityReset = false;
    public int activatedPriority = PufferfishConfig.maximumActivationPrio;
    public final BlockPosition.MutableBlockPosition cachedBlockPos = new BlockPosition.MutableBlockPosition();
    @javax.annotation.Nullable
    public Boolean immuneToFire = null;
    public BlockPosition portalBlock;
    public WorldServer portalWorld;
    final TrackingRange.TrackingRangeType trackingRangeType = TrackingRange.getTrackingRangeType(this);
    public boolean isLegacyTrackingEntity = false;
    private final boolean hardCollides = this instanceof EntityBoat || this instanceof EntityShulker || this instanceof EntityMinecartAbstract || this.shouldHardCollide();
    private static final Map<Class<? extends Entity>, Boolean> cachedOverrides = Collections.synchronizedMap(new WeakHashMap());
    public FullChunkStatus chunkStatus;
    public int sectionX = Integer.MIN_VALUE;
    public int sectionY = Integer.MIN_VALUE;
    public int sectionZ = Integer.MIN_VALUE;
    public boolean updatingSectionStatus = false;
    public final Object posLock = new Object();
    private Vec3D moveVector;
    private double moveStartX;
    private double moveStartY;
    private double moveStartZ;
    public BlockPosition portalPos = BlockPosition.b;
    @javax.annotation.Nullable
    private EntityHuman rider = null;

    static boolean isLevelAtLeast(NBTTagCompound tag, int level) {
        return tag.e("Bukkit.updateLevel") && tag.h("Bukkit.updateLevel") >= level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CraftEntity getBukkitEntity() {
        if (this.bukkitEntity == null) {
            Entity entity = this;
            synchronized (entity) {
                if (this.bukkitEntity == null) {
                    this.bukkitEntity = CraftEntity.getEntity(this.t.getCraftServer(), this);
                    return this.bukkitEntity;
                }
            }
        }
        return this.bukkitEntity;
    }

    public CraftEntity getBukkitEntityRaw() {
        return this.bukkitEntity;
    }

    @Override
    public CommandSender getBukkitSender(CommandListenerWrapper wrapper) {
        return this.getBukkitEntity();
    }

    public int getDefaultMaxAirSupply() {
        return 300;
    }

    public void inactiveTick() {
    }

    public void setOrigin(@Nonnull Location location) {
        this.origin = location.toVector();
        this.originWorld = location.getWorld().getUID();
    }

    @javax.annotation.Nullable
    public Vector getOriginVector() {
        return this.origin != null ? this.origin.clone() : null;
    }

    @javax.annotation.Nullable
    public UUID getOriginWorld() {
        return this.originWorld;
    }

    public void tickEndPortal() {
        BlockPosition pos = this.portalBlock;
        WorldServer world = this.portalWorld;
        this.portalBlock = null;
        this.portalWorld = null;
        if (pos == null || world == null || world != this.t) {
            return;
        }
        if (this.bO() || this.bP() || !this.ct() || this.dH() || !this.valid || !this.bx()) {
            return;
        }
        ResourceKey<net.minecraft.world.level.World> resourcekey = world.getTypeKey() == WorldDimension.d ? net.minecraft.world.level.World.h : net.minecraft.world.level.World.j;
        WorldServer worldserver = world.o().a(resourcekey);
        EntityPortalEnterEvent event = new EntityPortalEnterEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), new Location((World)world.getWorld(), (double)pos.u(), (double)pos.v(), (double)pos.w()));
        event.callEvent();
        if (this instanceof EntityPlayer) {
            ((EntityPlayer)this).changeDimension(worldserver, PlayerTeleportEvent.TeleportCause.END_PORTAL);
            return;
        }
        this.teleportTo(worldserver, null);
    }

    public final void setLegacyTrackingEntity(boolean isLegacyTrackingEntity) {
        this.isLegacyTrackingEntity = isLegacyTrackingEntity;
    }

    public final PooledLinkedHashSets.PooledObjectLinkedOpenHashSet<EntityPlayer> getPlayersInTrackRange() {
        if (this.r.isEmpty()) {
            return ((WorldServer)this.t).l().a.playerEntityTrackerTrackMaps[this.trackingRangeType.ordinal()].getObjectsInRange(MCUtil.getCoordinateKey(this));
        }
        Iterable<Entity> passengers = this.cT();
        PlayerChunkMap chunkMap = ((WorldServer)this.t).l().a;
        TrackingRange.TrackingRangeType type = this.trackingRangeType;
        int range = chunkMap.getEntityTrackerRange(type.ordinal());
        for (Entity passenger : passengers) {
            TrackingRange.TrackingRangeType passengerType = passenger.trackingRangeType;
            int passengerRange = chunkMap.getEntityTrackerRange(passengerType.ordinal());
            if (passengerRange <= range) continue;
            type = passengerType;
            range = passengerRange;
        }
        return chunkMap.playerEntityTrackerTrackMaps[type.ordinal()].getObjectsInRange(MCUtil.getCoordinateKey(this));
    }

    public float getBukkitYaw() {
        return this.aG;
    }

    public boolean isChunkLoaded() {
        return this.t.b((int)Math.floor(this.dr()) >> 4, (int)Math.floor(this.dx()) >> 4);
    }

    public final AxisAlignedBB getBoundingBoxAt(double x2, double y2, double z2) {
        return this.bh.a(x2, y2, z2);
    }

    protected boolean shouldHardCollide() {
        return false;
    }

    public boolean canSaveToDisk() {
        return true;
    }

    public boolean fY() {
        if (this.dM().P() && !this.dM().B) {
            boolean flag;
            float f2 = this.bo();
            BlockPosition blockposition = BlockPosition.a(this.dr(), this.dv(), this.dx());
            boolean bl = flag = this.bb() || this.aA || this.aB;
            if (f2 > 0.5f && this.ag.i() * 30.0f < (f2 - 0.4f) * 2.0f && !flag && this.dM().h(blockposition)) {
                return true;
            }
        }
        return false;
    }

    public final boolean hardCollides() {
        return this.hardCollides;
    }

    public Entity(EntityTypes<?> type, net.minecraft.world.level.World world) {
        this.q = d.incrementAndGet();
        this.r = ImmutableList.of();
        this.aF = Vec3D.b;
        this.aI = k;
        this.U = Vec3D.b;
        this.ag = world == null || world.purpurConfig.entitySharedRandom ? SHARED_RANDOM : RandomSource.a();
        this.aN = -this.dc();
        this.aj = new Object2DoubleArrayMap(2);
        this.aO = new HashSet<TagKey<FluidType>>();
        this.am = true;
        this.aZ = EntityInLevelCallback.a;
        this.ba = new VecDeltaCodec();
        this.ay = MathHelper.a(this.ag);
        this.az = this.ay.toString();
        this.be = Sets.newHashSet();
        this.bf = new double[]{0.0, 0.0, 0.0};
        this.aD = Optional.empty();
        this.bj = false;
        this.bn = null;
        this.p = type;
        this.t = world;
        this.bh = type.n();
        this.u = Vec3D.b;
        this.v = BlockPosition.b;
        this.aE = ChunkCoordIntPair.b;
        this.defaultActivationState = world != null ? ActivationRange.initializeEntityActivationState(this, world.spigotConfig) : false;
        this.an = new DataWatcher(this);
        this.an.a(ao, (byte)0);
        this.an.a(aT, this.ch());
        this.an.a(aV, false);
        this.an.a(aU, Optional.empty());
        this.an.a(aW, false);
        this.an.a(aX, false);
        this.an.a(as, EntityPose.a);
        this.an.a(aY, 0);
        this.c_();
        this.an().registrationLocked = true;
        this.a_(0.0, 0.0, 0.0);
        this.bi = this.a(EntityPose.a, this.bh);
    }

    public boolean a(BlockPosition pos, IBlockData state) {
        VoxelShape voxelshape = state.b((IBlockAccess)this.dM(), pos, VoxelShapeCollision.a(this));
        VoxelShape voxelshape1 = voxelshape.a(pos.u(), (double)pos.v(), (double)pos.w());
        return VoxelShapes.c(voxelshape1, VoxelShapes.a(this.cH()), OperatorBoolean.i);
    }

    public int j_() {
        ScoreboardTeam scoreboardteam = this.cg();
        return scoreboardteam != null && scoreboardteam.n().f() != null ? scoreboardteam.n().f() : 0xFFFFFF;
    }

    public boolean P_() {
        return false;
    }

    public final void ag() {
        if (this.bP()) {
            this.bB();
        }
        if (this.bO()) {
            this.ac();
        }
    }

    public void f(double x2, double y2, double z2) {
        this.ba.e(new Vec3D(x2, y2, z2));
    }

    public VecDeltaCodec ah() {
        return this.ba;
    }

    public EntityTypes<?> ai() {
        return this.p;
    }

    @Override
    public int aj() {
        return this.q;
    }

    public void e(int id) {
        this.q = id;
    }

    public Set<String> ak() {
        return this.be;
    }

    public boolean a(String tag) {
        return this.be.size() >= 1024 ? false : this.be.add(tag);
    }

    public boolean b(String tag) {
        return this.be.remove(tag);
    }

    public void al() {
        this.remove(RemovalReason.a, EntityRemoveEvent.Cause.DEATH);
        this.a(GameEvent.p);
    }

    public final void am() {
        this.discard(null);
    }

    public final void discard(EntityRemoveEvent.Cause cause) {
        this.remove(RemovalReason.b, cause);
    }

    protected abstract void c_();

    public DataWatcher an() {
        return this.an;
    }

    public boolean equals(Object object) {
        return object instanceof Entity ? ((Entity)object).q == this.q : false;
    }

    public int hashCode() {
        return this.q;
    }

    public void a(RemovalReason reason) {
        this.setRemoved(reason, null);
    }

    public void remove(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        this.setRemoved(entity_removalreason, cause);
    }

    public void ao() {
    }

    public void b(EntityPose pose) {
        if (this.fixedPose) {
            return;
        }
        if (pose == this.ap()) {
            return;
        }
        if (!this.generation) {
            this.t.getCraftServer().getPluginManager().callEvent((Event)new EntityPoseChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), Pose.values()[pose.ordinal()]));
        }
        this.an.b(as, pose);
    }

    public EntityPose ap() {
        return this.an.b(as);
    }

    public boolean c(EntityPose pose) {
        return this.ap() == pose;
    }

    public boolean a(Entity entity, double radius) {
        return this.dk().a((IPosition)entity.dk(), radius);
    }

    public boolean a(Entity entity, double horizontalRadius, double verticalRadius) {
        double d2 = entity.dr() - this.dr();
        double d3 = entity.dt() - this.dt();
        double d4 = entity.dx() - this.dx();
        return MathHelper.e(d2, d4) < MathHelper.k(horizontalRadius) && MathHelper.k(d3) < MathHelper.k(verticalRadius);
    }

    public void a(float yaw, float pitch) {
        if (Float.isNaN(yaw)) {
            yaw = 0.0f;
        }
        if (yaw == Float.POSITIVE_INFINITY || yaw == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.t.getCraftServer().getLogger().warning(this.cy() + " was caught trying to crash the server with an invalid yaw");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite yaw (Hacking?)");
            }
            yaw = 0.0f;
        }
        if (Float.isNaN(pitch)) {
            pitch = 0.0f;
        }
        if (pitch == Float.POSITIVE_INFINITY || pitch == Float.NEGATIVE_INFINITY) {
            if (this instanceof EntityPlayer) {
                this.t.getCraftServer().getLogger().warning(this.cy() + " was caught trying to crash the server with an invalid pitch");
                ((CraftPlayer)this.getBukkitEntity()).kickPlayer("Infinite pitch (Hacking?)");
            }
            pitch = 0.0f;
        }
        this.r(yaw % 360.0f);
        this.s(pitch % 360.0f);
    }

    public final void b(Vec3D pos) {
        this.a_(pos.a(), pos.b(), pos.c());
    }

    public void a_(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, true);
    }

    protected AxisAlignedBB aq() {
        return this.bh.a(this.u);
    }

    protected void ar() {
        this.a_(this.u.c, this.u.d, this.u.e);
    }

    public void b(double cursorDeltaX, double cursorDeltaY) {
        float f2 = (float)cursorDeltaY * 0.15f;
        float f1 = (float)cursorDeltaX * 0.15f;
        this.s(this.dE() + f2);
        this.r(this.dC() + f1);
        this.s(MathHelper.a(this.dE(), -90.0f, 90.0f));
        this.O += f2;
        this.N += f1;
        this.O = MathHelper.a(this.O, -90.0f, 90.0f);
        if (this.s != null) {
            this.s.j(this);
        }
    }

    public void l() {
        if (this.p != EntityTypes.bv && this.p.ttl >= 0 && this.ah >= this.p.ttl) {
            this.discard(EntityRemoveEvent.Cause.DISCARD);
            return;
        }
        this.as();
    }

    public void postTick() {
        if (!(this instanceof EntityPlayer) && this.bx()) {
            this.bI();
        }
    }

    public void as() {
        Entity entity;
        if (this.am && (entity = this) instanceof IEntityAngerable) {
            IEntityAngerable neutralMob = (IEntityAngerable)((Object)entity);
            neutralMob.tickInitialPersistentAnger(this.t);
        }
        this.bn = null;
        if (this.bO() && this.cZ().dH()) {
            this.ac();
        }
        if (this.J > 0) {
            --this.J;
        }
        this.X = this.Y;
        this.O = this.dE();
        this.N = this.dC();
        if (this instanceof EntityPlayer) {
            this.bI();
        }
        if (this.bl()) {
            this.bm();
        }
        this.aB = this.aA;
        this.aA = false;
        this.bg();
        this.y();
        this.bf();
        if (this.dM().B) {
            this.aA();
        } else if (this.aN > 0) {
            if (this.aY()) {
                this.h(this.aN - 4);
                if (this.aN < 0) {
                    this.aA();
                }
            } else {
                if (this.aN % 20 == 0 && !this.bn()) {
                    this.a(this.dN().c(), 1.0f);
                }
                this.h(this.aN - 1);
            }
            if (this.cj() > 0 && !this.freezeLocked) {
                this.k(0);
                this.dM().a((EntityHuman)null, 1009, this.v, 1);
            }
        }
        if (this.bn()) {
            this.ay();
            this.ab *= 0.5f;
        } else {
            this.lastLavaContact = null;
        }
        this.at();
        if (!this.dM().B) {
            this.a_(this.aN > 0);
        }
        this.am = false;
    }

    public void a_(boolean onFire) {
        this.b(0, onFire || this.bm);
    }

    public void at() {
        block6: {
            Entity entity;
            block5: {
                if (this.dt() < (double)this.t.J_() + this.dM().purpurConfig.voidDamageHeight) break block5;
                if (this.t.getWorld().getEnvironment() != World.Environment.NETHER || !this.t.paperConfig().environment.netherCeilingVoidDamageHeight.test(v2 -> this.dt() >= (double)v2)) break block6;
                Entity entity2 = this;
                if (!(entity2 instanceof EntityHuman)) break block5;
                EntityHuman player = (EntityHuman)entity2;
                if (player.fT().a) break block6;
            }
            if (this.dM().purpurConfig.teleportOnNetherCeilingDamage && this.t.getWorld().getEnvironment() == World.Environment.NETHER && (entity = this) instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                player.teleport(MCUtil.toLocation(this.t, this.t.T()));
            } else {
                this.aB();
            }
        }
    }

    public void au() {
        this.bb = this.bJ();
    }

    public void f(int portalCooldown) {
        this.bb = portalCooldown;
    }

    public int av() {
        return this.bb;
    }

    public boolean aw() {
        return this.bb > 0;
    }

    protected void L() {
        if (this.aw()) {
            --this.bb;
        }
    }

    public int ax() {
        return 0;
    }

    public void ay() {
        if (!this.aY()) {
            if (this instanceof EntityLiving && this.aN <= 0) {
                CraftBlock damager = this.lastLavaContact == null ? null : CraftBlock.at(this.t, this.lastLavaContact);
                CraftEntity damagee = this.getBukkitEntity();
                EntityCombustByBlockEvent combustEvent = new EntityCombustByBlockEvent((org.bukkit.block.Block)damager, (org.bukkit.entity.Entity)damagee, 15);
                this.t.getCraftServer().getPluginManager().callEvent((Event)combustEvent);
                if (!combustEvent.isCancelled()) {
                    this.setSecondsOnFire(combustEvent.getDuration(), false);
                }
            } else {
                this.setSecondsOnFire(15, false);
            }
            if (this.a(this.dN().d().directBlock(this.t, this.lastLavaContact), 4.0f)) {
                this.a(SoundEffects.jw, 0.4f, 2.0f + this.ag.i() * 0.4f);
            }
        }
    }

    public void g(int seconds) {
        this.setSecondsOnFire(seconds, true);
    }

    public void setSecondsOnFire(int i2, boolean callEvent) {
        if (callEvent) {
            EntityCombustEvent event = new EntityCombustEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), i2);
            this.t.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            i2 = event.getDuration();
        }
        int j2 = i2 * 20;
        if (this instanceof EntityLiving) {
            j2 = EnchantmentProtection.a((EntityLiving)this, j2);
        }
        if (this.aN < j2) {
            this.h(j2);
        }
    }

    public void h(int fireTicks) {
        this.aN = fireTicks;
    }

    public int az() {
        return this.aN;
    }

    public void aA() {
        this.h(0);
    }

    protected void aB() {
        this.discard(EntityRemoveEvent.Cause.OUT_OF_WORLD);
    }

    public boolean g(double offsetX, double offsetY, double offsetZ) {
        return this.b(this.cH().d(offsetX, offsetY, offsetZ));
    }

    private boolean b(AxisAlignedBB box) {
        return this.dM().a(this, box) && !this.dM().d(box);
    }

    public void c(boolean onGround) {
        this.aJ = onGround;
        this.b(onGround, (Vec3D)null);
    }

    public void a(boolean onGround, Vec3D movement) {
        this.aJ = onGround;
        this.b(onGround, movement);
    }

    public boolean d(BlockPosition pos) {
        return this.aD.isPresent() && this.aD.get().equals(pos);
    }

    protected void b(boolean onGround, @javax.annotation.Nullable Vec3D movement) {
        if (onGround) {
            AxisAlignedBB axisalignedbb = this.cH();
            AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.a, axisalignedbb.b - 1.0E-6, axisalignedbb.c, axisalignedbb.d, axisalignedbb.b, axisalignedbb.f);
            Optional<BlockPosition> optional = this.t.g(this, axisalignedbb1);
            if (!optional.isPresent() && !this.bj) {
                if (movement != null) {
                    AxisAlignedBB axisalignedbb2 = axisalignedbb1.d(-movement.c, 0.0, -movement.e);
                    optional = this.t.g(this, axisalignedbb2);
                    this.aD = optional;
                }
            } else {
                this.aD = optional;
            }
            this.bj = optional.isEmpty();
        } else {
            this.bj = false;
            if (this.aD.isPresent()) {
                this.aD = Optional.empty();
            }
        }
    }

    public boolean aC() {
        return this.aJ;
    }

    public final Vec3D getMoveVector() {
        return this.moveVector;
    }

    public final double getMoveStartX() {
        return this.moveStartX;
    }

    public final double getMoveStartY() {
        return this.moveStartY;
    }

    public final double getMoveStartZ() {
        return this.moveStartZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(EnumMoveType movementType, Vec3D movement) {
        Vec3D originalMovement = movement;
        TickThread.ensureTickThread("Cannot move an entity off-main");
        Object object = this.posLock;
        synchronized (object) {
            this.moveStartX = this.dr();
            this.moveStartY = this.dt();
            this.moveStartZ = this.dx();
            this.moveVector = movement;
        }
        try {
            if (this.af) {
                this.a_(this.dr() + movement.c, this.dt() + movement.d, this.dx() + movement.e);
            } else {
                this.aC = this.bN();
                if (movementType == EnumMoveType.c) {
                    this.activatedTick = Math.max(this.activatedTick, (long)(MinecraftServer.currentTick + 20));
                    this.activatedImmunityTick = Math.max(this.activatedImmunityTick, (long)(MinecraftServer.currentTick + 20));
                    if ((movement = this.d(movement)).equals(Vec3D.b)) {
                        return;
                    }
                }
                if (this.U.g() > 1.0E-7) {
                    movement = movement.h(this.U);
                    this.U = Vec3D.b;
                    this.g(Vec3D.b);
                }
                if (this.isTemporarilyActive && !(this instanceof EntityItem) && movement == this.dp() && movementType == EnumMoveType.a) {
                    this.g(Vec3D.b);
                    return;
                }
                Vec3D vec3d1 = this.a(movement = this.a(movement, movementType));
                double d0 = vec3d1.g();
                if (d0 > 1.0E-7) {
                    MovingObjectPositionBlock movingobjectpositionblock;
                    if (this.ab != 0.0f && d0 >= 1.0 && (movingobjectpositionblock = this.dM().a(new RayTrace(this.dk(), this.dk().e(vec3d1), RayTrace.BlockCollisionOption.d, RayTrace.FluidCollisionOption.d, this))).c() != MovingObjectPosition.EnumMovingObjectType.a) {
                        this.n();
                    }
                    this.a_(this.dr() + vec3d1.c, this.dt() + vec3d1.d, this.dx() + vec3d1.e);
                }
                boolean flag = !MathHelper.b(movement.c, vec3d1.c);
                boolean flag1 = !MathHelper.b(movement.e, vec3d1.e);
                this.P = flag || flag1;
                this.Q = movement.d != vec3d1.d;
                this.R = this.Q && movement.d < 0.0;
                this.S = this.P ? this.c(vec3d1) : false;
                this.a(this.R, vec3d1);
                BlockPosition blockposition = this.aH();
                IBlockData iblockdata = this.dM().a_(blockposition);
                this.a(vec3d1.d, this.aC(), iblockdata, blockposition);
                if (this.dH()) {
                } else {
                    MovementEmission entity_movementemission;
                    if (this.P) {
                        Vec3D vec3d2 = this.dp();
                        this.o(flag ? 0.0 : vec3d2.c, vec3d2.d, flag1 ? 0.0 : vec3d2.e);
                    }
                    Block block = iblockdata.b();
                    if (movement.d != vec3d1.d) {
                        block.a(this.dM(), this);
                    }
                    if (this.P && this.getBukkitEntity() instanceof Vehicle) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        org.bukkit.block.Block bl = this.t.getWorld().getBlockAt(MathHelper.a(this.dr()), MathHelper.a(this.dt()), MathHelper.a(this.dx()));
                        if (movement.c > vec3d1.c) {
                            bl = bl.getRelative(BlockFace.EAST);
                        } else if (movement.c < vec3d1.c) {
                            bl = bl.getRelative(BlockFace.WEST);
                        } else if (movement.e > vec3d1.e) {
                            bl = bl.getRelative(BlockFace.SOUTH);
                        } else if (movement.e < vec3d1.e) {
                            bl = bl.getRelative(BlockFace.NORTH);
                        }
                        if (!bl.getType().isAir()) {
                            VehicleBlockCollisionEvent event = new VehicleBlockCollisionEvent(vehicle, bl, CraftVector.toBukkit(originalMovement));
                            this.t.getCraftServer().getPluginManager().callEvent((Event)event);
                        }
                    }
                    if (this.aC()) {
                        block.a(this.dM(), blockposition, iblockdata, this);
                    }
                    if ((entity_movementemission = this.aW()).a() && !this.bO()) {
                        double d1 = vec3d1.c;
                        double d2 = vec3d1.d;
                        double d3 = vec3d1.e;
                        this.aa += (float)(vec3d1.f() * 0.6);
                        BlockPosition blockposition1 = this.aJ();
                        IBlockData iblockdata1 = this.dM().a_(blockposition1);
                        boolean flag2 = this.c(iblockdata1);
                        if (!flag2) {
                            d2 = 0.0;
                        }
                        this.Y += (float)vec3d1.h() * 0.6f;
                        this.Z += (float)Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3) * 0.6f;
                        if (this.Z > this.aL && !iblockdata1.i()) {
                            boolean flag3 = blockposition1.equals(blockposition);
                            boolean flag4 = this.a(blockposition, iblockdata, entity_movementemission.c(), flag3, movement);
                            if (!flag3) {
                                flag4 |= this.a(blockposition1, iblockdata1, false, entity_movementemission.b(), movement);
                            }
                            if (flag4) {
                                this.aL = this.aM();
                            } else if (this.aZ()) {
                                this.aL = this.aM();
                                if (entity_movementemission.c()) {
                                    this.aR();
                                }
                                if (entity_movementemission.b()) {
                                    this.a(GameEvent.Q);
                                }
                            }
                        } else if (iblockdata1.i()) {
                            this.aG();
                        }
                    }
                    this.aD();
                    float f2 = this.aL();
                    this.g(this.dp().d(f2, 1.0, f2));
                    boolean noneMatch = true;
                    AxisAlignedBB fireSearchBox = this.cH().h(1.0E-6);
                    int minX = MathHelper.a(fireSearchBox.a);
                    int minY = MathHelper.a(fireSearchBox.b);
                    int minZ = MathHelper.a(fireSearchBox.c);
                    int maxX = MathHelper.a(fireSearchBox.d);
                    int maxY = MathHelper.a(fireSearchBox.e);
                    int maxZ = MathHelper.a(fireSearchBox.f);
                    block20: for (int fz = minZ; fz <= maxZ; ++fz) {
                        for (int fx = minX; fx <= maxX; ++fx) {
                            for (int fy = minY; fy <= maxY; ++fy) {
                                IBlockData type;
                                Chunk chunk = (Chunk)this.t.getChunkIfLoadedImmediately(fx >> 4, fz >> 4);
                                if (chunk == null) {
                                    noneMatch = true;
                                    break block20;
                                }
                                if (!noneMatch || !(type = chunk.getBlockStateFinal(fx, fy, fz)).a(TagsBlock.aJ) && !type.a(Blocks.H)) continue;
                                noneMatch = false;
                            }
                        }
                    }
                    if (noneMatch) {
                        if (this.aN <= 0) {
                            this.h(-this.dc());
                        }
                        if (this.aC && (this.aA || this.bb())) {
                            this.aE();
                        }
                    }
                    if (this.bN() && (this.aA || this.bb())) {
                        this.h(-this.dc());
                    }
                }
            }
        }
        finally {
            object = this.posLock;
            synchronized (object) {
                this.moveVector = null;
            }
        }
    }

    private boolean c(IBlockData state) {
        return state.a(TagsBlock.aO) || state.a(Blocks.qP);
    }

    private boolean a(BlockPosition pos, IBlockData state, boolean playSound, boolean emitEvent, Vec3D movement) {
        if (state.i()) {
            return false;
        }
        boolean flag2 = this.c(state);
        if ((this.aC() || flag2 || this.bX() && movement.d == 0.0 || this.cf()) && !this.bZ()) {
            if (playSound) {
                this.c(pos, state);
            }
            if (emitEvent) {
                this.dM().a(GameEvent.P, this.dk(), GameEvent.a.a(this, state));
            }
            return true;
        }
        return false;
    }

    protected boolean c(Vec3D adjustedMovement) {
        return false;
    }

    protected void aD() {
        try {
            this.aQ();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Checking entity block collision");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being checked for collision");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected void aE() {
        this.a(SoundEffects.jB, 0.7f, 1.6f + (this.ag.i() - this.ag.i()) * 0.4f);
    }

    public void aF() {
        if (!this.dM().B && this.aC) {
            this.aE();
        }
        this.aA();
    }

    protected void aG() {
        if (this.aT()) {
            this.aS();
            if (this.aW().b()) {
                this.a(GameEvent.x);
            }
        }
    }

    @Deprecated
    public BlockPosition aH() {
        return this.d(0.2f);
    }

    protected BlockPosition aI() {
        return this.d(0.500001f);
    }

    public BlockPosition aJ() {
        return this.d(1.0E-5f);
    }

    protected BlockPosition d(float offset) {
        if (this.aD.isPresent() && this.dM().getChunkIfLoadedImmediately(this.aD.get()) != null) {
            BlockPosition blockposition = this.aD.get();
            if (offset <= 1.0E-5f) {
                return blockposition;
            }
            IBlockData iblockdata = this.dM().a_(blockposition);
            return ((double)offset > 0.5 || !iblockdata.a(TagsBlock.S)) && !iblockdata.a(TagsBlock.L) && !(iblockdata.b() instanceof BlockFenceGate) ? blockposition.h(MathHelper.a(this.u.d - (double)offset)) : blockposition;
        }
        int i2 = MathHelper.a(this.u.c);
        int j2 = MathHelper.a(this.u.d - (double)offset);
        int k2 = MathHelper.a(this.u.e);
        return new BlockPosition(i2, j2, k2);
    }

    protected float aK() {
        float f2 = this.dM().a_(this.dm()).b().l();
        float f1 = this.dM().a_(this.aI()).b().l();
        return (double)f2 == 1.0 ? f1 : f2;
    }

    protected float aL() {
        IBlockData iblockdata = this.dM().a_(this.dm());
        float f2 = iblockdata.b().j();
        return !iblockdata.a(Blocks.G) && !iblockdata.a(Blocks.nd) ? ((double)f2 == 1.0 ? this.dM().a_(this.aI()).b().j() : f2) : f2;
    }

    protected Vec3D a(Vec3D movement, EnumMoveType type) {
        return movement;
    }

    protected Vec3D d(Vec3D movement) {
        if (movement.g() <= 1.0E-7) {
            return movement;
        }
        long i2 = this.dM().X();
        if (i2 != this.bg) {
            Arrays.fill(this.bf, 0.0);
            this.bg = i2;
        }
        if (movement.c != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.a, movement.c);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(d0, 0.0, 0.0);
        }
        if (movement.d != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.b, movement.d);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(0.0, d0, 0.0);
        }
        if (movement.e != 0.0) {
            double d0 = this.a(EnumDirection.EnumAxis.c, movement.e);
            return Math.abs(d0) <= (double)1.0E-5f ? Vec3D.b : new Vec3D(0.0, 0.0, d0);
        }
        return Vec3D.b;
    }

    private double a(EnumDirection.EnumAxis axis, double offsetFactor) {
        int i2 = axis.ordinal();
        double d1 = MathHelper.a(offsetFactor + this.bf[i2], -0.51, 0.51);
        offsetFactor = d1 - this.bf[i2];
        this.bf[i2] = d1;
        return offsetFactor;
    }

    private Vec3D a(Vec3D movement) {
        boolean zZero;
        boolean xZero = movement.c == 0.0;
        boolean yZero = movement.d == 0.0;
        boolean bl = zZero = movement.e == 0.0;
        if (xZero & yZero & zZero) {
            return movement;
        }
        net.minecraft.world.level.World world = this.t;
        AxisAlignedBB currBoundingBox = this.cH();
        if (CollisionUtil.isEmpty(currBoundingBox)) {
            return movement;
        }
        ArrayList<AxisAlignedBB> potentialCollisionsBB = new ArrayList<AxisAlignedBB>();
        ArrayList<VoxelShape> potentialCollisionsVoxel = new ArrayList<VoxelShape>();
        double stepHeight = this.dG();
        boolean onGround = this.aJ;
        AxisAlignedBB collisionBox = xZero & zZero ? (movement.d > 0.0 ? CollisionUtil.cutUpwards(currBoundingBox, movement.d) : CollisionUtil.cutDownwards(currBoundingBox, movement.d)) : (stepHeight > 0.0 && (onGround || movement.d < 0.0) ? (movement.d <= 0.0 ? CollisionUtil.expandUpwards(currBoundingBox.b(movement.c, movement.d, movement.e), stepHeight) : currBoundingBox.b(movement.c, Math.max(stepHeight, movement.d), movement.e)) : currBoundingBox.b(movement.c, movement.d, movement.e));
        CollisionUtil.getCollisions(world, this, collisionBox, potentialCollisionsVoxel, potentialCollisionsBB, 4, null, null);
        if (potentialCollisionsVoxel.isEmpty() && potentialCollisionsBB.isEmpty()) {
            return movement;
        }
        Vec3D limitedMoveVector = CollisionUtil.performCollisions(movement, currBoundingBox, potentialCollisionsVoxel, potentialCollisionsBB);
        if (stepHeight > 0.0 && (onGround || limitedMoveVector.d != movement.d && movement.d < 0.0) && (limitedMoveVector.c != movement.c || limitedMoveVector.e != movement.e)) {
            Vec3D vec3d4;
            Vec3D vec3d2 = CollisionUtil.performCollisions(new Vec3D(movement.c, stepHeight, movement.e), currBoundingBox, potentialCollisionsVoxel, potentialCollisionsBB);
            Vec3D vec3d3 = CollisionUtil.performCollisions(new Vec3D(0.0, stepHeight, 0.0), currBoundingBox.b(movement.c, 0.0, movement.e), potentialCollisionsVoxel, potentialCollisionsBB);
            if (vec3d3.d < stepHeight && (vec3d4 = CollisionUtil.performCollisions(new Vec3D(movement.c, 0.0, movement.e), currBoundingBox.c(vec3d3), potentialCollisionsVoxel, potentialCollisionsBB).e(vec3d3)).i() > vec3d2.i()) {
                vec3d2 = vec3d4;
            }
            if (vec3d2.i() > limitedMoveVector.i()) {
                return vec3d2.e(CollisionUtil.performCollisions(new Vec3D(0.0, -vec3d2.d + movement.d, 0.0), currBoundingBox.c(vec3d2), potentialCollisionsVoxel, potentialCollisionsBB));
            }
            return limitedMoveVector;
        }
        return limitedMoveVector;
    }

    public static Vec3D a(@javax.annotation.Nullable Entity entity, Vec3D movement, AxisAlignedBB entityBoundingBox, net.minecraft.world.level.World world, List<VoxelShape> collisions) {
        boolean flag;
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            builder.addAll(collisions);
        }
        WorldBorder worldborder = world.D_();
        boolean bl = flag = entity != null && worldborder.a(entity, entityBoundingBox.b(movement));
        if (flag) {
            builder.add((Object)worldborder.c());
        }
        builder.addAll(world.e(entity, entityBoundingBox.b(movement)));
        return Entity.a(movement, entityBoundingBox, (List<VoxelShape>)builder.build());
    }

    private static Vec3D a(Vec3D movement, AxisAlignedBB entityBoundingBox, List<VoxelShape> collisions) {
        boolean flag;
        if (collisions.isEmpty()) {
            return movement;
        }
        double d0 = movement.c;
        double d1 = movement.d;
        double d2 = movement.e;
        if (d1 != 0.0 && (d1 = VoxelShapes.a(EnumDirection.EnumAxis.b, entityBoundingBox, collisions, d1)) != 0.0) {
            entityBoundingBox = entityBoundingBox.d(0.0, d1, 0.0);
        }
        boolean bl = flag = Math.abs(d0) < Math.abs(d2);
        if (flag && d2 != 0.0 && (d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBoundingBox, collisions, d2)) != 0.0) {
            entityBoundingBox = entityBoundingBox.d(0.0, 0.0, d2);
        }
        if (d0 != 0.0) {
            d0 = VoxelShapes.a(EnumDirection.EnumAxis.a, entityBoundingBox, collisions, d0);
            if (!flag && d0 != 0.0) {
                entityBoundingBox = entityBoundingBox.d(d0, 0.0, 0.0);
            }
        }
        if (!flag && d2 != 0.0) {
            d2 = VoxelShapes.a(EnumDirection.EnumAxis.c, entityBoundingBox, collisions, d2);
        }
        return new Vec3D(d0, d1, d2);
    }

    protected float aM() {
        return (int)this.Z + 1;
    }

    protected SoundEffect aN() {
        return SoundEffects.jF;
    }

    protected SoundEffect aO() {
        return SoundEffects.jE;
    }

    protected SoundEffect aP() {
        return SoundEffects.jE;
    }

    public SoundEffect getSwimSound0() {
        return this.aN();
    }

    public SoundEffect getSwimSplashSound0() {
        return this.aO();
    }

    public SoundEffect getSwimHighSpeedSplashSound0() {
        return this.aP();
    }

    protected void aQ() {
        AxisAlignedBB axisalignedbb = this.cH();
        BlockPosition blockposition = BlockPosition.a(axisalignedbb.a + 1.0E-7, axisalignedbb.b + 1.0E-7, axisalignedbb.c + 1.0E-7);
        BlockPosition blockposition1 = BlockPosition.a(axisalignedbb.d - 1.0E-7, axisalignedbb.e - 1.0E-7, axisalignedbb.f - 1.0E-7);
        if (this.dM().a(blockposition, blockposition1)) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int i2 = blockposition.u(); i2 <= blockposition1.u(); ++i2) {
                for (int j2 = blockposition.v(); j2 <= blockposition1.v(); ++j2) {
                    for (int k2 = blockposition.w(); k2 <= blockposition1.w(); ++k2) {
                        if (!this.bx()) {
                            return;
                        }
                        blockposition_mutableblockposition.d(i2, j2, k2);
                        IBlockData iblockdata = this.dM().a_(blockposition_mutableblockposition);
                        try {
                            iblockdata.a(this.dM(), (BlockPosition)blockposition_mutableblockposition, this);
                            this.a(iblockdata);
                            continue;
                        }
                        catch (Throwable throwable) {
                            CrashReport crashreport = CrashReport.a(throwable, "Colliding entity with block");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Block being collided with");
                            CrashReportSystemDetails.a(crashreportsystemdetails, this.dM(), blockposition_mutableblockposition, iblockdata);
                            throw new ReportedException(crashreport);
                        }
                    }
                }
            }
        }
    }

    protected void a(IBlockData state) {
    }

    public void a(GameEvent event, @javax.annotation.Nullable Entity entity) {
        this.dM().a(entity, event, this.u);
    }

    public void a(GameEvent event) {
        this.a(event, this);
    }

    private void c(BlockPosition pos, IBlockData state) {
        this.b(pos, state);
        if (this.d(state)) {
            this.s();
        }
    }

    protected void aR() {
        Entity entity = Objects.requireNonNullElse(this.cN(), this);
        float f2 = entity == this ? 0.35f : 0.4f;
        Vec3D vec3d = entity.dp();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.c * vec3d.c * (double)0.2f + vec3d.d * vec3d.d + vec3d.e * vec3d.e * (double)0.2f) * f2);
        this.e(f1);
    }

    protected BlockPosition e(BlockPosition pos) {
        BlockPosition blockposition1 = pos.c();
        IBlockData iblockdata = this.dM().a_(blockposition1);
        return !iblockdata.a(TagsBlock.bm) && !iblockdata.a(TagsBlock.bn) ? pos : blockposition1;
    }

    protected void a(IBlockData primaryState, IBlockData secondaryState) {
        SoundEffectType soundeffecttype = primaryState.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
        this.b(secondaryState);
    }

    protected void b(IBlockData state) {
        SoundEffectType soundeffecttype = state.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.05f, soundeffecttype.b() * 0.8f);
    }

    protected void b(BlockPosition pos, IBlockData state) {
        SoundEffectType soundeffecttype = state.w();
        this.a(soundeffecttype.d(), soundeffecttype.a() * 0.15f, soundeffecttype.b());
    }

    private boolean d(IBlockData state) {
        return state.a(TagsBlock.bl) && this.ah >= this.bl + 20;
    }

    private void s() {
        this.bk *= (float)Math.pow(0.997, this.ah - this.bl);
        this.bk = Math.min(1.0f, this.bk + 0.07f);
        float f2 = 0.5f + this.bk * this.ag.i() * 1.2f;
        float f1 = 0.1f + this.bk * 1.2f;
        this.a(SoundEffects.E, f1, f2);
        this.bl = this.ah;
    }

    protected void e(float volume) {
        this.a(this.aN(), volume, 1.0f + (this.ag.i() - this.ag.i()) * 0.4f);
    }

    protected void aS() {
    }

    protected boolean aT() {
        return false;
    }

    public void a(SoundEffect sound, float volume, float pitch) {
        if (!this.aU()) {
            this.dM().a((EntityHuman)null, this.dr(), this.dt(), this.dx(), sound, this.db(), volume, pitch);
        }
    }

    public void a(SoundEffect event) {
        if (!this.aU()) {
            this.a(event, 1.0f, 1.0f);
        }
    }

    public boolean aU() {
        return this.an.b(aW);
    }

    public void d(boolean silent) {
        this.an.b(aW, silent);
    }

    public boolean aV() {
        return this.an.b(aX);
    }

    public void e(boolean noGravity) {
        this.an.b(aX, noGravity);
    }

    protected MovementEmission aW() {
        return MovementEmission.d;
    }

    public boolean aX() {
        return false;
    }

    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
        if (onGround) {
            if (this.ab > 0.0f) {
                state.b().a(this.dM(), state, landedPosition, this, this.ab);
                this.dM().a(GameEvent.A, this.u, GameEvent.a.a(this, this.aD.map(blockposition1 -> this.dM().a_((BlockPosition)blockposition1)).orElse(state)));
            }
            this.n();
        } else if (heightDifference < 0.0) {
            this.ab -= (float)heightDifference;
        }
    }

    public boolean aY() {
        return this.immuneToFire != null ? this.immuneToFire.booleanValue() : this.ai().d();
    }

    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        if (this.p.a(TagsEntity.o)) {
            return false;
        }
        if (this.bP()) {
            for (Entity entity : this.cP()) {
                entity.a(fallDistance, damageMultiplier, damageSource);
            }
        }
        return false;
    }

    public boolean aZ() {
        return this.ai;
    }

    public boolean isInRain0() {
        BlockPosition blockposition = this.dm();
        return this.dM().r(blockposition) || this.dM().r(BlockPosition.a((double)blockposition.u(), this.cH().e, (double)blockposition.w()));
    }

    public boolean x() {
        return this.dM().a_(this.dm()).a(Blocks.nd);
    }

    public boolean ba() {
        return this.aZ() || this.isInRain0();
    }

    public boolean bb() {
        return this.aZ() || this.isInRain0() || this.x();
    }

    public boolean bc() {
        return this.aZ() || this.x();
    }

    public boolean bd() {
        return this.bc() || this.bn();
    }

    public boolean be() {
        return this.ak && this.aZ();
    }

    public void bf() {
        if (this.bZ()) {
            this.h(this.bY() && this.aZ() && !this.bO());
        } else {
            this.h(this.bY() && this.be() && !this.bO() && this.dM().b_(this.v).a(TagsFluid.a));
        }
    }

    protected boolean bg() {
        this.aj.clear();
        this.bh();
        double d0 = this.dM().E_().i() ? 0.007 : 0.0023333333333333335;
        boolean flag = this.a(TagsFluid.b, d0);
        return this.aZ() || flag;
    }

    public void bh() {
        EntityBoat entityboat;
        Entity entity = this.cZ();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).be()) {
            this.ai = false;
            return;
        }
        if (this.a(TagsFluid.a, 0.014)) {
            if (!this.ai && !this.am) {
                this.bi();
            }
            this.n();
            this.ai = true;
            this.aA();
        } else {
            this.ai = false;
        }
    }

    private void y() {
        EntityBoat entityboat;
        this.ak = this.a(TagsFluid.a);
        this.aO.clear();
        double d0 = this.dv() - 0.1111111119389534;
        Entity entity = this.cZ();
        if (entity instanceof EntityBoat && !(entityboat = (EntityBoat)entity).be() && entityboat.cH().e >= d0 && entityboat.cH().b <= d0) {
            return;
        }
        BlockPosition blockposition = BlockPosition.a(this.dr(), d0, this.dx());
        Fluid fluid = this.dM().b_(blockposition);
        double d1 = (float)blockposition.v() + fluid.a((IBlockAccess)this.dM(), blockposition);
        if (d1 > d0) {
            Stream<TagKey<FluidType>> stream = fluid.k();
            Set<TagKey<FluidType>> set = this.aO;
            Objects.requireNonNull(this.aO);
            stream.forEach(set::add);
        }
    }

    protected void bi() {
        double d1;
        double d0;
        Entity entity = Objects.requireNonNullElse(this.cN(), this);
        float f2 = entity == this ? 0.2f : 0.9f;
        Vec3D vec3d = entity.dp();
        float f1 = Math.min(1.0f, (float)Math.sqrt(vec3d.c * vec3d.c * (double)0.2f + vec3d.d * vec3d.d + vec3d.e * vec3d.e * (double)0.2f) * f2);
        if (f1 < 0.25f) {
            this.a(this.aO(), f1, 1.0f + (this.ag.i() - this.ag.i()) * 0.4f);
        } else {
            this.a(this.aP(), f1, 1.0f + (this.ag.i() - this.ag.i()) * 0.4f);
        }
        float f22 = MathHelper.a(this.dt());
        int i2 = 0;
        while ((float)i2 < 1.0f + this.bh.a * 20.0f) {
            d0 = (this.ag.j() * 2.0 - 1.0) * (double)this.bh.a;
            d1 = (this.ag.j() * 2.0 - 1.0) * (double)this.bh.a;
            this.dM().a(Particles.e, this.dr() + d0, (double)(f22 + 1.0f), this.dx() + d1, vec3d.c, vec3d.d - this.ag.j() * (double)0.2f, vec3d.e);
            ++i2;
        }
        i2 = 0;
        while ((float)i2 < 1.0f + this.bh.a * 20.0f) {
            d0 = (this.ag.j() * 2.0 - 1.0) * (double)this.bh.a;
            d1 = (this.ag.j() * 2.0 - 1.0) * (double)this.bh.a;
            this.dM().a(Particles.aj, this.dr() + d0, (double)(f22 + 1.0f), this.dx() + d1, vec3d.c, vec3d.d, vec3d.e);
            ++i2;
        }
        this.a(GameEvent.O);
    }

    @Deprecated
    protected IBlockData bj() {
        return this.dM().a_(this.aH());
    }

    public IBlockData bk() {
        return this.dM().a_(this.aJ());
    }

    public boolean bl() {
        return this.bY() && !this.aZ() && !this.P_() && !this.bX() && !this.bn() && this.bx();
    }

    protected void bm() {
        BlockPosition blockposition = this.aH();
        IBlockData iblockdata = this.dM().a_(blockposition);
        if (iblockdata.l() != EnumRenderType.a) {
            Vec3D vec3d = this.dp();
            BlockPosition blockposition1 = this.dm();
            double d0 = this.dr() + (this.ag.j() - 0.5) * (double)this.bh.a;
            double d1 = this.dx() + (this.ag.j() - 0.5) * (double)this.bh.a;
            if (blockposition1.u() != blockposition.u()) {
                d0 = MathHelper.a(d0, (double)blockposition.u(), (double)blockposition.u() + 1.0);
            }
            if (blockposition1.w() != blockposition.w()) {
                d1 = MathHelper.a(d1, (double)blockposition.w(), (double)blockposition.w() + 1.0);
            }
            this.dM().a(new ParticleParamBlock(Particles.c, iblockdata), d0, this.dt() + 0.1, d1, vec3d.c * -4.0, 1.5, vec3d.e * -4.0);
        }
    }

    public boolean a(TagKey<FluidType> fluidTag) {
        return this.aO.contains(fluidTag);
    }

    public boolean bn() {
        return !this.am && this.aj.getDouble(TagsFluid.b) > 0.0;
    }

    public void a(float speed, Vec3D movementInput) {
        Vec3D vec3d1 = Entity.a(movementInput, speed, this.dC());
        this.g(this.dp().e(vec3d1));
    }

    private static Vec3D a(Vec3D movementInput, float speed, float yaw) {
        double d0 = movementInput.g();
        if (d0 < 1.0E-7) {
            return Vec3D.b;
        }
        Vec3D vec3d1 = (d0 > 1.0 ? movementInput.d() : movementInput).a((double)speed);
        float f2 = MathHelper.a(yaw * ((float)Math.PI / 180));
        float f3 = MathHelper.b(yaw * ((float)Math.PI / 180));
        return new Vec3D(vec3d1.c * (double)f3 - vec3d1.e * (double)f2, vec3d1.d, vec3d1.e * (double)f3 + vec3d1.c * (double)f2);
    }

    @Deprecated
    public float bo() {
        return this.dM().f(this.dq(), this.dw()) ? this.dM().x(BlockPosition.a(this.dr(), this.dv(), this.dx())) : 0.0f;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch) {
        this.h(x2, y2, z2);
        this.r(yaw % 360.0f);
        this.s(MathHelper.a(pitch, -90.0f, 90.0f) % 360.0f);
        this.N = this.dC();
        this.O = this.dE();
        this.n(yaw);
    }

    public void h(double x2, double y2, double z2) {
        double d3 = MathHelper.a(x2, -3.0E7, 3.0E7);
        double d4 = MathHelper.a(z2, -3.0E7, 3.0E7);
        this.K = d3;
        this.L = y2;
        this.M = d4;
        this.a_(d3, y2, d4);
        if (this.valid) {
            this.t.d((int)Math.floor(this.dr()) >> 4, (int)Math.floor(this.dx()) >> 4);
        }
    }

    public void e(Vec3D pos) {
        this.e(pos.c, pos.d, pos.e);
    }

    public void e(double x2, double y2, double z2) {
        this.b(x2, y2, z2, this.dC(), this.dE());
    }

    public void a(BlockPosition pos, float yaw, float pitch) {
        this.b((double)pos.u() + 0.5, pos.v(), (double)pos.w() + 0.5, yaw, pitch);
    }

    public void b(double x2, double y2, double z2, float yaw, float pitch) {
        if (!this.preserveMotion) {
            this.aF = Vec3D.b;
        } else {
            this.preserveMotion = false;
        }
        this.p(x2, y2, z2);
        this.r(yaw);
        this.s(pitch);
        this.bp();
        this.ar();
        this.n(yaw);
    }

    public final void bp() {
        double d0 = this.dr();
        double d1 = this.dt();
        double d2 = this.dx();
        this.K = d0;
        this.L = d1;
        this.M = d2;
        this.ac = d0;
        this.ad = d1;
        this.ae = d2;
        this.N = this.dC();
        this.O = this.dE();
    }

    public float e(Entity entity) {
        float f2 = (float)(this.dr() - entity.dr());
        float f1 = (float)(this.dt() - entity.dt());
        float f22 = (float)(this.dx() - entity.dx());
        return MathHelper.c(f2 * f2 + f1 * f1 + f22 * f22);
    }

    public double i(double x2, double y2, double z2) {
        double d3 = this.dr() - x2;
        double d4 = this.dt() - y2;
        double d5 = this.dx() - z2;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public double f(Entity entity) {
        return this.f(entity.dk());
    }

    public double f(Vec3D vector) {
        double d0 = this.dr() - vector.c;
        double d1 = this.dt() - vector.d;
        double d2 = this.dx() - vector.e;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void b_(EntityHuman player) {
    }

    public void g(Entity entity) {
        if (!(this.y(entity) || entity.af || this.af)) {
            double d1;
            if (this.t.paperConfig().collisions.onlyPlayersCollide && !(entity instanceof EntityPlayer) && !(this instanceof EntityPlayer)) {
                return;
            }
            double d0 = entity.dr() - this.dr();
            double d2 = MathHelper.a(d0, d1 = entity.dx() - this.dx());
            if (d2 >= (double)0.01f) {
                d2 = Math.sqrt(d2);
                d0 /= d2;
                d1 /= d2;
                double d3 = 1.0 / d2;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                d0 *= d3;
                d1 *= d3;
                d0 *= (double)0.05f;
                d1 *= (double)0.05f;
                if (!this.bP() && this.bu()) {
                    this.j(-d0, 0.0, -d1);
                }
                if (!entity.bP() && entity.bu()) {
                    entity.j(d0, 0.0, d1);
                }
            }
        }
    }

    public final void j(double deltaX, double deltaY, double deltaZ) {
        this.push(deltaX, deltaY, deltaZ, null);
    }

    public void push(double deltaX, double deltaY, double deltaZ, @Nullable Entity pushingEntity) {
        Vector delta = new Vector(deltaX, deltaY, deltaZ);
        if (pushingEntity != null) {
            EntityPushedByEntityAttackEvent event = new EntityPushedByEntityAttackEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)pushingEntity.getBukkitEntity(), delta);
            if (!event.callEvent()) {
                return;
            }
            delta = event.getAcceleration();
        }
        this.g(this.dp().b(delta.getX(), delta.getY(), delta.getZ()));
        this.au = true;
    }

    protected void bq() {
        this.T = true;
    }

    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        this.bq();
        return false;
    }

    public final Vec3D f(float tickDelta) {
        return this.b(this.g(tickDelta), this.h(tickDelta));
    }

    public float g(float tickDelta) {
        return tickDelta == 1.0f ? this.dE() : MathHelper.i(tickDelta, this.O, this.dE());
    }

    public float h(float tickDelta) {
        return tickDelta == 1.0f ? this.dC() : MathHelper.i(tickDelta, this.N, this.dC());
    }

    protected final Vec3D b(float pitch, float yaw) {
        float f2 = pitch * ((float)Math.PI / 180);
        float f3 = -yaw * ((float)Math.PI / 180);
        float f4 = MathHelper.b(f3);
        float f5 = MathHelper.a(f3);
        float f6 = MathHelper.b(f2);
        float f7 = MathHelper.a(f2);
        return new Vec3D(f5 * f6, -f7, f4 * f6);
    }

    public final Vec3D i(float tickDelta) {
        return this.c(this.g(tickDelta), this.h(tickDelta));
    }

    protected final Vec3D c(float pitch, float yaw) {
        return this.b(pitch - 90.0f, yaw);
    }

    public final Vec3D br() {
        return new Vec3D(this.dr(), this.dv(), this.dx());
    }

    public final Vec3D j(float tickDelta) {
        double d0 = MathHelper.d((double)tickDelta, this.K, this.dr());
        double d1 = MathHelper.d((double)tickDelta, this.L, this.dt()) + (double)this.cI();
        double d2 = MathHelper.d((double)tickDelta, this.M, this.dx());
        return new Vec3D(d0, d1, d2);
    }

    public Vec3D k(float tickDelta) {
        return this.j(tickDelta);
    }

    public final Vec3D l(float delta) {
        double d0 = MathHelper.d((double)delta, this.K, this.dr());
        double d1 = MathHelper.d((double)delta, this.L, this.dt());
        double d2 = MathHelper.d((double)delta, this.M, this.dx());
        return new Vec3D(d0, d1, d2);
    }

    public MovingObjectPosition a(double maxDistance, float tickDelta, boolean includeFluids) {
        Vec3D vec3d = this.j(tickDelta);
        Vec3D vec3d1 = this.f(tickDelta);
        Vec3D vec3d2 = vec3d.b(vec3d1.c * maxDistance, vec3d1.d * maxDistance, vec3d1.e * maxDistance);
        return this.dM().a(new RayTrace(vec3d, vec3d2, RayTrace.BlockCollisionOption.b, includeFluids ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, this));
    }

    public boolean bs() {
        return this.bx() && this.bt();
    }

    public boolean bt() {
        return false;
    }

    public boolean bu() {
        return this.isCollidable(false);
    }

    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    public boolean canCollideWithBukkit(Entity entity) {
        return this.bu();
    }

    public void a(Entity entityKilled, int score, DamageSource damageSource) {
        if (entityKilled instanceof EntityPlayer) {
            CriterionTriggers.d.a((EntityPlayer)entityKilled, this, damageSource);
        }
    }

    public boolean k(double cameraX, double cameraY, double cameraZ) {
        double d3 = this.dr() - cameraX;
        double d4 = this.dt() - cameraY;
        double d5 = this.dx() - cameraZ;
        double d6 = d3 * d3 + d4 * d4 + d5 * d5;
        return this.a(d6);
    }

    public boolean a(double distance) {
        double d1 = this.cH().a();
        if (Double.isNaN(d1)) {
            d1 = 1.0;
        }
        return distance < (d1 *= 64.0 * o) * d1;
    }

    public boolean d(NBTTagCompound nbt) {
        return this.saveAsPassenger(nbt, true);
    }

    public boolean saveAsPassenger(NBTTagCompound nbttagcompound, boolean includeAll) {
        if (this.aK != null && !this.aK.b()) {
            return false;
        }
        String s2 = this.bw();
        if (!this.persist || s2 == null) {
            return false;
        }
        nbttagcompound.a(w, s2);
        this.saveWithoutId(nbttagcompound, includeAll);
        return true;
    }

    public boolean serializeEntity(NBTTagCompound compound) {
        ArrayList<Entity> pass = new ArrayList<Entity>(this.cP());
        this.r = ImmutableList.of();
        boolean result = this.e(compound);
        this.r = ImmutableList.copyOf(pass);
        return result;
    }

    public boolean e(NBTTagCompound nbt) {
        return this.bO() ? false : this.d(nbt);
    }

    public NBTTagCompound f(NBTTagCompound nbt) {
        return this.saveWithoutId(nbt, true);
    }

    public NBTTagCompound saveWithoutId(NBTTagCompound nbttagcompound, boolean includeAll) {
        try {
            NBTTagList nbttaglist;
            int i2;
            if (includeAll) {
                if (this.s != null) {
                    nbttagcompound.a("Pos", this.a(new double[]{this.s.dr(), this.dt(), this.s.dx()}));
                } else {
                    nbttagcompound.a("Pos", this.a(new double[]{this.dr(), this.dt(), this.dx()}));
                }
            }
            Vec3D vec3d = this.dp();
            nbttagcompound.a("Motion", this.a(new double[]{vec3d.c, vec3d.d, vec3d.e}));
            if (Float.isNaN(this.aG)) {
                this.aG = 0.0f;
            }
            if (Float.isNaN(this.aH)) {
                this.aH = 0.0f;
            }
            nbttagcompound.a("Rotation", this.a(new float[]{this.dC(), this.dE()}));
            nbttagcompound.a("FallDistance", this.ab);
            nbttagcompound.a("Fire", (short)this.aN);
            nbttagcompound.a("Air", (short)this.ci());
            nbttagcompound.a("OnGround", this.aC());
            nbttagcompound.a("Invulnerable", this.bc);
            nbttagcompound.a("PortalCooldown", this.bb);
            if (includeAll) {
                nbttagcompound.a(H, this.cw());
                nbttagcompound.a("WorldUUIDLeast", ((WorldServer)this.t).getWorld().getUID().getLeastSignificantBits());
                nbttagcompound.a("WorldUUIDMost", ((WorldServer)this.t).getWorld().getUID().getMostSignificantBits());
            }
            nbttagcompound.a("Bukkit.updateLevel", 2);
            if (!this.persist) {
                nbttagcompound.a("Bukkit.persist", this.persist);
            }
            if (!this.visibleByDefault) {
                nbttagcompound.a("Bukkit.visibleByDefault", this.visibleByDefault);
            }
            if (this.persistentInvisibility) {
                nbttagcompound.a("Bukkit.invisible", this.persistentInvisibility);
            }
            if (this.maxAirTicks != this.getDefaultMaxAirSupply()) {
                nbttagcompound.a("Bukkit.MaxAirSupply", this.ch());
            }
            nbttagcompound.a("Spigot.ticksLived", this.ah);
            IChatBaseComponent ichatbasecomponent = this.af();
            if (ichatbasecomponent != null) {
                nbttagcompound.a("CustomName", IChatBaseComponent.ChatSerializer.a(ichatbasecomponent));
            }
            if (this.cB()) {
                nbttagcompound.a("CustomNameVisible", this.cB());
            }
            if (this.aU()) {
                nbttagcompound.a("Silent", this.aU());
            }
            if (this.aV()) {
                nbttagcompound.a("NoGravity", this.aV());
            }
            if (this.bd) {
                nbttagcompound.a("Glowing", true);
            }
            if ((i2 = this.cj()) > 0) {
                nbttagcompound.a("TicksFrozen", this.cj());
            }
            if (this.bm) {
                nbttagcompound.a("HasVisualFire", this.bm);
            }
            if (!this.be.isEmpty()) {
                nbttaglist = new NBTTagList();
                for (String s2 : this.be) {
                    nbttaglist.add(NBTTagString.a(s2));
                }
                nbttagcompound.a("Tags", nbttaglist);
            }
            this.addAdditionalSaveData(nbttagcompound, includeAll);
            if (this.bP()) {
                nbttaglist = new NBTTagList();
                for (Entity entity : this.cP()) {
                    NBTTagCompound nbttagcompound1;
                    if (!entity.saveAsPassenger(nbttagcompound1 = new NBTTagCompound(), includeAll)) continue;
                    nbttaglist.add(nbttagcompound1);
                }
                if (!nbttaglist.isEmpty()) {
                    nbttagcompound.a(x, nbttaglist);
                }
            }
            if (this.bukkitEntity != null) {
                this.bukkitEntity.storeBukkitValues(nbttagcompound);
            }
            if (this.origin != null) {
                UUID originWorld;
                UUID uUID = this.originWorld != null ? this.originWorld : (originWorld = this.t != null ? this.t.getWorld().getUID() : null);
                if (originWorld != null) {
                    nbttagcompound.a("Paper.OriginWorld", originWorld);
                }
                nbttagcompound.a("Paper.Origin", this.a(new double[]{this.origin.getX(), this.origin.getY(), this.origin.getZ()}));
            }
            if (this.spawnReason != null) {
                nbttagcompound.a("Paper.SpawnReason", this.spawnReason.name());
            }
            if (this.spawnedViaMobSpawner) {
                nbttagcompound.a("Paper.FromMobSpawner", true);
            }
            if (this.fromNetherPortal) {
                nbttagcompound.a("Paper.FromNetherPortal", true);
            }
            if (this.freezeLocked) {
                nbttagcompound.a("Paper.FreezeLock", true);
            }
            if (this.immuneToFire != null) {
                nbttagcompound.a("Purpur.FireImmune", this.immuneToFire);
            }
            return nbttagcompound;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Saving entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being saved");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void g(NBTTagCompound nbt) {
        try {
            NBTTagList originTag;
            NBTTagList nbttaglist = nbt.c("Pos", 6);
            NBTTagList nbttaglist1 = nbt.c("Motion", 6);
            NBTTagList nbttaglist2 = nbt.c("Rotation", 5);
            double d0 = nbttaglist1.h(0);
            double d1 = nbttaglist1.h(1);
            double d2 = nbttaglist1.h(2);
            this.o(Math.abs(d0) > 10.0 ? 0.0 : d0, Math.abs(d1) > 10.0 ? 0.0 : d1, Math.abs(d2) > 10.0 ? 0.0 : d2);
            double d3 = 3.0000512E7;
            this.p(MathHelper.a(nbttaglist.h(0), -3.0000512E7, 3.0000512E7), MathHelper.a(nbttaglist.h(1), -2.0E7, 2.0E7), MathHelper.a(nbttaglist.h(2), -3.0000512E7, 3.0000512E7));
            this.r(nbttaglist2.i(0));
            this.s(nbttaglist2.i(1));
            this.bp();
            this.n(this.dC());
            this.o(this.dC());
            this.ab = nbt.j("FallDistance");
            this.aN = nbt.g("Fire");
            if (nbt.e("Air")) {
                this.j(nbt.g("Air"));
            }
            this.aJ = nbt.q("OnGround");
            this.bc = nbt.q("Invulnerable");
            this.bb = nbt.h("PortalCooldown");
            if (nbt.b(H)) {
                this.ay = nbt.a(H);
                this.az = this.ay.toString();
            }
            if (!Double.isFinite(this.dr()) || !Double.isFinite(this.dt()) || !Double.isFinite(this.dx())) throw new IllegalStateException("Entity has invalid position");
            if (!Double.isFinite(this.dC()) || !Double.isFinite(this.dE())) throw new IllegalStateException("Entity has invalid rotation");
            this.ar();
            this.a(this.dC(), this.dE());
            if (nbt.b("CustomName", 8)) {
                String s2 = nbt.l("CustomName");
                try {
                    this.b(IChatBaseComponent.ChatSerializer.a(s2));
                }
                catch (Exception exception) {
                    c.warn("Failed to parse entity custom name {}", (Object)s2, (Object)exception);
                }
            }
            this.n(nbt.q("CustomNameVisible"));
            this.d(nbt.q("Silent"));
            this.e(nbt.q("NoGravity"));
            this.i(nbt.q("Glowing"));
            this.k(nbt.h("TicksFrozen"));
            this.bm = nbt.q("HasVisualFire");
            if (nbt.b("Tags", 9)) {
                this.be.clear();
                NBTTagList nbttaglist3 = nbt.c("Tags", 8);
                int i2 = Math.min(nbttaglist3.size(), 1024);
                for (int j2 = 0; j2 < i2; ++j2) {
                    this.be.add(nbttaglist3.j(j2));
                }
            }
            this.a(nbt);
            if (this.bv()) {
                this.ar();
            }
            if (this instanceof EntityLiving) {
                this.ah = nbt.h("Spigot.ticksLived");
            }
            this.persist = !nbt.e("Bukkit.persist") || nbt.q("Bukkit.persist");
            boolean bl = this.visibleByDefault = !nbt.e("Bukkit.visibleByDefault") || nbt.q("Bukkit.visibleByDefault");
            if (nbt.e("Bukkit.MaxAirSupply")) {
                this.maxAirTicks = nbt.h("Bukkit.MaxAirSupply");
            }
            this.getBukkitEntity().readBukkitValues(nbt);
            if (nbt.e("Bukkit.invisible")) {
                boolean bukkitInvisible = nbt.q("Bukkit.invisible");
                this.j(bukkitInvisible);
                this.persistentInvisibility = bukkitInvisible;
            }
            if (!(originTag = nbt.c("Paper.Origin", 6)).isEmpty()) {
                UUID originWorld = null;
                if (nbt.e("Paper.OriginWorld")) {
                    originWorld = nbt.a("Paper.OriginWorld");
                } else if (this.t != null) {
                    originWorld = this.t.getWorld().getUID();
                }
                this.originWorld = originWorld;
                this.origin = new Vector(originTag.h(0), originTag.h(1), originTag.h(2));
            }
            this.spawnedViaMobSpawner = nbt.q("Paper.FromMobSpawner");
            this.fromNetherPortal = nbt.q("Paper.FromNetherPortal");
            if (nbt.e("Paper.SpawnReason")) {
                String spawnReasonName = nbt.l("Paper.SpawnReason");
                try {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)spawnReasonName);
                }
                catch (Exception ignored) {
                    c.error("Unknown SpawnReason " + spawnReasonName + " for " + this);
                }
            }
            if (this.spawnReason == null) {
                if (this.spawnedViaMobSpawner) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.SPAWNER;
                } else if (this instanceof EntityInsentient && (this instanceof EntityAnimal || this instanceof EntityFish) && !((EntityInsentient)this).h(0.0) && !nbt.q("PersistenceRequired")) {
                    this.spawnReason = CreatureSpawnEvent.SpawnReason.NATURAL;
                }
            }
            if (this.spawnReason == null) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.DEFAULT;
            }
            if (nbt.e("Paper.FreezeLock")) {
                this.freezeLocked = nbt.q("Paper.FreezeLock");
            }
            if (!nbt.e("Purpur.FireImmune")) return;
            this.immuneToFire = nbt.q("Purpur.FireImmune");
            return;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.a(throwable, "Loading entity NBT");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Entity being loaded");
            this.a(crashreportsystemdetails);
            throw new ReportedException(crashreport);
        }
    }

    protected boolean bv() {
        return true;
    }

    @javax.annotation.Nullable
    public final String bw() {
        EntityTypes<?> entitytypes = this.ai();
        MinecraftKey minecraftkey = EntityTypes.a(entitytypes);
        return entitytypes.b() && minecraftkey != null ? minecraftkey.toString() : null;
    }

    protected void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        this.b(nbttagcompound);
    }

    protected abstract void a(NBTTagCompound var1);

    protected abstract void b(NBTTagCompound var1);

    protected NBTTagList a(double ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        double[] adouble1 = values;
        int i2 = values.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            double d0 = adouble1[j2];
            nbttaglist.add(NBTTagDouble.a(d0));
        }
        return nbttaglist;
    }

    protected NBTTagList a(float ... values) {
        NBTTagList nbttaglist = new NBTTagList();
        float[] afloat1 = values;
        int i2 = values.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            float f2 = afloat1[j2];
            nbttaglist.add(NBTTagFloat.a(f2));
        }
        return nbttaglist;
    }

    @javax.annotation.Nullable
    public EntityItem a(IMaterial item) {
        return this.a(item, 0);
    }

    @javax.annotation.Nullable
    public EntityItem a(IMaterial item, int yOffset) {
        return this.a(new ItemStack(item), (float)yOffset);
    }

    @javax.annotation.Nullable
    public EntityItem b(ItemStack stack) {
        return this.a(stack, 0.0f);
    }

    @javax.annotation.Nullable
    public EntityItem a(ItemStack stack, float yOffset) {
        return this.spawnAtLocation(stack, yOffset, null);
    }

    @javax.annotation.Nullable
    public EntityItem spawnAtLocation(ItemStack stack, float yOffset, @javax.annotation.Nullable Consumer<? super EntityItem> delayedAddConsumer) {
        if (stack.b()) {
            return null;
        }
        if (this.dM().B) {
            return null;
        }
        if (this instanceof EntityLiving && !((EntityLiving)this).forceDrops) {
            ((EntityLiving)this).drops.add(new DefaultDrop(stack, itemStack -> {
                EntityItem itemEntity = new EntityItem(this.t, this.dr(), this.dt() + (double)yOffset, this.dx(), (ItemStack)itemStack);
                itemEntity.u();
                this.t.b(itemEntity);
                if (delayedAddConsumer != null) {
                    delayedAddConsumer.accept(itemEntity);
                }
            }));
            return null;
        }
        EntityItem entityitem = new EntityItem(this.dM(), this.dr(), this.dt() + (double)yOffset, this.dx(), stack.p());
        stack.f(0);
        entityitem.u();
        return this.spawnAtLocation(entityitem);
    }

    @javax.annotation.Nullable
    public EntityItem spawnAtLocation(EntityItem entityitem) {
        EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        this.dM().b(entityitem);
        return entityitem;
    }

    public boolean bx() {
        return !this.dH();
    }

    public boolean by() {
        if (this.af) {
            return false;
        }
        float f2 = this.bh.a * 0.8f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.a(this.br(), f2, 1.0E-6, f2);
        if (CollisionUtil.isEmpty(axisalignedbb)) {
            return false;
        }
        BlockPosition.MutableBlockPosition tempPos = new BlockPosition.MutableBlockPosition();
        int minX = MathHelper.a(axisalignedbb.a);
        int minY = MathHelper.a(axisalignedbb.b);
        int minZ = MathHelper.a(axisalignedbb.c);
        int maxX = MathHelper.a(axisalignedbb.d);
        int maxY = MathHelper.a(axisalignedbb.e);
        int maxZ = MathHelper.a(axisalignedbb.f);
        ChunkProviderServer chunkProvider = (ChunkProviderServer)this.t.L();
        long lastChunkKey = ChunkCoordIntPair.a;
        Chunk lastChunk = null;
        for (int fz = minZ; fz <= maxZ; ++fz) {
            tempPos.r(fz);
            for (int fx = minX; fx <= maxX; ++fx) {
                int newChunkX = fx >> 4;
                int newChunkZ = fz >> 4;
                Chunk chunk = lastChunkKey == (lastChunkKey = CoordinateUtils.getChunkKey(newChunkX, newChunkZ)) ? lastChunk : chunkProvider.getChunkAtIfLoadedImmediately(newChunkX, newChunkZ);
                tempPos.p(fx);
                if (chunk == null) continue;
                for (int fy = minY; fy <= maxY; ++fy) {
                    VoxelShape collisionShape;
                    tempPos.q(fy);
                    IBlockData state = chunk.a_(tempPos);
                    if (state.emptyCollisionShape() || !state.o(this.t, tempPos) || (collisionShape = state.k(this.t, tempPos)).c()) continue;
                    AxisAlignedBB toCollide = axisalignedbb.d(-((double)fx), -((double)fy), -((double)fz));
                    AxisAlignedBB singleAABB = collisionShape.getSingleAABBRepresentation();
                    if (!(singleAABB != null ? CollisionUtil.voxelShapeIntersect(singleAABB, toCollide) : CollisionUtil.voxelShapeIntersectNoEmpty(collisionShape, toCollide))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public EnumInteractionResult a(EntityHuman player, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean h(Entity other) {
        return other.bz() && !this.y(other);
    }

    public boolean bz() {
        return false;
    }

    public void t() {
        this.g(Vec3D.b);
        this.l();
        if (this.bO()) {
            this.cZ().i(this);
        }
    }

    public final void i(Entity passenger) {
        if (this.x(passenger)) {
            this.a(passenger, Entity::a_);
        }
    }

    protected void a(Entity passenger, MoveFunction positionUpdater) {
        Vec3D vec3d = this.m(passenger);
        positionUpdater.accept(passenger, vec3d.c, vec3d.d + (double)passenger.k(this), vec3d.e);
    }

    public void j(Entity passenger) {
    }

    public float k(Entity vehicle) {
        return this.l(vehicle);
    }

    protected float l(Entity vehicle) {
        return 0.0f;
    }

    public Vec3D m(Entity passenger) {
        return new Vec3D(this.a(passenger, this.bh, 1.0f).rotateY(-this.aG * ((float)Math.PI / 180))).e(this.dk());
    }

    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b, 0.0f);
    }

    public boolean n(Entity entity) {
        return this.a(entity, false);
    }

    public boolean bA() {
        return this instanceof EntityLiving;
    }

    public boolean a(Entity entity, boolean force) {
        EntityMountEvent event;
        if (entity == this.s || entity.t != this.t) {
            return false;
        }
        if (!entity.bD()) {
            return false;
        }
        Entity entity1 = entity;
        while (entity1.s != null) {
            if (entity1.s == this) {
                return false;
            }
            entity1 = entity1.s;
        }
        if (!(force || this.o(entity) && entity.r(this))) {
            return false;
        }
        if (entity.getBukkitEntity() instanceof Vehicle && this.getBukkitEntity() instanceof LivingEntity) {
            event = new VehicleEnterEvent((Vehicle)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity());
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return false;
            }
        }
        event = new EntityMountEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity());
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.bO()) {
            this.ac();
        }
        this.b(EntityPose.a);
        this.s = entity;
        this.s.p(this);
        entity.B().filter(entity2 -> entity2 instanceof EntityPlayer).forEach(entity2 -> CriterionTriggers.S.a((EntityPlayer)entity2));
        return true;
    }

    protected boolean o(Entity entity) {
        return !this.bS() && this.J <= 0;
    }

    public void bB() {
        for (int i2 = this.r.size() - 1; i2 >= 0; --i2) {
            ((Entity)this.r.get(i2)).ac();
        }
    }

    public void bC() {
        this.stopRiding(false);
    }

    public void stopRiding(boolean suppressCancellation) {
        if (this.s != null) {
            Entity entity = this.s;
            this.s = null;
            if (!entity.removePassenger(this, suppressCancellation)) {
                this.s = entity;
            }
        }
    }

    public void ac() {
        this.bC();
    }

    protected void p(Entity passenger) {
        if (passenger.cZ() != this) {
            throw new IllegalStateException("Use x.startRiding(y), not y.addPassenger(x)");
        }
        if (this.r.isEmpty()) {
            this.r = ImmutableList.of((Object)passenger);
        } else {
            ArrayList list = Lists.newArrayList(this.r);
            if (!this.dM().B && passenger instanceof EntityHuman && !(this.cQ() instanceof EntityHuman)) {
                list.add(0, passenger);
            } else {
                list.add(passenger);
            }
            this.r = ImmutableList.copyOf((Collection)list);
        }
        if (this.isRidable() && this.r.get(0) == passenger && passenger instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)passenger;
            this.onMount(player);
            this.rider = player;
        }
        this.a(GameEvent.s, passenger);
    }

    protected boolean removePassenger(Entity entity) {
        return this.removePassenger(entity, false);
    }

    protected boolean removePassenger(Entity entity, boolean suppressCancellation) {
        EntityDismountEvent event;
        Entity orig;
        if (entity.cZ() == this) {
            throw new IllegalStateException("Use x.stopRiding(y), not y.removePassenger(x)");
        }
        CraftEntity craft = (CraftEntity)entity.getBukkitEntity().getVehicle();
        Entity entity2 = orig = craft == null ? null : craft.getHandle();
        if (this.getBukkitEntity() instanceof Vehicle && entity.getBukkitEntity() instanceof LivingEntity) {
            CraftEntity craftn;
            Entity n2;
            event = new VehicleExitEvent((Vehicle)this.getBukkitEntity(), (LivingEntity)entity.getBukkitEntity(), !suppressCancellation);
            if (this.valid) {
                Bukkit.getPluginManager().callEvent((Event)event);
            }
            Entity entity3 = n2 = (craftn = (CraftEntity)entity.getBukkitEntity().getVehicle()) == null ? null : craftn.getHandle();
            if (event.isCancelled() || n2 != orig) {
                return false;
            }
        }
        event = new EntityDismountEvent((org.bukkit.entity.Entity)entity.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity(), !suppressCancellation);
        if (this.valid) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        if (this.rider != null && this.r.get(0) == this.rider) {
            this.onDismount(this.rider);
            this.rider = null;
        }
        this.r = this.r.size() == 1 && this.r.get(0) == entity ? ImmutableList.of() : (ImmutableList)this.r.stream().filter(entity1 -> entity1 != entity).collect(ImmutableList.toImmutableList());
        entity.J = 60;
        this.a(GameEvent.q, entity);
        return true;
    }

    protected boolean r(Entity passenger) {
        return this.r.isEmpty();
    }

    protected boolean bD() {
        return true;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.a_(x2, y2, z2);
        this.a(yaw, pitch);
    }

    public double p_() {
        return this.dr();
    }

    public double N_() {
        return this.dt();
    }

    public double O_() {
        return this.dx();
    }

    public float f_() {
        return this.dE();
    }

    public float q_() {
        return this.dC();
    }

    public void a(float yaw, int interpolationSteps) {
        this.n(yaw);
    }

    public float bE() {
        return 0.0f;
    }

    public Vec3D bF() {
        return this.b(this.dE(), this.dC());
    }

    public Vec3D a(net.minecraft.world.item.Item item) {
        if (!(this instanceof EntityHuman)) {
            return Vec3D.b;
        }
        EntityHuman entityhuman = (EntityHuman)this;
        boolean flag = entityhuman.eU().a(item) && !entityhuman.eT().a(item);
        EnumMainHand enummainhand = flag ? entityhuman.fm().e() : entityhuman.fm();
        return this.b(0.0f, this.dC() + (float)(enummainhand == EnumMainHand.b ? 80 : -80)).a(0.5);
    }

    public Vec2F bG() {
        return new Vec2F(this.dE(), this.dC());
    }

    public Vec3D bH() {
        return Vec3D.a(this.bG());
    }

    public void f(BlockPosition pos) {
        if (this.aw()) {
            if (!this.dM().purpurConfig.playerFixStuckPortal || !(this instanceof EntityHuman) || pos.equals(this.portalPos)) {
                this.au();
            }
        } else if (this.dM().purpurConfig.entitiesCanUsePortals || this instanceof EntityPlayer) {
            if (!this.dM().B && !pos.equals(this.ax)) {
                this.ax = pos.i();
                this.portalPos = BlockPosition.b;
            }
            this.av = true;
        }
    }

    protected void bI() {
        if (this.dM() instanceof WorldServer) {
            int i2 = this.ax();
            WorldServer worldserver = (WorldServer)this.dM();
            if (this.av) {
                MinecraftServer minecraftserver = worldserver.o();
                ResourceKey<net.minecraft.world.level.World> resourcekey = this.dM().getTypeKey() == WorldDimension.c ? net.minecraft.world.level.World.h : net.minecraft.world.level.World.i;
                WorldServer worldserver1 = minecraftserver.a(resourcekey);
                if (!this.bO() && this.aw++ >= i2) {
                    this.aw = i2;
                    EntityPortalReadyEvent event = new EntityPortalReadyEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (World)(worldserver1 == null ? null : worldserver1.getWorld()), PortalType.NETHER);
                    if (!event.callEvent()) {
                        this.aw = 0;
                    } else {
                        worldserver1 = event.getTargetWorld() == null ? null : ((CraftWorld)event.getTargetWorld()).getHandle();
                        this.au();
                        if (this instanceof EntityPlayer) {
                            ((EntityPlayer)this).changeDimension(worldserver1, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
                        } else {
                            this.b(worldserver1);
                        }
                    }
                }
                this.av = false;
            } else {
                if (this.aw > 0) {
                    this.aw -= 4;
                }
                if (this.aw < 0) {
                    this.aw = 0;
                }
            }
            this.L();
            if (!GlobalConfiguration.get().unsupportedSettings.allowUnsafeEndPortalTeleportation) {
                this.tickEndPortal();
            }
        }
    }

    public int bJ() {
        return 300;
    }

    public void l(double x2, double y2, double z2) {
        this.o(x2, y2, z2);
    }

    public void c(DamageSource damageSource) {
    }

    public void b(byte status) {
        switch (status) {
            case 53: {
                BlockHoney.a(this);
            }
        }
    }

    public void m(float yaw) {
    }

    public Iterable<ItemStack> bK() {
        return e;
    }

    public Iterable<ItemStack> bL() {
        return e;
    }

    public Iterable<ItemStack> bM() {
        return Iterables.concat(this.bK(), this.bL());
    }

    public void a(EnumItemSlot slot, ItemStack stack) {
    }

    public boolean bN() {
        boolean flag = this.dM() != null && this.dM().B;
        return !this.aY() && (this.aN > 0 || flag && this.i(0));
    }

    public boolean bO() {
        return this.cZ() != null;
    }

    public boolean bP() {
        return !this.r.isEmpty();
    }

    public boolean bQ() {
        return this.ai().a(TagsEntity.p);
    }

    public boolean bR() {
        return !this.ai().a(TagsEntity.q);
    }

    public void f(boolean sneaking) {
        this.b(1, sneaking);
    }

    public boolean bS() {
        return this.i(1);
    }

    public boolean bT() {
        return this.bS();
    }

    public boolean bU() {
        return this.bS();
    }

    public boolean bV() {
        return this.bS();
    }

    public boolean bW() {
        return this.bS();
    }

    public boolean bX() {
        return this.c(EntityPose.f);
    }

    public boolean bY() {
        return this.i(3);
    }

    public void g(boolean sprinting) {
        this.b(3, sprinting);
    }

    public boolean bZ() {
        return this.i(4);
    }

    public boolean ca() {
        return this.c(EntityPose.d);
    }

    public boolean cb() {
        return this.ca() && !this.aZ();
    }

    public void h(boolean swimming) {
        if (this.valid && this.bZ() != swimming && this instanceof EntityLiving && CraftEventFactory.callToggleSwimEvent((EntityLiving)this, swimming).isCancelled()) {
            return;
        }
        this.b(4, swimming);
    }

    public final boolean cc() {
        return this.bd;
    }

    public final void i(boolean glowing) {
        this.bd = glowing;
        this.b(6, this.cd());
    }

    public boolean cd() {
        return this.dM().y_() ? this.i(6) : this.bd;
    }

    public boolean ce() {
        return this.i(5);
    }

    public boolean d(EntityHuman player) {
        if (player.P_()) {
            return false;
        }
        ScoreboardTeam scoreboardteam = this.cg();
        return scoreboardteam != null && player != null && player.cg() == scoreboardteam && scoreboardteam.i() ? false : this.ce();
    }

    public boolean cf() {
        return false;
    }

    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> callback) {
    }

    @javax.annotation.Nullable
    public ScoreboardTeam cg() {
        if (!this.dM().paperConfig().scoreboards.allowNonPlayerEntitiesOnScoreboards && !(this instanceof EntityHuman)) {
            return null;
        }
        return this.dM().K().e(this.cy());
    }

    public boolean s(Entity other) {
        return this.a(other.cg());
    }

    public boolean a(ScoreboardTeamBase team) {
        return this.cg() != null ? this.cg().a(team) : false;
    }

    public void j(boolean invisible) {
        if (!this.persistentInvisibility) {
            this.b(5, invisible);
        }
    }

    public boolean i(int index) {
        return (this.an.b(ao) & 1 << index) != 0;
    }

    public void b(int index, boolean value) {
        byte b0 = this.an.b(ao);
        if (value) {
            this.an.b(ao, (byte)(b0 | 1 << index));
        } else {
            this.an.b(ao, (byte)(b0 & ~(1 << index)));
        }
    }

    public int ch() {
        return this.t == null ? this.maxAirTicks : this.dM().purpurConfig.drowningAirTicks;
    }

    public int ci() {
        return this.an.b(aT);
    }

    public void j(int air) {
        EntityAirChangeEvent event = new EntityAirChangeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), air);
        if (this.valid) {
            event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled() && this.ci() != air) {
            this.an.markDirty(aT);
            return;
        }
        this.an.b(aT, event.getAmount());
    }

    public int cj() {
        return this.an.b(aY);
    }

    public void k(int frozenTicks) {
        this.an.b(aY, frozenTicks);
    }

    public float ck() {
        int i2 = this.cm();
        return (float)Math.min(this.cj(), i2) / (float)i2;
    }

    public boolean cl() {
        return this.cj() >= this.cm();
    }

    public int cm() {
        return 140;
    }

    public void a(WorldServer world, EntityLightning lightning) {
        this.h(this.aN + 1);
        CraftEntity thisBukkitEntity = this.getBukkitEntity();
        CraftEntity stormBukkitEntity = lightning.getBukkitEntity();
        PluginManager pluginManager = Bukkit.getPluginManager();
        if (this.aN == 0) {
            EntityCombustByEntityEvent entityCombustEvent = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)stormBukkitEntity, (org.bukkit.entity.Entity)thisBukkitEntity, 8);
            pluginManager.callEvent((Event)entityCombustEvent);
            if (!entityCombustEvent.isCancelled()) {
                this.setSecondsOnFire(entityCombustEvent.getDuration(), false);
            } else {
                this.h(this.aN - 1);
            }
        }
        if (thisBukkitEntity instanceof Hanging) {
            HangingBreakByEntityEvent hangingEvent = new HangingBreakByEntityEvent((Hanging)thisBukkitEntity, (org.bukkit.entity.Entity)stormBukkitEntity);
            pluginManager.callEvent((Event)hangingEvent);
            if (hangingEvent.isCancelled()) {
                return;
            }
        }
        if (this.aY()) {
            return;
        }
        if (!this.a(this.dN().b().customEventDamager(lightning), 5.0f)) {
            return;
        }
    }

    public void k(boolean drag) {
        Vec3D vec3d = this.dp();
        double d0 = drag ? Math.max(-0.9, vec3d.d - 0.03) : Math.min(1.8, vec3d.d + 0.1);
        this.o(vec3d.c, d0, vec3d.e);
    }

    public void l(boolean drag) {
        Vec3D vec3d = this.dp();
        double d0 = drag ? Math.max(-0.3, vec3d.d - 0.03) : Math.min(0.7, vec3d.d + 0.06);
        this.o(vec3d.c, d0, vec3d.e);
        this.n();
    }

    public boolean a(WorldServer world, EntityLiving other) {
        return true;
    }

    public void cn() {
        if (this.dp().b() > -0.5 && this.ab > 1.0f) {
            this.ab = 1.0f;
        }
    }

    public void n() {
        this.ab = 0.0f;
    }

    protected void m(double x2, double y2, double z2) {
        BlockPosition blockposition = BlockPosition.a(x2, y2, z2);
        Vec3D vec3d = new Vec3D(x2 - (double)blockposition.u(), y2 - (double)blockposition.v(), z2 - (double)blockposition.w());
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        EnumDirection enumdirection = EnumDirection.b;
        double d3 = Double.MAX_VALUE;
        for (EnumDirection enumdirection1 : new EnumDirection[]{EnumDirection.c, EnumDirection.d, EnumDirection.e, EnumDirection.f, EnumDirection.b}) {
            double d5;
            blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection1);
            if (this.dM().a_(blockposition_mutableblockposition).r(this.dM(), blockposition_mutableblockposition)) continue;
            double d4 = vec3d.a(enumdirection1.o());
            double d2 = d5 = enumdirection1.f() == EnumDirection.EnumAxisDirection.a ? 1.0 - d4 : d4;
            if (!(d5 < d3)) continue;
            d3 = d5;
            enumdirection = enumdirection1;
        }
        float f2 = this.ag.i() * 0.2f + 0.1f;
        float f1 = enumdirection.f().a();
        Vec3D vec3d1 = this.dp().a(0.75);
        if (enumdirection.o() == EnumDirection.EnumAxis.a) {
            this.o(f1 * f2, vec3d1.d, vec3d1.e);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            this.o(vec3d1.c, f1 * f2, vec3d1.e);
        } else if (enumdirection.o() == EnumDirection.EnumAxis.c) {
            this.o(vec3d1.c, vec3d1.d, f1 * f2);
        }
    }

    public void a(IBlockData state, Vec3D multiplier) {
        this.n();
        this.U = multiplier;
    }

    private static IChatBaseComponent c(IChatBaseComponent textComponent) {
        IChatMutableComponent ichatmutablecomponent = textComponent.e().b(textComponent.a().a((ChatClickable)null));
        for (IChatBaseComponent ichatbasecomponent1 : textComponent.c()) {
            ichatmutablecomponent.b(Entity.c(ichatbasecomponent1));
        }
        return ichatmutablecomponent;
    }

    @Override
    public IChatBaseComponent ad() {
        IChatBaseComponent ichatbasecomponent = this.af();
        return ichatbasecomponent != null ? Entity.c(ichatbasecomponent) : this.co();
    }

    protected IChatBaseComponent co() {
        return this.p.h();
    }

    public boolean t(Entity entity) {
        return this == entity;
    }

    public float cp() {
        return 0.0f;
    }

    public void n(float headYaw) {
    }

    public void o(float bodyYaw) {
    }

    public boolean cq() {
        return true;
    }

    public boolean u(Entity attacker) {
        return false;
    }

    public String toString() {
        String s2 = this.dM() == null ? "~NULL~" : this.dM().toString();
        return this.aK != null ? String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b, removed=%s]", new Object[]{this.getClass().getSimpleName(), this.ad().getString(), this.q, this.ay, s2, this.dr(), this.dt(), this.dx(), this.do(), this.ah, this.valid, this.aK}) : String.format(Locale.ROOT, "%s['%s'/%d, uuid='%s', l='%s', x=%.2f, y=%.2f, z=%.2f, cpos=%s, tl=%d, v=%b]", this.getClass().getSimpleName(), this.ad().getString(), this.q, this.ay, s2, this.dr(), this.dt(), this.dx(), this.do(), this.ah, this.valid);
    }

    public boolean b(DamageSource damageSource) {
        return this.dH() || this.bc && !damageSource.a(DamageTypeTags.e) && !damageSource.g() || damageSource.a(DamageTypeTags.j) && this.aY() || damageSource.a(DamageTypeTags.n) && this.ai().a(TagsEntity.o);
    }

    public boolean cr() {
        return this.bc;
    }

    public void m(boolean invulnerable) {
        this.bc = invulnerable;
    }

    public void v(Entity entity) {
        this.b(entity.dr(), entity.dt(), entity.dx(), entity.dC(), entity.dE());
    }

    public void w(Entity original) {
        CraftEntity bukkitEntity = original.bukkitEntity;
        if (bukkitEntity != null) {
            bukkitEntity.setHandle(this);
            this.bukkitEntity = bukkitEntity;
        }
        NBTTagCompound nbttagcompound = original.f(new NBTTagCompound());
        nbttagcompound.r("Dimension");
        this.g(nbttagcompound);
        this.bb = original.bb;
        this.ax = original.ax;
    }

    @javax.annotation.Nullable
    public Entity b(WorldServer destination) {
        return this.teleportTo(destination, null);
    }

    @javax.annotation.Nullable
    public Entity teleportTo(WorldServer worldserver, Vec3D location) {
        if (!this.bx() || !this.valid) {
            c.warn("Illegal Entity Teleport " + this + " to " + worldserver + ":" + location, new Throwable());
            return null;
        }
        if (this.dM() instanceof WorldServer && !this.dH()) {
            Object entity;
            ShapeDetectorShape shapedetectorshape;
            if (worldserver == null) {
                return null;
            }
            ShapeDetectorShape shapeDetectorShape = shapedetectorshape = location == null ? this.a(worldserver) : new ShapeDetectorShape(new Vec3D(location.a(), location.b(), location.c()), Vec3D.b, this.aG, this.aH, worldserver, null);
            if (shapedetectorshape == null) {
                return null;
            }
            worldserver = shapedetectorshape.world;
            Vec3D position = shapedetectorshape.a;
            float yaw = shapedetectorshape.c;
            float pitch = this.dE();
            Vec3D velocity = shapedetectorshape.b;
            CraftEntity bukkitEntity = this.getBukkitEntity();
            EntityPortalExitEvent event = new EntityPortalExitEvent((org.bukkit.entity.Entity)bukkitEntity, bukkitEntity.getLocation(), new Location((World)worldserver.getWorld(), position.c, position.d, position.e, yaw, pitch), bukkitEntity.getVelocity(), CraftVector.toBukkit(shapedetectorshape.b));
            event.callEvent();
            if (this.dH()) {
                return null;
            }
            if (!event.isCancelled() && event.getTo() != null) {
                worldserver = ((CraftWorld)event.getTo().getWorld()).getHandle();
                position = CraftLocation.toVec3D(event.getTo());
                yaw = event.getTo().getYaw();
                pitch = event.getTo().getPitch();
                velocity = CraftVector.toNMS(event.getAfter());
            }
            if (worldserver == this.t) {
                this.b(shapedetectorshape.a.c, shapedetectorshape.a.d, shapedetectorshape.a.e, shapedetectorshape.c, shapedetectorshape.d);
                this.g(shapedetectorshape.b);
                return this;
            }
            this.ag();
            if (this instanceof EntityInsentient) {
                ((EntityInsentient)this).a(true, true);
            }
            if ((entity = this.ai().a(worldserver)) != null) {
                ((Entity)entity).w(this);
                ((Entity)entity).b(position.c, position.d, position.e, yaw, pitch);
                ((Entity)entity).g(velocity);
                if (this.inWorld) {
                    worldserver.d((Entity)entity);
                    if (worldserver.getTypeKey() == WorldDimension.d) {
                        WorldServer.makeObsidianPlatform(worldserver, this);
                    }
                }
            }
            this.cs();
            ((WorldServer)this.dM()).h();
            worldserver.h();
            return entity;
        }
        return null;
    }

    protected void cs() {
        this.setRemoved(RemovalReason.e, null);
    }

    @javax.annotation.Nullable
    protected ShapeDetectorShape a(WorldServer destination) {
        BlockPosition blockposition1;
        boolean flag1;
        if (destination == null) {
            return null;
        }
        boolean flag = this.dM().getTypeKey() == WorldDimension.d && destination.getTypeKey() == WorldDimension.b;
        boolean bl = flag1 = destination.getTypeKey() == WorldDimension.d;
        if (!flag && !flag1) {
            CraftPortalEvent event;
            boolean flag2;
            boolean bl2 = flag2 = destination.getTypeKey() == WorldDimension.c;
            if (this.dM().getTypeKey() != WorldDimension.c && !flag2) {
                return null;
            }
            WorldBorder worldborder = destination.D_();
            double d0 = DimensionManager.a(this.dM().E_(), destination.E_());
            BlockPosition blockposition = worldborder.b(this.dr() * d0, this.dt(), this.dx() * d0);
            int portalSearchRadius = destination.paperConfig().environment.portalSearchRadius;
            if (this.t.paperConfig().environment.portalSearchVanillaDimensionScaling && flag2) {
                portalSearchRadius = (int)((double)portalSearchRadius / destination.E_().k());
            }
            if ((event = this.callPortalEvent(this, destination, new Vec3D(blockposition.u(), blockposition.v(), blockposition.w()), PlayerTeleportEvent.TeleportCause.NETHER_PORTAL, portalSearchRadius, destination.paperConfig().environment.portalCreateRadius)) == null) {
                return null;
            }
            WorldServer worldserverFinal = destination = ((CraftWorld)event.getTo().getWorld()).getHandle();
            worldborder = worldserverFinal.D_();
            blockposition = worldborder.b(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
            return this.getExitPortal(destination, blockposition, flag2, worldborder, event.getSearchRadius(), event.getCanCreatePortal(), event.getCreationRadius()).map(blockutil_rectangle -> {
                Vec3D vec3d;
                EnumDirection.EnumAxis enumdirection_enumaxis;
                IBlockData iblockdata = this.dM().a_(this.ax);
                if (iblockdata.b(BlockProperties.H)) {
                    enumdirection_enumaxis = iblockdata.c(BlockProperties.H);
                    BlockUtil.Rectangle blockutil_rectangle1 = BlockUtil.a(this.ax, enumdirection_enumaxis, 21, EnumDirection.EnumAxis.b, 21, blockposition1 -> this.dM().a_((BlockPosition)blockposition1) == iblockdata);
                    vec3d = this.a(enumdirection_enumaxis, blockutil_rectangle1);
                } else {
                    enumdirection_enumaxis = EnumDirection.EnumAxis.a;
                    vec3d = new Vec3D(0.5, 0.0, 0.0);
                }
                return BlockPortalShape.createPortalInfo(worldserverFinal, blockutil_rectangle, enumdirection_enumaxis, vec3d, this, this.dp(), this.dC(), this.dE(), event);
            }).orElse(null);
        }
        if (flag1) {
            blockposition1 = WorldServer.a;
        } else {
            destination.m(destination.T());
            blockposition1 = destination.a(HeightMap.Type.f, destination.T());
        }
        CraftPortalEvent event = this.callPortalEvent(this, destination, new Vec3D((double)blockposition1.u() + 0.5, blockposition1.v(), (double)blockposition1.w() + 0.5), PlayerTeleportEvent.TeleportCause.END_PORTAL, 0, 0);
        if (event == null) {
            return null;
        }
        return new ShapeDetectorShape(new Vec3D(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ()), this.dp(), this.dC(), this.dE(), ((CraftWorld)event.getTo().getWorld()).getHandle(), event);
    }

    protected Vec3D a(EnumDirection.EnumAxis portalAxis, BlockUtil.Rectangle portalRect) {
        return BlockPortalShape.a(portalRect, portalAxis, this.dk(), this.a(this.ap()));
    }

    protected CraftPortalEvent callPortalEvent(Entity entity, WorldServer exitWorldServer, Vec3D exitPosition, PlayerTeleportEvent.TeleportCause cause, int searchRadius, int creationRadius) {
        CraftEntity bukkitEntity = entity.getBukkitEntity();
        Location enter = bukkitEntity.getLocation();
        Location exit = CraftLocation.toBukkit(exitPosition, (World)exitWorldServer.getWorld());
        PortalType portalType = switch (cause) {
            case PlayerTeleportEvent.TeleportCause.END_PORTAL -> PortalType.ENDER;
            case PlayerTeleportEvent.TeleportCause.NETHER_PORTAL -> PortalType.NETHER;
            default -> PortalType.CUSTOM;
        };
        EntityPortalEvent event = new EntityPortalEvent((org.bukkit.entity.Entity)bukkitEntity, enter, exit, searchRadius, portalType);
        event.getEntity().getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || event.getTo() == null || event.getTo().getWorld() == null || !entity.bx()) {
            return null;
        }
        return new CraftPortalEvent(event);
    }

    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer worldserver, BlockPosition blockposition, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        return worldserver.p().findPortalAround(blockposition, worldborder, searchRadius);
    }

    public boolean ct() {
        return !this.bO() && !this.bP() && this.bx() && this.valid && (this.dM().purpurConfig.entitiesCanUsePortals || this instanceof EntityPlayer);
    }

    public float a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData blockState, Fluid fluidState, float max) {
        return max;
    }

    public boolean a(Explosion explosion, IBlockAccess world, BlockPosition pos, IBlockData state, float explosionPower) {
        return true;
    }

    public int cu() {
        return 3;
    }

    public boolean r_() {
        return false;
    }

    public void a(CrashReportSystemDetails section) {
        section.a("Entity Type", () -> {
            MinecraftKey minecraftkey = EntityTypes.a(this.ai());
            return minecraftkey + " (" + this.getClass().getCanonicalName() + ")";
        });
        section.a("Entity ID", this.q);
        section.a("Entity Name", () -> this.ad().getString());
        section.a("Entity's Exact location", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", this.dr(), this.dt(), this.dx()));
        section.a("Entity's Block location", CrashReportSystemDetails.a((LevelHeightAccessor)this.dM(), MathHelper.a(this.dr()), MathHelper.a(this.dt()), MathHelper.a(this.dx())));
        Vec3D vec3d = this.dp();
        section.a("Entity's Momentum", String.format(Locale.ROOT, "%.2f, %.2f, %.2f", vec3d.c, vec3d.d, vec3d.e));
        section.a("Entity's Passengers", () -> this.cP().toString());
        section.a("Entity's Vehicle", () -> String.valueOf(this.cZ()));
    }

    public boolean cv() {
        return this.bN() && !this.P_();
    }

    public void a_(UUID uuid) {
        this.ay = uuid;
        this.az = this.ay.toString();
    }

    @Override
    public UUID cw() {
        return this.ay;
    }

    public String cx() {
        return this.az;
    }

    @Override
    public String cy() {
        return this.az;
    }

    public boolean cz() {
        return true;
    }

    public static double cA() {
        return o;
    }

    public static void b(double value) {
        o = value;
    }

    @Override
    public IChatBaseComponent Q_() {
        return ScoreboardTeam.a(this.cg(), this.ad()).a(chatmodifier -> chatmodifier.a(this.cG()).a(this.cx()));
    }

    public void b(@javax.annotation.Nullable IChatBaseComponent name) {
        this.an.b(aU, Optional.ofNullable(name));
    }

    @Override
    @javax.annotation.Nullable
    public IChatBaseComponent af() {
        return this.an.b(aU).orElse(null);
    }

    @Override
    public boolean ae() {
        return this.an.b(aU).isPresent();
    }

    public void n(boolean visible) {
        this.an.b(aV, visible);
    }

    public boolean cB() {
        return this.an.b(aV);
    }

    public final void n(double destX, double destY, double destZ) {
        if (this.dM() instanceof WorldServer) {
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(BlockPosition.a(destX, destY, destZ));
            ((WorldServer)this.dM()).l().a(TicketType.g, chunkcoordintpair, 0, this.aj());
            this.dM().d(chunkcoordintpair.e, chunkcoordintpair.f);
            this.c(destX, destY, destZ);
        }
    }

    public boolean teleportTo(WorldServer worldserver, double d0, double d1, double d2, Set<RelativeMovement> set, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        return this.a(worldserver, d0, d1, d2, set, f2, f1);
    }

    public boolean a(WorldServer world, double destX, double destY, double destZ, Set<RelativeMovement> flags, float yaw, float pitch) {
        float f2 = MathHelper.a(pitch, -90.0f, 90.0f);
        if (world == this.dM()) {
            this.b(destX, destY, destZ, yaw, f2);
            this.z();
            this.n(yaw);
        } else {
            this.ag();
            Object entity = this.ai().a(world);
            if (entity == null) {
                return false;
            }
            ((Entity)entity).w(this);
            ((Entity)entity).b(destX, destY, destZ, yaw, f2);
            ((Entity)entity).n(yaw);
            this.setRemoved(RemovalReason.e, null);
            if (this.inWorld) {
                world.d((Entity)entity);
            }
        }
        return true;
    }

    public void a(double destX, double destY, double destZ) {
        this.c(destX, destY, destZ);
    }

    public void c(double destX, double destY, double destZ) {
        if (this.dM() instanceof WorldServer) {
            this.b(destX, destY, destZ, this.dC(), this.dE());
            this.z();
        }
    }

    public void z() {
        this.cR().forEach(entity -> {
            for (Entity entity1 : entity.r) {
                entity.a(entity1, Entity::e);
            }
        });
    }

    public void d(double offsetX, double offsetY, double offsetZ) {
        this.c(this.dr() + offsetX, this.dt() + offsetY, this.dx() + offsetZ);
    }

    public boolean cC() {
        return this.cB();
    }

    public void b(List<DataWatcher.b<?>> dataEntries) {
    }

    public void a(DataWatcherObject<?> data) {
        if (as.equals(data)) {
            this.k_();
        }
    }

    @Deprecated
    protected void cD() {
        EntitySize entitysize;
        EntityPose entitypose = this.ap();
        this.bh = entitysize = this.a(entitypose);
        this.bi = this.a(entitypose, entitysize);
    }

    public void k_() {
        boolean flag;
        EntitySize entitysize1;
        EntitySize entitysize = this.bh;
        EntityPose entitypose = this.ap();
        this.bh = entitysize1 = this.a(entitypose);
        this.bi = this.a(entitypose, entitysize1);
        this.ar();
        boolean bl = flag = (double)entitysize1.a <= 4.0 && (double)entitysize1.b <= 4.0;
        if (!(this.dM().B || this.am || this.af || !flag || !(entitysize1.a > entitysize.a) && !(entitysize1.b > entitysize.b) || this instanceof EntityHuman)) {
            Vec3D vec3d = this.dk().b(0.0, (double)entitysize.b / 2.0, 0.0);
            double d0 = (double)Math.max(0.0f, entitysize1.a - entitysize.a) + 1.0E-6;
            double d1 = (double)Math.max(0.0f, entitysize1.b - entitysize.b) + 1.0E-6;
            VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d, d0, d1, d0));
            this.dM().a(this, voxelshape, vec3d, (double)entitysize1.a, (double)entitysize1.b, (double)entitysize1.a).ifPresent(vec3d1 -> this.b(vec3d1.b(0.0, (double)(-entitysize1.b) / 2.0, 0.0)));
        }
    }

    public EnumDirection cE() {
        return EnumDirection.a(this.dC());
    }

    public EnumDirection cF() {
        return this.cE();
    }

    protected ChatHoverable cG() {
        return new ChatHoverable(ChatHoverable.EnumHoverAction.c, new ChatHoverable.b(this.ai(), this.cw(), this.ad()));
    }

    public boolean a(EntityPlayer spectator) {
        return true;
    }

    @Override
    public final AxisAlignedBB cH() {
        return this.aI;
    }

    public AxisAlignedBB i_() {
        return this.cH();
    }

    public final void a(AxisAlignedBB boundingBox) {
        double minX = boundingBox.a;
        double minY = boundingBox.b;
        double minZ = boundingBox.c;
        double maxX = boundingBox.d;
        double maxY = boundingBox.e;
        double maxZ = boundingBox.f;
        double len = boundingBox.d - boundingBox.a;
        if (len < 0.0) {
            maxX = minX;
        }
        if (len > 64.0) {
            maxX = minX + 64.0;
        }
        if ((len = boundingBox.e - boundingBox.b) < 0.0) {
            maxY = minY;
        }
        if (len > 64.0) {
            maxY = minY + 64.0;
        }
        if ((len = boundingBox.f - boundingBox.c) < 0.0) {
            maxZ = minZ;
        }
        if (len > 64.0) {
            maxZ = minZ + 64.0;
        }
        this.aI = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected float a(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.85f;
    }

    public float d(EntityPose pose) {
        return this.a(pose, this.a(pose));
    }

    public final float cI() {
        return this.bi;
    }

    public Vec3D p(float tickDelta) {
        return this.cJ();
    }

    protected Vec3D cJ() {
        return new Vec3D(0.0, this.cI(), this.dg() * 0.4f);
    }

    public SlotAccess a_(int mappedIndex) {
        return SlotAccess.b;
    }

    public void sendMiniMessage(@javax.annotation.Nullable String message) {
        if (message != null && !message.isEmpty()) {
            this.sendMessage(MiniMessage.miniMessage().deserialize((Object)message));
        }
    }

    public void sendMessage(@javax.annotation.Nullable Component message) {
        if (message != null) {
            this.a(PaperAdventure.asVanilla(message));
        }
    }

    @Override
    public void a(IChatBaseComponent message) {
    }

    public net.minecraft.world.level.World cK() {
        return this.dM();
    }

    @javax.annotation.Nullable
    public MinecraftServer cL() {
        return this.dM().o();
    }

    public EnumInteractionResult a(EntityHuman player, Vec3D hitPos, EnumHand hand) {
        return EnumInteractionResult.d;
    }

    public boolean a(Explosion explosion) {
        return false;
    }

    public void a(EntityLiving attacker, Entity target) {
        if (target instanceof EntityLiving) {
            EnchantmentManager.a((EntityLiving)target, (Entity)attacker);
        }
        EnchantmentManager.b(attacker, target);
    }

    public void c(EntityPlayer player) {
    }

    public void d(EntityPlayer player) {
        if (PlayerUntrackEntityEvent.getHandlerList().getRegisteredListeners().length > 0) {
            new PlayerUntrackEntityEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Entity)this.getBukkitEntity()).callEvent();
        }
    }

    public float a(EnumBlockRotation rotation) {
        float f2 = MathHelper.g(this.dC());
        switch (rotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 270.0f;
            }
            case b: {
                return f2 + 90.0f;
            }
        }
        return f2;
    }

    public float a(EnumBlockMirror mirror) {
        float f2 = MathHelper.g(this.dC());
        switch (mirror) {
            case c: {
                return -f2;
            }
            case b: {
                return 180.0f - f2;
            }
        }
        return f2;
    }

    public boolean cM() {
        return false;
    }

    @javax.annotation.Nullable
    public EntityLiving cN() {
        return null;
    }

    public final boolean cO() {
        return this.cN() != null;
    }

    public final List<Entity> cP() {
        return this.r;
    }

    @javax.annotation.Nullable
    public Entity cQ() {
        return this.r.isEmpty() ? null : (Entity)this.r.get(0);
    }

    public boolean x(Entity passenger) {
        return this.r.contains((Object)passenger);
    }

    public boolean a(Predicate<Entity> predicate) {
        Entity entity;
        UnmodifiableIterator unmodifiableiterator = this.r.iterator();
        do {
            if (unmodifiableiterator.hasNext()) continue;
            return false;
        } while (!predicate.test(entity = (Entity)unmodifiableiterator.next()));
        return true;
    }

    private Stream<Entity> B() {
        if (this.r.isEmpty()) {
            return Stream.of(new Entity[0]);
        }
        return this.r.stream().flatMap(Entity::cR);
    }

    public Stream<Entity> cR() {
        if (this.r.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(Stream.of(this), this.B());
    }

    public Stream<Entity> cS() {
        if (this.r.isEmpty()) {
            return Stream.of(this);
        }
        return Stream.concat(this.r.stream().flatMap(Entity::cS), Stream.of(this));
    }

    public Iterable<Entity> cT() {
        if (this.r.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder indirectPassengers = ImmutableList.builder();
        for (Entity passenger : this.r) {
            indirectPassengers.add((Object)passenger);
            indirectPassengers.addAll(passenger.cT());
        }
        return indirectPassengers.build();
    }

    private Iterable<Entity> getIndirectPassengers_old() {
        return () -> this.B().iterator();
    }

    public int cU() {
        return (int)this.B().filter(entity -> entity instanceof EntityHuman).count();
    }

    public boolean hasAnyPlayerPassengers() {
        if (this.r.isEmpty()) {
            return false;
        }
        return this.B().anyMatch(entity -> entity instanceof EntityHuman);
    }

    public boolean cV() {
        if (this.r.isEmpty()) {
            return false;
        }
        return this.cU() == 1;
    }

    public Entity cW() {
        Entity entity = this;
        while (entity.bO()) {
            entity = entity.cZ();
        }
        return entity;
    }

    public boolean y(Entity entity) {
        return this.cW() == entity.cW();
    }

    public boolean z(Entity passenger) {
        if (!passenger.bO()) {
            return false;
        }
        Entity entity1 = passenger.cZ();
        return entity1 == this ? true : this.z(entity1);
    }

    public boolean cX() {
        EntityLiving entityliving = this.cN();
        if (entityliving instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entityliving;
            return entityhuman.g();
        }
        return this.cY();
    }

    public boolean cY() {
        return !this.dM().B;
    }

    protected static Vec3D a(double vehicleWidth, double passengerWidth, float passengerYaw) {
        double d2 = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float f1 = -MathHelper.a(passengerYaw * ((float)Math.PI / 180));
        float f2 = MathHelper.b(passengerYaw * ((float)Math.PI / 180));
        float f3 = Math.max(Math.abs(f1), Math.abs(f2));
        return new Vec3D((double)f1 * d2 / (double)f3, 0.0, (double)f2 * d2 / (double)f3);
    }

    public Vec3D b(EntityLiving passenger) {
        return new Vec3D(this.dr(), this.cH().e, this.dx());
    }

    @javax.annotation.Nullable
    public Entity cZ() {
        return this.s;
    }

    @javax.annotation.Nullable
    public Entity da() {
        return this.s != null && this.s.cN() == this ? this.s : null;
    }

    public EnumPistonReaction s_() {
        return EnumPistonReaction.a;
    }

    public SoundCategory db() {
        return SoundCategory.g;
    }

    public int dc() {
        return 1;
    }

    public CommandListenerWrapper dd() {
        return new CommandListenerWrapper(this, this.dk(), this.bG(), this.dM() instanceof WorldServer ? (WorldServer)this.dM() : null, this.F(), this.ad().getString(), this.Q_(), this.dM().o(), this);
    }

    protected int F() {
        return 0;
    }

    public boolean l(int permissionLevel) {
        return this.F() >= permissionLevel;
    }

    @Override
    public boolean l_() {
        return this.dM().Z().b(GameRules.p);
    }

    @Override
    public boolean x_() {
        return true;
    }

    @Override
    public boolean W_() {
        return true;
    }

    public void a(ArgumentAnchor.Anchor anchorPoint, Vec3D target) {
        Vec3D vec3d1 = anchorPoint.a(this);
        double d0 = target.c - vec3d1.c;
        double d1 = target.d - vec3d1.d;
        double d2 = target.e - vec3d1.e;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        this.s(MathHelper.g((float)(-(MathHelper.d(d1, d3) * 57.2957763671875))));
        this.r(MathHelper.g((float)(MathHelper.d(d2, d0) * 57.2957763671875) - 90.0f));
        this.n(this.dC());
        this.O = this.dE();
        this.N = this.dC();
    }

    public AxisAlignedBB getAxisForFluidCheck() {
        return this.cH().h(0.001);
    }

    public boolean a(TagKey<FluidType> tag, double speed) {
        AxisAlignedBB axisalignedbb = this.cH().h(0.001);
        int minBlockX = MathHelper.a(axisalignedbb.a);
        int maxBlockX = MathHelper.c(axisalignedbb.d);
        int minBlockY = MathHelper.a(axisalignedbb.b);
        int maxBlockY = MathHelper.c(axisalignedbb.e);
        int minBlockZ = MathHelper.a(axisalignedbb.c);
        int maxBlockZ = MathHelper.c(axisalignedbb.f);
        double d1 = 0.0;
        boolean flag = this.cz();
        boolean flag1 = false;
        Vec3D vec3d = Vec3D.b;
        int k1 = 0;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int minSection = WorldUtil.getMinSection(this.dM());
        int maxSection = WorldUtil.getMaxSection(this.dM());
        int minBlock = minSection << 4;
        int maxBlock = maxSection << 4 | 0xF;
        if (minBlockY > maxBlock || maxBlockY < minBlock) {
            return false;
        }
        int minYIterate = Math.max(minBlock, minBlockY);
        int maxYIterate = Math.min(maxBlock, maxBlockY);
        int minChunkX = minBlockX >> 4;
        int maxChunkX = maxBlockX >> 4;
        int minChunkZ = minBlockZ >> 4;
        int maxChunkZ = maxBlockZ >> 4;
        for (int currChunkZ = minChunkZ; currChunkZ <= maxChunkZ; ++currChunkZ) {
            int minZ = currChunkZ == minChunkZ ? minBlockZ & 0xF : 0;
            int maxZ = currChunkZ == maxChunkZ ? maxBlockZ & 0xF : 16;
            for (int currChunkX = minChunkX; currChunkX <= maxChunkX; ++currChunkX) {
                int minX = currChunkX == minChunkX ? minBlockX & 0xF : 0;
                int maxX = currChunkX == maxChunkX ? maxBlockX & 0xF : 16;
                IChunkAccess chunk = this.dM().getChunkIfLoadedImmediately(currChunkX, currChunkZ);
                if (chunk == null) {
                    return false;
                }
                ChunkSection[] sections = chunk.d();
                for (int currY = minYIterate; currY < maxYIterate; ++currY) {
                    ChunkSection section = sections[(currY >> 4) - minSection];
                    if (section == null || section.c() || section.fluidStateCount == 0) {
                        currY = (currY & 0xFFFFFFF0) + 15;
                        continue;
                    }
                    DataPaletteBlock<IBlockData> blocks = section.h;
                    for (int currZ = minZ; currZ < maxZ; ++currZ) {
                        for (int currX = minX; currX < maxX; ++currX) {
                            Fluid fluid = blocks.a(currX & 0xF, currY & 0xF, currZ & 0xF).u();
                            if (!fluid.a(tag)) continue;
                            blockposition_mutableblockposition.d((currChunkX << 4) + currX, currY, (currChunkZ << 4) + currZ);
                            double d2 = (float)currY + fluid.a((IBlockAccess)this.dM(), (BlockPosition)blockposition_mutableblockposition);
                            if (!(d2 >= axisalignedbb.b)) continue;
                            flag1 = true;
                            d1 = Math.max(d2 - axisalignedbb.b, d1);
                            if (flag) {
                                Vec3D vec3d1 = fluid.c(this.dM(), blockposition_mutableblockposition);
                                if (d1 < 0.4) {
                                    vec3d1 = vec3d1.a(d1);
                                }
                                vec3d = vec3d.e(vec3d1);
                                ++k1;
                            }
                            if (tag != TagsFluid.b) continue;
                            this.lastLavaContact = blockposition_mutableblockposition.i();
                        }
                    }
                }
            }
        }
        if (vec3d.f() > 0.0) {
            if (k1 > 0) {
                vec3d = vec3d.a(1.0 / (double)k1);
            }
            if (!(this instanceof EntityHuman)) {
                vec3d = vec3d.d();
            }
            Vec3D vec3d2 = this.dp();
            vec3d = vec3d.a(speed * 1.0);
            double d3 = 0.003;
            if (Math.abs(vec3d2.c) < 0.003 && Math.abs(vec3d2.e) < 0.003 && vec3d.f() < 0.0045000000000000005) {
                vec3d = vec3d.d().a(0.0045000000000000005);
            }
            this.g(this.dp().e(vec3d));
        }
        this.aj.put(tag, d1);
        return flag1;
    }

    public boolean de() {
        AxisAlignedBB axisalignedbb = this.cH().g(1.0);
        int i2 = MathHelper.a(axisalignedbb.a);
        int j2 = MathHelper.c(axisalignedbb.d);
        int k2 = MathHelper.a(axisalignedbb.c);
        int l2 = MathHelper.c(axisalignedbb.f);
        return !this.dM().b(i2, k2, j2, l2);
    }

    public double b(TagKey<FluidType> fluid) {
        return this.aj.getDouble(fluid);
    }

    public double df() {
        return (double)this.cI() < 0.4 ? 0.0 : 0.4;
    }

    public final float dg() {
        return this.bh.a;
    }

    public final float dh() {
        return this.bh.b;
    }

    public float di() {
        return this.dh() + 0.5f;
    }

    public Packet<PacketListenerPlayOut> dj() {
        return new PacketPlayOutSpawnEntity(this);
    }

    public EntitySize a(EntityPose pose) {
        return this.p.n();
    }

    public Vec3D dk() {
        return this.u;
    }

    public Vec3D dl() {
        return this.dk();
    }

    @Override
    public BlockPosition dm() {
        return this.v;
    }

    public IBlockData dn() {
        if (this.bn == null) {
            this.bn = this.dM().a_(this.dm());
        }
        return this.bn;
    }

    public ChunkCoordIntPair do() {
        return this.aE;
    }

    public Vec3D dp() {
        return this.aF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void g(Vec3D velocity) {
        Object object = this.posLock;
        synchronized (object) {
            this.aF = velocity;
        }
    }

    public void h(Vec3D velocity) {
        this.g(this.dp().e(velocity));
    }

    public void o(double x2, double y2, double z2) {
        this.g(new Vec3D(x2, y2, z2));
    }

    public final int dq() {
        return this.v.u();
    }

    public final double dr() {
        return this.u.c;
    }

    public double c(double widthScale) {
        return this.u.c + (double)this.dg() * widthScale;
    }

    public double d(double widthScale) {
        return this.c((2.0 * this.ag.j() - 1.0) * widthScale);
    }

    public final int ds() {
        return this.v.v();
    }

    public final double dt() {
        return this.u.d;
    }

    public double e(double heightScale) {
        return this.u.d + (double)this.dh() * heightScale;
    }

    public double du() {
        return this.e(this.ag.j());
    }

    public double dv() {
        return this.u.d + (double)this.bi;
    }

    public final int dw() {
        return this.v.w();
    }

    public final double dx() {
        return this.u.e;
    }

    public double f(double widthScale) {
        return this.u.e + (double)this.dg() * widthScale;
    }

    public double g(double widthScale) {
        return this.f((2.0 * this.ag.j() - 1.0) * widthScale);
    }

    public static boolean checkPosition(Entity entity, double newX, double newY, double newZ) {
        String entityInfo;
        if (Double.isFinite(newX) && Double.isFinite(newY) && Double.isFinite(newZ)) {
            return true;
        }
        try {
            entityInfo = entity.toString();
        }
        catch (Exception ex) {
            entityInfo = "[Entity info unavailable] ";
        }
        c.error("New entity position is invalid! Tried to set invalid position ({},{},{}) for entity {} located at {}, entity info: {}", new Object[]{newX, newY, newZ, entity.getClass().getName(), entity.u, entityInfo, new Throwable()});
        return false;
    }

    public final void p(double x2, double y2, double z2) {
        this.setPosRaw(x2, y2, z2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPosRaw(double x2, double y2, double z2, boolean forceBoundingBoxUpdate) {
        if (!Entity.checkPosition(this, x2, y2, z2)) {
            return;
        }
        if (this.updatingSectionStatus) {
            c.error("Refusing to update position for entity {} to position {} since it is processing a section status update", new Object[]{this, new Vec3D(x2, y2, z2), new Throwable()});
            return;
        }
        if (this instanceof EntityItem && GlobalConfiguration.get().misc.fixEntityPositionDesync) {
            x2 = (double)MathHelper.b(x2 * 4096.0) * 2.44140625E-4;
            y2 = (double)MathHelper.b(y2 * 4096.0) * 2.44140625E-4;
            z2 = (double)MathHelper.b(z2 * 4096.0) * 2.44140625E-4;
        }
        if (this.u.c != x2 || this.u.d != y2 || this.u.e != z2) {
            Object object = this.posLock;
            synchronized (object) {
                this.u = new Vec3D(x2, y2, z2);
            }
            int i2 = MathHelper.a(x2);
            int j2 = MathHelper.a(y2);
            int k2 = MathHelper.a(z2);
            if (i2 != this.v.u() || j2 != this.v.v() || k2 != this.v.w()) {
                this.v = new BlockPosition(i2, j2, k2);
                this.bn = null;
                if (SectionPosition.a(i2) != this.aE.e || SectionPosition.a(k2) != this.aE.f) {
                    this.aE = new ChunkCoordIntPair(this.v);
                }
            }
            this.aZ.a();
        }
        if (!(this instanceof EntityHanging) && (forceBoundingBoxUpdate || this.u.c != x2 || this.u.d != y2 || this.u.e != z2)) {
            this.a(this.aq());
        }
    }

    public void dy() {
    }

    public Vec3D q(float delta) {
        return this.l(delta).b(0.0, (double)this.bi * 0.7, 0.0);
    }

    public void a(PacketPlayOutSpawnEntity packet) {
        int i2 = packet.a();
        double d0 = packet.f();
        double d1 = packet.g();
        double d2 = packet.h();
        this.f(d0, d1, d2);
        this.e(d0, d1, d2);
        this.s(packet.l());
        this.r(packet.m());
        this.e(i2);
        this.a_(packet.d());
    }

    @javax.annotation.Nullable
    public ItemStack dz() {
        return null;
    }

    public void o(boolean inPowderSnow) {
        this.aA = inPowderSnow;
    }

    public boolean dA() {
        return !this.ai().a(TagsEntity.k);
    }

    public boolean dB() {
        return (this.aA || this.aB) && this.dA();
    }

    public float dC() {
        return this.aG;
    }

    public float dD() {
        return this.dC();
    }

    public void r(float yaw) {
        if (!Float.isFinite(yaw)) {
            SystemUtils.a("Invalid entity rotation: " + yaw + ", discarding.");
        } else {
            this.aG = yaw;
        }
    }

    public float dE() {
        return this.aH;
    }

    public void s(float pitch) {
        if (!Float.isFinite(pitch)) {
            SystemUtils.a("Invalid entity rotation: " + pitch + ", discarding.");
        } else {
            this.aH = pitch;
        }
    }

    public boolean dF() {
        return false;
    }

    public float dG() {
        return this.aM;
    }

    public void t(float stepHeight) {
        this.aM = stepHeight;
    }

    public final boolean dH() {
        return this.aK != null;
    }

    @javax.annotation.Nullable
    public RemovalReason dI() {
        return this.aK;
    }

    @Override
    public final void b(RemovalReason reason) {
        this.setRemoved(reason, null);
    }

    @Override
    public final void setRemoved(RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        boolean alreadyRemoved;
        TickThread.ensureTickThread(this, "Cannot remove entity off-main");
        if (!((WorldServer)this.t).getEntityLookup().canRemoveEntity(this)) {
            c.warn("Entity " + this + " is currently prevented from being removed from the world since it is processing section status updates", new Throwable());
            return;
        }
        CraftEventFactory.callEntityRemoveEvent(this, cause);
        boolean bl = alreadyRemoved = this.aK != null;
        if (this.aK == null) {
            this.aK = entity_removalreason;
        }
        if (this.aK.a()) {
            this.ac();
        }
        if (entity_removalreason != RemovalReason.c) {
            this.cP().forEach(Entity::ac);
        }
        this.aZ.a(entity_removalreason);
        if (!(this instanceof EntityPlayer) && entity_removalreason != RemovalReason.e && !alreadyRemoved) {
            this.retireScheduler();
        }
    }

    public void dJ() {
        this.aK = null;
    }

    public final void retireScheduler() {
        this.getBukkitEntity().taskScheduler.retire();
    }

    @Override
    public void a(EntityInLevelCallback changeListener) {
        this.aZ = changeListener;
    }

    @Override
    public boolean dK() {
        return this.aK != null && !this.aK.b() ? false : (this.bO() ? false : !this.bP() || !this.hasAnyPlayerPassengers());
    }

    @Override
    public boolean dL() {
        return false;
    }

    public boolean a(net.minecraft.world.level.World world, BlockPosition pos) {
        return true;
    }

    public net.minecraft.world.level.World dM() {
        return this.t;
    }

    public void a(net.minecraft.world.level.World world) {
        this.t = world;
    }

    public DamageSources dN() {
        return this.dM().ai();
    }

    protected void a(int step, double x2, double y2, double z2, double yaw, double pitch) {
        double d5 = 1.0 / (double)step;
        double d6 = MathHelper.d(d5, this.dr(), x2);
        double d7 = MathHelper.d(d5, this.dt(), y2);
        double d8 = MathHelper.d(d5, this.dx(), z2);
        float f2 = (float)MathHelper.e(d5, (double)this.dC(), yaw);
        float f1 = (float)MathHelper.d(d5, (double)this.dE(), pitch);
        this.a_(d6, d7, d8);
        this.a(f2, f1);
    }

    public static int nextEntityId() {
        return d.incrementAndGet();
    }

    public boolean isTicking() {
        return ((ChunkProviderServer)this.t.L()).isPositionTicking(this);
    }

    @javax.annotation.Nullable
    public EntityHuman getRider() {
        return this.rider;
    }

    public boolean isRidable() {
        return false;
    }

    public boolean isControllable() {
        return true;
    }

    public void onMount(EntityHuman rider) {
        if (this instanceof EntityInsentient) {
            ((EntityInsentient)this).setTarget(null, null, false);
            ((EntityInsentient)this).N().n();
        }
        rider.r(false);
    }

    public void onDismount(EntityHuman player) {
    }

    public boolean onSpacebar() {
        return false;
    }

    public boolean onClick(EnumHand hand) {
        return false;
    }

    public boolean processClick(EnumHand hand) {
        return false;
    }

    public static enum RemovalReason {
        a(true, false),
        b(true, false),
        c(false, true),
        d(false, false),
        e(false, false);

        private final boolean f;
        private final boolean g;

        private RemovalReason(boolean flag, boolean flag1) {
            this.f = flag;
            this.g = flag1;
        }

        public boolean a() {
            return this.f;
        }

        public boolean b() {
            return this.g;
        }
    }

    public static enum MovementEmission {
        a(false, false),
        b(true, false),
        c(false, true),
        d(true, true);

        final boolean e;
        final boolean f;

        private MovementEmission(boolean flag, boolean flag1) {
            this.e = flag;
            this.f = flag1;
        }

        public boolean a() {
            return this.f || this.e;
        }

        public boolean b() {
            return this.f;
        }

        public boolean c() {
            return this.e;
        }
    }

    public record DefaultDrop(net.minecraft.world.item.Item item, org.bukkit.inventory.ItemStack stack, @javax.annotation.Nullable Consumer<ItemStack> dropConsumer) {
        public DefaultDrop(ItemStack stack, Consumer<ItemStack> dropConsumer) {
            this(stack.d(), CraftItemStack.asCraftMirror(stack), dropConsumer);
        }

        public void runConsumer(World fallbackWorld, Location fallbackLoc) {
            if (this.dropConsumer == null || CraftItemType.bukkitToMinecraft(this.stack.getType()) != this.item) {
                fallbackWorld.dropItem(fallbackLoc, this.stack);
            } else {
                this.dropConsumer.accept(CraftItemStack.asNMSCopy(this.stack));
            }
        }
    }

    @FunctionalInterface
    public static interface MoveFunction {
        public void accept(Entity var1, double var2, double var4, double var6);
    }

    private static final class RandomRandomSource
    extends Random
    implements BitRandomSource {
        private boolean locked = false;

        private RandomRandomSource() {
        }

        @Override
        public synchronized void b(long seed) {
            if (this.locked) {
                c.error("Ignoring setSeed on Entity.SHARED_RANDOM", new Throwable());
            } else {
                super.setSeed(seed);
                this.locked = true;
            }
        }

        @Override
        public RandomSource d() {
            return new LegacyRandomSource(this.g());
        }

        @Override
        public PositionalRandomFactory e() {
            return new LegacyRandomSource.a(this.g());
        }

        @Override
        public int c(int bits) {
            return super.next(bits);
        }

        @Override
        public int b(int origin, int bound) {
            return BitRandomSource.super.b(origin, bound);
        }

        @Override
        public long g() {
            return BitRandomSource.super.g();
        }

        @Override
        public int f() {
            return BitRandomSource.super.f();
        }

        @Override
        public int a(int bound) {
            return BitRandomSource.super.a(bound);
        }

        @Override
        public boolean h() {
            return BitRandomSource.super.h();
        }

        @Override
        public float i() {
            return BitRandomSource.super.i();
        }

        @Override
        public double j() {
            return BitRandomSource.super.j();
        }

        @Override
        public double k() {
            return super.nextGaussian();
        }
    }
}

