/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;

public final class IEntitySelector {
    public static final Predicate<Entity> a = Entity::bx;
    public static final Predicate<Entity> b = entity -> entity.bx() && entity instanceof EntityLiving;
    public static final Predicate<Entity> c = entity -> entity.bx() && !entity.bP() && !entity.bO();
    public static final Predicate<Entity> d = entity -> entity instanceof IInventory && entity.bx();
    public static final Predicate<Entity> e = entity -> !(entity instanceof EntityHuman) || !entity.P_() && !((EntityHuman)entity).f();
    public static final Predicate<Entity> f = entity -> !entity.P_();
    public static final Predicate<Entity> g = f.and(Entity::bz);
    public static Predicate<EntityHuman> IS_INSOMNIAC = player -> {
        EntityPlayer serverPlayer = (EntityPlayer)player;
        int playerInsomniaTicks = serverPlayer.dM().paperConfig().entities.behavior.playerInsomniaStartTicks;
        if (playerInsomniaTicks <= 0) {
            return false;
        }
        return MathHelper.a(serverPlayer.H().a(StatisticList.i.b(StatisticList.n)), 1, Integer.MAX_VALUE) >= playerInsomniaTicks;
    };
    public static Predicate<EntityHuman> notAfk = player -> !player.isAfk();
    public static final Predicate<Entity> PLAYER_AFFECTS_SPAWNING = entity -> {
        if (entity.P_()) return false;
        if (!entity.bx()) return false;
        if (!(entity instanceof EntityHuman)) return false;
        EntityHuman player = (EntityHuman)entity;
        if (!player.affectsSpawning) return false;
        return true;
    };

    private IEntitySelector() {
    }

    public static Predicate<Entity> a(double x2, double y2, double z2, double max) {
        double d4 = max * max;
        return entity -> entity != null && entity.i(x2, y2, z2) <= d4;
    }

    public static Predicate<Entity> a(Entity entity) {
        return IEntitySelector.pushable(entity, false);
    }

    public static Predicate<Entity> pushable(Entity entity, boolean ignoreClimbing) {
        ScoreboardTeam scoreboardteam = entity.cg();
        ScoreboardTeamBase.EnumTeamPush scoreboardteambase_enumteampush = scoreboardteam == null ? ScoreboardTeamBase.EnumTeamPush.a : scoreboardteam.l();
        return scoreboardteambase_enumteampush == ScoreboardTeamBase.EnumTeamPush.b ? Predicates.alwaysFalse() : f.and(entity1 -> {
            boolean flag;
            ScoreboardTeamBase.EnumTeamPush scoreboardteambase_enumteampush1;
            if (!(entity1.isCollidable(ignoreClimbing) && entity1.canCollideWithBukkit(entity) && entity.canCollideWithBukkit((Entity)entity1))) {
                return false;
            }
            if (!(!entity.dM().B || entity1 instanceof EntityHuman && ((EntityHuman)entity1).g())) {
                return false;
            }
            ScoreboardTeam scoreboardteam1 = entity1.cg();
            ScoreboardTeamBase.EnumTeamPush enumTeamPush = scoreboardteambase_enumteampush1 = scoreboardteam1 == null ? ScoreboardTeamBase.EnumTeamPush.a : scoreboardteam1.l();
            if (scoreboardteambase_enumteampush1 == ScoreboardTeamBase.EnumTeamPush.b) {
                return false;
            }
            boolean bl = flag = scoreboardteam != null && scoreboardteam.a(scoreboardteam1);
            return (scoreboardteambase_enumteampush == ScoreboardTeamBase.EnumTeamPush.d || scoreboardteambase_enumteampush1 == ScoreboardTeamBase.EnumTeamPush.d) && flag ? false : scoreboardteambase_enumteampush != ScoreboardTeamBase.EnumTeamPush.c && scoreboardteambase_enumteampush1 != ScoreboardTeamBase.EnumTeamPush.c || flag;
        });
    }

    public static Predicate<Entity> b(Entity entity) {
        return entity1 -> {
            while (entity1.bO()) {
                if ((entity1 = entity1.cZ()) != entity) continue;
                return false;
            }
            return true;
        };
    }

    public static class EntitySelectorEquipable
    implements Predicate<Entity> {
        private final ItemStack a;

        public EntitySelectorEquipable(ItemStack stack) {
            this.a = stack;
        }

        public boolean a(@Nullable Entity entity) {
            if (!entity.bx()) {
                return false;
            }
            if (!(entity instanceof EntityLiving)) {
                return false;
            }
            EntityLiving entityliving = (EntityLiving)entity;
            return entityliving.f(this.a);
        }
    }
}

