/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import org.slf4j.Logger;

public class AttributeMapBase {
    private static final Logger a = LogUtils.getLogger();
    private final Map<AttributeBase, AttributeModifiable> b = Maps.newHashMap();
    private final Set<AttributeModifiable> c = Sets.newHashSet();
    private final AttributeProvider d;
    private final Function<AttributeBase, AttributeModifiable> createInstance;
    private final EntityLiving entity;

    public AttributeMapBase(AttributeProvider defaultAttributes) {
        this(defaultAttributes, null);
    }

    public AttributeMapBase(AttributeProvider defaultAttributes, EntityLiving entity) {
        this.entity = entity;
        this.d = defaultAttributes;
        this.createInstance = attributex -> this.d.a(this::a, (AttributeBase)attributex);
    }

    private void a(AttributeModifiable instance) {
        if (instance.a().b() && (this.entity == null || this.entity.shouldSendAttribute(instance.a()))) {
            this.c.add(instance);
        }
    }

    public Set<AttributeModifiable> a() {
        return this.c;
    }

    public Collection<AttributeModifiable> b() {
        return this.b.values().stream().filter(attribute -> attribute.a().b() && (this.entity == null || this.entity.shouldSendAttribute(attribute.a()))).collect(Collectors.toList());
    }

    @Nullable
    public AttributeModifiable a(AttributeBase attribute) {
        return this.b.computeIfAbsent(attribute, this.createInstance);
    }

    @Nullable
    public AttributeModifiable a(Holder<AttributeBase> attribute) {
        return this.a(attribute.a());
    }

    public boolean b(AttributeBase attribute) {
        return this.b.get(attribute) != null || this.d.c(attribute);
    }

    public boolean b(Holder<AttributeBase> attribute) {
        return this.b(attribute.a());
    }

    public boolean a(AttributeBase attribute, UUID uuid) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.a(uuid) != null : this.d.b(attribute, uuid);
    }

    public boolean a(Holder<AttributeBase> attribute, UUID uuid) {
        return this.a(attribute.a(), uuid);
    }

    public double c(AttributeBase attribute) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.f() : this.d.a(attribute);
    }

    public double d(AttributeBase attribute) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.b() : this.d.b(attribute);
    }

    public double b(AttributeBase attribute, UUID uuid) {
        AttributeModifiable attributeInstance = this.b.get(attribute);
        return attributeInstance != null ? attributeInstance.a(uuid).c() : this.d.a(attribute, uuid);
    }

    public double b(Holder<AttributeBase> attribute, UUID uuid) {
        return this.b(attribute.a(), uuid);
    }

    public void a(Multimap<AttributeBase, AttributeModifier> attributeModifiers) {
        attributeModifiers.asMap().forEach((attribute, modifiers) -> {
            AttributeModifiable attributeInstance = this.b.get(attribute);
            if (attributeInstance != null) {
                modifiers.forEach(modifier -> attributeInstance.b(modifier.a()));
            }
        });
    }

    public void b(Multimap<AttributeBase, AttributeModifier> attributeModifiers) {
        attributeModifiers.forEach((attribute, attributeModifier) -> {
            AttributeModifiable attributeInstance = this.a((AttributeBase)attribute);
            if (attributeInstance != null) {
                attributeInstance.b(attributeModifier.a());
                attributeInstance.b((AttributeModifier)attributeModifier);
            }
        });
    }

    public void a(AttributeMapBase other) {
        other.b.values().forEach(attributeInstance -> {
            AttributeModifiable attributeInstance2 = this.a(attributeInstance.a());
            if (attributeInstance2 != null) {
                attributeInstance2.a((AttributeModifiable)attributeInstance);
            }
        });
    }

    public NBTTagList c() {
        NBTTagList listTag = new NBTTagList();
        for (AttributeModifiable attributeInstance : this.b.values()) {
            listTag.add(attributeInstance.g());
        }
        return listTag;
    }

    public void a(NBTTagList nbt) {
        for (int i2 = 0; i2 < nbt.size(); ++i2) {
            NBTTagCompound compoundTag = nbt.a(i2);
            String string = compoundTag.l("Name");
            SystemUtils.a(BuiltInRegistries.u.b(MinecraftKey.a(string)), attribute -> {
                AttributeModifiable attributeInstance = this.a((AttributeBase)attribute);
                if (attributeInstance != null) {
                    attributeInstance.a(compoundTag);
                }
            }, () -> a.warn("Ignoring unknown attribute '{}'", (Object)string));
        }
    }

    public void registerAttribute(AttributeBase attributeBase) {
        AttributeModifiable attributeModifiable = new AttributeModifiable(attributeBase, AttributeModifiable::a);
        this.b.put(attributeBase, attributeModifiable);
    }
}

