/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import org.slf4j.Logger;

public class AttributeModifier {
    private static final Logger b = LogUtils.getLogger();
    public static final Codec<AttributeModifier> a = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.a.fieldOf("UUID").forGetter(AttributeModifier::a), (App)Codec.STRING.fieldOf("Name").forGetter(modifier -> modifier.e), (App)Codec.DOUBLE.fieldOf("Amount").forGetter(AttributeModifier::c), (App)Operation.d.fieldOf("Operation").forGetter(AttributeModifier::b)).apply((Applicative)instance, AttributeModifier::new));
    private final double c;
    private final Operation d;
    public final String e;
    private final UUID f;

    public AttributeModifier(String name, double value, Operation operation) {
        this(MathHelper.a(RandomSource.c()), name, value, operation);
    }

    public AttributeModifier(UUID uuid, String name, double value, Operation operation) {
        this.f = uuid;
        this.e = name;
        this.c = value;
        this.d = operation;
    }

    public UUID a() {
        return this.f;
    }

    public Operation b() {
        return this.d;
    }

    public double c() {
        return this.c;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AttributeModifier attributeModifier = (AttributeModifier)object;
        return Objects.equals(this.f, attributeModifier.f);
    }

    @Override
    public int hashCode() {
        return this.f.hashCode();
    }

    @Override
    public String toString() {
        return "AttributeModifier{amount=" + this.c + ", operation=" + this.d + ", name='" + this.e + "', id=" + this.f + "}";
    }

    public NBTTagCompound d() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Name", this.e);
        compoundTag.a("Amount", this.c);
        compoundTag.a("Operation", this.d.a());
        compoundTag.a("UUID", this.f);
        return compoundTag;
    }

    @Nullable
    public static AttributeModifier a(NBTTagCompound nbt) {
        try {
            UUID uUID = nbt.a("UUID");
            Operation operation = Operation.a(nbt.h("Operation"));
            return new AttributeModifier(uUID, nbt.l("Name"), nbt.k("Amount"), operation);
        }
        catch (Exception exception) {
            b.warn("Unable to create attribute: {}", (Object)exception.getMessage());
            return null;
        }
    }

    public static final class Operation
    extends Enum<Operation>
    implements INamable {
        public static final /* enum */ Operation a = new Operation("addition", 0);
        public static final /* enum */ Operation b = new Operation("multiply_base", 1);
        public static final /* enum */ Operation c = new Operation("multiply_total", 2);
        private static final Operation[] e;
        public static final Codec<Operation> d;
        private final String f;
        private final int g;
        private static final /* synthetic */ Operation[] h;

        public static Operation[] values() {
            return (Operation[])h.clone();
        }

        public static Operation valueOf(String string) {
            return Enum.valueOf(Operation.class, string);
        }

        private Operation(String name, int id) {
            this.f = name;
            this.g = id;
        }

        public int a() {
            return this.g;
        }

        public static Operation a(int id) {
            if (id < 0 || id >= e.length) {
                throw new IllegalArgumentException("No operation with value " + id);
            }
            return e[id];
        }

        @Override
        @Override
        public String c() {
            return this.f;
        }

        private static /* synthetic */ Operation[] b() {
            return new Operation[]{a, b, c};
        }

        static {
            h = Operation.b();
            e = new Operation[]{a, b, c};
            d = INamable.a(Operation::values);
        }
    }
}

