/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.phys.Vec3D;

public class AnimalPanic
extends Behavior<EntityCreature> {
    private static final int c = 100;
    private static final int d = 120;
    private static final int e = 5;
    private static final int f = 4;
    private static final Predicate<EntityCreature> g = entity -> entity.eh() != null || entity.dB() || entity.bN();
    private final float h;
    private final Predicate<EntityCreature> i;

    public AnimalPanic(float speed) {
        this(speed, g);
    }

    public AnimalPanic(float speed, Predicate<EntityCreature> predicate) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.Y, (Object)((Object)MemoryStatus.c), MemoryModuleType.x, (Object)((Object)MemoryStatus.a)), 100, 120);
        this.h = speed;
        this.i = predicate;
    }

    @Override
    @Override
    protected boolean a(WorldServer world, EntityCreature entity) {
        return this.i.test(entity);
    }

    @Override
    @Override
    protected boolean a(WorldServer world, EntityCreature entity, long time) {
        return true;
    }

    @Override
    @Override
    protected void b(WorldServer serverLevel, EntityCreature pathfinderMob, long l2) {
        pathfinderMob.dO().a(MemoryModuleType.Y, true);
        pathfinderMob.dO().b(MemoryModuleType.m);
    }

    @Override
    @Override
    protected void c(WorldServer serverLevel, EntityCreature pathfinderMob, long l2) {
        BehaviorController<?> brain = pathfinderMob.dO();
        brain.b(MemoryModuleType.Y);
    }

    @Override
    @Override
    protected void d(WorldServer serverLevel, EntityCreature pathfinderMob, long l2) {
        Vec3D vec3;
        if (pathfinderMob.N().l() && (vec3 = this.a(pathfinderMob, serverLevel)) != null) {
            pathfinderMob.dO().a(MemoryModuleType.m, new MemoryTarget(vec3, this.h, 0));
        }
    }

    @Nullable
    private Vec3D a(EntityCreature entity, WorldServer world) {
        Optional<Vec3D> optional;
        if (entity.bN() && (optional = this.a((IBlockAccess)world, (Entity)entity).map(Vec3D::c)).isPresent()) {
            return optional.get();
        }
        return LandRandomPos.a(entity, 5, 4);
    }

    private Optional<BlockPosition> a(IBlockAccess world, Entity entity) {
        Predicate<BlockPosition> predicate2;
        BlockPosition blockPos = entity.dm();
        if (!world.a_(blockPos).k(world, blockPos).c()) {
            return Optional.empty();
        }
        if (MathHelper.f(entity.dg()) == 2) {
            Predicate<BlockPosition> predicate = pos -> BlockPosition.a(pos).allMatch(posx -> world.b_((BlockPosition)posx).a(TagsFluid.a));
        } else {
            predicate2 = pos -> world.b_((BlockPosition)pos).a(TagsFluid.a);
        }
        return BlockPosition.a(blockPos, 5, 1, predicate2);
    }

    @Override
    protected /* synthetic */ void b(WorldServer world, EntityLiving entity, long time) {
        this.c(world, (EntityCreature)entity, time);
    }

    @Override
    protected /* synthetic */ void c(WorldServer world, EntityLiving entity, long time) {
        this.d(world, (EntityCreature)entity, time);
    }

    @Override
    protected /* synthetic */ void d(WorldServer world, EntityLiving entity, long time) {
        this.b(world, (EntityCreature)entity, time);
    }
}

