/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalMoveThroughVillage
extends PathfinderGoal {
    protected final EntityCreature a;
    private final double b;
    @Nullable
    private PathEntity c;
    private BlockPosition d;
    private final boolean e;
    private final List<BlockPosition> f = Lists.newArrayList();
    private final int g;
    private final BooleanSupplier h;

    public PathfinderGoalMoveThroughVillage(EntityCreature entity, double speed, boolean requiresNighttime, int distance, BooleanSupplier doorPassingThroughGetter) {
        this.a = entity;
        this.b = speed;
        this.e = requiresNighttime;
        this.g = distance;
        this.h = doorPassingThroughGetter;
        this.a(EnumSet.of(PathfinderGoal.Type.a));
        if (!PathfinderGoalUtil.a(entity)) {
            throw new IllegalArgumentException("Unsupported mob for MoveThroughVillageGoal");
        }
    }

    @Override
    @Override
    public boolean a() {
        BlockPosition blockPos;
        if (!PathfinderGoalUtil.a(this.a)) {
            return false;
        }
        this.h();
        if (this.e && this.a.dM().P()) {
            return false;
        }
        WorldServer serverLevel = (WorldServer)this.a.dM();
        if (!serverLevel.a(blockPos = this.a.dm(), 6)) {
            return false;
        }
        Vec3D vec3 = LandRandomPos.a(this.a, 15, 7, pos -> {
            if (!serverLevel.c((BlockPosition)pos)) {
                return Double.NEGATIVE_INFINITY;
            }
            Optional<BlockPosition> optional = serverLevel.y().d(poiType -> poiType.a(PoiTypeTags.b), this::a, (BlockPosition)pos, 10, VillagePlace.Occupancy.b);
            return optional.map(blockPos2 -> -blockPos2.j(blockPos)).orElse(Double.NEGATIVE_INFINITY);
        });
        if (vec3 == null) {
            return false;
        }
        Optional<BlockPosition> optional = serverLevel.y().d(poiType -> poiType.a(PoiTypeTags.b), this::a, BlockPosition.a(vec3), 10, VillagePlace.Occupancy.b);
        if (optional.isEmpty()) {
            return false;
        }
        this.d = optional.get().i();
        Navigation groundPathNavigation = (Navigation)this.a.N();
        boolean bl = groundPathNavigation.f();
        groundPathNavigation.b(this.h.getAsBoolean());
        this.c = groundPathNavigation.a(this.d, 0);
        groundPathNavigation.b(bl);
        if (this.c == null) {
            Vec3D vec32 = DefaultRandomPos.a(this.a, 10, 7, Vec3D.c(this.d), 1.5707963705062866);
            if (vec32 == null) {
                return false;
            }
            groundPathNavigation.b(this.h.getAsBoolean());
            this.c = this.a.N().a(vec32.c, vec32.d, vec32.e, 0);
            groundPathNavigation.b(bl);
            if (this.c == null) {
                return false;
            }
        }
        for (int i2 = 0; i2 < this.c.e(); ++i2) {
            PathPoint node = this.c.a(i2);
            BlockPosition blockPos2 = new BlockPosition(node.a, node.b + 1, node.c);
            if (!BlockDoor.a(this.a.dM(), blockPos2)) continue;
            this.c = this.a.N().a((double)node.a, (double)node.b, (double)node.c, 0);
            break;
        }
        return this.c != null;
    }

    @Override
    @Override
    public boolean b() {
        if (this.a.N().l()) {
            return false;
        }
        return !this.d.a(this.a.dk(), (double)(this.a.dg() + (float)this.g));
    }

    @Override
    @Override
    public void c() {
        this.a.N().a(this.c, this.b);
    }

    @Override
    @Override
    public void d() {
        if (this.a.N().l() || this.d.a(this.a.dk(), (double)this.g)) {
            this.f.add(this.d);
        }
    }

    private boolean a(BlockPosition pos) {
        for (BlockPosition blockPos : this.f) {
            if (!Objects.equals(pos, blockPos)) continue;
            return false;
        }
        return true;
    }

    private void h() {
        if (this.f.size() > 15) {
            this.f.remove(0);
        }
    }
}

