/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.annotation.DoNotUse;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockLightAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class EntityAnimal
extends EntityAgeable {
    protected static final int bV = 6000;
    public int bT;
    @Nullable
    public UUID bU;
    public ItemStack breedItem;

    public abstract int getPurpurBreedTime();

    protected EntityAnimal(EntityTypes<? extends EntityAnimal> type, World world) {
        super((EntityTypes<? extends EntityAgeable>)type, world);
        this.a(PathType.n, 16.0f);
        this.a(PathType.o, -1.0f);
    }

    @Override
    protected void Z() {
        if (this.h() != 0) {
            this.bT = 0;
        }
        super.Z();
    }

    @Override
    public void d_() {
        super.d_();
        if (this.h() != 0) {
            this.bT = 0;
        }
        if (this.bT > 0) {
            --this.bT;
            if (this.bT % 10 == 0) {
                double d0 = this.ag.k() * 0.02;
                double d1 = this.ag.k() * 0.02;
                double d2 = this.ag.k() * 0.02;
                this.dM().a(Particles.O, this.d(1.0), this.du() + 0.5, this.g(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        boolean result = super.a(source, amount);
        if (result) {
            this.bT = 0;
        }
        return result;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return world.a_(pos.d()).a(Blocks.i) ? 10.0f : world.w(pos);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("InLove", this.bT);
        if (this.bU != null) {
            nbt.a("LoveCause", this.bU);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.bT = nbt.h("InLove");
        this.bU = nbt.b("LoveCause") ? nbt.a("LoveCause") : null;
    }

    public static boolean b(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        boolean flag = EnumMobSpawn.b(spawnReason) || EntityAnimal.a(world, pos);
        return world.a_(pos.d()).a(TagsBlock.bP) && flag;
    }

    protected static boolean a(IBlockLightAccess world, BlockPosition pos) {
        return world.b(pos, 0) > 8;
    }

    @Override
    public int Q() {
        return 120;
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    public int ee() {
        return 1 + this.dM().z.a(3);
    }

    public boolean m(ItemStack stack) {
        return stack.a(Items.pt);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (this.m(itemstack)) {
            int i2 = this.h();
            if (!(this.dM().B || i2 != 0 || !this.gf() || this.dM().purpurConfig.animalBreedingCooldownSeconds > 0 && this.dM().hasBreedingCooldown(player.cw(), this.getClass()))) {
                ItemStack breedCopy = itemstack.p();
                this.a(player, hand, itemstack);
                this.setInLove(player, breedCopy);
                return EnumInteractionResult.a;
            }
            if (this.o_()) {
                this.a(player, hand, itemstack);
                this.a(EntityAnimal.d_(-i2), true);
                return EnumInteractionResult.a(this.dM().B);
            }
            if (this.dM().B) {
                return EnumInteractionResult.b;
            }
        }
        return super.b(player, hand);
    }

    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (!player.fT().d) {
            stack.h(1);
        }
    }

    public boolean gf() {
        return this.bT <= 0;
    }

    @Deprecated
    @DoNotUse
    public void g(@Nullable EntityHuman player) {
        this.setInLove(player, null);
    }

    public void setInLove(@Nullable EntityHuman player, @Nullable ItemStack breedItemCopy) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent;
        if (breedItemCopy != null) {
            this.breedItem = breedItemCopy;
        }
        if ((entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent(player, this, 600)).isCancelled()) {
            this.breedItem = null;
            return;
        }
        this.bT = entityEnterLoveModeEvent.getTicksInLove();
        if (player != null) {
            this.bU = player.cw();
        }
        this.dM().a((Entity)this, (byte)18);
    }

    public void s(int loveTicks) {
        this.bT = loveTicks;
    }

    public int gg() {
        return this.bT;
    }

    @Nullable
    public EntityPlayer gh() {
        if (this.bU == null) {
            return null;
        }
        EntityHuman entityhuman = this.dM().b(this.bU);
        return entityhuman instanceof EntityPlayer ? (EntityPlayer)entityhuman : null;
    }

    public boolean gi() {
        return this.bT > 0;
    }

    public void gj() {
        this.bT = 0;
    }

    public boolean a(EntityAnimal other) {
        return other == this ? false : (other.getClass() != this.getClass() ? false : this.gi() && other.gi());
    }

    public void a(WorldServer world, EntityAnimal other) {
        EntityAgeable entityageable = this.a(world, (EntityAgeable)other);
        if (entityageable != null) {
            EntityPlayer breeder = Optional.ofNullable(this.gh()).or(() -> Optional.ofNullable(other.gh())).orElse(null);
            if (breeder != null && world.purpurConfig.animalBreedingCooldownSeconds > 0) {
                if (world.hasBreedingCooldown(breeder.cw(), this.getClass())) {
                    return;
                }
                world.addBreedingCooldown(breeder.cw(), this.getClass());
            }
            entityageable.a(true);
            entityageable.b(this.dr(), this.dt(), this.dx(), 0.0f, 0.0f);
            int experience = this.eg().a(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityageable, this, other, breeder, this.breedItem, experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            this.finalizeSpawnChildFromBreeding(world, other, entityageable, experience);
            world.addFreshEntityWithPassengers(entityageable, CreatureSpawnEvent.SpawnReason.BREEDING);
        }
    }

    public void a(WorldServer world, EntityAnimal other, @Nullable EntityAgeable baby) {
        this.finalizeSpawnChildFromBreeding(world, other, baby, this.eg().a(7) + 1);
    }

    public void finalizeSpawnChildFromBreeding(WorldServer worldserver, EntityAnimal entityanimal, @Nullable EntityAgeable entityageable, int experience) {
        EntityPlayer entityplayer = this.gh();
        if (entityplayer == null) {
            entityplayer = entityanimal.gh();
        }
        if (entityplayer != null) {
            entityplayer.a(StatisticList.P);
            CriterionTriggers.p.a(entityplayer, this, entityanimal, entityageable);
        }
        this.c_(this.getPurpurBreedTime());
        entityanimal.c_(entityanimal.getPurpurBreedTime());
        this.gj();
        entityanimal.gj();
        worldserver.a((Entity)this, (byte)18);
        if (worldserver.Z().b(GameRules.f) && experience > 0) {
            worldserver.b(new EntityExperienceOrb(worldserver, this.dr(), this.dt(), this.dx(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityageable));
        }
    }

    @Override
    public void b(byte status) {
        if (status == 18) {
            for (int i2 = 0; i2 < 7; ++i2) {
                double d0 = this.ag.k() * 0.02;
                double d1 = this.ag.k() * 0.02;
                double d2 = this.ag.k() * 0.02;
                this.dM().a(Particles.O, this.d(1.0), this.du() + 0.5, this.g(1.0), d0, d1, d2);
            }
        } else {
            super.b(status);
        }
    }
}

