/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityChicken
extends EntityAnimal {
    private static final RecipeItemStack cb = RecipeItemStack.a(Items.ps, Items.rW, Items.rV, Items.ve, Items.vb, Items.vc);
    public float bT;
    public float bU;
    public float bW;
    public float bX;
    public float bY = 1.0f;
    private float cc = 1.0f;
    public int bZ = this.ag.a(6000) + 6000;
    public boolean ca;

    public EntityChicken(EntityTypes<? extends EntityChicken> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.a(PathType.j, 0.0f);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.chickenRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.chickenRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.chickenControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.chickenMaxHealth);
        if (this.dM().purpurConfig.chickenRetaliate) {
            this.a(GenericAttributes.c).a(2.0);
        }
    }

    @Override
    public int getPurpurBreedTime() {
        return this.dM().purpurConfig.chickenBreedingTicks;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.chickenTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.chickenAlwaysDropExp;
    }

    @Override
    protected void B() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(0, new HasRider(this));
        this.bO.a(2, new PathfinderGoalBreed(this, 1.0));
        this.bO.a(3, new PathfinderGoalTempt(this, 1.0, cb, false));
        this.bO.a(4, new PathfinderGoalFollowParent(this, 1.1));
        this.bO.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(7, new PathfinderGoalRandomLookaround(this));
        if (this.dM().purpurConfig.chickenRetaliate) {
            this.bO.a(1, new PathfinderGoalMeleeAttack(this, 1.0, false));
            this.bP.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        } else {
            this.bO.a(1, new PathfinderGoalPanic(this, 1.4));
        }
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.o_() ? dimensions.b * 0.85f : dimensions.b * 0.92f;
    }

    public static AttributeProvider.Builder u() {
        return EntityInsentient.C().a(GenericAttributes.l, 4.0).a(GenericAttributes.m, 0.25).a(GenericAttributes.c, 0.0);
    }

    @Override
    public void d_() {
        super.d_();
        this.bX = this.bT;
        this.bW = this.bU;
        this.bU += (this.aC() ? -1.0f : 4.0f) * 0.3f;
        this.bU = MathHelper.a(this.bU, 0.0f, 1.0f);
        if (!this.aC() && this.bY < 1.0f) {
            this.bY = 1.0f;
        }
        this.bY *= 0.9f;
        Vec3D vec3d = this.dp();
        if (!this.aC() && vec3d.d < 0.0) {
            this.g(vec3d.d(1.0, 0.6, 1.0));
        }
        this.bT += this.bY * 2.0f;
        if (!this.dM().B && this.bx() && !this.o_() && !this.w() && --this.bZ <= 0) {
            this.a(SoundEffects.ev, 1.0f, (this.ag.i() - this.ag.i()) * 0.2f + 1.0f);
            this.forceDrops = true;
            this.a((IMaterial)Items.qO);
            this.forceDrops = false;
            this.a(GameEvent.t);
            this.bZ = this.ag.a(6000) + 6000;
        }
    }

    @Override
    protected boolean aT() {
        return this.aa > this.cc;
    }

    @Override
    protected void aS() {
        this.cc = this.aa + this.bU / 2.0f;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.et;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.ew;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.eu;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.ex, 0.15f, 1.0f);
    }

    @Nullable
    public EntityChicken b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.r.a(world);
    }

    @Override
    public boolean m(ItemStack stack) {
        return cb.a(stack);
    }

    @Override
    public int ee() {
        return this.w() ? 10 : super.ee();
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.ca = nbt.q("IsChickenJockey");
        if (nbt.e("EggLayTime")) {
            this.bZ = nbt.h("EggLayTime");
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsChickenJockey", this.ca);
        nbt.a("EggLayTime", this.bZ);
    }

    @Override
    public boolean h(double distanceSquared) {
        return this.w();
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.a(passenger, positionUpdater);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).aU = this.aU;
        }
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b, -0.1f * scaleFactor);
    }

    public boolean w() {
        return this.ca;
    }

    public void w(boolean hasJockey) {
        this.ca = hasJockey;
    }
}

