/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.destroystokyo.paper.event.entity.EntityTransformedEvent;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.joml.Vector3f;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityCow
extends EntityAnimal {
    private boolean isNaturallyAggressiveToPlayers;
    private int redMushroomsFed = 0;
    private int brownMushroomsFed = 0;

    public EntityCow(EntityTypes<? extends EntityCow> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.cowRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.cowRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.cowControllable;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.cowMaxHealth);
        this.a(GenericAttributes.c).a(this.dM().purpurConfig.cowNaturallyAggressiveToPlayersDamage);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.dM().purpurConfig.cowBreedingTicks;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.cowTakeDamageFromWater;
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, GroupDataEntity entityData, NBTTagCompound entityNbt) {
        this.isNaturallyAggressiveToPlayers = world.E().purpurConfig.cowNaturallyAggressiveToPlayersChance > 0.0 && this.ag.j() <= world.E().purpurConfig.cowNaturallyAggressiveToPlayersChance;
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.cowAlwaysDropExp;
    }

    @Override
    protected void B() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(0, new HasRider(this));
        this.bO.a(1, new PathfinderGoalPanic(this, 2.0));
        this.bO.a(1, new PathfinderGoalMeleeAttack(this, 1.2f, true));
        this.bO.a(2, new PathfinderGoalBreed(this, 1.0));
        if (this.dM().purpurConfig.cowFeedMushrooms > 0) {
            this.bO.a(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(Items.pt, Blocks.cg.k(), Blocks.cf.k()), false));
        } else {
            this.bO.a(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(Items.pt), false));
        }
        this.bO.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.bO.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(7, new PathfinderGoalRandomLookaround(this));
        this.bP.a(0, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, target -> this.isNaturallyAggressiveToPlayers));
    }

    public static AttributeProvider.Builder u() {
        return EntityInsentient.C().a(GenericAttributes.l, 10.0).a(GenericAttributes.m, 0.2f).a(GenericAttributes.c, 0.0);
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.fy;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.fA;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.fz;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.fC, 0.15f, 1.0f);
    }

    @Override
    public float eW() {
        return 0.4f;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        if (this.getRider() != null) {
            return EnumInteractionResult.d;
        }
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.qv) && !this.o_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)player.dM(), player, this.dm(), this.dm(), null, itemstack, Items.qB, hand);
            if (event.isCancelled()) {
                return this.tryRide(player, hand);
            }
            player.a(SoundEffects.fB, 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemstack1);
            return EnumInteractionResult.a(this.dM().B);
        }
        if (this.dM().purpurConfig.cowFeedMushrooms > 0 && this.ai() != EntityTypes.ap && this.isMushroom(itemstack)) {
            return this.feedMushroom(player, itemstack);
        }
        return super.b(player, hand);
    }

    @Nullable
    public EntityCow b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.u.a(world);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.o_() ? dimensions.b * 0.95f : 1.3f;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.03125f * scaleFactor, 0.0f);
    }

    private boolean isMushroom(ItemStack stack) {
        return stack.d() == Blocks.cg.k() || stack.d() == Blocks.cf.k();
    }

    private int incrementFeedCount(ItemStack stack) {
        if (stack.d() == Blocks.cg.k()) {
            return ++this.redMushroomsFed;
        }
        return ++this.brownMushroomsFed;
    }

    private EnumInteractionResult feedMushroom(EntityHuman player, ItemStack stack) {
        this.dM().a((Entity)this, (byte)18);
        this.a(SoundEffects.fB, 1.0f, 1.0f);
        if (this.incrementFeedCount(stack) < this.dM().purpurConfig.cowFeedMushrooms) {
            if (!player.fT().d) {
                stack.h(1);
            }
            return EnumInteractionResult.b;
        }
        EntityMushroomCow mooshroom = EntityTypes.ap.a(this.dM());
        if (mooshroom == null) {
            return EnumInteractionResult.d;
        }
        if (stack.d() == Blocks.cf.k()) {
            mooshroom.a(EntityMushroomCow.Type.b);
        } else {
            mooshroom.a(EntityMushroomCow.Type.a);
        }
        mooshroom.b(this.dr(), this.dt(), this.dx(), this.dC(), this.dE());
        mooshroom.c(this.ev());
        mooshroom.c_(this.h());
        mooshroom.v(this);
        mooshroom.o(this.aU);
        mooshroom.n(this.cp());
        mooshroom.N = this.N;
        mooshroom.O = this.O;
        if (this.ae()) {
            mooshroom.b(this.af());
        }
        if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, mooshroom, EntityTransformEvent.TransformReason.INFECTION).isCancelled()) {
            return EnumInteractionResult.d;
        }
        if (!new EntityTransformedEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)mooshroom.getBukkitEntity(), EntityTransformedEvent.TransformedReason.INFECTED).callEvent()) {
            return EnumInteractionResult.d;
        }
        this.dM().b(mooshroom);
        this.remove(Entity.RemovalReason.b, EntityRemoveEvent.Cause.DISCARD);
        if (!player.fT().d) {
            stack.h(1);
        }
        for (int i2 = 0; i2 < 15; ++i2) {
            ((WorldServer)this.dM()).sendParticles(((WorldServer)this.dM()).x(), null, Particles.M, this.dr() + (double)this.ag.i(), this.dt() + (double)(this.ag.i() * 2.0f), this.dx() + (double)this.ag.i(), 1, this.ag.k() * 0.05, this.ag.k() * 0.05, this.ag.k() * 0.05, 0.0, true);
        }
        return EnumInteractionResult.a;
    }
}

