/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreath;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowBoat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomSwim;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWater;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJump;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityGuardian;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.util.Vector;
import org.purpurmc.purpur.controller.WaterMoveControllerWASD;
import org.purpurmc.purpur.entity.DolphinSpit;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityDolphin
extends EntityWaterAnimal {
    private static final DataWatcherObject<BlockPosition> d = DataWatcher.a(EntityDolphin.class, DataWatcherRegistry.n);
    private static final DataWatcherObject<Boolean> e = DataWatcher.a(EntityDolphin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bT = DataWatcher.a(EntityDolphin.class, DataWatcherRegistry.b);
    static final PathfinderTargetCondition bU = PathfinderTargetCondition.b().a(10.0).d();
    public static final int b = 4800;
    private static final int bV = 2400;
    public static final Predicate<EntityItem> c = entityitem -> !entityitem.z() && entityitem.bx() && entityitem.aZ();
    private boolean isNaturallyAggressiveToPlayers;
    private int spitCooldown;

    @Override
    public int getDefaultMaxAirSupply() {
        return 4800;
    }

    public EntityDolphin(EntityTypes<? extends EntityDolphin> type, World world) {
        super((EntityTypes<? extends EntityWaterAnimal>)type, world);
        class DolphinMoveControl
        extends SmoothSwimmingMoveControl {
            private final WaterMoveControllerWASD waterMoveControllerWASD;
            private final EntityDolphin dolphin;

            public DolphinMoveControl(EntityDolphin dolphin, int pitchChange, int yawChange, float speedInWater, float speedInAir, boolean buoyant) {
                super(dolphin, pitchChange, yawChange, speedInWater, speedInAir, buoyant);
                this.dolphin = dolphin;
                this.waterMoveControllerWASD = new WaterMoveControllerWASD(dolphin);
            }

            @Override
            public void a() {
                if (this.dolphin.getRider() != null && this.dolphin.isControllable()) {
                    this.purpurTick(this.dolphin.getRider());
                } else {
                    super.a();
                }
            }

            public void purpurTick(EntityHuman rider) {
                if (this.dolphin.ci() < 150) {
                    super.a();
                } else {
                    this.waterMoveControllerWASD.purpurTick(rider);
                    this.dolphin.g(this.dolphin.dp().b(0.0, 0.005, 0.0));
                }
            }
        }
        this.bL = new DolphinMoveControl(this, 85, 10, 0.02f, 0.1f, true);
        this.bK = new SmoothSwimmingLookControl(this, 10);
        this.s(true);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.dolphinRidable;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.dolphinControllable;
    }

    @Override
    public boolean onSpacebar() {
        if (this.spitCooldown == 0 && this.getRider() != null) {
            this.spitCooldown = this.dM().purpurConfig.dolphinSpitCooldown;
            CraftPlayer player = (CraftPlayer)this.getRider().getBukkitEntity();
            if (!player.hasPermission("allow.special.dolphin")) {
                return false;
            }
            Location loc = player.getEyeLocation();
            loc.setPitch(loc.getPitch() - 10.0f);
            Vector target = loc.getDirection().normalize().multiply(10).add(loc.toVector());
            DolphinSpit spit = new DolphinSpit(this.dM(), this);
            spit.c(target.getX() - this.dr(), target.getY() - this.dt(), target.getZ() - this.dx(), this.dM().purpurConfig.dolphinSpitSpeed, 5.0f);
            this.dM().b(spit);
            this.a(SoundEffects.gu, 1.0f, 1.0f + (this.ag.i() - this.ag.i()) * 0.2f);
            return true;
        }
        return false;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.dolphinMaxHealth);
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.dolphinTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.dolphinAlwaysDropExp;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.j(this.ch());
        this.s(0.0f);
        this.isNaturallyAggressiveToPlayers = world.E().purpurConfig.dolphinNaturallyAggressiveToPlayersChance > 0.0 && this.ag.j() <= world.E().purpurConfig.dolphinNaturallyAggressiveToPlayersChance;
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected void b(int air) {
    }

    public void i(BlockPosition treasurePos) {
        this.an.b(d, treasurePos);
    }

    public BlockPosition u() {
        return this.an.b(d);
    }

    public boolean w() {
        return this.an.b(e);
    }

    public void w(boolean hasFish) {
        this.an.b(e, hasFish);
    }

    public int A() {
        return this.an.b(bT);
    }

    public void c(int moistness) {
        this.an.b(bT, moistness);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(d, BlockPosition.b);
        this.an.a(e, false);
        this.an.a(bT, 2400);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("TreasurePosX", this.u().u());
        nbt.a("TreasurePosY", this.u().v());
        nbt.a("TreasurePosZ", this.u().w());
        nbt.a("GotFish", this.w());
        nbt.a("Moistness", this.A());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2 = nbt.h("TreasurePosX");
        int j2 = nbt.h("TreasurePosY");
        int k2 = nbt.h("TreasurePosZ");
        this.i(new BlockPosition(i2, j2, k2));
        super.a(nbt);
        this.w(nbt.q("GotFish"));
        this.c(nbt.h("Moistness"));
    }

    @Override
    protected void B() {
        this.bO.a(0, new PathfinderGoalBreath(this));
        this.bO.a(0, new PathfinderGoalWater(this));
        this.bO.a(1, new PathfinderGoalMeleeAttack(this, 1.2f, true));
        this.bO.a(0, new HasRider(this));
        this.bO.a(1, new a(this));
        this.bO.a(2, new b(this, 4.0));
        this.bO.a(4, new PathfinderGoalRandomSwim(this, 1.0, 10));
        this.bO.a(4, new PathfinderGoalRandomLookaround(this));
        this.bO.a(5, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(5, new PathfinderGoalWaterJump(this, 10));
        this.bO.a(8, new c());
        this.bO.a(8, new PathfinderGoalFollowBoat(this));
        this.bO.a(9, new PathfinderGoalAvoidTarget<EntityGuardian>(this, EntityGuardian.class, 8.0f, 1.0, 1.0));
        this.bP.a(0, new HasRider(this));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, EntityGuardian.class).a(new Class[0]));
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, target -> this.isNaturallyAggressiveToPlayers));
    }

    public static AttributeProvider.Builder ge() {
        return EntityInsentient.C().a(GenericAttributes.l, 10.0).a(GenericAttributes.m, 1.2f).a(GenericAttributes.c, 3.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new NavigationGuardian(this, world);
    }

    @Override
    public boolean C(Entity target) {
        boolean flag = target.a(this.dN().b(this), (float)((int)this.b(GenericAttributes.c)));
        if (flag) {
            this.a((EntityLiving)this, target);
            this.a(SoundEffects.gu, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public int ch() {
        return this.maxAirTicks;
    }

    @Override
    protected int n(int air) {
        return this.ch();
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.3f;
    }

    @Override
    public int aa() {
        return 1;
    }

    @Override
    public int ab() {
        return 1;
    }

    @Override
    protected boolean o(Entity entity) {
        return this.J <= 0;
    }

    @Override
    public boolean f(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return !this.c(enumitemslot).b() ? false : enumitemslot == EnumItemSlot.a && super.f(stack);
    }

    @Override
    protected void b(EntityItem item) {
        ItemStack itemstack;
        if (this.c(EnumItemSlot.a).b() && this.j(itemstack = item.q())) {
            if (CraftEventFactory.callEntityPickupItemEvent(this, item, 0, false).isCancelled()) {
                return;
            }
            itemstack = item.q();
            this.a(item);
            this.a(EnumItemSlot.a, itemstack);
            this.e(EnumItemSlot.a);
            this.a((Entity)item, itemstack.L());
            item.discard(EntityRemoveEvent.Cause.PICKUP);
        }
    }

    @Override
    public void l() {
        super.l();
        if (this.spitCooldown > 0) {
            --this.spitCooldown;
        }
        if (this.fU()) {
            this.j(this.ch());
        } else {
            if (this.bb()) {
                this.c(2400);
            } else {
                this.c(this.A() - 1);
                if (this.A() <= 0) {
                    this.a(this.dN().r(), 1.0f);
                }
                if (this.aC()) {
                    this.g(this.dp().b((this.ag.i() * 2.0f - 1.0f) * 0.2f, 0.5, (this.ag.i() * 2.0f - 1.0f) * 0.2f));
                    this.r(this.ag.i() * 360.0f);
                    this.c(false);
                    this.au = true;
                }
            }
            if (this.dM().B && this.aZ() && this.dp().g() > 0.03) {
                Vec3D vec3d = this.f(0.0f);
                float f2 = MathHelper.b(this.dC() * ((float)Math.PI / 180)) * 0.3f;
                float f1 = MathHelper.a(this.dC() * ((float)Math.PI / 180)) * 0.3f;
                float f22 = 1.2f - this.ag.i() * 0.7f;
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.dM().a(Particles.ap, this.dr() - vec3d.c * (double)f22 + (double)f2, this.dt() - vec3d.d, this.dx() - vec3d.e * (double)f22 + (double)f1, 0.0, 0.0, 0.0);
                    this.dM().a(Particles.ap, this.dr() - vec3d.c * (double)f22 - (double)f2, this.dt() - vec3d.d, this.dx() - vec3d.e * (double)f22 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void b(byte status) {
        if (status == 38) {
            this.a(Particles.M);
        } else {
            super.b(status);
        }
    }

    private void a(ParticleParam parameters) {
        for (int i2 = 0; i2 < 7; ++i2) {
            double d0 = this.ag.k() * 0.01;
            double d1 = this.ag.k() * 0.01;
            double d2 = this.ag.k() * 0.01;
            this.dM().a(parameters, this.d(1.0), this.du() + 0.2, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!itemstack.b() && itemstack.a(TagsItem.ao)) {
            if (!this.dM().B) {
                this.a(SoundEffects.gw, 1.0f, 1.0f);
            }
            this.w(true);
            if (!player.fT().d) {
                itemstack.h(1);
            }
            return EnumInteractionResult.a(this.dM().B);
        }
        return super.b(player, hand);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.gx;
    }

    @Override
    @Nullable
    public SoundEffect n_() {
        return SoundEffects.gv;
    }

    @Override
    @Nullable
    protected SoundEffect y() {
        return this.aZ() ? SoundEffects.gt : SoundEffects.gs;
    }

    @Override
    protected SoundEffect aO() {
        return SoundEffects.gA;
    }

    @Override
    protected SoundEffect aN() {
        return SoundEffects.gB;
    }

    protected boolean gf() {
        BlockPosition blockposition = this.N().h();
        return blockposition != null ? blockposition.a(this.dk(), 12.0) : false;
    }

    @Override
    public void a(Vec3D movementInput) {
        if (this.cY() && this.aZ()) {
            this.a(this.ff(), movementInput);
            this.a(EnumMoveType.a, this.dp());
            this.g(this.dp().a(0.9));
            if (this.q() == null) {
                this.g(this.dp().b(0.0, -0.005, 0.0));
            }
        } else {
            super.a(movementInput);
        }
    }

    @Override
    public boolean a(EntityHuman player) {
        return true;
    }

    private static class a
    extends PathfinderGoal {
        private final EntityDolphin a;
        private boolean b;

        a(EntityDolphin dolphin) {
            this.a = dolphin;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean S_() {
            return false;
        }

        @Override
        public boolean a() {
            if (this.a.dM().purpurConfig.dolphinDisableTreasureSearching) {
                return false;
            }
            return this.a.w() && this.a.ci() >= 100;
        }

        @Override
        public boolean b() {
            BlockPosition blockposition = this.a.u();
            return !BlockPosition.a((double)blockposition.u(), this.a.dt(), (double)blockposition.w()).a(this.a.dk(), 4.0) && !this.b && this.a.ci() >= 100;
        }

        @Override
        public void c() {
            if (this.a.dM() instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)this.a.dM();
                this.b = false;
                this.a.N().n();
                BlockPosition blockposition = this.a.dm();
                BlockPosition blockposition1 = worldserver.a(StructureTags.b, blockposition, 50, false);
                if (blockposition1 != null) {
                    this.a.i(blockposition1);
                    worldserver.a((Entity)this.a, (byte)38);
                } else {
                    this.b = true;
                }
            }
        }

        @Override
        public void d() {
            BlockPosition blockposition = this.a.u();
            if (BlockPosition.a((double)blockposition.u(), this.a.dt(), (double)blockposition.w()).a(this.a.dk(), 4.0) || this.b) {
                this.a.w(false);
            }
        }

        @Override
        public void e() {
            World world = this.a.dM();
            if (this.a.gf() || this.a.N().l()) {
                BlockPosition blockposition;
                Vec3D vec3d = Vec3D.b(this.a.u());
                Vec3D vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 16, 1, vec3d, 0.3926991f);
                if (vec3d1 == null) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 4, vec3d, 1.5707963705062866);
                }
                if (!(vec3d1 == null || world.b_(blockposition = BlockPosition.a(vec3d1)).a(TagsFluid.a) && world.a_(blockposition).a((IBlockAccess)world, blockposition, PathMode.b))) {
                    vec3d1 = DefaultRandomPos.a((EntityCreature)this.a, 8, 5, vec3d, 1.5707963705062866);
                }
                if (vec3d1 == null) {
                    this.b = true;
                    return;
                }
                this.a.I().a(vec3d1.c, vec3d1.d, vec3d1.e, this.a.ab() + 20, this.a.aa());
                this.a.N().a(vec3d1.c, vec3d1.d, vec3d1.e, 1.3);
                if (world.z.a(this.a(80)) == 0) {
                    world.a((Entity)this.a, (byte)38);
                }
            }
        }
    }

    private static class b
    extends PathfinderGoal {
        private final EntityDolphin a;
        private final double b;
        @Nullable
        private EntityHuman c;

        b(EntityDolphin dolphin, double speed) {
            this.a = dolphin;
            this.b = speed;
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            this.c = this.a.dM().a(bU, this.a);
            return this.c == null ? false : this.c.bZ() && this.a.q() != this.c;
        }

        @Override
        public boolean b() {
            return this.c != null && this.c.bZ() && this.a.f((Entity)this.c) < 256.0;
        }

        @Override
        public void c() {
            this.c.addEffect(new MobEffect(MobEffects.D, 100), this.a, EntityPotionEffectEvent.Cause.DOLPHIN);
        }

        @Override
        public void d() {
            this.c = null;
            this.a.N().n();
        }

        @Override
        public void e() {
            this.a.I().a(this.c, (float)(this.a.ab() + 20), (float)this.a.aa());
            if (this.a.f((Entity)this.c) < 6.25) {
                this.a.N().n();
            } else {
                this.a.N().a((Entity)this.c, this.b);
            }
            if (this.c.bZ() && this.c.dM().z.a(6) == 0) {
                this.c.addEffect(new MobEffect(MobEffects.D, 100), this.a, EntityPotionEffectEvent.Cause.DOLPHIN);
            }
        }
    }

    private class c
    extends PathfinderGoal {
        private int b;

        c() {
        }

        @Override
        public boolean a() {
            if (this.b > EntityDolphin.this.ah) {
                return false;
            }
            List<EntityItem> list = EntityDolphin.this.dM().a(EntityItem.class, EntityDolphin.this.cH().c(8.0, 8.0, 8.0), c);
            return !list.isEmpty() || !EntityDolphin.this.c(EnumItemSlot.a).b();
        }

        @Override
        public void c() {
            List<EntityItem> list = EntityDolphin.this.dM().a(EntityItem.class, EntityDolphin.this.cH().c(8.0, 8.0, 8.0), c);
            if (!list.isEmpty()) {
                EntityDolphin.this.N().a((Entity)list.get(0), (double)1.2f);
                EntityDolphin.this.a(SoundEffects.gz, 1.0f, 1.0f);
            }
            this.b = 0;
        }

        @Override
        public void d() {
            ItemStack itemstack = EntityDolphin.this.c(EnumItemSlot.a);
            if (!itemstack.b()) {
                this.a(itemstack);
                EntityDolphin.this.a(EnumItemSlot.a, ItemStack.f);
                this.b = EntityDolphin.this.ah + EntityDolphin.this.ag.a(100);
            }
        }

        @Override
        public void e() {
            List<EntityItem> list = EntityDolphin.this.dM().a(EntityItem.class, EntityDolphin.this.cH().c(8.0, 8.0, 8.0), c);
            ItemStack itemstack = EntityDolphin.this.c(EnumItemSlot.a);
            if (!itemstack.b()) {
                this.a(itemstack);
                EntityDolphin.this.a(EnumItemSlot.a, ItemStack.f);
            } else if (!list.isEmpty()) {
                EntityDolphin.this.N().a((Entity)list.get(0), (double)1.2f);
            }
        }

        private void a(ItemStack stack) {
            if (!stack.b()) {
                double d0 = EntityDolphin.this.dv() - (double)0.3f;
                EntityItem entityitem = new EntityItem(EntityDolphin.this.dM(), EntityDolphin.this.dr(), d0, EntityDolphin.this.dx(), stack);
                entityitem.b(40);
                entityitem.a(EntityDolphin.this);
                float f2 = 0.3f;
                float f1 = EntityDolphin.this.ag.i() * ((float)Math.PI * 2);
                float f22 = 0.02f * EntityDolphin.this.ag.i();
                entityitem.o(0.3f * -MathHelper.a(EntityDolphin.this.dC() * ((float)Math.PI / 180)) * MathHelper.b(EntityDolphin.this.dE() * ((float)Math.PI / 180)) + MathHelper.b(f1) * f22, 0.3f * MathHelper.a(EntityDolphin.this.dE() * ((float)Math.PI / 180)) * 1.5f, 0.3f * MathHelper.b(EntityDolphin.this.dC() * ((float)Math.PI / 180)) * MathHelper.b(EntityDolphin.this.dE() * ((float)Math.PI / 180)) + MathHelper.a(f1) * f22);
                EntityDolphin.this.spawnAtLocation(entityitem);
            }
        }
    }
}

