/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowEntity;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPerch;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityBird;
import net.minecraft.world.entity.animal.EntityPerchable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.joml.Vector3f;
import org.purpurmc.purpur.controller.FlyingWithSpacebarMoveControllerWASD;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityParrot
extends EntityPerchable
implements VariantHolder<Variant>,
EntityBird {
    private static final DataWatcherObject<Integer> ca = DataWatcher.a(EntityParrot.class, DataWatcherRegistry.b);
    private static final Predicate<EntityInsentient> cb = new Predicate<EntityInsentient>(){

        public boolean a(@Nullable EntityInsentient entityinsentient) {
            return entityinsentient != null && ce.containsKey(entityinsentient.ai());
        }
    };
    private static final Item cc = Items.rP;
    private static final Set<Item> cd = Sets.newHashSet((Object[])new Item[]{Items.ps, Items.rW, Items.rV, Items.ve, Items.vb, Items.vc});
    static final Map<EntityTypes<?>, SoundEffect> ce = SystemUtils.a(Maps.newHashMap(), (? super T hashmap) -> {
        hashmap.put(EntityTypes.i, SoundEffects.rO);
        hashmap.put(EntityTypes.l, SoundEffects.rP);
        hashmap.put(EntityTypes.o, SoundEffects.sl);
        hashmap.put(EntityTypes.v, SoundEffects.rQ);
        hashmap.put(EntityTypes.z, SoundEffects.rR);
        hashmap.put(EntityTypes.B, SoundEffects.rS);
        hashmap.put(EntityTypes.D, SoundEffects.rT);
        hashmap.put(EntityTypes.G, SoundEffects.rU);
        hashmap.put(EntityTypes.H, SoundEffects.rV);
        hashmap.put(EntityTypes.R, SoundEffects.rW);
        hashmap.put(EntityTypes.W, SoundEffects.rX);
        hashmap.put(EntityTypes.X, SoundEffects.rY);
        hashmap.put(EntityTypes.aa, SoundEffects.rZ);
        hashmap.put(EntityTypes.ab, SoundEffects.sa);
        hashmap.put(EntityTypes.am, SoundEffects.sb);
        hashmap.put(EntityTypes.av, SoundEffects.sc);
        hashmap.put(EntityTypes.ax, SoundEffects.sd);
        hashmap.put(EntityTypes.ay, SoundEffects.se);
        hashmap.put(EntityTypes.az, SoundEffects.sf);
        hashmap.put(EntityTypes.aE, SoundEffects.sg);
        hashmap.put(EntityTypes.aH, SoundEffects.sh);
        hashmap.put(EntityTypes.aJ, SoundEffects.si);
        hashmap.put(EntityTypes.aK, SoundEffects.sj);
        hashmap.put(EntityTypes.aM, SoundEffects.sk);
        hashmap.put(EntityTypes.aT, SoundEffects.sl);
        hashmap.put(EntityTypes.aV, SoundEffects.sm);
        hashmap.put(EntityTypes.bf, SoundEffects.sn);
        hashmap.put(EntityTypes.bh, SoundEffects.so);
        hashmap.put(EntityTypes.bj, SoundEffects.sp);
        hashmap.put(EntityTypes.bl, SoundEffects.sq);
        hashmap.put(EntityTypes.bm, SoundEffects.sr);
        hashmap.put(EntityTypes.bn, SoundEffects.ss);
        hashmap.put(EntityTypes.bq, SoundEffects.st);
        hashmap.put(EntityTypes.br, SoundEffects.su);
        hashmap.put(EntityTypes.bt, SoundEffects.sv);
    });
    public float bW;
    public float bX;
    public float bY;
    public float bZ;
    private float cf = 1.0f;
    private float cg = 1.0f;
    private boolean ch;
    @Nullable
    private BlockPosition ci;

    public EntityParrot(EntityTypes<? extends EntityParrot> type, World world) {
        super((EntityTypes<? extends EntityPerchable>)type, world);
        final FlyingWithSpacebarMoveControllerWASD flyingController = new FlyingWithSpacebarMoveControllerWASD((EntityInsentient)this, 0.3f);
        class ParrotMoveControl
        extends ControllerMoveFlying {
            public ParrotMoveControl(EntityInsentient entity, int maxPitchChange, boolean noGravity) {
                super(entity, maxPitchChange, noGravity);
            }

            @Override
            public void a() {
                if (this.d.getRider() != null && this.d.isControllable()) {
                    flyingController.purpurTick(this.d.getRider());
                } else {
                    super.a();
                }
            }

            @Override
            public boolean b() {
                return this.d.getRider() != null && this.d.isControllable() ? EntityParrot.this.getForwardMot() != 0.0f || EntityParrot.this.getStrafeMot() != 0.0f : super.b();
            }
        }
        this.bL = new ParrotMoveControl(this, 10, false);
        this.a(PathType.n, -1.0f);
        this.a(PathType.o, -1.0f);
        this.a(PathType.x, -1.0f);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.parrotRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.parrotRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.parrotControllable;
    }

    @Override
    public double getMaxY() {
        return this.dM().purpurConfig.parrotMaxY;
    }

    @Override
    public void a(Vec3D vec3) {
        super.a(vec3);
        if (this.getRider() != null && this.isControllable() && !((Entity)this).aJ) {
            float speed = (float)this.b(GenericAttributes.f) * 2.0f;
            this.w(speed);
            Vec3D mot = this.dp();
            this.a(EnumMoveType.a, mot.d(speed, 0.25, speed));
            this.g(mot.a(0.9));
        }
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.parrotMaxHealth);
    }

    @Override
    public int getPurpurBreedTime() {
        return 6000;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.parrotTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.parrotAlwaysDropExp;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.a((Variant)SystemUtils.a((Object[])Variant.values(), world.F_()));
        if (entityData == null) {
            entityData = new EntityAgeable.a(false);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public boolean o_() {
        return false;
    }

    @Override
    protected void B() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        if (this.dM().purpurConfig.parrotBreedable) {
            this.bO.a(1, new PathfinderGoalBreed(this, 1.0));
        }
        this.bO.a(0, new HasRider(this));
        this.bO.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bO.a(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(2, new PathfinderGoalSit(this));
        this.bO.a(2, new PathfinderGoalFollowOwner(this, 1.0, 5.0f, 1.0f, true));
        this.bO.a(2, new a(this, 1.0));
        this.bO.a(3, new PathfinderGoalPerch(this));
        this.bO.a(3, new PathfinderGoalFollowEntity(this, 1.0, 3.0f, 7.0f));
    }

    public static AttributeProvider.Builder gk() {
        return EntityInsentient.C().a(GenericAttributes.l, 6.0).a(GenericAttributes.f, 0.4f).a(GenericAttributes.m, 0.2f);
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.b(false);
        navigationflying.a(true);
        navigationflying.c(true);
        return navigationflying;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.6f;
    }

    @Override
    public void d_() {
        if (this.ci == null || !this.ci.a(this.dk(), 3.46) || !this.dM().a_(this.ci).a(Blocks.dT)) {
            this.ch = false;
            this.ci = null;
        }
        if (this.dM().z.a(400) == 0) {
            EntityParrot.a(this.dM(), this);
        }
        super.d_();
        this.go();
    }

    @Override
    public void a(BlockPosition songPosition, boolean playing) {
        this.ci = songPosition;
        this.ch = playing;
    }

    public boolean gl() {
        return this.ch;
    }

    private void go() {
        this.bZ = this.bW;
        this.bY = this.bX;
        this.bX += (float)(!this.aC() && !this.bO() ? 4 : -1) * 0.3f;
        this.bX = MathHelper.a(this.bX, 0.0f, 1.0f);
        if (!this.aC() && this.cf < 1.0f) {
            this.cf = 1.0f;
        }
        this.cf *= 0.9f;
        Vec3D vec3d = this.dp();
        if (!this.aC() && vec3d.d < 0.0) {
            this.g(vec3d.d(1.0, 0.6, 1.0));
        }
        this.bW += this.cf * 2.0f;
    }

    public static boolean a(World world, Entity parrot) {
        if (parrot.bx() && !parrot.aU() && world.z.a(2) == 0) {
            EntityInsentient entityinsentient;
            List<EntityInsentient> list = world.a(EntityInsentient.class, parrot.cH().g(20.0), cb);
            if (!list.isEmpty() && !(entityinsentient = list.get(world.z.a(list.size()))).aU()) {
                SoundEffect soundeffect = EntityParrot.b(entityinsentient.ai());
                world.a((EntityHuman)null, parrot.dr(), parrot.dt(), parrot.dx(), soundeffect, parrot.db(), 0.7f, EntityParrot.a(world.z));
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (!this.u() && cd.contains(itemstack.d())) {
            if (!player.fT().d) {
                itemstack.h(1);
            }
            if (!this.aU()) {
                this.dM().a((EntityHuman)null, this.dr(), this.dt(), this.dx(), SoundEffects.rL, this.db(), 1.0f, 1.0f + (this.ag.i() - this.ag.i()) * 0.2f);
            }
            if (!this.dM().B) {
                if (this.dM().purpurConfig.alwaysTameInCreative && player.fT().d || this.ag.a(10) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                    this.f(player);
                    this.dM().a((Entity)this, (byte)7);
                } else {
                    this.dM().a((Entity)this, (byte)6);
                }
            }
            if (this.dM().purpurConfig.parrotBreedable) {
                return super.b(player, hand);
            }
            return EnumInteractionResult.a(this.dM().B);
        }
        if (itemstack.a(cc)) {
            if (!player.fT().d) {
                itemstack.h(1);
            }
            this.addEffect(new MobEffect(MobEffects.s, 900), EntityPotionEffectEvent.Cause.FOOD);
            if (player.f() || !this.cr()) {
                this.a(this.dN().a(player), Float.MAX_VALUE);
            }
            return EnumInteractionResult.a(this.dM().B);
        }
        if (!this.gr() && this.u() && this.j(player)) {
            if (!this.dM().B) {
                this.z(!this.ge());
            }
            return EnumInteractionResult.a(this.dM().B);
        }
        return super.b(player, hand);
    }

    @Override
    public boolean m(ItemStack stack) {
        return this.dM().purpurConfig.parrotBreedable && cd.contains(stack.d());
    }

    public static boolean c(EntityTypes<EntityParrot> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bT) && EntityParrot.a(world, pos);
    }

    @Override
    protected void a(double heightDifference, boolean onGround, IBlockData state, BlockPosition landedPosition) {
    }

    @Override
    public boolean a(EntityAnimal other) {
        return super.a(other);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return world.purpurConfig.parrotBreedable ? (EntityAgeable)EntityTypes.au.a(world) : null;
    }

    @Override
    public boolean C(Entity target) {
        return target.a(this.dN().b(this), 3.0f);
    }

    @Override
    @Nullable
    public SoundEffect y() {
        return EntityParrot.a(this.dM(), this.dM().z);
    }

    public static SoundEffect a(World world, RandomSource random) {
        if (world.ak() != EnumDifficulty.a && random.a(1000) == 0) {
            ArrayList list = Lists.newArrayList(ce.keySet());
            return EntityParrot.b((EntityTypes)list.get(random.a(list.size())));
        }
        return SoundEffects.rJ;
    }

    private static SoundEffect b(EntityTypes<?> imitate) {
        return ce.getOrDefault(imitate, SoundEffects.rJ);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.rN;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.rK;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.sw, 0.15f, 1.0f);
    }

    @Override
    protected boolean aT() {
        return this.aa > this.cg;
    }

    @Override
    protected void aS() {
        this.a(SoundEffects.rM, 0.15f, 1.0f);
        this.cg = this.aa + this.bX / 2.0f;
    }

    @Override
    public float eX() {
        return EntityParrot.a(this.ag);
    }

    public static float a(RandomSource random) {
        return (random.i() - random.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundCategory db() {
        return SoundCategory.g;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return super.isCollidable(ignoreClimbing);
    }

    @Override
    protected void D(Entity entity) {
        if (!(entity instanceof EntityHuman)) {
            super.D(entity);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        boolean result = super.a(source, amount);
        if (!this.dM().B && result) {
            this.z(false);
        }
        return result;
    }

    public Variant gm() {
        return Variant.a(this.an.b(ca));
    }

    @Override
    public void a(Variant variant) {
        this.an.b(ca, variant.h);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(ca, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Variant", this.gm().h);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(Variant.a(nbt.h("Variant")));
    }

    @Override
    public boolean gr() {
        return !this.aC();
    }

    @Override
    public Vec3D cJ() {
        return new Vec3D(0.0, 0.5f * this.cI(), this.dg() * 0.4f);
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.4375f * scaleFactor, 0.0f);
    }

    public static enum Variant implements INamable
    {
        a(0, "red_blue"),
        b(1, "blue"),
        c(2, "green"),
        d(3, "yellow_blue"),
        e(4, "gray");

        public static final Codec<Variant> f;
        private static final IntFunction<Variant> g;
        final int h;
        private final String i;

        private Variant(int i2, String s2) {
            this.h = i2;
            this.i = s2;
        }

        public int a() {
            return this.h;
        }

        public static Variant a(int index) {
            return g.apply(index);
        }

        @Override
        public String c() {
            return this.i;
        }

        static {
            f = INamable.a(Variant::values);
            g = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
        }
    }

    private static class a
    extends PathfinderGoalRandomFly {
        public a(EntityCreature mob, double speed) {
            super(mob, speed);
        }

        @Override
        @Nullable
        protected Vec3D h() {
            Vec3D vec3d = null;
            if (this.b.aZ()) {
                vec3d = LandRandomPos.a(this.b, 15, 15);
            }
            if (this.b.eg().i() >= this.j) {
                vec3d = this.k();
            }
            return vec3d == null ? super.h() : vec3d;
        }

        @Nullable
        private Vec3D k() {
            BlockPosition blockposition = this.b.dm();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = new BlockPosition.MutableBlockPosition();
            Iterable<BlockPosition> iterable = BlockPosition.b(MathHelper.a(this.b.dr() - 3.0), MathHelper.a(this.b.dt() - 6.0), MathHelper.a(this.b.dx() - 3.0), MathHelper.a(this.b.dr() + 3.0), MathHelper.a(this.b.dt() + 6.0), MathHelper.a(this.b.dx() + 3.0));
            for (BlockPosition blockposition1 : iterable) {
                IBlockData iblockdata;
                boolean flag;
                if (blockposition.equals(blockposition1) || !(flag = (iblockdata = this.b.dM().a_(blockposition_mutableblockposition1.a((BaseBlockPosition)blockposition1, EnumDirection.a))).b() instanceof BlockLeaves || iblockdata.a(TagsBlock.t)) || !this.b.dM().u(blockposition1) || !this.b.dM().u(blockposition_mutableblockposition.a((BaseBlockPosition)blockposition1, EnumDirection.b))) continue;
                return Vec3D.c(blockposition1);
            }
            return null;
        }
    }
}

