/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.state.IBlockData;
import org.purpurmc.purpur.entity.ai.HasRider;

public class EntityPolarBear
extends EntityAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> bT = DataWatcher.a(EntityPolarBear.class, DataWatcherRegistry.k);
    private static final float bU = 6.0f;
    private float bW;
    private float bX;
    private int bY;
    private static final UniformInt bZ = TimeRange.a(20, 39);
    private int ca;
    @Nullable
    private UUID cb;
    private int standTimer = 0;

    public EntityPolarBear(EntityTypes<? extends EntityPolarBear> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.polarBearRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.polarBearRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.polarBearControllable;
    }

    @Override
    public boolean onSpacebar() {
        if (!this.A() && this.getRider() != null && this.getRider().getForwardMot() == 0.0f && this.getRider().getStrafeMot() == 0.0f) {
            this.w(true);
            this.a(SoundEffects.tE, 1.0f, 1.0f);
        }
        return false;
    }

    @Override
    public void initAttributes() {
        this.a(GenericAttributes.l).a(this.dM().purpurConfig.polarBearMaxHealth);
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (other == this) {
            return false;
        }
        if (this.A()) {
            return false;
        }
        if (this.q() != null) {
            return false;
        }
        if (!(other instanceof EntityPolarBear)) {
            return false;
        }
        EntityPolarBear bear = (EntityPolarBear)other;
        if (bear.A()) {
            return false;
        }
        if (bear.q() != null) {
            return false;
        }
        return this.gi() && bear.gi();
    }

    @Override
    public int getPurpurBreedTime() {
        return this.dM().purpurConfig.polarBearBreedingTicks;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.polarBearTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.polarBearAlwaysDropExp;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aA.a(world);
    }

    @Override
    public boolean m(ItemStack stack) {
        return this.dM().purpurConfig.polarBearBreedableItem != null && stack.d() == this.dM().purpurConfig.polarBearBreedableItem;
    }

    @Override
    protected void B() {
        super.B();
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(0, new HasRider(this));
        this.bO.a(1, new c());
        this.bO.a(1, new d());
        if (this.dM().purpurConfig.polarBearBreedableItem != null) {
            this.bO.a(2, new PathfinderGoalBreed(this, 1.0));
            this.bO.a(3, new PathfinderGoalTempt(this, 1.0, RecipeItemStack.a(this.dM().purpurConfig.polarBearBreedableItem), false));
        }
        this.bO.a(4, new PathfinderGoalFollowParent(this, 1.25));
        this.bO.a(5, new PathfinderGoalRandomStroll(this, 1.0));
        this.bO.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(7, new PathfinderGoalRandomLookaround(this));
        this.bP.a(0, new HasRider(this));
        this.bP.a(1, new b());
        this.bP.a(2, new a());
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bP.a(4, new PathfinderGoalNearestAttackableTarget<EntityFox>(this, EntityFox.class, 10, true, true, null));
        this.bP.a(5, new PathfinderGoalUniversalAngerReset<EntityPolarBear>(this, false));
    }

    public static AttributeProvider.Builder u() {
        return EntityInsentient.C().a(GenericAttributes.l, 30.0).a(GenericAttributes.g, 20.0).a(GenericAttributes.m, 0.25).a(GenericAttributes.c, 6.0);
    }

    public static boolean c(EntityTypes<EntityPolarBear> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        Holder<BiomeBase> holder = world.t(pos);
        return !holder.a(BiomeTags.ao) ? EntityPolarBear.b(type, world, spawnReason, pos, random) : EntityPolarBear.a(world, pos) && world.a_(pos.d()).a(TagsBlock.bU);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(this.dM(), nbt);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.c(nbt);
    }

    @Override
    public void c() {
        this.a(bZ.a(this.ag));
    }

    @Override
    public void a(int angerTime) {
        this.ca = angerTime;
    }

    @Override
    public int a() {
        return this.ca;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.cb = angryAt;
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cb;
    }

    @Override
    protected SoundEffect y() {
        return this.o_() ? SoundEffects.tA : SoundEffects.tz;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.tC;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.tB;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.tD, 0.15f, 1.0f);
    }

    protected void w() {
        if (this.bY <= 0) {
            this.a(SoundEffects.tE, 1.0f, this.eX());
            this.bY = 40;
        }
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(bT, false);
    }

    @Override
    public void l() {
        super.l();
        if (this.dM().B) {
            if (this.bX != this.bW) {
                this.k_();
            }
            this.bW = this.bX;
            this.bX = this.A() ? MathHelper.a(this.bX + 1.0f, 0.0f, 6.0f) : MathHelper.a(this.bX - 1.0f, 0.0f, 6.0f);
        }
        if (this.bY > 0) {
            --this.bY;
        }
        if (!this.dM().B) {
            this.a((WorldServer)this.dM(), true);
        }
        if (this.A() && --this.standTimer <= 0) {
            this.w(false);
        }
    }

    @Override
    public EntitySize a(EntityPose pose) {
        if (this.bX > 0.0f) {
            float f2 = this.bX / 6.0f;
            float g2 = 1.0f + f2;
            return super.a(pose).a(1.0f, g2);
        }
        return super.a(pose);
    }

    @Override
    public boolean C(Entity target) {
        boolean bl = target.a(this.dN().b(this), (float)((int)this.b(GenericAttributes.c)));
        if (bl) {
            this.a((EntityLiving)this, target);
        }
        return bl;
    }

    public boolean A() {
        return this.an.b(bT);
    }

    public void w(boolean warning) {
        this.an.b(bT, warning);
        this.standTimer = warning ? 20 : -1;
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.bW, this.bX) / 6.0f;
    }

    @Override
    protected float fd() {
        return 0.98f;
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(1.0f);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    class c
    extends PathfinderGoalMeleeAttack {
        public c() {
            super(EntityPolarBear.this, 1.25, true);
        }

        @Override
        protected void a(EntityLiving target) {
            if (this.b(target)) {
                this.h();
                this.a.C(target);
                EntityPolarBear.this.w(false);
            } else if (this.a.f((Entity)target) < (double)((target.dg() + 3.0f) * (target.dg() + 3.0f))) {
                if (this.i()) {
                    EntityPolarBear.this.w(false);
                    this.h();
                }
                if (this.k() <= 10) {
                    EntityPolarBear.this.w(true);
                    EntityPolarBear.this.w();
                }
            } else {
                this.h();
                EntityPolarBear.this.w(false);
            }
        }

        @Override
        public void d() {
            EntityPolarBear.this.w(false);
            super.d();
        }
    }

    class d
    extends PathfinderGoalPanic {
        public d() {
            super(EntityPolarBear.this, 2.0);
        }

        @Override
        protected boolean h() {
            return this.b.eh() != null && this.b.o_() || this.b.bN();
        }
    }

    class b
    extends PathfinderGoalHurtByTarget {
        public b() {
            super(EntityPolarBear.this, new Class[0]);
        }

        @Override
        public void c() {
            super.c();
            if (EntityPolarBear.this.o_()) {
                this.h();
                this.d();
            }
        }

        @Override
        protected void a(EntityInsentient mob, EntityLiving target) {
            if (mob instanceof EntityPolarBear && !mob.o_()) {
                super.a(mob, target);
            }
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public a() {
            super(EntityPolarBear.this, EntityHuman.class, 20, true, true, null);
        }

        @Override
        public boolean a() {
            if (EntityPolarBear.this.o_()) {
                return false;
            }
            if (super.a()) {
                for (EntityPolarBear polarBear : EntityPolarBear.this.dM().a(EntityPolarBear.class, EntityPolarBear.this.cH().c(8.0, 4.0, 8.0))) {
                    if (!polarBear.o_()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        protected double l() {
            return super.l() * 0.5;
        }
    }
}

