/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R3.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.joml.Vector3f;
import org.purpurmc.purpur.event.entity.GoatRamEntityEvent;

public class Goat
extends EntityAnimal {
    public static final EntitySize bT = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int ca = 2;
    private static final int cb = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> bU = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.n, SensorType.f, SensorType.q);
    protected static final ImmutableList<MemoryModuleType<?>> bW = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.au, MemoryModuleType.r, MemoryModuleType.R, MemoryModuleType.S, MemoryModuleType.N, MemoryModuleType.J, MemoryModuleType.O, (Object[])new MemoryModuleType[]{MemoryModuleType.Q, MemoryModuleType.U, MemoryModuleType.V, MemoryModuleType.Y});
    public static final int bX = 10;
    public static final double bY = 0.02;
    public static final double bZ = (double)0.1f;
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cd = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> ce = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private boolean cf;
    private int cg;
    private int behaviorTick = 0;

    public Goat(EntityTypes<? extends Goat> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.N().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack u() {
        RandomSource randomsource = RandomSource.a(this.cw().hashCode());
        TagKey<Instrument> tagkey = this.go() ? InstrumentTags.b : InstrumentTags.a;
        HolderSet.Named<Instrument> holderset = BuiltInRegistries.an.a(tagkey);
        return InstrumentItem.a(Items.vV, holderset.a(randomsource).get());
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.goatRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.goatRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.goatControllable;
    }

    @Override
    public int getPurpurBreedTime() {
        return this.dM().purpurConfig.goatBreedingTicks;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.goatTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.goatAlwaysDropExp;
    }

    protected BehaviorController.b<Goat> dP() {
        return BehaviorController.a(bW, bU);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.dP().a(dynamic));
    }

    public static AttributeProvider.Builder w() {
        return EntityInsentient.C().a(GenericAttributes.l, 10.0).a(GenericAttributes.m, 0.2f).a(GenericAttributes.c, 2.0);
    }

    @Override
    protected void m() {
        if (this.o_()) {
            this.a(GenericAttributes.c).a(1.0);
            this.gn();
        } else {
            this.a(GenericAttributes.c).a(2.0);
            this.gm();
        }
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return super.d(fallDistance, damageMultiplier) - 10;
    }

    @Override
    protected SoundEffect y() {
        return this.go() ? SoundEffects.kq : SoundEffects.kg;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return this.go() ? SoundEffects.kt : SoundEffects.kj;
    }

    @Override
    public SoundEffect n_() {
        return this.go() ? SoundEffects.kr : SoundEffects.kh;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.kz, 0.15f, 1.0f);
    }

    protected SoundEffect A() {
        return this.go() ? SoundEffects.kv : SoundEffects.kl;
    }

    @Nullable
    public Goat b(WorldServer world, EntityAgeable entity) {
        Goat goat = EntityTypes.V.a(world);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, world.F_());
            EntityAgeable object = world.F_().h() ? this : entity;
            boolean flag = object instanceof Goat && ((Goat)(goat1 = object)).go() || !(world.F_().j() >= 0.02);
            boolean flag1 = flag;
            goat.w(flag1);
        }
        return goat;
    }

    public BehaviorController<Goat> dO() {
        return super.dO();
    }

    @Override
    protected void Z() {
        if (!(this.getRider() != null && this.isControllable() || this.behaviorTick++ % this.activatedPriority != 0)) {
            this.dO().a((WorldServer)this.dM(), this);
        }
        GoatAi.a(this);
        super.Z();
    }

    @Override
    public int ab() {
        return 15;
    }

    @Override
    public void n(float headYaw) {
        int i2 = this.ab();
        float f1 = MathHelper.c(this.aU, headYaw);
        float f2 = MathHelper.a(f1, (float)(-i2), (float)i2);
        super.n(this.aU + f2);
    }

    @Override
    public SoundEffect d(ItemStack stack) {
        return this.go() ? SoundEffects.ks : SoundEffects.ki;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.qv) && !this.o_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)player.dM(), player, this.dm(), this.dm(), null, itemstack, Items.qB, hand);
            if (event.isCancelled()) {
                return EnumInteractionResult.d;
            }
            player.a(this.A(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemstack1);
            return EnumInteractionResult.a(this.dM().B);
        }
        boolean isFood = this.m(itemstack);
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a() && isFood) {
            this.dM().a((EntityHuman)null, this, this.d(itemstack), SoundCategory.g, 1.0f, MathHelper.b(this.dM().z, 0.8f, 1.2f));
        }
        return enuminteractionresult;
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.F_();
        GoatAi.a(this, randomsource);
        this.w(randomsource.j() < 0.02);
        this.m();
        if (!this.o_() && (double)randomsource.i() < (double)0.1f) {
            DataWatcherObject<Boolean> datawatcherobject = randomsource.h() ? cd : ce;
            this.an.b(datawatcherobject, false);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected void Y() {
        super.Y();
        PacketDebug.a(this);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return pose == EntityPose.g ? bT.a(this.dZ()) : super.a(pose);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsScreamingGoat", this.go());
        nbt.a("HasLeftHorn", this.ge());
        nbt.a("HasRightHorn", this.gk());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.w(nbt.q("IsScreamingGoat"));
        this.an.b(cd, nbt.q("HasLeftHorn"));
        this.an.b(ce, nbt.q("HasRightHorn"));
    }

    @Override
    public void b(byte status) {
        if (status == 58) {
            this.cf = true;
        } else if (status == 59) {
            this.cf = false;
        } else {
            super.b(status);
        }
    }

    @Override
    public void d_() {
        this.cg = this.cf ? ++this.cg : (this.cg -= 2);
        this.cg = MathHelper.a(this.cg, 0, 20);
        super.d_();
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(cc, false);
        this.an.a(cd, true);
        this.an.a(ce, true);
    }

    public boolean ge() {
        return this.an.b(cd);
    }

    public boolean gk() {
        return this.an.b(ce);
    }

    public boolean gl() {
        boolean flag = this.ge();
        boolean flag1 = this.gk();
        if (!flag && !flag1) {
            return false;
        }
        DataWatcherObject<Boolean> datawatcherobject = !flag ? ce : (!flag1 ? cd : (this.ag.h() ? cd : ce));
        this.an.b(datawatcherobject, false);
        Vec3D vec3d = this.dk();
        ItemStack itemstack = this.u();
        double d0 = MathHelper.b(this.ag, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.ag, 0.3f, 0.7f);
        double d2 = MathHelper.b(this.ag, -0.2f, 0.2f);
        EntityItem entityitem = new EntityItem(this.dM(), vec3d.a(), vec3d.b(), vec3d.c(), itemstack, d0, d1, d2);
        return this.spawnAtLocation(entityitem) != null;
    }

    public void gm() {
        this.an.b(cd, true);
        this.an.b(ce, true);
    }

    public void gn() {
        this.an.b(cd, false);
        this.an.b(ce, false);
    }

    public boolean go() {
        return this.an.b(cc);
    }

    public void w(boolean screaming) {
        this.an.b(cc, screaming);
    }

    public float gp() {
        return (float)this.cg / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bR) && Goat.a(world, pos);
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.1875f * scaleFactor, 0.0f);
    }

    public void ram(EntityLiving entity) {
        if (!new GoatRamEntityEvent((org.bukkit.entity.Goat)this.getBukkitEntity(), (LivingEntity)entity.getBukkitLivingEntity()).callEvent()) {
            return;
        }
        BehaviorController<Goat> brain = this.dO();
        brain.a(MemoryModuleType.V, entity.dk());
        brain.b(MemoryModuleType.U);
        brain.b(MemoryModuleType.r);
        brain.b(MemoryModuleType.N);
        brain.a(Activity.r);
    }
}

