/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.HorseColor;
import net.minecraft.world.entity.animal.horse.HorseStyle;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemHorseArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.SoundEffectType;

public class EntityHorse
extends EntityHorseAbstract
implements VariantHolder<HorseColor> {
    private static final UUID bT = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataWatcherObject<Integer> bU = DataWatcher.a(EntityHorse.class, DataWatcherRegistry.b);

    public EntityHorse(EntityTypes<? extends EntityHorse> type, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, world);
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.horseRidableInWater;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(this.dM().purpurConfig.horseMaxHealthMin, this.dM().purpurConfig.horseMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(this.dM().purpurConfig.horseJumpStrengthMin, this.dM().purpurConfig.horseJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(this.dM().purpurConfig.horseMovementSpeedMin, this.dM().purpurConfig.horseMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.dM().purpurConfig.horseBreedingTicks;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.horseTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.horseAlwaysDropExp;
    }

    @Override
    protected void a(RandomSource random) {
        this.a(GenericAttributes.l).a(EntityHorse.a(random::a));
        this.a(GenericAttributes.m).a(EntityHorse.b(random::j));
        this.a(GenericAttributes.h).a(EntityHorse.a(random::j));
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(bU, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Variant", this.gm());
        if (!this.cp.a(1).b()) {
            nbt.a("ArmorItem", this.cp.a(1).b(new NBTTagCompound()));
        }
    }

    public ItemStack u() {
        return this.c(EnumItemSlot.e);
    }

    private void n(ItemStack stack) {
        this.a(EnumItemSlot.e, stack);
        this.a(EnumItemSlot.e, 0.0f);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        ItemStack itemStack;
        super.a(nbt);
        this.w(nbt.h("Variant"));
        if (nbt.b("ArmorItem", 10) && !(itemStack = ItemStack.a(nbt.p("ArmorItem"))).b() && this.l(itemStack)) {
            this.cp.a(1, itemStack);
        }
        this.gB();
    }

    private void w(int variant) {
        this.an.b(bU, variant);
    }

    private int gm() {
        return this.an.b(bU);
    }

    public void a(HorseColor color, HorseStyle marking) {
        this.w(color.a() & 0xFF | marking.a() << 8 & 0xFF00);
    }

    public HorseColor w() {
        return HorseColor.a(this.gm() & 0xFF);
    }

    @Override
    public void a(HorseColor variant) {
        this.w(variant.a() & 0xFF | this.gm() & 0xFFFFFF00);
    }

    public HorseStyle ge() {
        return HorseStyle.a((this.gm() & 0xFF00) >> 8);
    }

    @Override
    protected void gB() {
        if (!this.dM().B) {
            super.gB();
            this.o(this.cp.a(1));
            this.a(EnumItemSlot.e, 0.0f);
        }
    }

    private void o(ItemStack stack) {
        this.n(stack);
        if (!this.dM().B) {
            int i2;
            this.a(GenericAttributes.a).b(bT);
            if (this.l(stack) && (i2 = ((ItemHorseArmor)stack.d()).i()) != 0) {
                this.a(GenericAttributes.a).b(new AttributeModifier(bT, "Horse armor bonus", i2, AttributeModifier.Operation.a));
            }
        }
    }

    @Override
    public void a(IInventory sender) {
        ItemStack itemStack = this.u();
        super.a(sender);
        ItemStack itemStack2 = this.u();
        if (this.ah > 20 && this.l(itemStack2) && itemStack != itemStack2) {
            this.a(SoundEffects.lU, 0.5f, 1.0f);
        }
    }

    @Override
    protected void a(SoundEffectType group) {
        super.a(group);
        if (this.ag.a(10) == 0) {
            this.a(SoundEffects.lV, group.a() * 0.6f, group.b());
        }
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.lS;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.lW;
    }

    @Override
    @Nullable
    protected SoundEffect gl() {
        return SoundEffects.lX;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.lZ;
    }

    @Override
    protected SoundEffect gD() {
        return SoundEffects.lT;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean bl;
        boolean bl2 = bl = !this.o_() && this.gt() && player.fI();
        if (!this.bP() && !bl) {
            ItemStack itemStack = player.b(hand);
            if (!itemStack.b()) {
                if (this.m(itemStack)) {
                    return this.c(player, itemStack);
                }
                if (!this.gt()) {
                    this.gK();
                    return EnumInteractionResult.a(this.dM().B);
                }
            }
            return super.b(player, hand);
        }
        return super.b(player, hand);
    }

    @Override
    public boolean a(EntityAnimal other) {
        return other != this && (other instanceof EntityHorseDonkey || other instanceof EntityHorse) && this.gM() && ((EntityHorseAbstract)other).gM();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        if (entity instanceof EntityHorseDonkey) {
            EntityHorseMule mule = EntityTypes.aq.a(world);
            if (mule != null) {
                this.a(entity, mule);
            }
            return mule;
        }
        EntityHorse horse = (EntityHorse)entity;
        EntityHorse horse2 = EntityTypes.Z.a(world);
        if (horse2 != null) {
            int i2 = this.ag.a(9);
            HorseColor variant = i2 < 4 ? this.w() : (i2 < 8 ? horse.w() : SystemUtils.a(HorseColor.values(), this.ag));
            int j2 = this.ag.a(5);
            HorseStyle markings = j2 < 2 ? this.ge() : (j2 < 4 ? horse.ge() : SystemUtils.a(HorseStyle.values(), this.ag));
            horse2.a(variant, markings);
            this.a(entity, horse2);
        }
        return horse2;
    }

    @Override
    public boolean gN() {
        return true;
    }

    @Override
    public boolean l(ItemStack item) {
        return item.d() instanceof ItemHorseArmor;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        HorseColor variant;
        RandomSource randomSource = world.F_();
        if (entityData instanceof a) {
            variant = ((a)entityData).a;
        } else {
            variant = SystemUtils.a(HorseColor.values(), randomSource);
            entityData = new a(variant);
        }
        this.a(variant, SystemUtils.a(HorseStyle.values(), randomSource));
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static class a
    extends EntityAgeable.a {
        public final HorseColor a;

        public a(HorseColor color) {
            super(true);
            this.a = color;
        }
    }
}

