/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.level.World;

public class EntityHorseDonkey
extends EntityHorseChestedAbstract {
    public EntityHorseDonkey(EntityTypes<? extends EntityHorseDonkey> type, World world) {
        super((EntityTypes<? extends EntityHorseChestedAbstract>)type, world);
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.donkeyRidableInWater;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(this.dM().purpurConfig.donkeyMaxHealthMin, this.dM().purpurConfig.donkeyMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(this.dM().purpurConfig.donkeyJumpStrengthMin, this.dM().purpurConfig.donkeyJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(this.dM().purpurConfig.donkeyMovementSpeedMin, this.dM().purpurConfig.donkeyMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.dM().purpurConfig.donkeyBreedingTicks;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.donkeyTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.donkeyAlwaysDropExp;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.gC;
    }

    @Override
    protected SoundEffect gD() {
        return SoundEffects.gD;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.gF;
    }

    @Override
    @Nullable
    protected SoundEffect gl() {
        return SoundEffects.gG;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.gH;
    }

    @Override
    public boolean a(EntityAnimal other) {
        return other != this && (other instanceof EntityHorseDonkey || other instanceof EntityHorse) && this.gM() && ((EntityHorseAbstract)other).gM();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        EntityTypes<EntityHorseChestedAbstract> entityType = entity instanceof EntityHorse ? EntityTypes.aq : EntityTypes.x;
        EntityHorseAbstract abstractHorse = entityType.a(world);
        if (abstractHorse != null) {
            this.a(entity, abstractHorse);
        }
        return abstractHorse;
    }
}

