/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;

public class EntityHorseZombie
extends EntityHorseAbstract {
    public EntityHorseZombie(EntityTypes<? extends EntityHorseZombie> type, World world) {
        super((EntityTypes<? extends EntityHorseAbstract>)type, world);
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.zombieHorseRidableInWater;
    }

    @Override
    public boolean gt() {
        return super.gt() || this.dM().purpurConfig.zombieHorseRidable;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(this.dM().purpurConfig.zombieHorseMaxHealthMin, this.dM().purpurConfig.zombieHorseMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(this.dM().purpurConfig.zombieHorseJumpStrengthMin, this.dM().purpurConfig.zombieHorseJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(this.dM().purpurConfig.zombieHorseMovementSpeedMin, this.dM().purpurConfig.zombieHorseMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return 6000;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.zombieHorseTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.zombieHorseAlwaysDropExp;
    }

    public static AttributeProvider.Builder u() {
        return EntityHorseZombie.gE().a(GenericAttributes.l, 15.0).a(GenericAttributes.m, 0.2f);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> type, GeneratorAccess world, EnumMobSpawn reason, BlockPosition pos, RandomSource random) {
        return !EnumMobSpawn.a(reason) ? EntityAnimal.b(type, world, reason, pos, random) : EnumMobSpawn.b(reason) || EntityHorseZombie.a(world, pos);
    }

    @Override
    protected void a(RandomSource random) {
        this.a(GenericAttributes.h).a(EntityHorseZombie.a(random::j));
    }

    @Override
    public EnumMonsterType eS() {
        return EnumMonsterType.b;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.Cj;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.Ck;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.Cl;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.bs.a(world);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return !this.gt() ? EnumInteractionResult.d : super.b(player, hand);
    }

    @Override
    protected void gu() {
        if (this.dM().purpurConfig.zombieHorseCanSwim) {
            this.bO.a(0, new PathfinderGoalFloat(this));
        }
    }

    @Override
    protected float a(EntitySize dimensions, float scaleFactor) {
        return dimensions.b - (this.o_() ? 0.03125f : 0.28125f) * scaleFactor;
    }
}

