/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLlamaFollow;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockCarpet;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Llama;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.joml.Vector3f;
import org.purpurmc.purpur.controller.LookControllerWASD;
import org.purpurmc.purpur.controller.MoveControllerWASD;
import org.purpurmc.purpur.entity.ai.LlamaHasRider;
import org.purpurmc.purpur.event.entity.LlamaJoinCaravanEvent;
import org.purpurmc.purpur.event.entity.LlamaLeaveCaravanEvent;

public class EntityLlama
extends EntityHorseChestedAbstract
implements VariantHolder<Variant>,
IRangedEntity {
    private static final int bU = 5;
    private static final RecipeItemStack bW = RecipeItemStack.a(Items.pt, Blocks.ij.k());
    private static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bY = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(EntityLlama.class, DataWatcherRegistry.b);
    boolean ca;
    @Nullable
    private EntityLlama cb;
    @Nullable
    public EntityLlama cc;
    public boolean shouldJoinCaravan = true;

    public EntityLlama(EntityTypes<? extends EntityLlama> type, World world) {
        super((EntityTypes<? extends EntityHorseChestedAbstract>)type, world);
        this.bL = new MoveControllerWASD(this){

            @Override
            public void a() {
                if (this.entity.getRider() != null && this.entity.isControllable() && EntityLlama.this.i()) {
                    this.purpurTick(this.entity.getRider());
                } else {
                    this.vanillaTick();
                }
            }
        };
        this.bK = new LookControllerWASD(this){

            @Override
            public void a() {
                if (this.entity.getRider() != null && this.entity.isControllable() && EntityLlama.this.i()) {
                    this.purpurTick(this.entity.getRider());
                } else {
                    this.vanillaTick();
                }
            }
        };
    }

    @Override
    public boolean isRidable() {
        return this.dM().purpurConfig.llamaRidable;
    }

    @Override
    public boolean bQ() {
        return this.dM().purpurConfig.useDismountsUnderwaterTag ? super.bQ() : !this.dM().purpurConfig.llamaRidableInWater;
    }

    @Override
    public boolean isControllable() {
        return this.dM().purpurConfig.llamaControllable;
    }

    @Override
    public boolean i() {
        return super.i() || this.gt() && this.gr() != null;
    }

    @Override
    public float generateMaxHealth(RandomSource random) {
        return (float)this.generateMaxHealth(this.dM().purpurConfig.llamaMaxHealthMin, this.dM().purpurConfig.llamaMaxHealthMax);
    }

    @Override
    public double generateJumpStrength(RandomSource random) {
        return this.generateJumpStrength(this.dM().purpurConfig.llamaJumpStrengthMin, this.dM().purpurConfig.llamaJumpStrengthMax);
    }

    @Override
    public double generateSpeed(RandomSource random) {
        return this.generateSpeed(this.dM().purpurConfig.llamaMovementSpeedMin, this.dM().purpurConfig.llamaMovementSpeedMax);
    }

    @Override
    public int getPurpurBreedTime() {
        return this.dM().purpurConfig.llamaBreedingTicks;
    }

    @Override
    public boolean fh() {
        return this.dM().purpurConfig.llamaTakeDamageFromWater;
    }

    @Override
    protected boolean ef() {
        return this.dM().purpurConfig.llamaAlwaysDropExp;
    }

    public boolean gn() {
        return false;
    }

    public void setStrengthPublic(int i2) {
        this.w(i2);
    }

    private void w(int strength) {
        this.an.b(bX, Math.max(1, Math.min(5, strength)));
    }

    private void b(RandomSource random) {
        int i2 = random.i() < 0.04f ? 5 : 3;
        this.w(1 + random.a(i2));
    }

    public int go() {
        return this.an.b(bX);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Variant", this.gq().g);
        nbt.a("Strength", this.go());
        if (!this.cp.a(1).b()) {
            nbt.a("DecorItem", this.cp.a(1).b(new NBTTagCompound()));
        }
        nbt.a("Purpur.ShouldJoinCaravan", this.shouldJoinCaravan);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.w(nbt.h("Strength"));
        super.a(nbt);
        this.a(Variant.a(nbt.h("Variant")));
        if (nbt.b("DecorItem", 10)) {
            this.cp.a(1, ItemStack.a(nbt.p("DecorItem")));
        }
        if (nbt.e("Purpur.ShouldJoinCaravan")) {
            this.shouldJoinCaravan = nbt.q("Purpur.ShouldJoinCaravan");
        }
        this.gB();
    }

    @Override
    protected void B() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(0, new LlamaHasRider(this));
        this.bO.a(1, new PathfinderGoalTame(this, 1.2));
        this.bO.a(2, new PathfinderGoalLlamaFollow(this, 2.1f));
        this.bO.a(3, new PathfinderGoalArrowAttack(this, 1.25, 40, 20.0f));
        this.bO.a(3, new PathfinderGoalPanic(this, 1.2));
        this.bO.a(4, new PathfinderGoalBreed(this, 1.0));
        this.bO.a(5, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(Items.hC), false));
        this.bO.a(6, new PathfinderGoalFollowParent(this, 1.0));
        this.bO.a(7, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(9, new PathfinderGoalRandomLookaround(this));
        this.bP.a(0, new LlamaHasRider(this));
        this.bP.a(1, new c(this));
        this.bP.a(2, new a(this));
    }

    public static AttributeProvider.Builder gp() {
        return EntityLlama.u().a(GenericAttributes.g, 40.0);
    }

    @Override
    protected void c_() {
        super.c_();
        this.an.a(bX, 0);
        this.an.a(bY, -1);
        this.an.a(bZ, 0);
    }

    public Variant gq() {
        return Variant.a(this.an.b(bZ));
    }

    @Override
    public void a(Variant variant) {
        this.an.b(bZ, variant.g);
    }

    @Override
    protected int ac_() {
        return this.w() ? 2 + 3 * this.gm() : super.ac_();
    }

    @Override
    public boolean m(ItemStack stack) {
        return bW.a(stack);
    }

    @Override
    protected boolean a(EntityHuman player, ItemStack item) {
        SoundEffect soundeffect;
        int b0 = 0;
        int b1 = 0;
        float f2 = 0.0f;
        boolean flag = false;
        if (item.a(Items.pt)) {
            b0 = 10;
            b1 = 3;
            f2 = 2.0f;
        } else if (item.a(Blocks.ij.k())) {
            b0 = 90;
            b1 = 6;
            f2 = 10.0f;
            if (this.gt() && this.h() == 0 && this.gf()) {
                flag = true;
                this.setInLove(player, item.p());
            }
        }
        if (this.ev() < this.eM() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.o_() && b0 > 0) {
            this.dM().a(Particles.M, this.d(1.0), this.du() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dM().B) {
                this.b_(b0);
            }
            flag = true;
        }
        if (b1 > 0 && (flag || !this.gt()) && this.gz() < this.gF()) {
            flag = true;
            if (!this.dM().B) {
                this.v(b1);
            }
        }
        if (flag && !this.aU() && (soundeffect = this.gl()) != null) {
            this.dM().a((EntityHuman)null, this.dr(), this.dt(), this.dx(), this.gl(), this.db(), 1.0f, 1.0f + (this.ag.i() - this.ag.i()) * 0.2f);
        }
        return flag;
    }

    @Override
    public boolean eY() {
        return this.ew() || this.gw();
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        Variant entityllama_variant;
        RandomSource randomsource = world.F_();
        this.b(randomsource);
        if (entityData instanceof b) {
            entityllama_variant = ((b)entityData).a;
        } else {
            entityllama_variant = (Variant)SystemUtils.a((Object[])Variant.values(), randomsource);
            entityData = new b(entityllama_variant);
        }
        this.a(entityllama_variant);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected boolean gk() {
        return false;
    }

    @Override
    protected SoundEffect gD() {
        return SoundEffects.nl;
    }

    @Override
    protected SoundEffect y() {
        return SoundEffects.nk;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.np;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.nn;
    }

    @Override
    @Nullable
    protected SoundEffect gl() {
        return SoundEffects.no;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.nr, 0.15f, 1.0f);
    }

    @Override
    protected void ge() {
        this.a(SoundEffects.nm, 1.0f, (this.ag.i() - this.ag.i()) * 0.2f + 1.0f);
    }

    @Override
    public int gm() {
        return this.go();
    }

    @Override
    public boolean gN() {
        return true;
    }

    @Override
    public boolean gO() {
        return !this.cp.a(1).b();
    }

    @Override
    public boolean l(ItemStack item) {
        return item.a(TagsItem.g);
    }

    @Override
    public boolean g() {
        return false;
    }

    @Override
    public void a(IInventory sender) {
        EnumColor enumcolor = this.gr();
        super.a(sender);
        EnumColor enumcolor1 = this.gr();
        if (this.ah > 20 && enumcolor1 != null && enumcolor1 != enumcolor) {
            this.a(SoundEffects.ns, 0.5f, 1.0f);
        }
    }

    @Override
    protected void gB() {
        if (!this.dM().B) {
            super.gB();
            this.a(EntityLlama.n(this.cp.a(1)));
        }
    }

    @Override
    private void a(@Nullable EnumColor color) {
        this.an.b(bY, color == null ? -1 : color.a());
    }

    @Nullable
    private static EnumColor n(ItemStack color) {
        Block block = Block.a(color.d());
        return block instanceof BlockCarpet ? ((BlockCarpet)block).b() : null;
    }

    @Nullable
    public EnumColor gr() {
        int i2 = this.an.b(bY);
        return i2 == -1 ? null : EnumColor.a(i2);
    }

    @Override
    public int gF() {
        return 30;
    }

    @Override
    public boolean a(EntityAnimal other) {
        return other != this && other instanceof EntityLlama && this.gM() && ((EntityLlama)other).gM();
    }

    @Nullable
    public EntityLlama b(WorldServer world, EntityAgeable entity) {
        EntityLlama entityllama = this.gs();
        if (entityllama != null) {
            this.a(entity, entityllama);
            EntityLlama entityllama1 = (EntityLlama)entity;
            int i2 = this.ag.a(Math.max(this.go(), entityllama1.go())) + 1;
            if (this.ag.i() < 0.03f) {
                ++i2;
            }
            entityllama.w(i2);
            entityllama.a(this.ag.h() ? this.gq() : entityllama1.gq());
        }
        return entityllama;
    }

    @Nullable
    protected EntityLlama gs() {
        return EntityTypes.ak.a(this.dM());
    }

    private void k(EntityLiving target) {
        EntityLlamaSpit entityllamaspit = new EntityLlamaSpit(this.dM(), this);
        double d0 = target.dr() - this.dr();
        double d1 = target.e(0.3333333333333333) - entityllamaspit.dt();
        double d2 = target.dx() - this.dx();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        entityllamaspit.c(d0, d1 + d3, d2, 1.5f, 10.0f);
        if (!this.aU()) {
            this.dM().a((EntityHuman)null, this.dr(), this.dt(), this.dx(), SoundEffects.nq, this.db(), 1.0f, 1.0f + (this.ag.i() - this.ag.i()) * 0.2f);
        }
        this.dM().b(entityllamaspit);
        this.ca = true;
    }

    void D(boolean spit) {
        this.ca = spit;
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2 = this.d(fallDistance, damageMultiplier);
        if (i2 <= 0) {
            return false;
        }
        if (fallDistance >= 6.0f) {
            this.a(damageSource, (float)i2);
            if (this.bP()) {
                for (Entity entity : this.cT()) {
                    entity.a(damageSource, (float)i2);
                }
            }
        }
        this.eI();
        return true;
    }

    public void gQ() {
        if (this.cb != null) {
            new LlamaLeaveCaravanEvent((Llama)this.getBukkitEntity()).callEvent();
            this.cb.cc = null;
        }
        this.cb = null;
    }

    @Override
    public void a(EntityLlama llama) {
        if (!(this.dM().purpurConfig.llamaJoinCaravans && this.shouldJoinCaravan && new LlamaJoinCaravanEvent((Llama)this.getBukkitEntity(), (Llama)llama.getBukkitEntity()).callEvent())) {
            return;
        }
        this.cb = llama;
        this.cb.cc = this;
    }

    public boolean gR() {
        return this.cc != null;
    }

    public boolean gS() {
        return this.cb != null;
    }

    @Nullable
    public EntityLlama gT() {
        return this.cb;
    }

    @Override
    protected double gd() {
        return 2.0;
    }

    @Override
    protected void gG() {
        if (!this.gS() && this.o_()) {
            super.gG();
        }
    }

    @Override
    public boolean gH() {
        return false;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.k(target);
    }

    @Override
    public Vec3D cJ() {
        return new Vec3D(0.0, 0.75 * (double)this.cI(), (double)this.dg() * 0.5);
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - (this.o_() ? 0.8125f : 0.5f) * scaleFactor, -0.3f * scaleFactor);
    }

    public static enum Variant implements INamable
    {
        a(0, "creamy"),
        b(1, "white"),
        c(2, "brown"),
        d(3, "gray");

        public static final Codec<Variant> e;
        private static final IntFunction<Variant> f;
        final int g;
        private final String h;

        private Variant(int i2, String s2) {
            this.g = i2;
            this.h = s2;
        }

        public int a() {
            return this.g;
        }

        public static Variant a(int id) {
            return f.apply(id);
        }

        @Override
        public String c() {
            return this.h;
        }

        static {
            e = INamable.a(Variant::values);
            f = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.c);
        }
    }

    private static class c
    extends PathfinderGoalHurtByTarget {
        public c(EntityLlama llama) {
            super(llama, new Class[0]);
        }

        @Override
        public boolean b() {
            EntityInsentient entityinsentient = this.e;
            if (entityinsentient instanceof EntityLlama) {
                EntityLlama entityllama = (EntityLlama)entityinsentient;
                if (entityllama.ca) {
                    entityllama.D(false);
                    return false;
                }
            }
            return super.b();
        }
    }

    private static class a
    extends PathfinderGoalNearestAttackableTarget<EntityWolf> {
        public a(EntityLlama llama) {
            super(llama, EntityWolf.class, 16, false, true, entityliving -> !((EntityWolf)entityliving).u());
        }

        @Override
        protected double l() {
            return super.l() * 0.25;
        }
    }

    private static class b
    extends EntityAgeable.a {
        public final Variant a;

        b(Variant variant) {
            super(true);
            this.a = variant;
        }
    }
}

